# Cilium debug information

#### Cilium status

```
KVStore:                Disabled   
Kubernetes:             Ok         1.35 (v1.35.0+k3s1) [linux/amd64]
Kubernetes APIs:        ["cilium/v2::CiliumCIDRGroup", "cilium/v2::CiliumClusterwideNetworkPolicy", "cilium/v2::CiliumEndpoint", "cilium/v2::CiliumNetworkPolicy", "cilium/v2::CiliumNode", "core/v1::Pods", "networking.k8s.io/v1::NetworkPolicy"]
KubeProxyReplacement:   True   [enp41s0   65.108.205.29 fe80::8854:58c1:2f08:6ceb, vlan4000   192.168.100.22 fe80::b54d:107:c901:d3b4 (Direct Routing), tailscale0    100.64.1.179 fd7a:115c:a1e0::1b4 fe80::9c64:81b:b01c:efd8]
Host firewall:          Disabled
SRv6:                   Disabled
CNI Chaining:           none
CNI Config file:        successfully wrote CNI configuration file to /host/etc/cni/net.d/05-cilium.conflist
Cilium:                 Ok   1.19.0-rc.0 (v1.19.0-rc.0-b6f44c92)
NodeMonitor:            Listening for events on 12 CPUs with 64x4096 of shared memory
Cilium health daemon:   Ok   
IPAM:                   IPv4: 13/254 allocated from 10.0.12.0/24, 
Allocated addresses:
  10.0.12.161 (router)
  10.0.12.19 (redacted-dev/redacted-collector-dev-578d9d6889-jzlkk [restored])
  10.0.12.192 (longhorn-system/longhorn-csi-plugin-6lb29 [restored])
  10.0.12.195 (health)
  10.0.12.199 (longhorn-system/engine-image-ei-e09d8caa-4nxxp [restored])
  10.0.12.220 (redacted-dev/redacted-redis-job-meteo-france-radar-6407065-vjqlm)
  10.0.12.226 (longhorn-system/csi-attacher-5d68b48d9-8w9g9 [restored])
  10.0.12.228 (longhorn-system/instance-manager-f3cdddbee4b34d17fbf0e0d6af8d15c2 [restored])
  10.0.12.229 (redacted-dev/cluster-redacted-2 [restored])
  10.0.12.24 (longhorn-system/longhorn-manager-phqvw [restored])
  10.0.12.243 (harbor/harbor-jobservice-7445fcfbd-gn8hb [restored])
  10.0.12.60 (monitoring/kured-57cd4 [restored])
  10.0.12.88 (monitoring/victorialogs-vector-pqlsz [restored])
IPv4 BIG TCP:           Disabled
IPv6 BIG TCP:           Disabled
BandwidthManager:       Disabled
Routing:                Network: Tunnel [vxlan]   Host: BPF
Attach Mode:            TCX
Device Mode:            veth
Masquerading:           BPF   [enp41s0, vlan4000, tailscale0]   10.0.12.0/24  [IPv4: Enabled, IPv6: Disabled]
Clock Source for BPF:   ktime
Controller Status:      80/80 healthy
  Name                                                                               Last success   Last error   Count   Message
  cilium-health-ep                                                                   2s ago         never        0       no error   
  ct-map-pressure                                                                    8s ago         never        0       no error   
  endpoint-1078-regeneration-recovery                                                never          never        0       no error   
  endpoint-1128-regeneration-recovery                                                never          never        0       no error   
  endpoint-1200-regeneration-recovery                                                never          never        0       no error   
  endpoint-1322-regeneration-recovery                                                never          never        0       no error   
  endpoint-1486-regeneration-recovery                                                never          never        0       no error   
  endpoint-1713-regeneration-recovery                                                never          never        0       no error   
  endpoint-2245-regeneration-recovery                                                never          never        0       no error   
  endpoint-2387-regeneration-recovery                                                never          never        0       no error   
  endpoint-3416-regeneration-recovery                                                never          never        0       no error   
  endpoint-349-regeneration-recovery                                                 never          never        0       no error   
  endpoint-3491-regeneration-recovery                                                never          never        0       no error   
  endpoint-380-regeneration-recovery                                                 never          never        0       no error   
  endpoint-4060-regeneration-recovery                                                never          never        0       no error   
  endpoint-gc                                                                        3s ago         never        0       no error   
  endpoint-periodic-regeneration                                                     3s ago         never        0       no error   
  ipcache-inject-labels                                                              3s ago         never        0       no error   
  k8s-heartbeat                                                                      2s ago         never        0       no error   
  local-identity-checkpoint                                                          7h1m50s ago    never        0       no error   
  resolve-identity-1200                                                              2m59s ago      never        0       no error   
  resolve-identity-1713                                                              2s ago         never        0       no error   
  resolve-labels-/                                                                   7h50m3s ago    never        0       no error   
  resolve-labels-harbor/harbor-jobservice-7445fcfbd-gn8hb                            7h49m57s ago   never        0       no error   
  resolve-labels-longhorn-system/csi-attacher-5d68b48d9-8w9g9                        7h49m57s ago   never        0       no error   
  resolve-labels-longhorn-system/engine-image-ei-e09d8caa-4nxxp                      7h49m57s ago   never        0       no error   
  resolve-labels-longhorn-system/instance-manager-f3cdddbee4b34d17fbf0e0d6af8d15c2   7h49m57s ago   never        0       no error   
  resolve-labels-longhorn-system/longhorn-csi-plugin-6lb29                           7h49m57s ago   never        0       no error   
  resolve-labels-longhorn-system/longhorn-manager-phqvw                              7h49m57s ago   never        0       no error   
  resolve-labels-monitoring/kured-57cd4                                              7h49m57s ago   never        0       no error   
  resolve-labels-monitoring/victorialogs-vector-pqlsz                                7h49m57s ago   never        0       no error   
  resolve-labels-redacted-dev/cluster-redacted-2                                       7h49m57s ago   never        0       no error   
  resolve-labels-redacted-dev/redacted-collector-dev-578d9d6889-jzlkk                  7h49m57s ago   never        0       no error   
  resolve-labels-redacted-dev/redacted-redis-job-meteo-france-radar-6407065-vjqlm      2m59s ago      never        0       no error   
  restoring-ep-identity (1078)                                                       7h50m3s ago    never        0       no error   
  restoring-ep-identity (1128)                                                       7h50m3s ago    never        0       no error   
  restoring-ep-identity (1322)                                                       7h50m3s ago    never        0       no error   
  restoring-ep-identity (1486)                                                       7h50m3s ago    never        0       no error   
  restoring-ep-identity (2245)                                                       7h50m3s ago    never        0       no error   
  restoring-ep-identity (2387)                                                       7h50m3s ago    never        0       no error   
  restoring-ep-identity (3416)                                                       7h50m3s ago    never        0       no error   
  restoring-ep-identity (349)                                                        7h50m3s ago    never        0       no error   
  restoring-ep-identity (3491)                                                       7h50m3s ago    never        0       no error   
  restoring-ep-identity (380)                                                        7h50m3s ago    never        0       no error   
  restoring-ep-identity (4060)                                                       7h50m3s ago    never        0       no error   
  sync-policymap-1078                                                                4m57s ago      never        0       no error   
  sync-policymap-1128                                                                4m57s ago      never        0       no error   
  sync-policymap-1200                                                                2m59s ago      never        0       no error   
  sync-policymap-1322                                                                4m57s ago      never        0       no error   
  sync-policymap-1486                                                                4m57s ago      never        0       no error   
  sync-policymap-1713                                                                4m57s ago      never        0       no error   
  sync-policymap-2245                                                                4m57s ago      never        0       no error   
  sync-policymap-2387                                                                4m57s ago      never        0       no error   
  sync-policymap-3416                                                                4m57s ago      never        0       no error   
  sync-policymap-349                                                                 4m57s ago      never        0       no error   
  sync-policymap-3491                                                                4m57s ago      never        0       no error   
  sync-policymap-380                                                                 4m57s ago      never        0       no error   
  sync-policymap-4060                                                                4m57s ago      never        0       no error   
  sync-to-k8s-ciliumendpoint (1078)                                                  2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (1128)                                                  2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (1200)                                                  9s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (1486)                                                  2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (2245)                                                  2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (2387)                                                  2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (3416)                                                  2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (349)                                                   2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (3491)                                                  1s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (380)                                                   2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (4060)                                                  2s ago         never        0       no error   
  waiting-initial-global-identities-ep (1078)                                        7h50m3s ago    never        0       no error   
  waiting-initial-global-identities-ep (1128)                                        7h50m3s ago    never        0       no error   
  waiting-initial-global-identities-ep (1486)                                        7h50m3s ago    never        0       no error   
  waiting-initial-global-identities-ep (2245)                                        7h50m3s ago    never        0       no error   
  waiting-initial-global-identities-ep (2387)                                        7h50m3s ago    never        0       no error   
  waiting-initial-global-identities-ep (3416)                                        7h50m3s ago    never        0       no error   
  waiting-initial-global-identities-ep (349)                                         7h50m3s ago    never        0       no error   
  waiting-initial-global-identities-ep (3491)                                        7h50m3s ago    never        0       no error   
  waiting-initial-global-identities-ep (380)                                         7h50m3s ago    never        0       no error   
  waiting-initial-global-identities-ep (4060)                                        7h50m3s ago    never        0       no error   
  write-cni-file                                                                     7h50m3s ago    never        0       no error   
Proxy Status:            OK, ip 10.0.12.161, 0 redirects active on ports 10000-20000, Envoy: external
Global Identity Range:   min 256, max 65535
Hubble:                  Ok   Current/Max Flows: 4095/4095 (100.00%), Flows/s: 1443.36   Metrics: Disabled
KubeProxyReplacement Details:
  Status:               True
  Socket LB:            Enabled
  Socket LB Tracing:    Enabled
  Socket LB Coverage:   Full
  Devices:              enp41s0   65.108.205.29 fe80::8854:58c1:2f08:6ceb, vlan4000   192.168.100.22 fe80::b54d:107:c901:d3b4 (Direct Routing), tailscale0    100.64.1.179 fd7a:115c:a1e0::1b4 fe80::9c64:81b:b01c:efd8
  Mode:                 SNAT
  Backend Selection:    Random
  Session Affinity:     Enabled
  NAT46/64 Support:     Disabled
  XDP Acceleration:     Disabled
  Services:
  - ClusterIP:      Enabled
  - NodePort:       Enabled (Range: 30000-32767) 
  - LoadBalancer:   Enabled 
  - externalIPs:    Enabled 
  - HostPort:       Enabled
  Annotations:
  - service.cilium.io/node
  - service.cilium.io/node-selector
  - service.cilium.io/proxy-delegation
  - service.cilium.io/src-ranges-policy
  - service.cilium.io/type
BPF Maps:   dynamic sizing: on (ratio: 0.002500)
  Name                          Size
  Auth                          524288
  Non-TCP connection tracking   592044
  TCP connection tracking       1184089
  Endpoints                     65535
  IP cache                      512000
  IPv4 masquerading agent       16384
  IPv6 masquerading agent       16384
  IPv4 fragmentation            8192
  IPv4 service                  65536
  IPv6 service                  65536
  IPv4 service backend          65536
  IPv6 service backend          65536
  IPv4 service reverse NAT      65536
  IPv6 service reverse NAT      65536
  Metrics                       1024
  Ratelimit metrics             64
  NAT                           1184089
  Neighbor table                1184089
  Endpoint policy               16384
  Policy stats                  65532
  Session affinity              65536
  Sock reverse NAT              592044
Encryption:   Wireguard   [NodeEncryption: Disabled, cilium_wg0 (Pubkey: BSw5bTigw43neZycBX8XP+2TTJ/COr9KdR1BXbha0gs=, Port: 51871, Peers: 11)]
```

#### Cilium environment keys

```
socket-path:/var/run/cilium/cilium.sock
identity-restore-grace-period:30s
proxy-max-concurrent-retries:128
k8s-client-connection-keep-alive:30s
bpf-lb-rss-ipv4-src-cidr:
crd-wait-timeout:5m0s
hubble-redact-enabled:false
ingress-secrets-namespace:
ipsec-key-rotation-duration:5m0s
bpf-ct-timeout-regular-tcp-fin:10s
hubble-flowlogs-config-path:
enable-wireguard:true
ip-tracing-option-type:0
enable-l7-proxy:true
kvstore-lease-ttl:15m0s
http-request-timeout:3600
envoy-log:
endpoint-gc-interval:5m0s
enable-health-checking:true
enable-endpoint-routes:false
bpf-lb-maglev-map-max:0
k8s-api-server:
bpf-filter-priority:1
ipv4-native-routing-cidr:
enable-mke:false
install-uplink-routes-for-delegated-ipam:false
clustermesh-config:/var/lib/cilium/clustermesh/
enable-k8s:true
bpf-policy-map-full-reconciliation-interval:15m0s
tofqdns-dns-reject-response-code:refused
bpf-events-drop-enabled:true
ztunnel-zds-unix-addr:/var/run/cilium/ztunnel.sock
connectivity-probe-frequency-ratio:0.5
node-port-acceleration:disabled
operator-api-serve-addr:127.0.0.1:9234
bpf-events-default-rate-limit:0
bpf-lb-service-backend-map-max:0
proxy-admin-port:0
force-device-detection:false
hubble-export-aggregation-interval:0s
preallocate-bpf-maps:false
nodes-gc-interval:5m0s
envoy-access-log-buffer-size:4096
tofqdns-pre-cache:
bypass-ip-availability-upon-restore:false
enable-icmp-rules:true
node-port-mode:
gateway-api-secrets-namespace:
monitor-aggregation-interval:5s
http-retry-count:3
enable-encryption-strict-mode-ingress:false
ipam-default-ip-pool:default
vtep-cidr:
max-controller-interval:0
bpf-lb-nat46x64:false
envoy-config-retry-interval:15s
enable-masquerade-to-route-source:false
alibabacloud-vswitch-tags:
enable-ipv6-masquerade:true
hubble-tls-cert-file:/var/lib/cilium/tls/hubble/server.crt
conntrack-gc-interval:0s
cni-chaining-target:
lrp-address-matcher-cidrs:
ipv6-native-routing-cidr:
enable-policy-secrets-sync:true
proxy-cluster-max-connections:1024
bpf-lb-sock:false
bpf-lb-algorithm-annotation:false
enable-endpoint-lockdown-on-policy-overflow:false
proxy-initial-fetch-timeout:30
hubble-export-file-compress:false
eni-use-primary-address:false
hubble-export-file-max-size-mb:10
conntrack-gc-max-interval:0s
bpf-lb-acceleration:disabled
tofqdns-min-ttl:0
node-port-bind-protection:true
hubble-redact-http-userinfo:true
encryption-strict-egress-allow-remote-node-identities:false
bpf-lb-mode:snat
disable-envoy-version-check:false
debug-verbose:
local-max-addr-scope:254
enable-endpoint-health-checking:true
version:false
tofqdns-endpoint-max-ip-per-hostname:1000
enable-k8s-host-firewall-bypass:true
http-normalize-path:true
srv6-encap-mode:reduced
disable-external-ip-mitigation:false
enable-ztunnel:false
write-cni-conf-when-ready:/host/etc/cni/net.d/05-cilium.conflist
ip-masq-agent-config-path:/etc/config/ip-masq-agent
node-labels:
bpf-ct-timeout-service-tcp-grace:1m0s
envoy-http-upstream-linger-timeout:-1
identity-management-mode:agent
mesh-auth-mutual-connect-timeout:5s
proxy-portrange-max:20000
datapath-mode:veth
l2-announcements-retry-period:2s
egress-gateway-reconciliation-trigger-interval:1s
kube-proxy-replacement-healthz-bind-address:
policy-accounting:true
multicast-enabled:false
enable-k8s-api-discovery:false
enable-ipip-termination:false
bpf-lb-rss-ipv6-src-cidr:
eni-exclude-interface-tags:
bpf-events-policy-verdict-enabled:true
bpf-ct-timeout-regular-any:1m0s
hubble-skip-unknown-cgroup-ids:true
encryption-strict-egress-cidr:
hubble-drop-events-interval:2m0s
proxy-use-original-source-address:true
cni-external-routing:false
enable-standalone-dns-proxy:false
encrypt-interface:
hubble-redact-http-headers-allow:
enable-route-mtu-for-cni-chaining:false
underlay-protocol:ipv4
agent-liveness-update-interval:1s
bpf-map-dynamic-size-ratio:0.0025
proxy-portrange-min:10000
enable-bgp-control-plane-status-report:true
endpoint-regen-interval:2m0s
bpf-neigh-global-max:524288
config:
ipv4-pod-subnets:
bpf-lb-maglev-table-size:16381
enable-service-topology:false
enable-bpf-clock-probe:false
allow-localhost:auto
auto-create-cilium-node-resource:true
enable-xdp-prefilter:false
pprof-block-profile-rate:0
enable-gops:true
vtep-sync-interval:1m0s
ipsec-key-file:
bpf-ct-timeout-regular-tcp:2h13m20s
hubble-monitor-events:
bpf-lb-sock-terminate-pod-connections:true
mesh-auth-mutual-listener-port:0
proxy-idle-timeout-seconds:60
cni-log-file:/var/run/cilium/cilium-cni.log
proxy-max-active-downstream-connections:50000
install-no-conntrack-iptables-rules:false
eni-first-interface-index:0
bpf-lb-map-max:65536
kvstore-max-consecutive-quorum-errors:2
annotate-k8s-node:false
tunnel-source-port-range:0-0
tunnel-protocol:vxlan
enable-monitor:true
bpf-policy-stats-map-max:65536
ipv6-pod-subnets:
identity-max-jitter:30s
lb-pressure-metrics-interval:5m0s
remove-cilium-node-taints:true
labels:
enable-drift-checker:true
policy-default-local-cluster:true
enable-nat46x64-gateway:false
controller-group-metrics:
bpf-policy-map-max:16384
mtu:0
pprof-port:6060
enable-ipv4:true
enable-node-selector-labels:false
service-no-backend-response:reject
ipv6-service-range:auto
ignore-flags-drift-checker:
lb-retry-backoff-max:1s
eni-delete-on-termination:true
proxy-connect-timeout:2
ipv4-service-loopback-address:169.254.42.1
dns-max-ips-per-restored-rule:1000
disable-endpoint-crd:false
enable-l2-announcements:false
hubble-dynamic-metrics-config-path:
gops-port:9890
enable-envoy-config:false
enable-pmtu-discovery:false
enable-auto-protect-node-port-range:true
enable-health-check-nodeport:true
enable-packetization-layer-pmtud:true
mesh-auth-gc-interval:5m0s
bpf-sock-rev-map-max:0
hubble-export-denylist:
ipv4-service-range:auto
bpf-fragments-map-max:8192
bpf-root:/sys/fs/bpf
clustermesh-cache-ttl:0s
bpf-lb-dsr-dispatch:opt
endpoint-queue-size:25
direct-routing-skip-unreachable:false
operator-prometheus-serve-addr::9963
enable-ipv6-big-tcp:false
use-cilium-internal-ip-for-ipsec:false
bpf-ct-global-any-max:262144
hubble-prefer-ipv6:false
log-opt:
bpf-lb-external-clusterip:false
enable-host-legacy-routing:false
status-collector-stackdump-path:/run/cilium/state/agent.stack.gz
status-collector-probe-check-timeout:5m0s
boot-id-file:/proc/sys/kernel/random/boot_id
envoy-policy-restore-timeout:3m0s
bpf-lb-sock-hostns-only:false
agent-health-port:9879
state-dir:/var/run/cilium
hubble-redact-http-headers-deny:
enable-dynamic-config:true
node-port-algorithm:
hive-stop-timeout:1m0s
mesh-auth-signal-backoff-duration:1s
hubble-export-allowlist:
policy-trigger-interval:1s
bpf-lb-source-range-map-max:0
lb-init-wait-timeout:1m0s
tofqdns-max-deferred-connection-deletes:10000
lib-dir:/var/lib/cilium
enable-l2-pod-announcements:false
k8s-require-ipv6-pod-cidr:false
bpf-ct-timeout-service-any:1m0s
cmdref:
identity-allocation-sync-interval:5m0s
enable-ipsec:false
enable-tcx:true
mesh-auth-spire-admin-socket:
set-cilium-node-taints:true
enable-bbr-hostns-only:false
bpf-ct-timeout-regular-tcp-syn:1m0s
enable-egress-gateway:true
l2-announcements-lease-duration:15s
custom-cni-conf:false
cluster-health-port:4240
nat-map-stats-entries:32
identity-heartbeat-timeout:30m0s
bpf-events-trace-enabled:true
enable-encryption-strict-mode-egress:false
envoy-keep-cap-netbindservice:false
ipv6-range:auto
hubble-lost-event-send-interval:1s
hive-start-timeout:5m0s
proxy-max-connection-duration-seconds:0
k8s-sync-timeout:3m0s
container-ip-local-reserved-ports:auto
enable-tracing:false
route-metric:0
fqdn-regex-compile-lru-size:1024
enable-ipv6:false
enable-non-default-deny-policies:true
enable-xt-socket-fallback:true
bpf-lb-service-map-max:0
enable-ipsec-key-watcher:true
hubble-export-fieldmask:
enable-hubble:true
egress-gateway-policy-map-max:16384
ipv6-service-loopback-address:fe80::1
trace-payloadlen:128
proxy-max-requests-per-connection:0
enable-k8s-networkpolicy:true
enable-cilium-api-server-access:
hubble-network-policy-correlation-enabled:true
proxy-cluster-max-requests:1024
prepend-iptables-chains:true
keep-config:false
set-cilium-is-up-condition:true
api-rate-limit:
enable-no-service-endpoints-routable:true
wireguard-persistent-keepalive:0s
hive-log-threshold:100ms
hubble-socket-path:/var/run/cilium/hubble.sock
enable-health-check-loadbalancer-ip:false
enable-bgp-legacy-origin-attribute:false
envoy-config-timeout:2m0s
enable-srv6:false
enable-metrics:true
debug:false
bpf-conntrack-accounting:false
encrypt-node:false
eni-subnet-ids:
external-envoy-proxy:true
hubble-export-file-max-backups:5
bpf-lb-rev-nat-map-max:0
enable-host-firewall:false
envoy-base-id:0
kvstore:
status-collector-interval:5s
metrics:
hubble-event-queue-size:0
http-max-grpc-timeout:0
local-router-ipv6:
derive-masq-ip-addr-from-device:
ipam:cluster-pool
bpf-lb-ipip-sock-mark:false
hubble-redact-kafka-apikey:false
enable-ipv4-fragment-tracking:true
ipam-multi-pool-pre-allocation:
nat-map-stats-interval:30s
mesh-auth-enabled:true
use-full-tls-context:false
default-lb-service-ipam:lbipam
exclude-local-address:
standalone-dns-proxy-server-port:10095
envoy-secrets-namespace:
bpf-lb-source-range-all-types:false
ipv6-node:auto
l2-pod-announcements-interface-pattern:
endpoint-bpf-prog-watchdog-interval:30s
enable-node-ipam:false
http-retry-timeout:0
ipam-max-allocate:0
bpf-node-map-max:16384
cni-chaining-mode:none
enable-sctp:false
metrics-sampling-interval:5m
enable-cilium-endpoint-slice:false
ipv6-mcast-device:
node-port-range:
bpf-nat-global-max:524288
enable-ipv4-masquerade:true
enable-ciliumnode-crd:true
enable-well-known-identities:false
azure-interface-name:
dnsproxy-concurrency-processing-grace-period:0s
cluster-id:0
dnsproxy-concurrency-limit:0
lb-retry-backoff-min:1s
dnsproxy-socket-linger-timeout:10
pprof-address:localhost
iptables-lock-timeout:5s
envoy-default-log-level:
log-system-load:false
k8s-heartbeat-timeout:30s
clustermesh-enable-mcs-api:false
routing-mode:tunnel
hubble-metrics-server-enable-tls:false
hubble-metrics-server-tls-client-ca-files:
bgp-router-id-allocation-mode:default
encryption-strict-mode-allow-remote-node-identities:false
monitor-queue-size:0
status-collector-failure-threshold:1m0s
cluster-name:default
hubble-metrics-server-tls-key-file:
enable-extended-ip-protocols:false
dnsproxy-insecure-skip-transparent-mode-check:false
enable-tunnel-big-tcp:false
enable-stale-cilium-endpoint-cleanup:true
bpf-map-event-buffers:
allocator-list-timeout:3m0s
prometheus-serve-addr:
ipv4-node:auto
enable-lb-ipam:true
bpf-events-default-burst-limit:0
wireguard-track-all-ips-fallback:false
policy-cidr-match-mode:
pprof:false
lb-state-file-interval:1s
node-encryption-opt-out-labels:node-role.kubernetes.io/control-plane
max-internal-timer-delay:0s
enable-bandwidth-manager:false
policy-secrets-namespace:cilium-secrets
monitor-aggregation:medium
hubble-metrics-server-tls-cert-file:
enable-active-connection-tracking:false
status-collector-warning-threshold:15s
hubble-drop-events-extended:false
read-cni-conf:
shell-sock-path:/var/run/cilium/shell.sock
synchronize-k8s-nodes:true
log-driver:
hubble-tls-key-file:/var/lib/cilium/tls/hubble/server.key
mke-cgroup-mount:
enable-policy:default
config-sources-overrides:{"allowConfigKeys":[],"denyConfigKeys":[]}
k8s-client-qps:10
dnsproxy-lock-count:131
tofqdns-preallocate-identities:true
bpf-ct-timeout-service-tcp:2h13m20s
enable-bpf-masquerade:true
enable-local-node-route:true
http-idle-timeout:0
hubble-drop-events:false
mesh-auth-rotated-identities-queue-size:1024
devices:
hubble-metrics-server:
trace-payloadlen-overlay:192
enable-gateway-api:false
max-connected-clusters:255
identity-gc-interval:15m0s
health-check-icmp-failure-threshold:3
dns-policy-unload-on-shutdown:false
bpf-lb-affinity-map-max:0
ipv4-range:auto
lb-state-file:
config-dir:/tmp/cilium/config-map
exclude-node-label-patterns:
enable-cilium-health-api-server-access:
tofqdns-proxy-response-max-delay:100ms
cilium-endpoint-gc-interval:5m0s
enable-cilium-clusterwide-network-policy:true
egress-masquerade-interfaces:
hubble-export-fieldaggregate:
local-router-ipv4:
kvstore-opt:
iptables-random-fully:false
mesh-auth-spiffe-trust-domain:spiffe.cilium
encryption-strict-mode-cidr:
tofqdns-idle-connection-grace-period:0s
hubble-metrics:
enable-source-ip-verification:true
tofqdns-proxy-port:0
bpf-policy-map-pressure-metrics-threshold:0.1
trace-sock:true
procfs:/host/proc
eni-security-group-tags:
cni-exclusive:true
enable-bbr:false
agent-not-ready-taint-key:node.cilium.io/agent-not-ready
enable-identity-mark:true
bpf-auth-map-max:524288
identity-change-grace-period:5s
vtep-endpoint:
vtep-mac:
k8s-require-ipv4-pod-cidr:false
alibabacloud-vswitches:
policy-audit-mode:true
bpf-ct-global-tcp-max:524288
ipam-static-ip-tags:
dnsproxy-lock-timeout:500ms
pprof-mutex-profile-fraction:0
k8s-client-burst:20
kube-proxy-replacement:true
vtep-mask:
enable-ipsec-xfrm-state-caching:true
static-cnp-path:
hubble-event-buffer-capacity:4095
eni-disable-prefix-delegation:false
enable-ip-masq-agent:false
hubble-listen-address::4244
clustermesh-enable-endpoint-sync:false
http-stream-idle-timeout:300
enable-dynamic-lifecycle-manager:false
k8s-namespace:kube-system
mesh-auth-queue-size:1024
proxy-xff-num-trusted-hops-egress:0
l2-announcements-renew-deadline:5s
enable-cilium-network-policy:true
hubble-tls-client-ca-files:/var/lib/cilium/tls/hubble/client-ca.crt
fixed-identity-mapping:
enable-vtep:false
enable-unreachable-routes:false
restore:true
ipam-min-allocate:0
enable-ipv6-fragment-tracking:true
bpf-distributed-lru:false
tunnel-port:0
ipam-cilium-node-update-rate:15s
cgroup-root:/run/cilium/cgroupv2
ipv6-cluster-alloc-cidr:f00d::/64
dynamic-lifecycle-config:[]
proxy-gid:1337
enable-l2-neigh-discovery:false
install-iptables-rules:true
policy-queue-size:100
enable-bpf-tproxy:false
label-prefix-file:
proxy-prometheus-port:0
dnsproxy-enable-transparent-mode:true
agent-health-require-k8s-connectivity:true
cluster-pool-ipv4-mask-size:24
identity-allocation-timeout:2m0s
enable-bgp-control-plane:false
enable-remote-node-masquerade:false
hubble-redact-http-urlquery:false
monitor-aggregation-flags:all
proxy-xff-num-trusted-hops-ingress:0
enable-ipv6-ndp:false
policy-secrets-only-from-secrets-namespace:true
alibabacloud-security-groups:
bgp-router-id-allocation-ip-pool:
enable-encryption-strict-mode:false
hubble-drop-events-rate-limit:1
vlan-bpf-bypass:
tofqdns-enable-dns-compression:true
disable-iptables-feeder-rules:
allow-icmp-frag-needed:true
enable-ipv4-big-tcp:false
alibabacloud-security-group-tags:
bpf-lb-maglev-hash-seed:JLfvgnHc2kaSUFaI
unmanaged-pod-watcher-interval:15s
bpf-lb-algorithm:random
allow-unsafe-policy-skb-usage:false
k8s-client-connection-timeout:30s
auto-direct-node-routes:false
ipam-pre-allocate:0
enable-ingress-controller:false
k8s-kubeconfig-path:
hubble-drop-events-reasons:
config-sources:[{"kind":"config-map","namespace":"kube-system","name":"cilium-config"}]
enable-local-redirect-policy:false
identity-allocation-mode:crd
nodeport-addresses:
eni-subnet-tags:
only-masquerade-default-pool:false
lb-sock-terminate-all-protos:false
k8s-api-server-urls:
clustermesh-sync-timeout:1m0s
bpf-lb-mode-annotation:false
cluster-pool-ipv4-cidr:10.0.0.0/8
hubble-export-file-path:
clustermesh-mcs-api-install-crds:true
enable-hubble-open-metrics:false
restored-proxy-ports-age-limit:15
certificates-directory:/var/run/cilium/certs
eni-security-groups:
direct-routing-device:
hubble-disable-tls:false
k8s-service-proxy-name:
policy-deny-response:none
agent-labels:
```


#### Endpoint list

```
ENDPOINT   POLICY (ingress)   POLICY (egress)   IDENTITY   LABELS (source:key[=value])                                                                     IPv6   IPv4          STATUS   
           ENFORCEMENT        ENFORCEMENT                                                                                                                                       
349        Disabled (Audit)   Disabled          43550      k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                         10.0.12.199   ready   
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                             
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                              
                                                           k8s:longhorn.io/component=engine-image                                                                                       
                                                           k8s:longhorn.io/engine-image=ei-e09d8caa                                                                                     
380        Disabled (Audit)   Disabled          4394       k8s:app.kubernetes.io/instance=longhorn                                                                10.0.12.24    ready   
                                                           k8s:app.kubernetes.io/managed-by=Helm                                                                                        
                                                           k8s:app.kubernetes.io/name=longhorn                                                                                          
                                                           k8s:app.kubernetes.io/version=v1.9.0                                                                                         
                                                           k8s:app=longhorn-manager                                                                                                     
                                                           k8s:helm.sh/chart=longhorn-1.9.0                                                                                             
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                               
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                             
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                              
                                                           k8s:longhorn.io/admission-webhook=longhorn-admission-webhook                                                                 
                                                           k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook                                                               
                                                           k8s:longhorn.io/recovery-backend=longhorn-recovery-backend                                                                   
1078       Disabled (Audit)   Disabled          29994      k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                         10.0.12.228   ready   
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                             
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                              
                                                           k8s:longhorn.io/component=instance-manager                                                                                   
                                                           k8s:longhorn.io/data-engine=v1                                                                                               
                                                           k8s:longhorn.io/instance-manager-image=imi-29909444                                                                          
                                                           k8s:longhorn.io/instance-manager-type=aio                                                                                    
                                                           k8s:longhorn.io/managed-by=longhorn-manager                                                                                  
                                                           k8s:longhorn.io/node=dev-agent-03                                                                                            
1128       Disabled (Audit)   Disabled          18622      k8s:cnpg.io/cluster=cluster-redacted                                                                    10.0.12.229   ready   
                                                           k8s:cnpg.io/instanceName=cluster-redacted-2                                                                                   
                                                           k8s:cnpg.io/instanceRole=replica                                                                                             
                                                           k8s:cnpg.io/podRole=instance                                                                                                 
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev                                                   
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                           k8s:io.cilium.k8s.policy.serviceaccount=cluster-redacted                                                                      
                                                           k8s:io.kubernetes.pod.namespace=redacted-dev                                                                                  
                                                           k8s:role=replica                                                                                                             
1200       Disabled (Audit)   Disabled          33088      k8s:app=redacted-processor-dev-job                                                                      10.0.12.220   ready   
                                                           k8s:batch.kubernetes.io/job-name=redacted-redis-job-meteo-france-radar-6407065                                                
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev                                                   
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                           k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account                                                    
                                                           k8s:io.kubernetes.pod.namespace=redacted-dev                                                                                  
                                                           k8s:job-name=redacted-redis-job-meteo-france-radar-6407065                                                                    
                                                           k8s:job=redis-job-meteo-france-radar                                                                                         
1322       Disabled           Disabled          1          k8s:k3s-upgrade=true                                                                                                 ready   
                                                           k8s:node.kubernetes.io/instance-type=k3s                                                                                     
                                                           k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812                                
                                                           reserved:host                                                                                                                
1486       Disabled (Audit)   Disabled          43339      k8s:app=csi-attacher                                                                                   10.0.12.226   ready   
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                               
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                             
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                              
1713       Disabled (Audit)   Disabled          4          reserved:health                                                                                        10.0.12.195   ready   
2245       Disabled (Audit)   Disabled          55741      k8s:app.kubernetes.io/component=jobservice                                                             10.0.12.243   ready   
                                                           k8s:app.kubernetes.io/instance=harbor                                                                                        
                                                           k8s:app.kubernetes.io/managed-by=Helm                                                                                        
                                                           k8s:app.kubernetes.io/name=harbor                                                                                            
                                                           k8s:app.kubernetes.io/part-of=harbor                                                                                         
                                                           k8s:app.kubernetes.io/version=2.12.0                                                                                         
                                                           k8s:app=harbor                                                                                                               
                                                           k8s:chart=harbor                                                                                                             
                                                           k8s:component=jobservice                                                                                                     
                                                           k8s:heritage=Helm                                                                                                            
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=harbor                                                        
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                           k8s:io.cilium.k8s.policy.serviceaccount=default                                                                              
                                                           k8s:io.kubernetes.pod.namespace=harbor                                                                                       
                                                           k8s:release=harbor                                                                                                           
2387       Disabled (Audit)   Disabled          5117       k8s:app=redacted-collector-dev                                                                          10.0.12.19    ready   
                                                           k8s:egress=cilium                                                                                                            
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev                                                   
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                           k8s:io.cilium.k8s.policy.serviceaccount=default                                                                              
                                                           k8s:io.kubernetes.pod.namespace=redacted-dev                                                                                  
3416       Disabled (Audit)   Disabled          28201      k8s:app=longhorn-csi-plugin                                                                            10.0.12.192   ready   
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                               
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                             
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                              
3491       Disabled (Audit)   Disabled          34352      k8s:app.kubernetes.io/component=Agent                                                                  10.0.12.88    ready   
                                                           k8s:app.kubernetes.io/instance=victorialogs                                                                                  
                                                           k8s:app.kubernetes.io/name=vector                                                                                            
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring                                                    
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                           k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector                                                                  
                                                           k8s:io.kubernetes.pod.namespace=monitoring                                                                                   
                                                           k8s:vector.dev/exclude=true                                                                                                  
4060       Disabled (Audit)   Disabled          4988       k8s:app.kubernetes.io/instance=kured                                                                   10.0.12.60    ready   
                                                           k8s:app.kubernetes.io/managed-by=Helm                                                                                        
                                                           k8s:app.kubernetes.io/name=kured                                                                                             
                                                           k8s:helm.sh/chart=kured-5.6.2                                                                                                
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring                                                    
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                           k8s:io.cilium.k8s.policy.serviceaccount=kured                                                                                
                                                           k8s:io.kubernetes.pod.namespace=monitoring                                                                                   
```

#### BPF Policy Get 349

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES   PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -       -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -       -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -       -         0        0
Allow    Egress      0          ANY          NONE         disabled    -       -         0        0

```


#### BPF CT List 349

```
Invalid argument: unknown type 349
```


#### Endpoint Get 349

```
[
  {
    "id": 349,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-349-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "eeda8231-edd5-4118-8491-f6e8f2959701"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/engine-image-ei-e09d8caa-4nxxp",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:30.031Z",
            "success-count": 2
          },
          "uuid": "a05a4a12-5193-48bf-8c47-94fea675bc5a"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (349)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "95bf758b-e188-4730-98c6-8b8788f4ce7d"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-349",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:29.845Z",
            "success-count": 32
          },
          "uuid": "575f63a3-ca10-40ba-8792-1fbd3bec1a30"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (349)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.064Z",
            "success-count": 2821
          },
          "uuid": "a7f97e3b-4c23-4627-bc2b-7a61d4db3d50"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (349)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "f00ea7b9-08f3-4b28-9a21-1dbe401b0959"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "a6836c7f4a18b763137d620888468625f8d504969558e788718e09df99aadaf2:eth0",
        "container-id": "a6836c7f4a18b763137d620888468625f8d504969558e788718e09df99aadaf2",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "engine-image-ei-e09d8caa-4nxxp",
        "pod-name": "longhorn-system/engine-image-ei-e09d8caa-4nxxp"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 43550,
        "labels": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=engine-image",
          "k8s:longhorn.io/engine-image=ei-e09d8caa"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=76b647f6f7",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=engine-image",
          "k8s:longhorn.io/engine-image=ei-e09d8caa"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.12.199",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "3a:46:aa:3c:a2:9c",
        "interface-index": 16,
        "interface-name": "lxcb08d6e347aa7",
        "mac": "a2:59:00:34:cf:a8"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43550,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43550,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 349

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 349

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 43550

```
ID      LABELS
43550   k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system
        k8s:longhorn.io/component=engine-image
        k8s:longhorn.io/engine-image=ei-e09d8caa

```


#### BPF Policy Get 380

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES       PACKETS   PREFIX   COOKIE
Allow    Ingress     0          9503/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     0          9502/TCP     NONE         disabled    383622      641       24       0
Allow    Ingress     1          9501/TCP     NONE         disabled    171440      793       24       0
Allow    Ingress     1          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2          ANY          NONE         disabled    6383623     29564     0        0
Allow    Ingress     6          9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     7          9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     9          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -           -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1252       9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     1252       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3446       9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     3446       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4394       9501/TCP     NONE         disabled    131406      1991      24       0
Allow    Ingress     4394       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6043       9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     6043       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8453       9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     8779       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15473      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     15505      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17163      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     17163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19572      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     19572      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23106      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     23106      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27422      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     27422      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    141562      1737      0        0
Allow    Ingress     28201      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     28530      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29163      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     29163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29395      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     29994      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29994      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     31674      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34995      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     35682      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39166      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     39166      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43339      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     43339      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43550      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     43616      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    230755      3105      0        0
Allow    Ingress     47918      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     48334      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49075      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     49276      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53439      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     54396      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16777217   9501/TCP     NONE         disabled    -           -         24       0
Allow    Egress      0          ANY          NONE         disabled    125761203   1016429   0        0

```


#### BPF CT List 380

```
Invalid argument: unknown type 380
```


#### Endpoint Get 380

```
[
  {
    "id": 380,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-380-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "515aa8fb-3640-4c25-b193-6f5d74f306fd"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/longhorn-manager-phqvw",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:30.082Z",
            "success-count": 2
          },
          "uuid": "36b3efe6-18da-4f0a-82d8-6cf4f28cac00"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (380)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "a69721d4-3af8-4b96-8ee4-dacaa7b7ebcb"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-380",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:29.969Z",
            "success-count": 32
          },
          "uuid": "d3693d05-7df5-4ed3-81c3-c378c9a2f339"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (380)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.064Z",
            "success-count": 2821
          },
          "uuid": "afc9bdd0-02d6-4707-a9cc-75e8e561a228"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (380)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "57a6bc6f-78ae-452e-bfb7-6880c5ff616b"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "dbd908e3d752fb2699d3b7e83deabf5822bdb1bb3c1f13eaaf2f17eaa2fad080:eth0",
        "container-id": "dbd908e3d752fb2699d3b7e83deabf5822bdb1bb3c1f13eaaf2f17eaa2fad080",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "longhorn-manager-phqvw",
        "pod-name": "longhorn-system/longhorn-manager-phqvw"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4394,
        "labels": [
          "k8s:app=longhorn-manager",
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/admission-webhook=longhorn-admission-webhook",
          "k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook",
          "k8s:longhorn.io/recovery-backend=longhorn-recovery-backend"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=55566b9bd7",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:app=longhorn-manager",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/admission-webhook=longhorn-admission-webhook",
          "k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook",
          "k8s:longhorn.io/recovery-backend=longhorn-recovery-backend"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "namedPorts": [
        {
          "name": "admission-wh",
          "port": 9502,
          "protocol": "TCP"
        },
        {
          "name": "conversion-wh",
          "port": 9501,
          "protocol": "TCP"
        },
        {
          "name": "manager",
          "port": 9500,
          "protocol": "TCP"
        },
        {
          "name": "recov-backend",
          "port": 9503,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.12.24",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "d6:b0:01:5b:8d:85",
        "interface-index": 14,
        "interface-name": "lxc601654bd1ed4",
        "mac": "12:e7:22:53:9f:f2"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4394,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                  ]
                ],
                "rule": "{\"port\":9501,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                  ]
                ],
                "rule": "{\"port\":9502,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                  ]
                ],
                "rule": "{\"port\":9503,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4394,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                  ]
                ],
                "rule": "{\"port\":9501,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                  ]
                ],
                "rule": "{\"port\":9502,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                  ]
                ],
                "rule": "{\"port\":9503,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 380

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 380

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4394

```
ID     LABELS
4394   k8s:app.kubernetes.io/instance=longhorn
       k8s:app.kubernetes.io/managed-by=Helm
       k8s:app.kubernetes.io/name=longhorn
       k8s:app.kubernetes.io/version=v1.9.0
       k8s:app=longhorn-manager
       k8s:helm.sh/chart=longhorn-1.9.0
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
       k8s:io.kubernetes.pod.namespace=longhorn-system
       k8s:longhorn.io/admission-webhook=longhorn-admission-webhook
       k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook
       k8s:longhorn.io/recovery-backend=longhorn-recovery-backend

```


#### BPF Policy Get 1078

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES      PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    726        11        0        0
Allow    Ingress     2          ANY          NONE         disabled    1122       17        0        0
Allow    Ingress     9          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -          -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -          -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    49065115   428663    0        0
Allow    Ingress     4988       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -          -         0        0
Allow    Egress      0          ANY          NONE         disabled    56181328   643605    0        0

```


#### BPF CT List 1078

```
Invalid argument: unknown type 1078
```


#### Endpoint Get 1078

```
[
  {
    "id": 1078,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1078-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "2d07d87e-ed8c-4155-96d3-050f39614b23"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/instance-manager-f3cdddbee4b34d17fbf0e0d6af8d15c2",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:30.074Z",
            "success-count": 2
          },
          "uuid": "98f62cfa-201c-4bb0-8ccf-5d1e399bd7cc"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1078)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "ecaa6dd7-0a5d-4265-b608-03c033801baf"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1078",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:29.969Z",
            "success-count": 32
          },
          "uuid": "de2cef4e-c0ea-4f6b-a663-10833459ce2b"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1078)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.064Z",
            "success-count": 2821
          },
          "uuid": "f3f7c52e-bb94-475f-a5cf-84b76b448c76"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1078)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "5c99c5da-0768-498a-9aa4-c67161c1b72d"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "24a514a2b3554dbeda94406ff94c2e2c4a4e22ece2acddda1dc7c8a42fd415b0:eth0",
        "container-id": "24a514a2b3554dbeda94406ff94c2e2c4a4e22ece2acddda1dc7c8a42fd415b0",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "instance-manager-f3cdddbee4b34d17fbf0e0d6af8d15c2",
        "pod-name": "longhorn-system/instance-manager-f3cdddbee4b34d17fbf0e0d6af8d15c2"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 29994,
        "labels": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=instance-manager",
          "k8s:longhorn.io/data-engine=v1",
          "k8s:longhorn.io/instance-manager-image=imi-29909444",
          "k8s:longhorn.io/instance-manager-type=aio",
          "k8s:longhorn.io/managed-by=longhorn-manager",
          "k8s:longhorn.io/node=dev-agent-03"
        ]
      },
      "labels": {
        "realized": {},
        "security-relevant": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=instance-manager",
          "k8s:longhorn.io/data-engine=v1",
          "k8s:longhorn.io/instance-manager-image=imi-29909444",
          "k8s:longhorn.io/instance-manager-type=aio",
          "k8s:longhorn.io/managed-by=longhorn-manager",
          "k8s:longhorn.io/node=dev-agent-03"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.12.228",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "aa:58:49:e9:96:e2",
        "interface-index": 194,
        "interface-name": "lxc62eeea06bb0b",
        "mac": "92:9d:67:cc:5b:03"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 29994,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=instance-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 29994,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=instance-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1078

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1078

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 29994

```
ID      LABELS
29994   k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system
        k8s:longhorn.io/component=instance-manager
        k8s:longhorn.io/data-engine=v1
        k8s:longhorn.io/instance-manager-image=imi-29909444
        k8s:longhorn.io/instance-manager-type=aio
        k8s:longhorn.io/managed-by=longhorn-manager
        k8s:longhorn.io/node=dev-agent-03

```


#### BPF Policy Get 1128

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2          ANY          NONE         disabled    74        1         0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    208532    2818      0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    104266    1409      0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    5914154   79921     0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    703841    4704      0        0

```


#### BPF CT List 1128

```
Invalid argument: unknown type 1128
```


#### Endpoint Get 1128

```
[
  {
    "id": 1128,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1128-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "3513cc03-db13-4cea-ad73-638b6950bb6c"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-redacted-dev/cluster-redacted-2",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:30.068Z",
            "success-count": 2
          },
          "uuid": "baee69ac-550d-474c-a4da-42f53abbddad"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1128)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "b7a16051-732f-4368-b580-0679b2bc4ea3"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1128",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:29.969Z",
            "success-count": 32
          },
          "uuid": "0a2811d6-b3a3-4ad1-b859-fa33a1f72949"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1128)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.064Z",
            "success-count": 2821
          },
          "uuid": "53f0ea8f-49cb-4ee4-9df6-3f141b6688fb"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1128)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "01cd02fd-6149-4486-a1c9-1c90641318bb"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "ee9d8592739e8117d61d43386df66838518c2d3cab3c0717e72434832b330c95:eth0",
        "container-id": "ee9d8592739e8117d61d43386df66838518c2d3cab3c0717e72434832b330c95",
        "k8s-namespace": "redacted-dev",
        "k8s-pod-name": "cluster-redacted-2",
        "pod-name": "redacted-dev/cluster-redacted-2"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 18622,
        "labels": [
          "k8s:cnpg.io/cluster=cluster-redacted",
          "k8s:cnpg.io/instanceName=cluster-redacted-2",
          "k8s:cnpg.io/instanceRole=replica",
          "k8s:cnpg.io/podRole=instance",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=cluster-redacted",
          "k8s:io.kubernetes.pod.namespace=redacted-dev",
          "k8s:role=replica"
        ]
      },
      "labels": {
        "realized": {},
        "security-relevant": [
          "k8s:cnpg.io/cluster=cluster-redacted",
          "k8s:cnpg.io/instanceName=cluster-redacted-2",
          "k8s:cnpg.io/instanceRole=replica",
          "k8s:cnpg.io/podRole=instance",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=cluster-redacted",
          "k8s:io.kubernetes.pod.namespace=redacted-dev",
          "k8s:role=replica"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "namedPorts": [
        {
          "name": "metrics",
          "port": 9187,
          "protocol": "TCP"
        },
        {
          "name": "postgresql",
          "port": 5432,
          "protocol": "TCP"
        },
        {
          "name": "status",
          "port": 8000,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.12.229",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "f2:a5:5d:07:39:6e",
        "interface-index": 196,
        "interface-name": "lxcfa1c13c9a018",
        "mac": "42:ba:71:53:d7:b8"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 18622,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 18622,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1128

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1128

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 18622

```
ID      LABELS
18622   k8s:cnpg.io/cluster=cluster-redacted
        k8s:cnpg.io/instanceName=cluster-redacted-2
        k8s:cnpg.io/instanceRole=replica
        k8s:cnpg.io/podRole=instance
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=cluster-redacted
        k8s:io.kubernetes.pod.namespace=redacted-dev
        k8s:role=replica

```


#### BPF Policy Get 1200

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES      PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -          -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -          -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    740        10        0        0
Allow    Ingress     33454      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -          -         0        0
Allow    Egress      0          ANY          NONE         disabled    39948300   28116     0        0

```


#### BPF CT List 1200

```
Invalid argument: unknown type 1200
```


#### Endpoint Get 1200

```
[
  {
    "id": 1200,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1200-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "ae486e2f-09cf-4dcd-a391-ca981ef21c32"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "5m0s"
          },
          "name": "resolve-identity-1200",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:06:28.011Z",
            "success-count": 1
          },
          "uuid": "34117c9c-9716-461d-a66e-1c2e2f6ba383"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-redacted-dev/redacted-redis-job-meteo-france-radar-6407065-vjqlm",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:06:28.011Z",
            "success-count": 1
          },
          "uuid": "73a8def9-3dc5-4739-857e-8d5faff19c1d"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1200",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:06:28.102Z",
            "success-count": 1
          },
          "uuid": "21bcae2f-eb0b-4bca-91ea-d8b9829d2be7"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1200)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:28.053Z",
            "success-count": 20
          },
          "uuid": "1b5b5e10-5177-429a-965d-1ffb56911a4a"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "d0a6de49f75ed91be64e1203da3fde4b6ecb2aca62fe80467a1e99a834e69702:eth0",
        "container-id": "d0a6de49f75ed91be64e1203da3fde4b6ecb2aca62fe80467a1e99a834e69702",
        "k8s-namespace": "redacted-dev",
        "k8s-pod-name": "redacted-redis-job-meteo-france-radar-6407065-vjqlm",
        "pod-name": "redacted-dev/redacted-redis-job-meteo-france-radar-6407065-vjqlm"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 33088,
        "labels": [
          "k8s:app=redacted-processor-dev-job",
          "k8s:batch.kubernetes.io/job-name=redacted-redis-job-meteo-france-radar-6407065",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account",
          "k8s:io.kubernetes.pod.namespace=redacted-dev",
          "k8s:job=redis-job-meteo-france-radar",
          "k8s:job-name=redacted-redis-job-meteo-france-radar-6407065"
        ]
      },
      "labels": {
        "derived": [
          "k8s:batch.kubernetes.io/controller-uid=94141be2-6ef0-4890-9fb5-422e665e3cf8",
          "k8s:controller-uid=94141be2-6ef0-4890-9fb5-422e665e3cf8"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=redacted-processor-dev-job",
          "k8s:batch.kubernetes.io/job-name=redacted-redis-job-meteo-france-radar-6407065",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account",
          "k8s:io.kubernetes.pod.namespace=redacted-dev",
          "k8s:job-name=redacted-redis-job-meteo-france-radar-6407065",
          "k8s:job=redis-job-meteo-france-radar"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.12.220",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "0e:3d:b7:d0:c2:20",
        "interface-index": 2616,
        "interface-name": "lxcf20c5c939af5",
        "mac": "7e:a2:b8:5c:72:da"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 33088,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 33088,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1200

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1200

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:28Z   OK       ready                   Successfully regenerated endpoint program (Reason: updated security labels)
2026-01-19T22:06:28Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:28Z   OK       regenerating            Regenerating endpoint: updated security labels
2026-01-19T22:06:28Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to updated security labels
2026-01-19T22:06:28Z   OK       ready                   Set identity for this endpoint
2026-01-19T22:06:27Z   OK       waiting-for-identity    Endpoint creation

```


#### Identity get 33088

```
ID      LABELS
33088   k8s:app=redacted-processor-dev-job
        k8s:batch.kubernetes.io/job-name=redacted-redis-job-meteo-france-radar-6407065
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account
        k8s:io.kubernetes.pod.namespace=redacted-dev
        k8s:job-name=redacted-redis-job-meteo-france-radar-6407065
        k8s:job=redis-job-meteo-france-radar

```


#### BPF Policy Get 1322

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES   PACKETS   PREFIX   COOKIE
Allow    Ingress     0          ANY          NONE         disabled    -       -         0        0
Allow    Egress      0          ANY          NONE         disabled    -       -         0        0

```


#### BPF CT List 1322

```
Invalid argument: unknown type 1322
```


#### Endpoint Get 1322

```
[
  {
    "id": 1322,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1322-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "6f99f5c8-c28a-4608-8e95-0f705b1afdcd"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-/",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:24.008Z",
            "success-count": 1
          },
          "uuid": "02cefff2-2aa9-4f09-80c8-536b1f7c2de8"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1322)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "b3269ac2-07bf-4023-b6f5-ffb05c981e58"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1322",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:30.153Z",
            "success-count": 32
          },
          "uuid": "85f215ea-d8ed-4177-996f-682acfb6c973"
        }
      ],
      "external-identifiers": {
        "pod-name": "/"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 1,
        "labels": [
          "reserved:host",
          "k8s:k3s-upgrade=true",
          "k8s:node.kubernetes.io/instance-type=k3s",
          "k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812"
        ]
      },
      "labels": {
        "derived": [
          "k8s:k3s-upgrade=true",
          "k8s:node.kubernetes.io/instance-type=k3s",
          "k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812",
          "reserved:host"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:k3s-upgrade=true",
          "k8s:node.kubernetes.io/instance-type=k3s",
          "k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812",
          "reserved:host"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "networking": {
        "addressing": [
          {}
        ],
        "host-mac": "1a:56:00:9d:4f:eb",
        "interface-index": 6,
        "interface-name": "cilium_host",
        "mac": "1a:56:00:9d:4f:eb"
      },
      "policy": {
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            0
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 1,
          "l4": {
            "egress": [],
            "ingress": []
          },
          "policy-enabled": "none",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            0
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 1,
          "l4": {
            "egress": [],
            "ingress": []
          },
          "policy-enabled": "none",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1322

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1322

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 1

```
ID   LABELS
1    reserved:host

```


#### BPF Policy Get 1486

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES    PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -        -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -        -         0        0
Allow    Egress      0          ANY          NONE         disabled    660173   7565      0        0

```


#### BPF CT List 1486

```
Invalid argument: unknown type 1486
```


#### Endpoint Get 1486

```
[
  {
    "id": 1486,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1486-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "098ce4b5-9b24-4863-97b2-3973353be6bd"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/csi-attacher-5d68b48d9-8w9g9",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:30.051Z",
            "success-count": 2
          },
          "uuid": "0bae36ff-df47-40cf-aa65-75e497755f2e"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1486)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "80307cfc-114f-42a2-a24e-2b485c524ad4"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1486",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:29.928Z",
            "success-count": 32
          },
          "uuid": "2bfac98d-eb43-4d56-afc7-d087a5f0dc23"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1486)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.214Z",
            "success-count": 2821
          },
          "uuid": "24700d8d-4021-43b5-9085-af7aee71915a"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1486)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "be210cf5-bb9e-4645-b91a-121d237f3c5d"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "c9c61776896066fec87dcc23d6ed89d911fd26ea713483a9454c30cc29555108:eth0",
        "container-id": "c9c61776896066fec87dcc23d6ed89d911fd26ea713483a9454c30cc29555108",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "csi-attacher-5d68b48d9-8w9g9",
        "pod-name": "longhorn-system/csi-attacher-5d68b48d9-8w9g9"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 43339,
        "labels": [
          "k8s:app=csi-attacher",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=5d68b48d9"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=csi-attacher",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "namedPorts": [
        {
          "name": "csi-attacher",
          "port": 8000,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.12.226",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "32:e9:b9:a4:f7:1c",
        "interface-index": 2392,
        "interface-name": "lxc7bf192e1d178",
        "mac": "be:1b:81:e7:39:82"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43339,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43339,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1486

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1486

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 43339

```
ID      LABELS
43339   k8s:app=csi-attacher
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system

```


#### BPF Policy Get 1713

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES    PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    277340   3250      0        0
Allow    Ingress     2          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -        -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -        -         0        0
Allow    Egress      0          ANY          NONE         disabled    -        -         0        0

```


#### BPF CT List 1713

```
Invalid argument: unknown type 1713
```


#### Endpoint Get 1713

```
[
  {
    "id": 1713,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1713-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "e404e449-6b00-409f-9875-19fe81d7a3d8"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "5m0s"
          },
          "name": "resolve-identity-1713",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:24.752Z",
            "success-count": 95
          },
          "uuid": "1eeba4ec-09c9-43df-935b-d852e4d678f8"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1713",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:30.026Z",
            "success-count": 32
          },
          "uuid": "1ec95f82-ad8b-41c0-b0b7-b3e1d59652a2"
        }
      ],
      "external-identifiers": {
        "container-name": "cilium-health",
        "pod-name": "/"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4,
        "labels": [
          "reserved:health"
        ]
      },
      "labels": {
        "realized": {},
        "security-relevant": [
          "reserved:health"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.12.195",
            "ipv4-pool-name": "default"
          }
        ],
        "host-mac": "5a:50:a6:94:69:e3",
        "interface-index": 2446,
        "interface-name": "lxc_health",
        "mac": "da:25:06:6e:80:97"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1713

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1713

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4

```
ID   LABELS
4    reserved:health

```


#### BPF Policy Get 2245

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES    PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    1110     15        0        0
Allow    Ingress     2          ANY          NONE         disabled    38406    519       0        0
Allow    Ingress     9          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -        -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -        -         0        0
Allow    Egress      0          ANY          NONE         disabled    560228   6719      0        0

```


#### BPF CT List 2245

```
Invalid argument: unknown type 2245
```


#### Endpoint Get 2245

```
[
  {
    "id": 2245,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-2245-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "8fb336a1-1518-4887-823f-b08e49b0ab68"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-harbor/harbor-jobservice-7445fcfbd-gn8hb",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:30.139Z",
            "success-count": 2
          },
          "uuid": "1e1ba207-d1c3-4b91-bbda-317722599202"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (2245)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "b1ce3301-88bf-4324-9318-6580066af0c0"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-2245",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:29.969Z",
            "success-count": 32
          },
          "uuid": "14a357ba-8a6e-4507-8d57-3acac62c0fff"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (2245)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.064Z",
            "success-count": 2821
          },
          "uuid": "80a21bff-2ddb-4d92-8a5a-8b60ac6a04dd"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (2245)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "fd95ea0c-e560-454a-af2e-2d6d2cbbc8f2"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "75b0fdb4d6127519bbab9981dc1b3386291bd5bb66ffa268554333e6a7e87c35:eth0",
        "container-id": "75b0fdb4d6127519bbab9981dc1b3386291bd5bb66ffa268554333e6a7e87c35",
        "k8s-namespace": "harbor",
        "k8s-pod-name": "harbor-jobservice-7445fcfbd-gn8hb",
        "pod-name": "harbor/harbor-jobservice-7445fcfbd-gn8hb"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 55741,
        "labels": [
          "k8s:app=harbor",
          "k8s:app.kubernetes.io/component=jobservice",
          "k8s:app.kubernetes.io/instance=harbor",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=harbor",
          "k8s:app.kubernetes.io/part-of=harbor",
          "k8s:app.kubernetes.io/version=2.12.0",
          "k8s:chart=harbor",
          "k8s:component=jobservice",
          "k8s:heritage=Helm",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=harbor",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=harbor",
          "k8s:release=harbor"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=7445fcfbd"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/component=jobservice",
          "k8s:app.kubernetes.io/instance=harbor",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=harbor",
          "k8s:app.kubernetes.io/part-of=harbor",
          "k8s:app.kubernetes.io/version=2.12.0",
          "k8s:app=harbor",
          "k8s:chart=harbor",
          "k8s:component=jobservice",
          "k8s:heritage=Helm",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=harbor",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=harbor",
          "k8s:release=harbor"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.12.243",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "02:b8:23:d6:08:c4",
        "interface-index": 198,
        "interface-name": "lxcf6ad4645aae9",
        "mac": "82:14:b2:05:ce:e5"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 55741,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 55741,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 2245

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 2245

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 55741

```
ID      LABELS
55741   k8s:app.kubernetes.io/component=jobservice
        k8s:app.kubernetes.io/instance=harbor
        k8s:app.kubernetes.io/managed-by=Helm
        k8s:app.kubernetes.io/name=harbor
        k8s:app.kubernetes.io/part-of=harbor
        k8s:app.kubernetes.io/version=2.12.0
        k8s:app=harbor
        k8s:chart=harbor
        k8s:component=jobservice
        k8s:heritage=Helm
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=harbor
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=default
        k8s:io.kubernetes.pod.namespace=harbor
        k8s:release=harbor

```


#### BPF Policy Get 2387

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES          PACKETS    PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    80929          947        0        0
Allow    Ingress     2          ANY          NONE         disabled    2940019        34391      0        0
Allow    Ingress     9          ANY          NONE         disabled    -              -          0        0
Allow    Ingress     10         ANY          NONE         disabled    -              -          0        0
Allow    Ingress     465        ANY          NONE         disabled    -              -          0        0
Allow    Ingress     566        ANY          NONE         disabled    -              -          0        0
Allow    Ingress     1252       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     1596       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     1624       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     1637       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     2269       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     2645       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     2833       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     2843       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     2978       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     3128       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     3446       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     3592       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     3761       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     3836       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     3866       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     4394       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     4988       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     5015       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     5080       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     5117       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     5438       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     5493       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     5643       ANY          NONE         disabled    551059         3538       0        0
Allow    Ingress     5993       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     6043       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     6344       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     6933       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     7513       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     7936       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     8105       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     8231       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     8241       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     8367       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     8453       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     8779       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     9194       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     9585       ANY          NONE         disabled    -              -          0        0
Allow    Ingress     10807      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     11332      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     12176      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     12201      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     12307      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     12337      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     13556      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     13626      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     13786      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     14280      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     14657      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     14667      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     14966      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     14973      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     15202      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     15473      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     15505      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     15927      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     16376      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     16908      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     16992      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     17163      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     17926      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     18592      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     18622      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     19324      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     19460      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     19572      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     19792      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     19881      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     19945      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     20806      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     22863      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     22922      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     23106      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     23582      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     24706      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     24736      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     25152      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     25226      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     25555      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     25589      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     26001      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     26267      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     26869      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     26892      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     27422      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     27486      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     28201      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     28530      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     28621      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     29089      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     29163      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     29395      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     29994      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     31674      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     31840      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     32467      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     33088      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     33311      ANY          NONE         disabled    4102506        56353      0        0
Allow    Ingress     33454      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     33688      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     33755      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     34216      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     34266      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     34352      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     34736      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     34995      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     35682      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     35696      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     36596      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     37415      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     37517      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     38491      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     39166      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     39278      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     39699      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     40088      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     41969      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     42199      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     42605      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     42869      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     43339      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     43550      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     43616      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     47483      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     47918      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     48334      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     48593      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     49075      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     49276      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     52241      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     52642      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     52772      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     53263      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     53293      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     53439      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     54396      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     54583      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     55202      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     55741      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     57633      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     58710      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     60465      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     60492      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     60523      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     61421      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     61927      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     62026      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     63330      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     64556      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     65239      ANY          NONE         disabled    -              -          0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -              -          0        0
Allow    Egress      0          ANY          NONE         disabled    195560676659   57094883   0        0

```


#### BPF CT List 2387

```
Invalid argument: unknown type 2387
```


#### Endpoint Get 2387

```
[
  {
    "id": 2387,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-2387-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "4b1f4372-6dfb-415c-8f38-27c6399bfc3b"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-redacted-dev/redacted-collector-dev-578d9d6889-jzlkk",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:29.812Z",
            "success-count": 2
          },
          "uuid": "e2b1a9b4-6cba-4257-b00e-9cdae2ca747b"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (2387)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "89ad3c34-9fef-4af0-b094-473da8b4f03d"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-2387",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:29.839Z",
            "success-count": 32
          },
          "uuid": "a3371d0c-4730-490a-95c3-99dca2d2acc5"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (2387)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.064Z",
            "success-count": 2821
          },
          "uuid": "d16a8afc-c9f0-43a4-9e9a-f0122b336305"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (2387)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "51486fc7-38e4-4bc5-a4b2-c77d3328555f"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "dbef6b9995ba6afc3f565239348e45c18500408a9ae9a6849b63f124e1f05179:eth0",
        "container-id": "dbef6b9995ba6afc3f565239348e45c18500408a9ae9a6849b63f124e1f05179",
        "k8s-namespace": "redacted-dev",
        "k8s-pod-name": "redacted-collector-dev-578d9d6889-jzlkk",
        "pod-name": "redacted-dev/redacted-collector-dev-578d9d6889-jzlkk"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 5117,
        "labels": [
          "k8s:app=redacted-collector-dev",
          "k8s:egress=cilium",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=redacted-dev"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=578d9d6889"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=redacted-collector-dev",
          "k8s:egress=cilium",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=redacted-dev"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.12.19",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "f2:e1:e2:04:9d:e3",
        "interface-index": 2394,
        "interface-name": "lxc8ab63553e77b",
        "mac": "e6:b2:52:91:56:d2"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 5117,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 5117,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 2387

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 2387

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 5117

```
ID     LABELS
5117   k8s:app=redacted-collector-dev
       k8s:egress=cilium
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=default
       k8s:io.kubernetes.pod.namespace=redacted-dev

```


#### BPF Policy Get 3416

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          9808/TCP     NONE         disabled    63394     712       24       0
Allow    Ingress     1          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2          9808/TCP     NONE         disabled    2495996   27983     24       0
Allow    Ingress     2          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     7          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29395      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    648628    7468      0        0

```


#### BPF CT List 3416

```
Invalid argument: unknown type 3416
```


#### Endpoint Get 3416

```
[
  {
    "id": 3416,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-3416-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "26c4977a-4987-4542-a9f7-a55d7cde76f1"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/longhorn-csi-plugin-6lb29",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:30.091Z",
            "success-count": 2
          },
          "uuid": "00796828-edd8-4087-814a-58bf2ed61b7a"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (3416)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "b4d334c4-8aea-423a-b923-8970b03ad901"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-3416",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:29.903Z",
            "success-count": 32
          },
          "uuid": "c38fe0fb-320f-4525-b0ad-42983a9980da"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (3416)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.064Z",
            "success-count": 2821
          },
          "uuid": "2804c030-c449-4082-bc21-23f477d41666"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (3416)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "dd4b9bf0-7f1c-4a3a-b86a-06043ed58400"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "12b384e7885dff61634b590ce2749c6745f761e257fd3cd7709541dcab1f09d3:eth0",
        "container-id": "12b384e7885dff61634b590ce2749c6745f761e257fd3cd7709541dcab1f09d3",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "longhorn-csi-plugin-6lb29",
        "pod-name": "longhorn-system/longhorn-csi-plugin-6lb29"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 28201,
        "labels": [
          "k8s:app=longhorn-csi-plugin",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=5769d89c9f",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=longhorn-csi-plugin",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.12.192",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "3a:08:5e:24:cd:57",
        "interface-index": 12,
        "interface-name": "lxccfc638ab8ff0",
        "mac": "c2:80:21:9e:fe:e6"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 28201,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                  ]
                ],
                "rule": "{\"port\":9808,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 28201,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                  ]
                ],
                "rule": "{\"port\":9808,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 3416

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 3416

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 28201

```
ID      LABELS
28201   k8s:app=longhorn-csi-plugin
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system

```


#### BPF Policy Get 3491

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES        PACKETS    PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     10         ANY          NONE         disabled    -            -          0        0
Allow    Ingress     465        ANY          NONE         disabled    -            -          0        0
Allow    Ingress     566        ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1252       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1596       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1624       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1637       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2269       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2645       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2833       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2843       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2978       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3128       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3446       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3592       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3761       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3836       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3866       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     4394       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     4988       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5015       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5080       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5117       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5438       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5493       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5643       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5993       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6043       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6344       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6933       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     7513       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     7936       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8105       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8231       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8241       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8367       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8453       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8779       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9194       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9585       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     10807      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     11332      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12176      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12201      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12307      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12337      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13556      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13626      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13786      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14280      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14657      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14667      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14966      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14973      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15202      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15473      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15505      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15927      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16376      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16908      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16992      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     17163      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     17926      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     18592      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     18622      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19324      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19460      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19572      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19792      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19881      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19945      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     20806      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     22863      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     22922      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     23106      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     23582      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     24706      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     24736      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25152      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25226      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25555      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25589      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26001      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26267      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26869      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26892      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     27422      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     27486      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28201      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28530      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28621      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29089      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29163      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29395      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29994      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     31674      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     31840      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     32467      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33088      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33311      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33454      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33688      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33755      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34216      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34266      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34352      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34736      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34995      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     35682      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     35696      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     36596      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     37415      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     37517      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     38491      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39166      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39278      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39699      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     40088      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     41969      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42199      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42605      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42869      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43339      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43550      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43616      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     47483      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     47918      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     48334      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     48593      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     49075      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     49276      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52241      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52642      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52772      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53263      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53293      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53439      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     54396      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     54583      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     55202      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     55741      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     57633      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     58710      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60465      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60492      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60523      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     61421      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     61927      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     62026      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     63330      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     64556      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     65239      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -            -          0        0
Allow    Egress      0          ANY          NONE         disabled    3823815559   22235292   0        0

```


#### BPF CT List 3491

```
Invalid argument: unknown type 3491
```


#### Endpoint Get 3491

```
[
  {
    "id": 3491,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-3491-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "babb096d-6368-4edc-894e-ac35de48e798"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-monitoring/victorialogs-vector-pqlsz",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:30.018Z",
            "success-count": 2
          },
          "uuid": "68f4fa98-1992-455f-bda2-1532c53914fb"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (3491)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "557bb44c-1d20-47ee-88aa-68fee6f03be1"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-3491",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:29.885Z",
            "success-count": 32
          },
          "uuid": "cde4396c-5ef0-43f3-8c68-c8f39762d0a4"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (3491)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.453Z",
            "success-count": 2821
          },
          "uuid": "d51fb9e0-38de-41b6-bc9f-e401cfbc32f2"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (3491)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "4fe4c0df-3cc9-429b-82a6-e1bc5d3c9a62"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "5fc9893575bb4ac8cc561f77699a327e2fb0a1a4f62f228955e854ae720cdce6:eth0",
        "container-id": "5fc9893575bb4ac8cc561f77699a327e2fb0a1a4f62f228955e854ae720cdce6",
        "k8s-namespace": "monitoring",
        "k8s-pod-name": "victorialogs-vector-pqlsz",
        "pod-name": "monitoring/victorialogs-vector-pqlsz"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 34352,
        "labels": [
          "k8s:app.kubernetes.io/component=Agent",
          "k8s:app.kubernetes.io/instance=victorialogs",
          "k8s:app.kubernetes.io/name=vector",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector",
          "k8s:io.kubernetes.pod.namespace=monitoring",
          "k8s:vector.dev/exclude=true"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=547c594464",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/component=Agent",
          "k8s:app.kubernetes.io/instance=victorialogs",
          "k8s:app.kubernetes.io/name=vector",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector",
          "k8s:io.kubernetes.pod.namespace=monitoring",
          "k8s:vector.dev/exclude=true"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "namedPorts": [
        {
          "name": "prom-exporter",
          "port": 9090,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.12.88",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "52:d4:13:85:af:2d",
        "interface-index": 18,
        "interface-name": "lxc29c4c070ddf2",
        "mac": "3e:b9:59:0b:be:27"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 34352,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 34352,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 3491

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 3491

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 34352

```
ID      LABELS
34352   k8s:app.kubernetes.io/component=Agent
        k8s:app.kubernetes.io/instance=victorialogs
        k8s:app.kubernetes.io/name=vector
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector
        k8s:io.kubernetes.pod.namespace=monitoring
        k8s:vector.dev/exclude=true

```


#### BPF Policy Get 4060

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    28959     359       0        0
Allow    Ingress     2          ANY          NONE         disabled    1062237   13150     0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    -         -         0        0

```


#### BPF CT List 4060

```
Invalid argument: unknown type 4060
```


#### Endpoint Get 4060

```
[
  {
    "id": 4060,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-4060-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "99136e7f-268b-4e02-bd1e-738ce96cc77b"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-monitoring/kured-57cd4",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:30.064Z",
            "success-count": 2
          },
          "uuid": "15b174a5-6ed9-41db-96c4-c43388c0a877"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (4060)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "25fda6fb-da4a-42ab-8b24-cbaf0e935888"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-4060",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:29.965Z",
            "success-count": 32
          },
          "uuid": "73f89610-6f9c-41f5-a597-07e2671edde7"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (4060)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.064Z",
            "success-count": 2821
          },
          "uuid": "a1dfccf4-30b0-4528-98e6-499df1071eba"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (4060)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:23.687Z",
            "success-count": 1
          },
          "uuid": "306e759f-fd60-441f-802a-7fbbda35fda0"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "1a1239f9e8b2db1a0215877323a12a26d703b623ebf0610b4e9c9cfef56786ec:eth0",
        "container-id": "1a1239f9e8b2db1a0215877323a12a26d703b623ebf0610b4e9c9cfef56786ec",
        "k8s-namespace": "monitoring",
        "k8s-pod-name": "kured-57cd4",
        "pod-name": "monitoring/kured-57cd4"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4988,
        "labels": [
          "k8s:app.kubernetes.io/instance=kured",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=kured",
          "k8s:helm.sh/chart=kured-5.6.2",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kured",
          "k8s:io.kubernetes.pod.namespace=monitoring"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=796657747b",
          "k8s:pod-template-generation=4"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=kured",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=kured",
          "k8s:helm.sh/chart=kured-5.6.2",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kured",
          "k8s:io.kubernetes.pod.namespace=monitoring"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:09:23Z"
        }
      ],
      "namedPorts": [
        {
          "name": "metrics",
          "port": 8080,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.12.60",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "0a:24:a6:94:c8:e7",
        "interface-index": 352,
        "interface-name": "lxcfdf0fe342df8",
        "mac": "1e:04:23:91:67:d8"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4988,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4988,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 4060

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 4060

```
Timestamp              Status   State                   Message
2026-01-19T22:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:23Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4988

```
ID     LABELS
4988   k8s:app.kubernetes.io/instance=kured
       k8s:app.kubernetes.io/managed-by=Helm
       k8s:app.kubernetes.io/name=kured
       k8s:helm.sh/chart=kured-5.6.2
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=kured
       k8s:io.kubernetes.pod.namespace=monitoring

```


#### Service list

```
ID    Frontend                  Service Type   Backend                                   
1     10.43.140.7:9402/TCP      ClusterIP      1 => 10.0.8.198:9402/TCP (active)         
2     10.43.143.190:443/TCP     ClusterIP      1 => 10.0.8.196:10250/TCP (active)        
3     10.43.235.23:443/TCP      ClusterIP      1 => 10.0.11.242:9443/TCP (active)        
4     10.43.0.1:443/TCP         ClusterIP      1 => 192.168.100.10:6443/TCP (active)     
                                               2 => 192.168.100.11:6443/TCP (active)     
                                               3 => 192.168.100.12:6443/TCP (active)     
5     10.43.137.234:80/TCP      ClusterIP      1 => 10.0.11.78:8080/TCP (active)         
6     10.43.182.35:5432/TCP     ClusterIP      1 => 10.0.2.69:5432/TCP (active)          
7     10.43.185.45:80/TCP       ClusterIP      1 => 10.0.12.243:8080/TCP (maintenance)   
8     10.43.120.177:80/TCP      ClusterIP      1 => 10.0.2.144:8080/TCP (active)         
9     10.43.173.175:6379/TCP    ClusterIP      1 => 10.0.2.94:6379/TCP (active)          
10    10.43.155.42:5000/TCP     ClusterIP      1 => 10.0.2.111:5000/TCP (active)         
11    10.43.155.42:8080/TCP     ClusterIP      1 => 10.0.2.111:8080/TCP (active)         
12    10.43.56.177:8080/TCP     ClusterIP      1 => 10.0.11.214:8080/TCP (active)        
13    10.43.135.54:80/TCP       ClusterIP      1 => 10.0.0.220:80/TCP (active)           
                                               2 => 10.0.2.88:80/TCP (active)            
                                               3 => 10.0.13.209:80/TCP (active)          
14    10.43.135.54:443/TCP      ClusterIP      1 => 10.0.0.220:443/TCP (active)          
                                               2 => 10.0.2.88:443/TCP (active)           
                                               3 => 10.0.13.209:443/TCP (active)         
18    0.0.0.0:31337/TCP         NodePort       1 => 10.0.0.220:80/TCP (active)           
                                               2 => 10.0.2.88:80/TCP (active)            
                                               3 => 10.0.13.209:80/TCP (active)          
22    0.0.0.0:30908/TCP         NodePort       1 => 10.0.0.220:443/TCP (active)          
                                               2 => 10.0.2.88:443/TCP (active)           
                                               3 => 10.0.13.209:443/TCP (active)         
23    10.43.241.115:443/TCP     ClusterIP      1 => 10.0.0.220:8443/TCP (active)         
                                               2 => 10.0.2.88:8443/TCP (active)          
                                               3 => 10.0.13.209:8443/TCP (active)        
24    10.43.254.4:443/TCP       ClusterIP      1 => 192.168.100.22:4244/TCP (active)     
25    10.43.135.114:80/TCP      ClusterIP      1 => 10.0.8.116:4245/TCP (active)         
26    10.43.52.21:80/TCP        ClusterIP      1 => 10.0.0.107:8081/TCP (active)         
27    10.43.0.10:53/UDP         ClusterIP      1 => 10.0.2.158:53/UDP (active)           
28    10.43.0.10:53/TCP         ClusterIP      1 => 10.0.2.158:53/TCP (active)           
29    10.43.0.10:9153/TCP       ClusterIP      1 => 10.0.2.158:9153/TCP (active)         
30    10.43.159.1:443/TCP       ClusterIP      1 => 10.0.2.237:10250/TCP (active)        
31    10.43.177.85:5557/TCP     ClusterIP      1 => 10.0.2.90:5557/TCP (active)          
32    10.43.177.85:5558/TCP     ClusterIP      1 => 10.0.2.90:5558/TCP (active)          
33    10.43.177.85:8089/TCP     ClusterIP      1 => 10.0.2.90:8089/TCP (active)          
34    10.43.134.50:9502/TCP     ClusterIP      1 => 10.0.0.68:9502/TCP (active)          
                                               2 => 10.0.2.190:9502/TCP (active)         
                                               3 => 10.0.5.87:9502/TCP (active)          
                                               4 => 10.0.6.35:9502/TCP (active)          
                                               5 => 10.0.7.203:9502/TCP (active)         
                                               6 => 10.0.8.150:9502/TCP (active)         
                                               7 => 10.0.9.211:9502/TCP (active)         
                                               8 => 10.0.10.111:9502/TCP (active)        
                                               9 => 10.0.11.30:9502/TCP (active)         
                                               10 => 10.0.12.24:9502/TCP (active)        
                                               11 => 10.0.13.16:9502/TCP (active)        
                                               12 => 10.0.14.170:9502/TCP (active)       
35    10.43.4.198:9500/TCP      ClusterIP      1 => 10.0.0.68:9500/TCP (active)          
                                               2 => 10.0.2.190:9500/TCP (active)         
                                               3 => 10.0.5.87:9500/TCP (active)          
                                               4 => 10.0.6.35:9500/TCP (active)          
                                               5 => 10.0.7.203:9500/TCP (active)         
                                               6 => 10.0.8.150:9500/TCP (active)         
                                               7 => 10.0.9.211:9500/TCP (active)         
                                               8 => 10.0.10.111:9500/TCP (active)        
                                               9 => 10.0.11.30:9500/TCP (active)         
                                               10 => 10.0.12.24:9500/TCP (active)        
                                               11 => 10.0.13.16:9500/TCP (active)        
                                               12 => 10.0.14.170:9500/TCP (active)       
36    10.43.105.144:9501/TCP    ClusterIP      1 => 10.0.0.68:9501/TCP (active)          
                                               2 => 10.0.2.190:9501/TCP (active)         
                                               3 => 10.0.5.87:9501/TCP (active)          
                                               4 => 10.0.6.35:9501/TCP (active)          
                                               5 => 10.0.7.203:9501/TCP (active)         
                                               6 => 10.0.8.150:9501/TCP (active)         
                                               7 => 10.0.9.211:9501/TCP (active)         
                                               8 => 10.0.10.111:9501/TCP (active)        
                                               9 => 10.0.11.30:9501/TCP (active)         
                                               10 => 10.0.12.24:9501/TCP (active)        
                                               11 => 10.0.13.16:9501/TCP (active)        
                                               12 => 10.0.14.170:9501/TCP (active)       
37    10.43.246.180:80/TCP      ClusterIP      1 => 10.0.2.38:8000/TCP (active)          
                                               2 => 10.0.13.26:8000/TCP (active)         
38    10.43.210.20:9503/TCP     ClusterIP      1 => 10.0.0.68:9503/TCP (active)          
                                               2 => 10.0.2.190:9503/TCP (active)         
                                               3 => 10.0.5.87:9503/TCP (active)          
                                               4 => 10.0.6.35:9503/TCP (active)          
                                               5 => 10.0.7.203:9503/TCP (active)         
                                               6 => 10.0.8.150:9503/TCP (active)         
                                               7 => 10.0.9.211:9503/TCP (active)         
                                               8 => 10.0.10.111:9503/TCP (active)        
                                               9 => 10.0.11.30:9503/TCP (active)         
                                               10 => 10.0.12.24:9503/TCP (active)        
                                               11 => 10.0.13.16:9503/TCP (active)        
                                               12 => 10.0.14.170:9503/TCP (active)       
39    10.43.7.198:9003/TCP      ClusterIP      1 => 10.0.5.133:9003/TCP (active)         
40    10.43.7.198:9090/TCP      ClusterIP      1 => 10.0.5.133:9090/TCP (active)         
41    10.43.153.111:8429/TCP    ClusterIP      1 => 10.0.5.60:8429/TCP (active)          
42    10.43.134.2:8080/TCP      ClusterIP      1 => 10.0.11.20:8080/TCP (active)         
43    10.43.96.250:9100/TCP     ClusterIP                                                
44    10.43.102.143:8080/TCP    ClusterIP      1 => 10.0.9.186:8080/TCP (active)         
45    10.43.102.143:9443/TCP    ClusterIP      1 => 10.0.9.186:9443/TCP (active)         
46    10.43.158.92:8428/TCP     ClusterIP      1 => 10.0.6.169:8428/TCP (active)         
47    10.43.124.188:80/TCP      ClusterIP      1 => 10.0.2.146:4180/TCP (active)         
48    10.43.124.188:44180/TCP   ClusterIP      1 => 10.0.2.146:44180/TCP (active)        
49    10.43.136.244:6379/TCP    ClusterIP                                                
50    10.43.123.199:9121/TCP    ClusterIP                                                
51    10.43.103.159:5432/TCP    ClusterIP      1 => 10.0.9.191:5432/TCP (maintenance)    
52    10.43.144.150:5432/TCP    ClusterIP                                                
53    10.43.174.66:5432/TCP     ClusterIP      1 => 10.0.9.191:5432/TCP (maintenance)    
54    10.43.228.139:8080/TCP    ClusterIP      1 => 10.0.11.111:8080/TCP (maintenance)   
55    10.43.43.90:8080/TCP      ClusterIP      1 => 10.0.7.55:8080/TCP (maintenance)     
56    10.43.13.222:5432/TCP     ClusterIP      1 => 10.0.12.229:5432/TCP (maintenance)   
                                               2 => 10.0.14.51:5432/TCP (active)         
57    10.43.233.54:5432/TCP     ClusterIP      1 => 10.0.12.229:5432/TCP (maintenance)   
58    10.43.231.192:5432/TCP    ClusterIP      1 => 10.0.14.51:5432/TCP (active)         
59    10.43.152.86:3000/TCP     ClusterIP      1 => 10.0.0.30:3000/TCP (active)          
60    10.43.250.59:8080/TCP     ClusterIP      1 => 10.0.6.212:8080/TCP (active)         
61    10.43.69.189:8080/TCP     ClusterIP      1 => 10.0.12.19:8080/TCP (active)         
62    10.43.17.147:8000/TCP     ClusterIP      1 => 10.0.8.129:8000/TCP (active)         
63    10.43.9.105:8080/TCP      ClusterIP      1 => 10.0.9.170:8080/TCP (active)         
64    10.43.228.145:8080/TCP    ClusterIP      1 => 10.0.0.84:8080/TCP (active)          
65    10.43.243.11:8080/TCP     ClusterIP      1 => 10.0.5.142:8080/TCP (active)         
66    10.43.130.49:8000/TCP     ClusterIP      1 => 10.0.0.245:8000/TCP (active)         
                                               2 => 10.0.5.77:8000/TCP (active)          
                                               3 => 10.0.9.178:8000/TCP (active)         
                                               4 => 10.0.11.4:8000/TCP (active)          
67    10.43.184.39:8080/TCP     ClusterIP      1 => 10.0.11.42:8080/TCP (active)         
68    10.43.170.239:8080/TCP    ClusterIP      1 => 10.0.2.123:8080/TCP (active)         
69    10.43.154.43:8080/TCP     ClusterIP      1 => 10.0.2.214:8080/TCP (active)         
84    10.43.185.251:8080/TCP    ClusterIP      1 => 10.0.9.197:8080/TCP (maintenance)    
85    10.43.222.236:8080/TCP    ClusterIP      1 => 10.0.13.165:8080/TCP (maintenance)   
112   10.43.2.220:3000/TCP      ClusterIP      1 => 10.0.9.5:3000/TCP (maintenance)      
113   10.43.57.80:3888/TCP      ClusterIP      1 => 10.0.8.28:3888/TCP (active)          
                                               2 => 10.0.9.46:3888/TCP (active)          
                                               3 => 10.0.11.66:3888/TCP (maintenance)    
114   10.43.57.80:2181/TCP      ClusterIP      1 => 10.0.8.28:2181/TCP (active)          
                                               2 => 10.0.9.46:2181/TCP (active)          
                                               3 => 10.0.11.66:2181/TCP (maintenance)    
115   10.43.57.80:2888/TCP      ClusterIP      1 => 10.0.8.28:2888/TCP (active)          
                                               2 => 10.0.9.46:2888/TCP (active)          
                                               3 => 10.0.11.66:2888/TCP (maintenance)    
116   10.43.208.117:5432/TCP    ClusterIP      1 => 10.0.9.80:5432/TCP (active)          
117   10.43.82.123:8123/TCP     ClusterIP      1 => 10.0.10.192:8123/TCP (active)        
                                               2 => 10.0.13.1:8123/TCP (active)          
                                               3 => 10.0.14.236:8123/TCP (active)        
118   10.43.82.123:9000/TCP     ClusterIP      1 => 10.0.10.192:9000/TCP (active)        
                                               2 => 10.0.13.1:9000/TCP (active)          
                                               3 => 10.0.14.236:9000/TCP (active)        
119   10.43.82.123:9004/TCP     ClusterIP      1 => 10.0.10.192:9004/TCP (active)        
                                               2 => 10.0.13.1:9004/TCP (active)          
                                               3 => 10.0.14.236:9004/TCP (active)        
120   10.43.82.123:9005/TCP     ClusterIP      1 => 10.0.10.192:9005/TCP (active)        
                                               2 => 10.0.13.1:9005/TCP (active)          
                                               3 => 10.0.14.236:9005/TCP (active)        
121   10.43.82.123:9009/TCP     ClusterIP      1 => 10.0.10.192:9009/TCP (active)        
                                               2 => 10.0.13.1:9009/TCP (active)          
                                               3 => 10.0.14.236:9009/TCP (active)        
122   10.43.104.20:6379/TCP     ClusterIP      1 => 10.0.9.89:6379/TCP (maintenance)     
123   10.43.13.77:9000/TCP      ClusterIP      1 => 10.0.11.36:9000/TCP (active)         
124   10.43.13.77:9001/TCP      ClusterIP      1 => 10.0.11.36:9001/TCP (active)         
125   10.43.210.167:5432/TCP    ClusterIP                                                
126   10.43.56.234:5432/TCP     ClusterIP                                                
127   10.43.148.227:5432/TCP    ClusterIP                                                
137   10.43.173.222:9121/TCP    ClusterIP      1 => 10.0.10.205:9121/TCP (active)        
138   10.43.215.61:6379/TCP     ClusterIP      1 => 10.0.10.205:6379/TCP (active)        
144   10.43.4.93:9091/TCP       ClusterIP      1 => 10.0.5.46:9091/TCP (maintenance)     
                                               2 => 10.0.8.124:9091/TCP (maintenance)    
                                               3 => 10.0.11.189:9091/TCP (maintenance)   
145   10.43.4.93:9092/TCP       ClusterIP      1 => 10.0.5.46:9092/TCP (maintenance)     
                                               2 => 10.0.8.124:9092/TCP (maintenance)    
                                               3 => 10.0.11.189:9092/TCP (maintenance)   
146   10.43.4.93:9093/TCP       ClusterIP      1 => 10.0.5.46:9093/TCP (maintenance)     
                                               2 => 10.0.8.124:9093/TCP (maintenance)    
                                               3 => 10.0.11.189:9093/TCP (maintenance)   
```

#### ipam

```
(string) (len=6) "owners"
(map[ipam.Pool]map[string]string) (len=1) {
 (ipam.Pool) (len=7) default: (map[string]string) (len=13) {
  (string) (len=10) "10.0.12.24": (string) (len=49) "longhorn-system/longhorn-manager-phqvw [restored]",
  (string) (len=11) "10.0.12.192": (string) (len=52) "longhorn-system/longhorn-csi-plugin-6lb29 [restored]",
  (string) (len=11) "10.0.12.243": (string) (len=51) "harbor/harbor-jobservice-7445fcfbd-gn8hb [restored]",
  (string) (len=10) "10.0.12.88": (string) (len=47) "monitoring/victorialogs-vector-pqlsz [restored]",
  (string) (len=11) "10.0.12.228": (string) (len=76) "longhorn-system/instance-manager-f3cdddbee4b34d17fbf0e0d6af8d15c2 [restored]",
  (string) (len=11) "10.0.12.229": (string) (len=40) "redacted-dev/cluster-redacted-2 [restored]",
  (string) (len=10) "10.0.12.19": (string) (len=61) "redacted-dev/redacted-collector-dev-578d9d6889-jzlkk [restored]",
  (string) (len=11) "10.0.12.195": (string) (len=6) "health",
  (string) (len=10) "10.0.12.60": (string) (len=33) "monitoring/kured-57cd4 [restored]",
  (string) (len=11) "10.0.12.226": (string) (len=55) "longhorn-system/csi-attacher-5d68b48d9-8w9g9 [restored]",
  (string) (len=11) "10.0.12.199": (string) (len=57) "longhorn-system/engine-image-ei-e09d8caa-4nxxp [restored]",
  (string) (len=11) "10.0.12.161": (string) (len=6) "router",
  (string) (len=11) "10.0.12.220": (string) (len=62) "redacted-dev/redacted-redis-job-meteo-france-radar-6407065-vjqlm"
 }
}
(string) (len=17) "expiration timers"
(map[ipam.timerKey]ipam.expirationTimer) {
}
(string) (len=12) "excluded ips"
(map[string]string) (len=1) {
 (string) (len=22) "default:192.168.100.22": (string) (len=7) "node-ip"
}

```


#### kvstore-locks

```
(map[string]kvstore.lockOwner) {
}

```


#### ongoing-endpoint-creations


#### Cilium version

```
1.19.0-rc.0 b6f44c92 2026-01-14T23:04:46+00:00 go version go1.25.5 linux/amd64
```


#### Kernel version

```
6.12.0
```


#### Policy get

```
:
 [
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "instance-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "instance-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "2ff1f074-01bb-452c-85e6-a10cc548b287",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/managed-by": "longhorn-manager"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-driver-deployer",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      "cidr:0.0.0.0/0"
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-internet",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "3435d905-c9c4-480e-b86e-a2c964f77c42",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": false,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "backing-image-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "5220481c-b461-4d94-adaf-7955db01ad5f",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka"
        }
      },
      "cidr:10.0.0.0/12"
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "8080",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-node-ingress",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "a9a888a5-cbf8-4324-bab7-fa93a3a6b77b",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {}
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-same-namespace",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "4f936664-abef-481c-a701-081659408cae",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": false,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-ui",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-csi-plugin",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        },
        "matchExpressions": [
          {
            "key": "k8s.longhorn.io/job-task",
            "operator": "Exists"
          }
        ]
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      },
      "cidr:10.0.0.0/12"
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/name": "kafka-cluster-kafka-exporter"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-data-source"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "backing-image-data-source"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-data-source",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "6b710528-3078-446b-bf8d-e2dda11cfc84",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka"
        }
      },
      "cidr:0.0.0.0/0"
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9092",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-internet",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "3435d905-c9c4-480e-b86e-a2c964f77c42",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/kind": "cluster-operator"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9090",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/name": "kafka-cluster-cruise-control"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-same-namespace",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "4f936664-abef-481c-a701-081659408cae",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {},
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default"
        },
        "matchExpressions": [
          {
            "key": "k8s.io.kubernetes.pod.namespace",
            "operator": "Exists"
          }
        ]
      }
    ],
    "L4": [],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumClusterwideNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "test-allow-cluster-ingress-all",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "43ed3334-a7fd-4b02-a5ec-b7234ea021b4",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-data-source"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-data-source",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "6b710528-3078-446b-bf8d-e2dda11cfc84",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-data-source"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "instance-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-data-source",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "6b710528-3078-446b-bf8d-e2dda11cfc84",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-data-source"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "backing-image-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-data-source",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "6b710528-3078-446b-bf8d-e2dda11cfc84",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/cluster": "kafka-cluster",
          "k8s.strimzi.io/kind": "Kafka",
          "k8s.strimzi.io/name": "kafka-cluster-kafka"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9092",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app.kubernetes.io/component": "controller",
        "k8s.app.kubernetes.io/name": "ingress-nginx",
        "k8s.io.kubernetes.pod.namespace": "ingress-nginx"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "80",
            "protocol": "TCP"
          },
          {
            "port": "443",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumClusterwideNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-all-to-ingress-nginx",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "9b0662a3-d945-4917-9cd7-524feb6d4f54",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "any.app": "longhorn-csi-plugin",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "reserved.remote-node": ""
        }
      },
      {
        "matchLabels": {
          "reserved.host": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv4": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv6": ""
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9808",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-csi-plugin-node-access",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "4c790d77-1673-4c32-a951-9dccc4b34c5f",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/admission-webhook": "longhorn-admission-webhook"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9502",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-admission-webhook",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "dafd5ae7-fec1-4361-9b68-15a84634f20e",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/name": "kafka-cluster-entity-operator"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/recovery-backend": "longhorn-recovery-backend"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9503",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-recovery-backend",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "a48ed662-92ca-48cf-8eb5-84f664e63c39",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {}
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-same-namespace",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "4f936664-abef-481c-a701-081659408cae",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": false,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "any.app.kubernetes.io/name": "ingress-nginx",
        "k8s.io.kubernetes.pod.namespace": "ingress-internal"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "reserved.world": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv4": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv6": ""
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "80",
            "protocol": "TCP"
          },
          {
            "port": "443",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-world-to-ingress-nginx",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "ingress-internal",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "5e2f2bdd-f374-4698-ab40-0bd473bc18f6",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/kind": "cluster-operator"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/kind": "cluster-operator"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "8443",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-csi-plugin",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9808",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-csi-plugin",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "dcfe5679-1b87-415a-be9a-b0f75aff8771",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "any.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "reserved.remote-node": ""
        }
      },
      {
        "matchLabels": {
          "reserved.host": ""
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager-node-access",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "3692c6de-9cb3-4390-bb4b-3e56867f9f61",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/cluster": "kafka-cluster",
          "k8s.strimzi.io/kind": "Kafka",
          "k8s.strimzi.io/name": "kafka-cluster-kafka"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9090",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "instance-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "5220481c-b461-4d94-adaf-7955db01ad5f",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "instance-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "instance-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "instance-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "2ff1f074-01bb-452c-85e6-a10cc548b287",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "instance-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "backing-image-data-source"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "instance-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "2ff1f074-01bb-452c-85e6-a10cc548b287",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9093",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "5220481c-b461-4d94-adaf-7955db01ad5f",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-csi-plugin",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      },
      "cidr:10.0.0.0/12"
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9808",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-csi-plugin",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "dcfe5679-1b87-415a-be9a-b0f75aff8771",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-ui",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app.kubernetes.io/component": "controller",
          "k8s.app.kubernetes.io/instance": "ingress-nginx",
          "k8s.app.kubernetes.io/name": "ingress-nginx",
          "k8s.io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name": "ingress-nginx",
          "k8s.io.cilium.k8s.policy.cluster": "default"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-ui",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b75292d2-11c7-467c-8558-50508860334c",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {},
    "L3": [
      {
        "matchLabels": {
          "reserved.world": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv4": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv6": ""
        }
      }
    ],
    "L4": [],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumClusterwideNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "test-allow-cluster-ingress-all",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "43ed3334-a7fd-4b02-a5ec-b7234ea021b4",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  }
]
Revision: 25

```


#### Cilium memory map


```
00400000-03a47000 r-xp 00000000 00:7c 2714809                            /usr/bin/cilium-agent
03a47000-07dfe000 r--p 03647000 00:7c 2714809                            /usr/bin/cilium-agent
07dfe000-080c9000 rw-p 079fe000 00:7c 2714809                            /usr/bin/cilium-agent
080c9000-08657000 rw-p 00000000 00:00 0 
c000000000-c009800000 rw-p 00000000 00:00 0                              [anon: Go: heap]
c009800000-c00c000000 ---p 00000000 00:00 0                              [anon: Go: heap reservation]
7f8f2eb38000-7f8f2eb78000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2eb78000-7f8f2eb88000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f2eb88000-7f8f2ebc8000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2ebc8000-7f8f2ebd8000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f2ebd8000-7f8f2ec98000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2ec98000-7f8f2eca8000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f2eca8000-7f8f2eccc000 rw-p 00000000 00:00 0                          [anon: Go: allspans array]
7f8f2eccc000-7f8f2ecec000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f2ecec000-7f8f2ed2c000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2ed2d000-7f8f2ed4d000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f2ed52000-7f8f2ed53000 rw-p 00000000 00:00 0                          [anon: Go: getrandom states]
7f8f2ed56000-7f8f2ed68000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2ed68000-7f8f2ed78000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f2ed78000-7f8f2edb8000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2edc6000-7f8f2edf6000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f2edf7000-7f8f2ee37000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2ee37000-7f8f2ee38000 rw-s 00000000 00:10 2078                       anon_inode:bpf-map
7f8f2ee38000-7f8f2ee4a000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2ee4a000-7f8f2ee8b000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2ee8b000-7f8f2eecc000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2eecc000-7f8f2ef0d000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2ef0d000-7f8f2ef4e000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2ef4e000-7f8f2ef8f000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2ef8f000-7f8f2efd0000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2efd0000-7f8f2f011000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2f011000-7f8f2f052000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2f052000-7f8f2f093000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2f093000-7f8f2f0d4000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2f0d4000-7f8f2f115000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2f115000-7f8f2f156000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2f156000-7f8f2f196000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2f196000-7f8f2f198000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2f198000-7f8f2f19a000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2f19a000-7f8f2f19c000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2f19c000-7f8f2f19e000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2f19e000-7f8f2f1a0000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f2f1a0000-7f8f2f220000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2f220000-7f8f2f230000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f2f230000-7f8f2f270000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2f270000-7f8f2f280000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f2f280000-7f8f2f340000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2f340000-7f8f2f350000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f2f350000-7f8f2f450000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2f450000-7f8f2f460000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f2f460000-7f8f2f7a0000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f2f7a0000-7f8f2f900000 rw-p 00000000 00:00 0                          [anon: Go: profiler hash buckets]
7f8f2f900000-7f8f2fa00000 rw-p 00000000 00:00 0                          [anon: Go: page alloc index]
7f8f2fa00000-7f8f31a00000 rw-p 00000000 00:00 0                          [anon: Go: heap index]
7f8f31a00000-7f8f41b80000 ---p 00000000 00:00 0                          [anon: Go: scavenge index]
7f8f41b80000-7f8f41b81000 rw-p 00000000 00:00 0                          [anon: Go: scavenge index]
7f8f41b81000-7f8f51a00000 ---p 00000000 00:00 0                          [anon: Go: scavenge index]
7f8f51a00000-7f8f61b80000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7f8f61b80000-7f8f61b81000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7f8f61b81000-7f8f73a30000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7f8f73a30000-7f8f73a31000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7f8f73a31000-7f8f75e06000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7f8f75e06000-7f8f75e07000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7f8f75e07000-7f8f76200000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7f8f76200000-7f8f76202000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f76202000-7f8f76204000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f76204000-7f8f76206000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f76206000-7f8f76208000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f76208000-7f8f7620a000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f7620a000-7f8f7620c000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f7620c000-7f8f7620e000 rw-s 00000000 00:10 2078                       anon_inode:[perf_event]
7f8f7620e000-7f8f7621e000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f7621e000-7f8f7621f000 rw-p 00000000 00:00 0                          [anon: Go: getrandom states]
7f8f7621f000-7f8f76235000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f76235000-7f8f76255000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7f8f76255000-7f8f76267000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f76267000-7f8f762e7000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7f8f762e7000-7f8f762e8000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7f8f762e8000-7f8f76367000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7f8f76367000-7f8f76387000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7f8f76387000-7f8f763c7000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7f8f763c7000-7f8f763cb000 r--p 00000000 00:00 0                          [vvar]
7f