# Cilium debug information

#### Cilium status

```
KVStore:                Disabled   
Kubernetes:             Ok         1.35 (v1.35.0+k3s1) [linux/amd64]
Kubernetes APIs:        ["cilium/v2::CiliumCIDRGroup", "cilium/v2::CiliumClusterwideNetworkPolicy", "cilium/v2::CiliumEndpoint", "cilium/v2::CiliumNetworkPolicy", "cilium/v2::CiliumNode", "core/v1::Pods", "networking.k8s.io/v1::NetworkPolicy"]
KubeProxyReplacement:   True   [enp8s0   65.109.103.254 fe80::387f:3d1f:b49d:44dd, vlan4000   192.168.100.10 fe80::2cf9:774b:b98:5e41 (Direct Routing), tailscale0    100.64.0.154 fd7a:115c:a1e0::9b fe80::6bd9:7bec:b025:b55a]
Host firewall:          Disabled
SRv6:                   Disabled
CNI Chaining:           none
CNI Config file:        successfully wrote CNI configuration file to /host/etc/cni/net.d/05-cilium.conflist
Cilium:                 Ok   1.19.0-rc.0 (v1.19.0-rc.0-b6f44c92)
NodeMonitor:            Listening for events on 12 CPUs with 64x4096 of shared memory
Cilium health daemon:   Ok   
IPAM:                   IPv4: 15/254 allocated from 10.0.13.0/24, 
Allocated addresses:
  10.0.13.1 (langfuse/langfuse-clickhouse-shard0-0 [restored])
  10.0.13.138 (monitoring/kured-4bsc4 [restored])
  10.0.13.16 (longhorn-system/longhorn-manager-c9mnx [restored])
  10.0.13.165 (outdoor-platform-dev/outdoor-platform-ws-dev-795d799998-vlmzf [restored])
  10.0.13.178 (router)
  10.0.13.185 (longhorn-system/instance-manager-abbde5560bb0c9372ec9cd26e887eaac [restored])
  10.0.13.192 (longhorn-system/csi-resizer-6c558c9fbc-p4pd9 [restored])
  10.0.13.20 (system-upgrade/system-upgrade-controller-6fbbfc5bc8-wfblf [restored])
  10.0.13.209 (ingress-internal/ingress-nginx-controller-59bb75dc84-fcclv [restored])
  10.0.13.222 (health)
  10.0.13.226 (monitoring/victorialogs-vector-5zfcb [restored])
  10.0.13.24 (longhorn-system/engine-image-ei-e09d8caa-7t4lt [restored])
  10.0.13.240 (longhorn-system/longhorn-csi-plugin-lllgb [restored])
  10.0.13.26 (longhorn-system/longhorn-ui-6b44759848-kg79c [restored])
  10.0.13.71 (redacted-dev/redacted-redis-job-met-nordic-6403506-x84gl [restored])
IPv4 BIG TCP:           Disabled
IPv6 BIG TCP:           Disabled
BandwidthManager:       Disabled
Routing:                Network: Tunnel [vxlan]   Host: BPF
Attach Mode:            TCX
Device Mode:            veth
Masquerading:           BPF   [enp8s0, vlan4000, tailscale0]   10.0.13.0/24  [IPv4: Enabled, IPv6: Disabled]
Clock Source for BPF:   ktime
Controller Status:      93/93 healthy
  Name                                                                               Last success   Last error   Count   Message
  cilium-health-ep                                                                   48s ago        never        0       no error   
  ct-map-pressure                                                                    22s ago        never        0       no error   
  endpoint-1011-regeneration-recovery                                                never          never        0       no error   
  endpoint-1158-regeneration-recovery                                                never          never        0       no error   
  endpoint-1356-regeneration-recovery                                                never          never        0       no error   
  endpoint-1441-regeneration-recovery                                                never          never        0       no error   
  endpoint-2581-regeneration-recovery                                                never          never        0       no error   
  endpoint-2619-regeneration-recovery                                                never          never        0       no error   
  endpoint-285-regeneration-recovery                                                 never          never        0       no error   
  endpoint-31-regeneration-recovery                                                  never          never        0       no error   
  endpoint-334-regeneration-recovery                                                 never          never        0       no error   
  endpoint-3817-regeneration-recovery                                                never          never        0       no error   
  endpoint-3873-regeneration-recovery                                                never          never        0       no error   
  endpoint-3947-regeneration-recovery                                                never          never        0       no error   
  endpoint-663-regeneration-recovery                                                 never          never        0       no error   
  endpoint-7-regeneration-recovery                                                   never          never        0       no error   
  endpoint-870-regeneration-recovery                                                 never          never        0       no error   
  endpoint-gc                                                                        3m50s ago      never        0       no error   
  endpoint-periodic-regeneration                                                     49s ago        never        0       no error   
  ipcache-inject-labels                                                              49s ago        never        0       no error   
  k8s-heartbeat                                                                      19s ago        never        0       no error   
  local-identity-checkpoint                                                          7h1m50s ago    never        0       no error   
  resolve-identity-2581                                                              3m48s ago      never        0       no error   
  resolve-labels-/                                                                   7h48m49s ago   never        0       no error   
  resolve-labels-ingress-internal/ingress-nginx-controller-59bb75dc84-fcclv          7h48m44s ago   never        0       no error   
  resolve-labels-langfuse/langfuse-clickhouse-shard0-0                               7h48m44s ago   never        0       no error   
  resolve-labels-longhorn-system/csi-resizer-6c558c9fbc-p4pd9                        7h48m44s ago   never        0       no error   
  resolve-labels-longhorn-system/engine-image-ei-e09d8caa-7t4lt                      7h48m44s ago   never        0       no error   
  resolve-labels-longhorn-system/instance-manager-abbde5560bb0c9372ec9cd26e887eaac   7h48m44s ago   never        0       no error   
  resolve-labels-longhorn-system/longhorn-csi-plugin-lllgb                           7h48m44s ago   never        0       no error   
  resolve-labels-longhorn-system/longhorn-manager-c9mnx                              7h48m44s ago   never        0       no error   
  resolve-labels-longhorn-system/longhorn-ui-6b44759848-kg79c                        7h48m44s ago   never        0       no error   
  resolve-labels-monitoring/kured-4bsc4                                              7h48m44s ago   never        0       no error   
  resolve-labels-monitoring/victorialogs-vector-5zfcb                                7h48m44s ago   never        0       no error   
  resolve-labels-outdoor-platform-dev/outdoor-platform-ws-dev-795d799998-vlmzf       7h48m44s ago   never        0       no error   
  resolve-labels-system-upgrade/system-upgrade-controller-6fbbfc5bc8-wfblf           7h48m44s ago   never        0       no error   
  resolve-labels-redacted-dev/redacted-redis-job-met-nordic-6403506-x84gl              7h48m44s ago   never        0       no error   
  restoring-ep-identity (1011)                                                       7h48m49s ago   never        0       no error   
  restoring-ep-identity (1158)                                                       7h48m49s ago   never        0       no error   
  restoring-ep-identity (1356)                                                       7h48m49s ago   never        0       no error   
  restoring-ep-identity (1441)                                                       7h48m49s ago   never        0       no error   
  restoring-ep-identity (2619)                                                       7h48m49s ago   never        0       no error   
  restoring-ep-identity (285)                                                        7h48m49s ago   never        0       no error   
  restoring-ep-identity (31)                                                         7h48m49s ago   never        0       no error   
  restoring-ep-identity (334)                                                        7h48m49s ago   never        0       no error   
  restoring-ep-identity (3817)                                                       7h48m49s ago   never        0       no error   
  restoring-ep-identity (3873)                                                       7h48m49s ago   never        0       no error   
  restoring-ep-identity (3947)                                                       7h48m49s ago   never        0       no error   
  restoring-ep-identity (663)                                                        7h48m49s ago   never        0       no error   
  restoring-ep-identity (7)                                                          7h48m49s ago   never        0       no error   
  restoring-ep-identity (870)                                                        7h48m49s ago   never        0       no error   
  sync-policymap-1011                                                                3m44s ago      never        0       no error   
  sync-policymap-1158                                                                3m44s ago      never        0       no error   
  sync-policymap-1356                                                                3m44s ago      never        0       no error   
  sync-policymap-1441                                                                3m44s ago      never        0       no error   
  sync-policymap-2581                                                                3m44s ago      never        0       no error   
  sync-policymap-2619                                                                3m44s ago      never        0       no error   
  sync-policymap-285                                                                 3m44s ago      never        0       no error   
  sync-policymap-31                                                                  3m44s ago      never        0       no error   
  sync-policymap-334                                                                 3m44s ago      never        0       no error   
  sync-policymap-3817                                                                3m44s ago      never        0       no error   
  sync-policymap-3873                                                                3m44s ago      never        0       no error   
  sync-policymap-3947                                                                3m44s ago      never        0       no error   
  sync-policymap-663                                                                 3m42s ago      never        0       no error   
  sync-policymap-7                                                                   3m44s ago      never        0       no error   
  sync-policymap-870                                                                 3m44s ago      never        0       no error   
  sync-to-k8s-ciliumendpoint (1011)                                                  8s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (1158)                                                  7s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (1356)                                                  8s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (1441)                                                  8s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (2619)                                                  7s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (285)                                                   7s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (31)                                                    7s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (334)                                                   8s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (3817)                                                  8s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (3873)                                                  8s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (3947)                                                  8s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (7)                                                     8s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (870)                                                   8s ago         never        0       no error   
  waiting-initial-global-identities-ep (1011)                                        7h48m49s ago   never        0       no error   
  waiting-initial-global-identities-ep (1158)                                        7h48m49s ago   never        0       no error   
  waiting-initial-global-identities-ep (1356)                                        7h48m49s ago   never        0       no error   
  waiting-initial-global-identities-ep (1441)                                        7h48m49s ago   never        0       no error   
  waiting-initial-global-identities-ep (2619)                                        7h48m49s ago   never        0       no error   
  waiting-initial-global-identities-ep (285)                                         7h48m49s ago   never        0       no error   
  waiting-initial-global-identities-ep (31)                                          7h48m49s ago   never        0       no error   
  waiting-initial-global-identities-ep (334)                                         7h48m49s ago   never        0       no error   
  waiting-initial-global-identities-ep (3817)                                        7h48m49s ago   never        0       no error   
  waiting-initial-global-identities-ep (3873)                                        7h48m49s ago   never        0       no error   
  waiting-initial-global-identities-ep (3947)                                        7h48m49s ago   never        0       no error   
  waiting-initial-global-identities-ep (7)                                           7h48m49s ago   never        0       no error   
  waiting-initial-global-identities-ep (870)                                         7h48m49s ago   never        0       no error   
  write-cni-file                                                                     7h48m50s ago   never        0       no error   
Proxy Status:            OK, ip 10.0.13.178, 0 redirects active on ports 10000-20000, Envoy: external
Global Identity Range:   min 256, max 65535
Hubble:                  Ok   Current/Max Flows: 4095/4095 (100.00%), Flows/s: 1882.61   Metrics: Disabled
KubeProxyReplacement Details:
  Status:               True
  Socket LB:            Enabled
  Socket LB Tracing:    Enabled
  Socket LB Coverage:   Full
  Devices:              enp8s0   65.109.103.254 fe80::387f:3d1f:b49d:44dd, vlan4000   192.168.100.10 fe80::2cf9:774b:b98:5e41 (Direct Routing), tailscale0    100.64.0.154 fd7a:115c:a1e0::9b fe80::6bd9:7bec:b025:b55a
  Mode:                 SNAT
  Backend Selection:    Random
  Session Affinity:     Enabled
  NAT46/64 Support:     Disabled
  XDP Acceleration:     Disabled
  Services:
  - ClusterIP:      Enabled
  - NodePort:       Enabled (Range: 30000-32767) 
  - LoadBalancer:   Enabled 
  - externalIPs:    Enabled 
  - HostPort:       Enabled
  Annotations:
  - service.cilium.io/node
  - service.cilium.io/node-selector
  - service.cilium.io/proxy-delegation
  - service.cilium.io/src-ranges-policy
  - service.cilium.io/type
BPF Maps:   dynamic sizing: on (ratio: 0.002500)
  Name                          Size
  Auth                          524288
  Non-TCP connection tracking   591976
  TCP connection tracking       1183953
  Endpoints                     65535
  IP cache                      512000
  IPv4 masquerading agent       16384
  IPv6 masquerading agent       16384
  IPv4 fragmentation            8192
  IPv4 service                  65536
  IPv6 service                  65536
  IPv4 service backend          65536
  IPv6 service backend          65536
  IPv4 service reverse NAT      65536
  IPv6 service reverse NAT      65536
  Metrics                       1024
  Ratelimit metrics             64
  NAT                           1183953
  Neighbor table                1183953
  Endpoint policy               16384
  Policy stats                  65532
  Session affinity              65536
  Sock reverse NAT              591976
Encryption:   Wireguard   [NodeEncryption: Disabled, cilium_wg0 (Pubkey: MBDqQ+cwr5VwHHKvYMkpcKZItLnJ6qb9HN7R4ZqMqnQ=, Port: 51871, Peers: 11)]
```

#### Cilium environment keys

```
enable-hubble-open-metrics:false
policy-trigger-interval:1s
ipam-max-allocate:0
kvstore:
ip-masq-agent-config-path:/etc/config/ip-masq-agent
proxy-xff-num-trusted-hops-ingress:0
bpf-auth-map-max:524288
proxy-portrange-min:10000
enable-ztunnel:false
alibabacloud-security-group-tags:
node-encryption-opt-out-labels:node-role.kubernetes.io/control-plane
encryption-strict-mode-cidr:
bypass-ip-availability-upon-restore:false
enable-egress-gateway:true
policy-cidr-match-mode:
enable-endpoint-lockdown-on-policy-overflow:false
vlan-bpf-bypass:
envoy-access-log-buffer-size:4096
hubble-drop-events-extended:false
tofqdns-max-deferred-connection-deletes:10000
lb-init-wait-timeout:1m0s
hubble-network-policy-correlation-enabled:true
tofqdns-min-ttl:0
enable-lb-ipam:true
bpf-lb-maglev-map-max:0
node-labels:
enable-non-default-deny-policies:true
hubble-monitor-events:
l2-announcements-retry-period:2s
bpf-lb-rss-ipv6-src-cidr:
operator-prometheus-serve-addr::9963
auto-create-cilium-node-resource:true
node-port-acceleration:disabled
encryption-strict-egress-allow-remote-node-identities:false
ipam-static-ip-tags:
http-idle-timeout:0
status-collector-warning-threshold:15s
procfs:/host/proc
enable-ciliumnode-crd:true
policy-accounting:true
enable-health-check-loadbalancer-ip:false
bpf-conntrack-accounting:false
http-max-grpc-timeout:0
envoy-http-upstream-linger-timeout:-1
bpf-lb-maglev-hash-seed:JLfvgnHc2kaSUFaI
disable-external-ip-mitigation:false
proxy-initial-fetch-timeout:30
bpf-lb-source-range-all-types:false
bpf-events-default-burst-limit:0
proxy-portrange-max:20000
crd-wait-timeout:5m0s
local-max-addr-scope:254
cni-chaining-target:
enable-auto-protect-node-port-range:true
enable-policy-secrets-sync:true
identity-restore-grace-period:30s
nat-map-stats-interval:30s
enable-l2-announcements:false
identity-management-mode:agent
bpf-ct-global-tcp-max:524288
monitor-queue-size:0
routing-mode:tunnel
enable-policy:default
ipv6-service-loopback-address:fe80::1
enable-source-ip-verification:true
cilium-endpoint-gc-interval:5m0s
enable-ipip-termination:false
bpf-ct-timeout-service-tcp:2h13m20s
bpf-distributed-lru:false
allow-unsafe-policy-skb-usage:false
hubble-export-denylist:
vtep-sync-interval:1m0s
proxy-max-concurrent-retries:128
kube-proxy-replacement:true
bpf-lb-sock-hostns-only:false
restored-proxy-ports-age-limit:15
enable-remote-node-masquerade:false
ipam:cluster-pool
lb-retry-backoff-max:1s
identity-heartbeat-timeout:30m0s
dnsproxy-lock-timeout:500ms
exclude-local-address:
enable-stale-cilium-endpoint-cleanup:true
conntrack-gc-interval:0s
enable-standalone-dns-proxy:false
bpf-policy-map-pressure-metrics-threshold:0.1
external-envoy-proxy:true
ipsec-key-file:
bpf-lb-rev-nat-map-max:0
policy-audit-mode:true
max-controller-interval:0
dnsproxy-concurrency-processing-grace-period:0s
debug-verbose:
enable-dynamic-config:true
enable-mke:false
install-no-conntrack-iptables-rules:false
enable-health-checking:true
k8s-api-server-urls:
dynamic-lifecycle-config:[]
log-opt:
disable-iptables-feeder-rules:
encryption-strict-mode-allow-remote-node-identities:false
standalone-dns-proxy-server-port:10095
tofqdns-dns-reject-response-code:refused
cni-chaining-mode:none
envoy-keep-cap-netbindservice:false
envoy-default-log-level:
l2-announcements-renew-deadline:5s
hubble-tls-client-ca-files:/var/lib/cilium/tls/hubble/client-ca.crt
remove-cilium-node-taints:true
hubble-flowlogs-config-path:
config:
k8s-heartbeat-timeout:30s
enable-ipv4-masquerade:true
multicast-enabled:false
set-cilium-node-taints:true
bpf-lb-algorithm:random
monitor-aggregation-interval:5s
enable-ipv6-big-tcp:false
mtu:0
boot-id-file:/proc/sys/kernel/random/boot_id
fixed-identity-mapping:
dnsproxy-socket-linger-timeout:10
enable-cilium-clusterwide-network-policy:true
eni-security-groups:
mke-cgroup-mount:
ingress-secrets-namespace:
http-retry-timeout:0
enable-bandwidth-manager:false
ipv4-node:auto
hubble-export-file-path:
dns-max-ips-per-restored-rule:1000
k8s-client-connection-keep-alive:30s
enable-l2-neigh-discovery:false
metrics:
agent-not-ready-taint-key:node.cilium.io/agent-not-ready
bpf-lb-map-max:65536
alibabacloud-security-groups:
bpf-ct-timeout-regular-tcp-fin:10s
policy-deny-response:none
labels:
ipam-min-allocate:0
hubble-redact-http-headers-allow:
keep-config:false
enable-host-legacy-routing:false
install-iptables-rules:true
disable-envoy-version-check:false
ipv4-native-routing-cidr:
endpoint-gc-interval:5m0s
mesh-auth-signal-backoff-duration:1s
tofqdns-pre-cache:
hubble-event-queue-size:0
trace-sock:true
eni-subnet-tags:
container-ip-local-reserved-ports:auto
certificates-directory:/var/run/cilium/certs
tunnel-source-port-range:0-0
local-router-ipv6:
envoy-config-retry-interval:15s
proxy-connect-timeout:2
health-check-icmp-failure-threshold:3
envoy-policy-restore-timeout:3m0s
hubble-drop-events-interval:2m0s
bpf-events-default-rate-limit:0
enable-tunnel-big-tcp:false
wireguard-persistent-keepalive:0s
nodes-gc-interval:5m0s
k8s-client-burst:20
allocator-list-timeout:3m0s
node-port-mode:
enable-encryption-strict-mode:false
dns-policy-unload-on-shutdown:false
hubble-metrics-server-enable-tls:false
ipv4-service-loopback-address:169.254.42.1
bpf-policy-map-full-reconciliation-interval:15m0s
enable-identity-mark:true
read-cni-conf:
http-stream-idle-timeout:300
ipam-pre-allocate:0
bpf-lb-service-backend-map-max:0
operator-api-serve-addr:127.0.0.1:9234
bpf-ct-timeout-service-any:1m0s
enable-k8s-api-discovery:false
dnsproxy-enable-transparent-mode:true
tofqdns-endpoint-max-ip-per-hostname:1000
policy-queue-size:100
proxy-max-active-downstream-connections:50000
eni-use-primary-address:false
mesh-auth-spire-admin-socket:
eni-subnet-ids:
mesh-auth-spiffe-trust-domain:spiffe.cilium
kvstore-lease-ttl:15m0s
debug:false
vtep-mac:
hubble-redact-kafka-apikey:false
enable-k8s:true
gateway-api-secrets-namespace:
bpf-ct-timeout-regular-tcp-syn:1m0s
mesh-auth-mutual-connect-timeout:5s
prometheus-serve-addr:
bpf-ct-timeout-regular-tcp:2h13m20s
hubble-export-allowlist:
http-normalize-path:true
enable-ipv6-ndp:false
tofqdns-proxy-port:0
prepend-iptables-chains:true
policy-secrets-namespace:cilium-secrets
mesh-auth-rotated-identities-queue-size:1024
bpf-map-dynamic-size-ratio:0.0025
enable-ipv6-masquerade:true
enable-cilium-endpoint-slice:false
egress-masquerade-interfaces:
lb-state-file-interval:1s
force-device-detection:false
enable-packetization-layer-pmtud:true
iptables-random-fully:false
bpf-ct-timeout-service-tcp-grace:1m0s
tofqdns-proxy-response-max-delay:100ms
bpf-ct-timeout-regular-any:1m0s
allow-localhost:auto
tunnel-protocol:vxlan
enable-pmtu-discovery:false
enable-service-topology:false
clustermesh-mcs-api-install-crds:true
set-cilium-is-up-condition:true
hubble-drop-events:false
ipv6-native-routing-cidr:
bpf-lb-source-range-map-max:0
agent-liveness-update-interval:1s
identity-max-jitter:30s
monitor-aggregation-flags:all
lb-retry-backoff-min:1s
alibabacloud-vswitch-tags:
socket-path:/var/run/cilium/cilium.sock
enable-extended-ip-protocols:false
status-collector-stackdump-path:/run/cilium/state/agent.stack.gz
hive-log-threshold:100ms
cluster-name:default
proxy-gid:1337
api-rate-limit:
bpf-events-policy-verdict-enabled:true
k8s-namespace:kube-system
derive-masq-ip-addr-from-device:
k8s-sync-timeout:3m0s
iptables-lock-timeout:5s
ipv6-range:auto
enable-k8s-networkpolicy:true
auto-direct-node-routes:false
bpf-ct-global-any-max:262144
devices:
local-router-ipv4:
lb-state-file:
bpf-lb-mode-annotation:false
enable-bpf-masquerade:true
enable-gops:true
identity-change-grace-period:5s
endpoint-regen-interval:2m0s
static-cnp-path:
trace-payloadlen-overlay:192
bpf-filter-priority:1
bpf-events-trace-enabled:true
hubble-prefer-ipv6:false
hubble-drop-events-rate-limit:1
log-system-load:false
cgroup-root:/run/cilium/cgroupv2
hubble-lost-event-send-interval:1s
enable-ipsec:false
bpf-policy-map-max:16384
hubble-metrics-server-tls-cert-file:
hubble-redact-http-userinfo:true
preallocate-bpf-maps:false
agent-health-port:9879
use-full-tls-context:false
ipam-cilium-node-update-rate:15s
config-sources-overrides:{"allowConfigKeys":[],"denyConfigKeys":[]}
clustermesh-enable-mcs-api:false
enable-bgp-control-plane-status-report:true
bpf-lb-service-map-max:0
exclude-node-label-patterns:
node-port-bind-protection:true
cmdref:
enable-node-ipam:false
hubble-export-fieldmask:
pprof-address:localhost
enable-bgp-legacy-origin-attribute:false
enable-ipv4-fragment-tracking:true
vtep-cidr:
tofqdns-preallocate-identities:true
datapath-mode:veth
http-request-timeout:3600
log-driver:
hubble-skip-unknown-cgroup-ids:true
bpf-map-event-buffers:
enable-endpoint-routes:false
enable-bpf-clock-probe:false
enable-xdp-prefilter:false
route-metric:0
hubble-metrics-server-tls-key-file:
ipv6-mcast-device:
version:false
install-uplink-routes-for-delegated-ipam:false
cluster-health-port:4240
status-collector-failure-threshold:1m0s
nodeport-addresses:
alibabacloud-vswitches:
enable-ipsec-key-watcher:true
proxy-prometheus-port:0
cni-exclusive:true
enable-node-selector-labels:false
enable-metrics:true
enable-wireguard:true
only-masquerade-default-pool:false
label-prefix-file:
lrp-address-matcher-cidrs:
enable-icmp-rules:true
k8s-kubeconfig-path:
service-no-backend-response:reject
proxy-idle-timeout-seconds:60
enable-cilium-health-api-server-access:
identity-gc-interval:15m0s
enable-ingress-controller:false
dnsproxy-lock-count:131
default-lb-service-ipam:lbipam
hive-start-timeout:5m0s
bpf-lb-sock:false
clustermesh-config:/var/lib/cilium/clustermesh/
hubble-socket-path:/var/run/cilium/hubble.sock
bpf-lb-ipip-sock-mark:false
egress-gateway-policy-map-max:16384
enable-hubble:true
cni-external-routing:false
vtep-mask:
k8s-service-proxy-name:
tofqdns-idle-connection-grace-period:0s
annotate-k8s-node:false
ipv6-pod-subnets:
max-internal-timer-delay:0s
kvstore-max-consecutive-quorum-errors:2
enable-bbr:false
eni-first-interface-index:0
envoy-config-timeout:2m0s
config-sources:[{"kind":"config-map","namespace":"kube-system","name":"cilium-config"}]
mesh-auth-gc-interval:5m0s
hive-stop-timeout:1m0s
controller-group-metrics:
hubble-metrics:
direct-routing-skip-unreachable:false
enable-k8s-host-firewall-bypass:true
conntrack-gc-max-interval:0s
enable-l7-proxy:true
eni-exclude-interface-tags:
enable-tcx:true
synchronize-k8s-nodes:true
bpf-policy-stats-map-max:65536
srv6-encap-mode:reduced
enable-gateway-api:false
ip-tracing-option-type:0
mesh-auth-enabled:true
bpf-lb-acceleration:disabled
bpf-lb-mode:snat
cluster-pool-ipv4-cidr:10.0.0.0/8
bpf-lb-rss-ipv4-src-cidr:
hubble-export-file-max-backups:5
monitor-aggregation:medium
bpf-root:/sys/fs/bpf
policy-secrets-only-from-secrets-namespace:true
lb-pressure-metrics-interval:5m0s
eni-disable-prefix-delegation:false
kube-proxy-replacement-healthz-bind-address:
pprof-port:6060
fqdn-regex-compile-lru-size:1024
ztunnel-zds-unix-addr:/var/run/cilium/ztunnel.sock
k8s-client-connection-timeout:30s
wireguard-track-all-ips-fallback:false
bpf-lb-nat46x64:false
mesh-auth-mutual-listener-port:0
enable-srv6:false
enable-encryption-strict-mode-ingress:false
bpf-sock-rev-map-max:0
state-dir:/var/run/cilium
k8s-client-qps:10
max-connected-clusters:255
enable-bbr-hostns-only:false
kvstore-opt:
k8s-api-server:
agent-health-require-k8s-connectivity:true
hubble-redact-http-headers-deny:
ipv6-node:auto
encrypt-interface:
bgp-router-id-allocation-mode:default
hubble-export-file-compress:false
envoy-secrets-namespace:
status-collector-interval:5s
endpoint-bpf-prog-watchdog-interval:30s
pprof-block-profile-rate:0
trace-payloadlen:128
proxy-use-original-source-address:true
enable-well-known-identities:false
hubble-event-buffer-capacity:4095
enable-ipsec-xfrm-state-caching:true
cni-log-file:/var/run/cilium/cilium-cni.log
gops-port:9890
node-port-algorithm:
encrypt-node:false
hubble-listen-address::4244
bpf-lb-algorithm-annotation:false
enable-envoy-config:false
ipv6-cluster-alloc-cidr:f00d::/64
clustermesh-enable-endpoint-sync:false
unmanaged-pod-watcher-interval:15s
cluster-pool-ipv4-mask-size:24
enable-monitor:true
pprof-mutex-profile-fraction:0
lib-dir:/var/lib/cilium
bpf-nat-global-max:524288
hubble-tls-cert-file:/var/lib/cilium/tls/hubble/server.crt
enable-dynamic-lifecycle-manager:false
enable-drift-checker:true
enable-ipv6-fragment-tracking:true
enable-masquerade-to-route-source:false
bpf-events-drop-enabled:true
direct-routing-device:
ipv4-service-range:auto
enable-ip-masq-agent:false
agent-labels:
bpf-neigh-global-max:524288
enable-active-connection-tracking:false
hubble-metrics-server-tls-client-ca-files:
enable-host-firewall:false
tunnel-port:0
hubble-export-file-max-size-mb:10
enable-local-redirect-policy:false
clustermesh-cache-ttl:0s
vtep-endpoint:
lb-sock-terminate-all-protos:false
cluster-id:0
bpf-lb-maglev-table-size:16381
bpf-lb-affinity-map-max:0
k8s-require-ipv4-pod-cidr:false
bpf-lb-sock-terminate-pod-connections:true
write-cni-conf-when-ready:/host/etc/cni/net.d/05-cilium.conflist
azure-interface-name:
hubble-export-fieldaggregate:
l2-pod-announcements-interface-pattern:
enable-bgp-control-plane:false
encryption-strict-egress-cidr:
hubble-tls-key-file:/var/lib/cilium/tls/hubble/server.key
proxy-max-connection-duration-seconds:0
ipv6-service-range:auto
hubble-redact-http-urlquery:false
envoy-base-id:0
enable-endpoint-health-checking:true
enable-vtep:false
connectivity-probe-frequency-ratio:0.5
identity-allocation-timeout:2m0s
underlay-protocol:ipv4
enable-cilium-api-server-access:
use-cilium-internal-ip-for-ipsec:false
identity-allocation-sync-interval:5m0s
enable-xt-socket-fallback:true
pprof:false
proxy-max-requests-per-connection:0
bpf-node-map-max:16384
enable-nat46x64-gateway:false
enable-ipv4-big-tcp:false
config-dir:/tmp/cilium/config-map
nat-map-stats-entries:32
enable-l2-pod-announcements:false
ipsec-key-rotation-duration:5m0s
enable-ipv6:false
proxy-xff-num-trusted-hops-egress:0
proxy-cluster-max-connections:1024
enable-encryption-strict-mode-egress:false
bpf-fragments-map-max:8192
hubble-disable-tls:false
ipam-default-ip-pool:default
enable-no-service-endpoints-routable:true
enable-health-check-nodeport:true
hubble-drop-events-reasons:
status-collector-probe-check-timeout:5m0s
envoy-log:
enable-ipv4:true
disable-endpoint-crd:false
hubble-export-aggregation-interval:0s
http-retry-count:3
dnsproxy-concurrency-limit:0
ipv4-pod-subnets:
enable-sctp:false
enable-unreachable-routes:false
ipam-multi-pool-pre-allocation:
identity-allocation-mode:crd
policy-default-local-cluster:true
k8s-require-ipv6-pod-cidr:false
proxy-cluster-max-requests:1024
enable-local-node-route:true
enable-bpf-tproxy:false
bpf-lb-external-clusterip:false
restore:true
dnsproxy-insecure-skip-transparent-mode-check:false
enable-tracing:false
node-port-range:
custom-cni-conf:false
tofqdns-enable-dns-compression:true
l2-announcements-lease-duration:15s
metrics-sampling-interval:5m
hubble-metrics-server:
enable-route-mtu-for-cni-chaining:false
allow-icmp-frag-needed:true
eni-security-group-tags:
eni-delete-on-termination:true
bgp-router-id-allocation-ip-pool:
mesh-auth-queue-size:1024
clustermesh-sync-timeout:1m0s
bpf-lb-dsr-dispatch:opt
hubble-redact-enabled:false
ipv4-range:auto
shell-sock-path:/var/run/cilium/shell.sock
endpoint-queue-size:25
egress-gateway-reconciliation-trigger-interval:1s
enable-cilium-network-policy:true
ignore-flags-drift-checker:
hubble-dynamic-metrics-config-path:
proxy-admin-port:0
```


#### Endpoint list

```
ENDPOINT   POLICY (ingress)   POLICY (egress)   IDENTITY   LABELS (source:key[=value])                                                                      IPv6   IPv4          STATUS   
           ENFORCEMENT        ENFORCEMENT                                                                                                                                        
7          Disabled (Audit)   Disabled          15473      k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                          10.0.13.185   ready   
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                              
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                               
                                                           k8s:longhorn.io/component=instance-manager                                                                                    
                                                           k8s:longhorn.io/data-engine=v1                                                                                                
                                                           k8s:longhorn.io/instance-manager-image=imi-29909444                                                                           
                                                           k8s:longhorn.io/instance-manager-type=aio                                                                                     
                                                           k8s:longhorn.io/managed-by=longhorn-manager                                                                                   
                                                           k8s:longhorn.io/node=dev-controlplane-01                                                                                      
31         Disabled (Audit)   Disabled          28201      k8s:app=longhorn-csi-plugin                                                                             10.0.13.240   ready   
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                                
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                              
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                               
285        Disabled (Audit)   Disabled          37415      k8s:app=outdoor-platform-ws-dev                                                                         10.0.13.165   ready   
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=outdoor-platform-dev                                           
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=default                                                                               
                                                           k8s:io.kubernetes.pod.namespace=outdoor-platform-dev                                                                          
334        Disabled (Audit)   Disabled          47918      k8s:app.kubernetes.io/instance=longhorn                                                                 10.0.13.26    ready   
                                                           k8s:app.kubernetes.io/managed-by=Helm                                                                                         
                                                           k8s:app.kubernetes.io/name=longhorn                                                                                           
                                                           k8s:app.kubernetes.io/version=v1.9.0                                                                                          
                                                           k8s:app=longhorn-ui                                                                                                           
                                                           k8s:helm.sh/chart=longhorn-1.9.0                                                                                              
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                                
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-ui-service-account                                                           
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                               
663        Disabled           Disabled          1          k8s:k3s-upgrade=true                                                                                                  ready   
                                                           k8s:node-role.kubernetes.io/control-plane=true                                                                                
                                                           k8s:node-role.kubernetes.io/etcd=true                                                                                         
                                                           k8s:node-role.kubernetes.io/master=true                                                                                       
                                                           k8s:node.kubernetes.io/instance-type=k3s                                                                                      
                                                           k8s:plan.upgrade.cattle.io/k3s-server=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812                                
                                                           reserved:host                                                                                                                 
870        Disabled (Audit)   Disabled          34352      k8s:app.kubernetes.io/component=Agent                                                                   10.0.13.226   ready   
                                                           k8s:app.kubernetes.io/instance=victorialogs                                                                                   
                                                           k8s:app.kubernetes.io/name=vector                                                                                             
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring                                                     
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector                                                                   
                                                           k8s:io.kubernetes.pod.namespace=monitoring                                                                                    
                                                           k8s:vector.dev/exclude=true                                                                                                   
1011       Disabled (Audit)   Disabled          8453       k8s:app=csi-resizer                                                                                     10.0.13.192   ready   
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                                
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                              
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                               
1158       Disabled (Audit)   Disabled          4988       k8s:app.kubernetes.io/instance=kured                                                                    10.0.13.138   ready   
                                                           k8s:app.kubernetes.io/managed-by=Helm                                                                                         
                                                           k8s:app.kubernetes.io/name=kured                                                                                              
                                                           k8s:helm.sh/chart=kured-5.6.2                                                                                                 
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring                                                     
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=kured                                                                                 
                                                           k8s:io.kubernetes.pod.namespace=monitoring                                                                                    
1356       Disabled (Audit)   Disabled          43550      k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                          10.0.13.24    ready   
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                              
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                               
                                                           k8s:longhorn.io/component=engine-image                                                                                        
                                                           k8s:longhorn.io/engine-image=ei-e09d8caa                                                                                      
1441       Disabled (Audit)   Disabled          8105       k8s:app=redacted-processor-dev-job                                                                       10.0.13.71    ready   
                                                           k8s:batch.kubernetes.io/job-name=redacted-redis-job-met-nordic-6403506                                                         
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev                                                    
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account                                                     
                                                           k8s:io.kubernetes.pod.namespace=redacted-dev                                                                                   
                                                           k8s:job-name=redacted-redis-job-met-nordic-6403506                                                                             
                                                           k8s:job=redis-job-met-nordic                                                                                                  
2581       Disabled (Audit)   Disabled          4          reserved:health                                                                                         10.0.13.222   ready   
2619       Disabled (Audit)   Disabled          4394       k8s:app.kubernetes.io/instance=longhorn                                                                 10.0.13.16    ready   
                                                           k8s:app.kubernetes.io/managed-by=Helm                                                                                         
                                                           k8s:app.kubernetes.io/name=longhorn                                                                                           
                                                           k8s:app.kubernetes.io/version=v1.9.0                                                                                          
                                                           k8s:app=longhorn-manager                                                                                                      
                                                           k8s:helm.sh/chart=longhorn-1.9.0                                                                                              
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                                
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                              
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                               
                                                           k8s:longhorn.io/admission-webhook=longhorn-admission-webhook                                                                  
                                                           k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook                                                                
                                                           k8s:longhorn.io/recovery-backend=longhorn-recovery-backend                                                                    
3817       Disabled (Audit)   Disabled          5643       k8s:app.kubernetes.io/component=controller                                                              10.0.13.209   ready   
                                                           k8s:app.kubernetes.io/instance=ingress-nginx                                                                                  
                                                           k8s:app.kubernetes.io/managed-by=Helm                                                                                         
                                                           k8s:app.kubernetes.io/name=ingress-nginx                                                                                      
                                                           k8s:app.kubernetes.io/part-of=ingress-nginx                                                                                   
                                                           k8s:app.kubernetes.io/version=1.12.1                                                                                          
                                                           k8s:helm.sh/chart=ingress-nginx-4.12.1                                                                                        
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=ingress-internal                                               
                                                           k8s:io.cilium.k8s.namespace.labels.name=ingress-internal                                                                      
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=ingress-nginx                                                                         
                                                           k8s:io.kubernetes.pod.namespace=ingress-internal                                                                              
3873       Disabled (Audit)   Disabled          57633      k8s:app.kubernetes.io/component=controller                                                              10.0.13.20    ready   
                                                           k8s:app.kubernetes.io/name=system-upgrade-controller                                                                          
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=system-upgrade                                                 
                                                           k8s:io.cilium.k8s.namespace.labels.pod-security.kubernetes.io/enforce=privileged                                              
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=system-upgrade                                                                        
                                                           k8s:io.kubernetes.pod.namespace=system-upgrade                                                                                
                                                           k8s:upgrade.cattle.io/controller=system-upgrade-controller                                                                    
3947       Disabled (Audit)   Disabled          12176      k8s:app.kubernetes.io/component=clickhouse                                                              10.0.13.1     ready   
                                                           k8s:app.kubernetes.io/instance=langfuse                                                                                       
                                                           k8s:app.kubernetes.io/managed-by=Helm                                                                                         
                                                           k8s:app.kubernetes.io/name=clickhouse                                                                                         
                                                           k8s:app.kubernetes.io/version=25.2.1                                                                                          
                                                           k8s:helm.sh/chart=clickhouse-8.0.5                                                                                            
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=langfuse                                                       
                                                           k8s:io.cilium.k8s.namespace.labels.name=langfuse                                                                              
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                      
                                                           k8s:io.cilium.k8s.policy.serviceaccount=langfuse-clickhouse                                                                   
                                                           k8s:io.kubernetes.pod.namespace=langfuse                                                                                      
                                                           k8s:shard=0                                                                                                                   
```

#### BPF Policy Get 7

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES      PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2          ANY          NONE         disabled    2256       32        0        0
Allow    Ingress     9          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -          -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -          -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    26498667   237487    0        0
Allow    Ingress     4988       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -          -         0        0
Allow    Egress      0          ANY          NONE         disabled    56439517   654131    0        0

```


#### BPF CT List 7

```
Invalid argument: unknown type 7
```


#### Endpoint Get 7

```
[
  {
    "id": 7,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-7-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "ef5450d2-c339-4f33-96c7-3d01688cdfc3"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/instance-manager-abbde5560bb0c9372ec9cd26e887eaac",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:43.005Z",
            "success-count": 2
          },
          "uuid": "9bc0299c-7422-493a-ab34-fcbfa2a347bc"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (7)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "037a2f12-3b45-4c2d-a629-0ac68d1d56a7"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-7",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:43.028Z",
            "success-count": 32
          },
          "uuid": "b1f572bd-0616-4edf-80ab-c3a611095b12"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (7)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:19.116Z",
            "success-count": 2813
          },
          "uuid": "48b931b3-429c-4a1f-972f-6e5e0e108632"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (7)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "20a34478-2af5-42ef-93a0-6801a8161cc6"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "1770c9eda87e134c3294ffd08adcb0b7477fd67dfa077acf156251c031ff3874:eth0",
        "container-id": "1770c9eda87e134c3294ffd08adcb0b7477fd67dfa077acf156251c031ff3874",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "instance-manager-abbde5560bb0c9372ec9cd26e887eaac",
        "pod-name": "longhorn-system/instance-manager-abbde5560bb0c9372ec9cd26e887eaac"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 15473,
        "labels": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=instance-manager",
          "k8s:longhorn.io/data-engine=v1",
          "k8s:longhorn.io/instance-manager-image=imi-29909444",
          "k8s:longhorn.io/instance-manager-type=aio",
          "k8s:longhorn.io/managed-by=longhorn-manager",
          "k8s:longhorn.io/node=dev-controlplane-01"
        ]
      },
      "labels": {
        "realized": {},
        "security-relevant": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=instance-manager",
          "k8s:longhorn.io/data-engine=v1",
          "k8s:longhorn.io/instance-manager-image=imi-29909444",
          "k8s:longhorn.io/instance-manager-type=aio",
          "k8s:longhorn.io/managed-by=longhorn-manager",
          "k8s:longhorn.io/node=dev-controlplane-01"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.185",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "36:55:34:f2:05:90",
        "interface-index": 56,
        "interface-name": "lxc2852b85fdc6a",
        "mac": "fe:79:e0:d4:d5:35"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 15473,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=instance-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 15473,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=instance-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 7

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 7

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 15473

```
ID      LABELS
15473   k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system
        k8s:longhorn.io/component=instance-manager
        k8s:longhorn.io/data-engine=v1
        k8s:longhorn.io/instance-manager-image=imi-29909444
        k8s:longhorn.io/instance-manager-type=aio
        k8s:longhorn.io/managed-by=longhorn-manager
        k8s:longhorn.io/node=dev-controlplane-01

```


#### BPF Policy Get 31

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          9808/TCP     NONE         disabled    31454     355       24       0
Allow    Ingress     1          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2          9808/TCP     NONE         disabled    2543392   28601     24       0
Allow    Ingress     2          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     7          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29395      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    431978    5411      0        0

```


#### BPF CT List 31

```
Invalid argument: unknown type 31
```


#### Endpoint Get 31

```
[
  {
    "id": 31,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-31-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "b35fdff5-a989-449f-b78a-88c09bb4cb93"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/longhorn-csi-plugin-lllgb",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:43.074Z",
            "success-count": 2
          },
          "uuid": "0ce4fcc9-4542-4c86-9361-2522b41c5f48"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (31)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "077b931b-a120-41e5-8429-c69033279cd7"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-31",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:42.972Z",
            "success-count": 32
          },
          "uuid": "470e1c58-8f9e-408d-b0a3-054363689fe1"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (31)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:19.600Z",
            "success-count": 2813
          },
          "uuid": "09b9a2b1-2ba0-4fb2-8c5f-fa1d759c0847"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (31)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "c5cf446b-dded-4282-baa7-92d9be9455b4"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "5cfcaff3d018461bd5f1272dbdd5a20120b8f491969e6b7f6ae21aefd6b18e4e:eth0",
        "container-id": "5cfcaff3d018461bd5f1272dbdd5a20120b8f491969e6b7f6ae21aefd6b18e4e",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "longhorn-csi-plugin-lllgb",
        "pod-name": "longhorn-system/longhorn-csi-plugin-lllgb"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 28201,
        "labels": [
          "k8s:app=longhorn-csi-plugin",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=5769d89c9f",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=longhorn-csi-plugin",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.240",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "9a:b5:48:76:f0:e9",
        "interface-index": 12,
        "interface-name": "lxccddb3388de68",
        "mac": "86:42:5e:9b:68:45"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 28201,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                  ]
                ],
                "rule": "{\"port\":9808,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 28201,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                  ]
                ],
                "rule": "{\"port\":9808,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 31

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 31

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 28201

```
ID      LABELS
28201   k8s:app=longhorn-csi-plugin
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system

```


#### BPF Policy Get 285

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES    PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -        -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    138750   1875      0        0
Allow    Ingress     33454      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -        -         0        0
Allow    Egress      0          ANY          NONE         disabled    -        -         0        0

```


#### BPF CT List 285

```
Invalid argument: unknown type 285
```


#### Endpoint Get 285

```
[
  {
    "id": 285,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-285-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "b7b6ad44-fd15-4f6e-962b-7f06d2159469"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-outdoor-platform-dev/outdoor-platform-ws-dev-795d799998-vlmzf",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:43.051Z",
            "success-count": 2
          },
          "uuid": "341995e7-25a8-44bf-864c-0b595d613bdd"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (285)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "b76e24d2-e05e-4a6e-bcd0-48b148fb4d79"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-285",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:42.945Z",
            "success-count": 32
          },
          "uuid": "926cf8e7-1d24-4510-95db-ecef3f498dac"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (285)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:19.299Z",
            "success-count": 2813
          },
          "uuid": "c9cc3559-91c0-481d-9401-927ff90f318b"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (285)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "5cc7bc33-1bfd-494f-bf39-dab3ff0b0d06"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "a2b3c3249d1ebe82a910495d7299119abe74de9fd3ec244378f7dc8748c5e179:eth0",
        "container-id": "a2b3c3249d1ebe82a910495d7299119abe74de9fd3ec244378f7dc8748c5e179",
        "k8s-namespace": "outdoor-platform-dev",
        "k8s-pod-name": "outdoor-platform-ws-dev-795d799998-vlmzf",
        "pod-name": "outdoor-platform-dev/outdoor-platform-ws-dev-795d799998-vlmzf"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 37415,
        "labels": [
          "k8s:app=outdoor-platform-ws-dev",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=outdoor-platform-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=outdoor-platform-dev"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=795d799998"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=outdoor-platform-ws-dev",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=outdoor-platform-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=outdoor-platform-dev"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.165",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "62:ed:09:29:97:8b",
        "interface-index": 334,
        "interface-name": "lxc54ae4480e28c",
        "mac": "9a:c0:57:34:ec:c0"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 37415,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 37415,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 285

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 285

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 37415

```
ID      LABELS
37415   k8s:app=outdoor-platform-ws-dev
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=outdoor-platform-dev
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=default
        k8s:io.kubernetes.pod.namespace=outdoor-platform-dev

```


#### BPF Policy Get 334

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    3841090   55634     0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    1543498   21506     0        0

```


#### BPF CT List 334

```
Invalid argument: unknown type 334
```


#### Endpoint Get 334

```
[
  {
    "id": 334,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-334-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "0d5f773b-49f7-449c-8733-3c3b2b846532"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/longhorn-ui-6b44759848-kg79c",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:43.051Z",
            "success-count": 2
          },
          "uuid": "64f75e02-5daa-408f-a3a2-318d5ef8e6ce"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (334)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "c1ec21bf-f53e-4937-ae15-5fc41e6224a5"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-334",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:42.943Z",
            "success-count": 32
          },
          "uuid": "86023d20-24ab-417b-853b-1074fd4efc60"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (334)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:19.026Z",
            "success-count": 2813
          },
          "uuid": "43a01c5f-5f97-488c-87d4-55e37366c3be"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (334)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "e0a26cbb-221f-4057-85d2-794ee9353d10"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "70cb535038193ecbca134e094904d082bcc860af85481066371a776641c97b03:eth0",
        "container-id": "70cb535038193ecbca134e094904d082bcc860af85481066371a776641c97b03",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "longhorn-ui-6b44759848-kg79c",
        "pod-name": "longhorn-system/longhorn-ui-6b44759848-kg79c"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 47918,
        "labels": [
          "k8s:app=longhorn-ui",
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-ui-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=6b44759848"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:app=longhorn-ui",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-ui-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "namedPorts": [
        {
          "name": "http",
          "port": 8000,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.26",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "5e:95:b0:93:0c:f1",
        "interface-index": 2504,
        "interface-name": "lxcd648ed570f17",
        "mac": "ba:63:77:fa:6e:de"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 47918,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-ui",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=b75292d2-11c7-467c-8558-50508860334c"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app.kubernetes.io/component: controller,k8s.app.kubernetes.io/instance: ingress-nginx,k8s.app.kubernetes.io/name: ingress-nginx,k8s.io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name: ingress-nginx,k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app.kubernetes.io/component: controller,k8s.app.kubernetes.io/instance: ingress-nginx,k8s.app.kubernetes.io/name: ingress-nginx,k8s.io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name: ingress-nginx,k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-ui",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b75292d2-11c7-467c-8558-50508860334c"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 47918,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-ui",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=b75292d2-11c7-467c-8558-50508860334c"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app.kubernetes.io/component: controller,k8s.app.kubernetes.io/instance: ingress-nginx,k8s.app.kubernetes.io/name: ingress-nginx,k8s.io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name: ingress-nginx,k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app.kubernetes.io/component: controller,k8s.app.kubernetes.io/instance: ingress-nginx,k8s.app.kubernetes.io/name: ingress-nginx,k8s.io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name: ingress-nginx,k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-ui",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b75292d2-11c7-467c-8558-50508860334c"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 334

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 334

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 47918

```
ID      LABELS
47918   k8s:app.kubernetes.io/instance=longhorn
        k8s:app.kubernetes.io/managed-by=Helm
        k8s:app.kubernetes.io/name=longhorn
        k8s:app.kubernetes.io/version=v1.9.0
        k8s:app=longhorn-ui
        k8s:helm.sh/chart=longhorn-1.9.0
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-ui-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system

```


#### BPF Policy Get 663

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES   PACKETS   PREFIX   COOKIE
Allow    Ingress     0          ANY          NONE         disabled    -       -         0        0
Allow    Egress      0          ANY          NONE         disabled    -       -         0        0

```


#### BPF CT List 663

```
Invalid argument: unknown type 663
```


#### Endpoint Get 663

```
[
  {
    "id": 663,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-663-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "3caa176f-73be-4cf6-a265-ab876e3e2924"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-/",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.909Z",
            "success-count": 1
          },
          "uuid": "9dce9f78-9fba-4e59-b05c-760267a31307"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (663)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.585Z",
            "success-count": 1
          },
          "uuid": "2a2aef14-2645-4c05-bd15-ecff5f52caa4"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-663",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:45.139Z",
            "success-count": 32
          },
          "uuid": "5caf2eb3-4518-41a2-b31a-465022fae1c4"
        }
      ],
      "external-identifiers": {
        "pod-name": "/"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 1,
        "labels": [
          "reserved:host",
          "k8s:k3s-upgrade=true",
          "k8s:node-role.kubernetes.io/control-plane=true",
          "k8s:node-role.kubernetes.io/etcd=true",
          "k8s:node-role.kubernetes.io/master=true",
          "k8s:node.kubernetes.io/instance-type=k3s",
          "k8s:plan.upgrade.cattle.io/k3s-server=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812"
        ]
      },
      "labels": {
        "derived": [
          "k8s:k3s-upgrade=true",
          "k8s:node-role.kubernetes.io/control-plane=true",
          "k8s:node-role.kubernetes.io/etcd=true",
          "k8s:node-role.kubernetes.io/master=true",
          "k8s:node.kubernetes.io/instance-type=k3s",
          "k8s:plan.upgrade.cattle.io/k3s-server=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812",
          "reserved:host"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:k3s-upgrade=true",
          "k8s:node-role.kubernetes.io/control-plane=true",
          "k8s:node-role.kubernetes.io/etcd=true",
          "k8s:node-role.kubernetes.io/master=true",
          "k8s:node.kubernetes.io/instance-type=k3s",
          "k8s:plan.upgrade.cattle.io/k3s-server=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812",
          "reserved:host"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "networking": {
        "addressing": [
          {}
        ],
        "host-mac": "4e:7c:3e:19:8b:3d",
        "interface-index": 6,
        "interface-name": "cilium_host",
        "mac": "4e:7c:3e:19:8b:3d"
      },
      "policy": {
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            0
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 1,
          "l4": {
            "egress": [],
            "ingress": []
          },
          "policy-enabled": "none",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            0
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 1,
          "l4": {
            "egress": [],
            "ingress": []
          },
          "policy-enabled": "none",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 663

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 663

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 1

```
ID   LABELS
1    reserved:host
     reserved:kube-apiserver

```


#### BPF Policy Get 870

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES        PACKETS    PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     10         ANY          NONE         disabled    -            -          0        0
Allow    Ingress     465        ANY          NONE         disabled    -            -          0        0
Allow    Ingress     566        ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1252       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1596       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1624       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1637       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2269       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2645       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2833       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2843       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2978       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3128       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3446       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3592       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3761       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3836       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3866       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     4394       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     4988       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5015       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5080       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5117       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5438       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5493       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5643       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5993       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6043       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6344       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6933       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     7513       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     7936       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8105       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8231       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8241       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8367       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8453       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8779       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9194       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9585       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     10807      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     11332      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12176      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12201      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12307      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12337      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13556      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13626      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13786      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14280      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14657      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14667      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14966      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14973      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15202      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15473      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15505      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15927      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16376      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16908      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16992      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     17163      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     17926      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     18592      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     18622      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19324      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19460      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19572      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19792      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19881      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19945      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     20806      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     22863      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     22922      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     23106      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     23582      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     24706      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     24736      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25152      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25226      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25555      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25589      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26001      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26267      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26869      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26892      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     27422      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     27486      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28201      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28530      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28621      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29089      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29163      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29395      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29994      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     31674      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     31840      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     32467      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33088      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33311      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33454      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33688      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33755      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34216      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34266      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34352      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34736      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34995      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     35682      ANY          NONE         disabled    228430       862        0        0
Allow    Ingress     35696      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     36596      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     37415      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     37517      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     38491      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39166      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39278      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39699      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     40088      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     41969      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42199      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42605      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42869      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43339      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43550      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43616      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     47483      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     47918      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     48334      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     48593      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     49075      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     49276      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52241      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52642      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52772      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53263      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53293      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53439      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     54396      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     54583      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     55202      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     55741      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     57633      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     58710      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60465      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60492      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60523      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     61421      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     61927      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     62026      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     63330      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     64556      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     65239      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -            -          0        0
Allow    Egress      0          ANY          NONE         disabled    5022035281   29198661   0        0

```


#### BPF CT List 870

```
Invalid argument: unknown type 870
```


#### Endpoint Get 870

```
[
  {
    "id": 870,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-870-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "89230717-f1ef-4710-a8f1-6e0dc5e5d050"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-monitoring/victorialogs-vector-5zfcb",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:43.058Z",
            "success-count": 2
          },
          "uuid": "f3e5b47c-6416-497e-9be4-e16e4d3e7d1b"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (870)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.585Z",
            "success-count": 1
          },
          "uuid": "bcb1f1fc-9673-44f3-befe-bbc43bac3be3"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-870",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:42.972Z",
            "success-count": 32
          },
          "uuid": "92754539-ced8-45fa-8f54-825996e93374"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (870)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:18.845Z",
            "success-count": 2813
          },
          "uuid": "7babcaab-8848-4c41-a33a-acc395fcafad"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (870)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.585Z",
            "success-count": 1
          },
          "uuid": "71df4793-8d33-4562-94bb-172f060113b4"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "ef478a90ce145e516da761400c10ee16fa78fb0b6be8e5e09e95c4799417c516:eth0",
        "container-id": "ef478a90ce145e516da761400c10ee16fa78fb0b6be8e5e09e95c4799417c516",
        "k8s-namespace": "monitoring",
        "k8s-pod-name": "victorialogs-vector-5zfcb",
        "pod-name": "monitoring/victorialogs-vector-5zfcb"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 34352,
        "labels": [
          "k8s:app.kubernetes.io/component=Agent",
          "k8s:app.kubernetes.io/instance=victorialogs",
          "k8s:app.kubernetes.io/name=vector",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector",
          "k8s:io.kubernetes.pod.namespace=monitoring",
          "k8s:vector.dev/exclude=true"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=547c594464",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/component=Agent",
          "k8s:app.kubernetes.io/instance=victorialogs",
          "k8s:app.kubernetes.io/name=vector",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector",
          "k8s:io.kubernetes.pod.namespace=monitoring",
          "k8s:vector.dev/exclude=true"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "namedPorts": [
        {
          "name": "prom-exporter",
          "port": 9090,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.226",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "62:80:df:2a:7c:dc",
        "interface-index": 16,
        "interface-name": "lxc61c07603c7e6",
        "mac": "be:71:5e:5a:c1:8b"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 34352,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 34352,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 870

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 870

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 34352

```
ID      LABELS
34352   k8s:app.kubernetes.io/component=Agent
        k8s:app.kubernetes.io/instance=victorialogs
        k8s:app.kubernetes.io/name=vector
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector
        k8s:io.kubernetes.pod.namespace=monitoring
        k8s:vector.dev/exclude=true

```


#### BPF Policy Get 1011

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    4383612   23268     0        0

```


#### BPF CT List 1011

```
Invalid argument: unknown type 1011
```


#### Endpoint Get 1011

```
[
  {
    "id": 1011,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1011-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "03e54eba-a478-4b52-b68d-5e818b752075"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/csi-resizer-6c558c9fbc-p4pd9",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:43.014Z",
            "success-count": 2
          },
          "uuid": "a4c7a1c6-8cc0-4598-a960-84697c5463d6"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1011)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "ed96dd4b-ec4c-43fa-a1b8-e8a50c4d4abd"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1011",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:43.041Z",
            "success-count": 32
          },
          "uuid": "3915b036-4128-4aad-8ec1-71112b43595a"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1011)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:18.846Z",
            "success-count": 2813
          },
          "uuid": "e11b549e-8263-4ae5-8bcc-ba59298aecc3"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1011)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "7ba1c5ea-59a8-43de-80a9-19e2d17c8d84"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "c0bd0ccf49527b24434904cf3096719b88b2f203b5ee10e43447c4217240b205:eth0",
        "container-id": "c0bd0ccf49527b24434904cf3096719b88b2f203b5ee10e43447c4217240b205",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "csi-resizer-6c558c9fbc-p4pd9",
        "pod-name": "longhorn-system/csi-resizer-6c558c9fbc-p4pd9"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 8453,
        "labels": [
          "k8s:app=csi-resizer",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=6c558c9fbc"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=csi-resizer",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "namedPorts": [
        {
          "name": "csi-resizer",
          "port": 8000,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.192",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "42:89:2c:98:2a:ba",
        "interface-index": 2500,
        "interface-name": "lxc4eff1912f2ff",
        "mac": "ee:19:d4:c0:7e:6a"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 8453,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 8453,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1011

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1011

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 8453

```
ID     LABELS
8453   k8s:app=csi-resizer
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
       k8s:io.kubernetes.pod.namespace=longhorn-system

```


#### BPF Policy Get 1158

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    12274     152       0        0
Allow    Ingress     2          ANY          NONE         disabled    1080962   13371     0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    -         -         0        0

```


#### BPF CT List 1158

```
Invalid argument: unknown type 1158
```


#### Endpoint Get 1158

```
[
  {
    "id": 1158,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1158-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "6acaa909-e324-431b-a8cb-973741a31af2"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-monitoring/kured-4bsc4",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:43.032Z",
            "success-count": 2
          },
          "uuid": "41bf65bc-d2a7-40f3-929e-ac46900ab46d"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1158)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "269bde7c-1d9b-4b5a-8f5c-d32d13fda6ab"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1158",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:42.965Z",
            "success-count": 32
          },
          "uuid": "75991d8e-23b3-41d7-8f78-f1a4c6c034a6"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1158)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:19.422Z",
            "success-count": 2813
          },
          "uuid": "030914f4-4fa5-4df0-b125-6fcbf82c9b1f"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1158)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "6e88d51d-8413-43c5-9e73-cc9c60dc4ddd"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "caa8c9e0290f82eb788d7fcfdf2c785b61f025facfc6f1b4608c6e5a4e71afa1:eth0",
        "container-id": "caa8c9e0290f82eb788d7fcfdf2c785b61f025facfc6f1b4608c6e5a4e71afa1",
        "k8s-namespace": "monitoring",
        "k8s-pod-name": "kured-4bsc4",
        "pod-name": "monitoring/kured-4bsc4"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4988,
        "labels": [
          "k8s:app.kubernetes.io/instance=kured",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=kured",
          "k8s:helm.sh/chart=kured-5.6.2",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kured",
          "k8s:io.kubernetes.pod.namespace=monitoring"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=796657747b",
          "k8s:pod-template-generation=4"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=kured",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=kured",
          "k8s:helm.sh/chart=kured-5.6.2",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kured",
          "k8s:io.kubernetes.pod.namespace=monitoring"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "namedPorts": [
        {
          "name": "metrics",
          "port": 8080,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.138",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "f2:8b:f9:aa:71:ba",
        "interface-index": 62,
        "interface-name": "lxc30da2eed66a4",
        "mac": "62:6a:66:7f:be:93"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4988,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4988,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1158

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1158

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4988

```
ID     LABELS
4988   k8s:app.kubernetes.io/instance=kured
       k8s:app.kubernetes.io/managed-by=Helm
       k8s:app.kubernetes.io/name=kured
       k8s:helm.sh/chart=kured-5.6.2
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=kured
       k8s:io.kubernetes.pod.namespace=monitoring

```


#### BPF Policy Get 1356

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES   PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -       -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -       -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -       -         0        0
Allow    Egress      0          ANY          NONE         disabled    -       -         0        0

```


#### BPF CT List 1356

```
Invalid argument: unknown type 1356
```


#### Endpoint Get 1356

```
[
  {
    "id": 1356,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1356-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "cde38568-3442-4025-973b-ac45e71d0ace"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/engine-image-ei-e09d8caa-7t4lt",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:43.082Z",
            "success-count": 2
          },
          "uuid": "bc27e39d-40d3-4a9f-afe3-f0e0ecc9561a"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1356)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "f7fa1a97-ca21-4048-8dca-177bad2a5fbb"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1356",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:42.974Z",
            "success-count": 32
          },
          "uuid": "68c5179f-15a7-487e-a283-248c0ce0726a"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1356)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:28.846Z",
            "success-count": 2814
          },
          "uuid": "c919da16-547b-4fd4-8b15-0f703c172ed4"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1356)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "20f51dd1-6d4f-4c88-9284-5f6e61b44144"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "22c564b8560a58fbf6bcf13f515efb53c592b0f7db723b7671edd175448b38cd:eth0",
        "container-id": "22c564b8560a58fbf6bcf13f515efb53c592b0f7db723b7671edd175448b38cd",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "engine-image-ei-e09d8caa-7t4lt",
        "pod-name": "longhorn-system/engine-image-ei-e09d8caa-7t4lt"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 43550,
        "labels": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=engine-image",
          "k8s:longhorn.io/engine-image=ei-e09d8caa"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=76b647f6f7",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=engine-image",
          "k8s:longhorn.io/engine-image=ei-e09d8caa"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.24",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "2a:83:a6:b1:4f:d9",
        "interface-index": 14,
        "interface-name": "lxc9b6f8f025e20",
        "mac": "7a:8f:41:7a:21:69"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43550,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43550,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1356

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1356

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 43550

```
ID      LABELS
43550   k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system
        k8s:longhorn.io/component=engine-image
        k8s:longhorn.io/engine-image=ei-e09d8caa

```


#### BPF Policy Get 1441

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    138750    1875      0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    8032190   25385     0        0

```


#### BPF CT List 1441

```
Invalid argument: unknown type 1441
```


#### Endpoint Get 1441

```
[
  {
    "id": 1441,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1441-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "e9a3cafd-a001-4c31-bf8f-3c68a6139ad1"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-redacted-dev/redacted-redis-job-met-nordic-6403506-x84gl",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:43.015Z",
            "success-count": 2
          },
          "uuid": "a05678fc-023c-40ad-a4f0-4f717b6ce033"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1441)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "76e4ba4d-82e1-4af9-a5b9-b488ca9958fe"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1441",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:43.039Z",
            "success-count": 32
          },
          "uuid": "59103d84-d6bd-463f-b29a-024bad56da2e"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1441)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:28.890Z",
            "success-count": 2814
          },
          "uuid": "aa913fb8-d85a-447b-8a3b-30520fa23620"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1441)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "0fd2dfab-eb27-406e-b382-269651246643"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "90fe8e88639bb445d652371ae7dd486927b0f2a4a80113b0519f917d94463ac2:eth0",
        "container-id": "90fe8e88639bb445d652371ae7dd486927b0f2a4a80113b0519f917d94463ac2",
        "k8s-namespace": "redacted-dev",
        "k8s-pod-name": "redacted-redis-job-met-nordic-6403506-x84gl",
        "pod-name": "redacted-dev/redacted-redis-job-met-nordic-6403506-x84gl"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 8105,
        "labels": [
          "k8s:app=redacted-processor-dev-job",
          "k8s:batch.kubernetes.io/job-name=redacted-redis-job-met-nordic-6403506",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account",
          "k8s:io.kubernetes.pod.namespace=redacted-dev",
          "k8s:job=redis-job-met-nordic",
          "k8s:job-name=redacted-redis-job-met-nordic-6403506"
        ]
      },
      "labels": {
        "derived": [
          "k8s:batch.kubernetes.io/controller-uid=1f9d543b-88cf-4cd4-ba5c-2bff6336f669",
          "k8s:controller-uid=1f9d543b-88cf-4cd4-ba5c-2bff6336f669"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=redacted-processor-dev-job",
          "k8s:batch.kubernetes.io/job-name=redacted-redis-job-met-nordic-6403506",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account",
          "k8s:io.kubernetes.pod.namespace=redacted-dev",
          "k8s:job-name=redacted-redis-job-met-nordic-6403506",
          "k8s:job=redis-job-met-nordic"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.71",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "fa:f8:16:9a:c3:0b",
        "interface-index": 2514,
        "interface-name": "lxc12b83caabd83",
        "mac": "8e:ef:fd:a9:7e:3d"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 8105,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 8105,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1441

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1441

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 8105

```
ID     LABELS
8105   k8s:app=redacted-processor-dev-job
       k8s:batch.kubernetes.io/job-name=redacted-redis-job-met-nordic-6403506
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account
       k8s:io.kubernetes.pod.namespace=redacted-dev
       k8s:job-name=redacted-redis-job-met-nordic-6403506
       k8s:job=redis-job-met-nordic

```


#### BPF Policy Get 2581

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES    PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    276080   3234      0        0
Allow    Ingress     2          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -        -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -        -         0        0
Allow    Egress      0          ANY          NONE         disabled    -        -         0        0

```


#### BPF CT List 2581

```
Invalid argument: unknown type 2581
```


#### Endpoint Get 2581

```
[
  {
    "id": 2581,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-2581-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "c26ac9d7-f360-4707-8f1e-7766b1e7b512"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "5m0s"
          },
          "name": "resolve-identity-2581",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:38.637Z",
            "success-count": 94
          },
          "uuid": "387923ef-5fff-4b8d-854f-3e8fa0b09c94"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-2581",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:43.076Z",
            "success-count": 32
          },
          "uuid": "8ebb60b3-eb22-4160-89d3-4e3c982c88df"
        }
      ],
      "external-identifiers": {
        "container-name": "cilium-health",
        "pod-name": "/"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4,
        "labels": [
          "reserved:health"
        ]
      },
      "labels": {
        "realized": {},
        "security-relevant": [
          "reserved:health"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.222",
            "ipv4-pool-name": "default"
          }
        ],
        "host-mac": "96:94:06:23:72:34",
        "interface-index": 2530,
        "interface-name": "lxc_health",
        "mac": "0e:70:0b:80:43:e9"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 2581

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 2581

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4

```
ID   LABELS
4    reserved:health

```


#### BPF Policy Get 2619

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES      PACKETS   PREFIX   COOKIE
Allow    Ingress     0          9503/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     0          9502/TCP     NONE         disabled    5860629    12349     24       0
Allow    Ingress     1          9501/TCP     NONE         disabled    89488      413       24       0
Allow    Ingress     1          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2          ANY          NONE         disabled    6446261    29945     0        0
Allow    Ingress     6          9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     7          9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     9          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -          -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -          -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1252       9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     1252       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3446       9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     3446       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     4394       9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     4394       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6043       9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     6043       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8453       9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     8779       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15473      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     15505      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     17163      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     17163      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19572      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     19572      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     23106      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     23106      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     27422      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     27422      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    375184     4502      0        0
Allow    Ingress     28201      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     28530      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29163      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     29163      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29395      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     29994      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29994      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     31674      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34995      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     35682      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39166      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     39166      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43339      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     43339      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43550      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     43616      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    412225     5816      0        0
Allow    Ingress     47918      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     48334      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     49075      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     49276      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53439      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     54396      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16777217   9501/TCP     NONE         disabled    -          -         24       0
Allow    Egress      0          ANY          NONE         disabled    98587421   832014    0        0

```


#### BPF CT List 2619

```
Invalid argument: unknown type 2619
```


#### Endpoint Get 2619

```
[
  {
    "id": 2619,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-2619-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "b991184c-23f4-4793-bc8a-27e2c5517b54"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/longhorn-manager-c9mnx",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:43.083Z",
            "success-count": 2
          },
          "uuid": "1b4ac59d-8656-44b6-b98c-1500cd2c4846"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (2619)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "b3121ab9-ee11-48fe-881d-47f382bce81e"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-2619",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:42.988Z",
            "success-count": 32
          },
          "uuid": "a46400c3-40fc-4ecc-b37e-8de2fa606a4f"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (2619)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:29.497Z",
            "success-count": 2814
          },
          "uuid": "123f7614-489f-4585-bca1-cf91b1b547e2"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (2619)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "1871a33c-8d24-420e-b1ea-25d2f0e0044a"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "1bbe5968b88ff7696f9b4e8b8583f717c3b204344034e03564f43e0e7ac9e9ae:eth0",
        "container-id": "1bbe5968b88ff7696f9b4e8b8583f717c3b204344034e03564f43e0e7ac9e9ae",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "longhorn-manager-c9mnx",
        "pod-name": "longhorn-system/longhorn-manager-c9mnx"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4394,
        "labels": [
          "k8s:app=longhorn-manager",
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/admission-webhook=longhorn-admission-webhook",
          "k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook",
          "k8s:longhorn.io/recovery-backend=longhorn-recovery-backend"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=55566b9bd7",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:app=longhorn-manager",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/admission-webhook=longhorn-admission-webhook",
          "k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook",
          "k8s:longhorn.io/recovery-backend=longhorn-recovery-backend"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "namedPorts": [
        {
          "name": "admission-wh",
          "port": 9502,
          "protocol": "TCP"
        },
        {
          "name": "conversion-wh",
          "port": 9501,
          "protocol": "TCP"
        },
        {
          "name": "manager",
          "port": 9500,
          "protocol": "TCP"
        },
        {
          "name": "recov-backend",
          "port": 9503,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.16",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "8e:fe:8f:98:4b:5e",
        "interface-index": 18,
        "interface-name": "lxc9debe830ea22",
        "mac": "fe:63:e5:1a:2c:eb"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4394,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                  ]
                ],
                "rule": "{\"port\":9501,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                  ]
                ],
                "rule": "{\"port\":9502,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                  ]
                ],
                "rule": "{\"port\":9503,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4394,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                  ]
                ],
                "rule": "{\"port\":9501,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                  ]
                ],
                "rule": "{\"port\":9502,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                  ]
                ],
                "rule": "{\"port\":9503,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 2619

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 2619

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4394

```
ID     LABELS
4394   k8s:app.kubernetes.io/instance=longhorn
       k8s:app.kubernetes.io/managed-by=Helm
       k8s:app.kubernetes.io/name=longhorn
       k8s:app.kubernetes.io/version=v1.9.0
       k8s:app=longhorn-manager
       k8s:helm.sh/chart=longhorn-1.9.0
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
       k8s:io.kubernetes.pod.namespace=longhorn-system
       k8s:longhorn.io/admission-webhook=longhorn-admission-webhook
       k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook
       k8s:longhorn.io/recovery-backend=longhorn-recovery-backend

```


#### BPF Policy Get 3817

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES        PACKETS    PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    30941        348        0        0
Allow    Ingress     2          443/TCP      NONE         disabled    14740027     87198      24       0
Allow    Ingress     2          ANY          NONE         disabled    2392376      26309      0        0
Allow    Ingress     2          80/TCP       NONE         disabled    2307121      19068      24       0
Allow    Ingress     9          443/TCP      NONE         disabled    -            -          24       0
Allow    Ingress     9          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9          80/TCP       NONE         disabled    -            -          24       0
Allow    Ingress     10         80/TCP       NONE         disabled    -            -          24       0
Allow    Ingress     10         443/TCP      NONE         disabled    -            -          24       0
Allow    Ingress     10         ANY          NONE         disabled    -            -          0        0
Allow    Ingress     465        ANY          NONE         disabled    -            -          0        0
Allow    Ingress     566        ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1252       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1596       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1624       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1637       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2269       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2645       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2833       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2843       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2978       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3128       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3446       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3592       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3761       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3836       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3866       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     4394       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     4988       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5015       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5080       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5117       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5438       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5493       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5643       ANY          NONE         disabled    6922499      5135       0        0
Allow    Ingress     5993       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6043       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6344       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6933       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     7513       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     7936       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8105       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8231       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8241       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8367       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8453       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8779       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9194       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9585       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     10807      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     11332      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12176      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12201      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12307      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12337      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13556      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13626      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13786      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14280      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14657      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14667      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14966      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14973      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15202      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15473      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15505      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15927      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16376      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16908      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16992      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     17163      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     17926      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     18592      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     18622      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19324      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19460      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19572      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19792      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19881      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19945      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     20806      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     22863      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     22922      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     23106      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     23582      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     24706      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     24736      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25152      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25226      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25555      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25589      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26001      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26267      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26869      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26892      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     27422      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     27486      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28201      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28530      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28621      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29089      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29163      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29395      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29994      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     31674      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     31840      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     32467      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33088      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33311      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33454      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33688      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33755      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34216      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34266      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34352      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34736      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34995      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     35682      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     35696      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     36596      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     37415      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     37517      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     38491      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39166      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39278      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39699      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     40088      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     41969      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42199      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42605      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42869      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43339      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43550      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43616      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     47483      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     47918      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     48334      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     48593      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     49075      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     49276      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52241      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52642      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52772      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53263      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53293      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53439      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     54396      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     54583      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     55202      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     55741      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     57633      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     58710      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60465      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60492      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60523      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     61421      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     61927      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     62026      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     63330      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     64556      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     65239      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16777217   443/TCP      NONE         disabled    -            -          24       0
Allow    Ingress     16777217   80/TCP       NONE         disabled    -            -          24       0
Allow    Egress      0          ANY          NONE         disabled    1837350698   14057993   0        0

```


#### BPF CT List 3817

```
Invalid argument: unknown type 3817
```


#### Endpoint Get 3817

```
[
  {
    "id": 3817,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-3817-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "4d5c8b39-3630-4292-bc90-320540243146"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-ingress-internal/ingress-nginx-controller-59bb75dc84-fcclv",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:43.084Z",
            "success-count": 2
          },
          "uuid": "3b64046a-59a3-4d7f-a3ec-88b32e0ad656"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (3817)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "b8a4506c-a63b-45c2-ad3b-d1759f010705"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-3817",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:42.977Z",
            "success-count": 32
          },
          "uuid": "31031fe4-6166-4158-bf5c-1a2b765348e1"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (3817)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:29.186Z",
            "success-count": 2814
          },
          "uuid": "bde6bcbb-8fcb-4344-b207-0e0248eee9be"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (3817)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "34d6176a-c366-4194-b7a8-8255455a1e2c"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "05d0c52a245d13caca85cdb39c6c34a18166964b45653ec14f9a64a059137733:eth0",
        "container-id": "05d0c52a245d13caca85cdb39c6c34a18166964b45653ec14f9a64a059137733",
        "k8s-namespace": "ingress-internal",
        "k8s-pod-name": "ingress-nginx-controller-59bb75dc84-fcclv",
        "pod-name": "ingress-internal/ingress-nginx-controller-59bb75dc84-fcclv"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 5643,
        "labels": [
          "k8s:app.kubernetes.io/component=controller",
          "k8s:app.kubernetes.io/instance=ingress-nginx",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=ingress-nginx",
          "k8s:app.kubernetes.io/part-of=ingress-nginx",
          "k8s:app.kubernetes.io/version=1.12.1",
          "k8s:helm.sh/chart=ingress-nginx-4.12.1",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=ingress-internal",
          "k8s:io.cilium.k8s.namespace.labels.name=ingress-internal",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=ingress-nginx",
          "k8s:io.kubernetes.pod.namespace=ingress-internal"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=59bb75dc84"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/component=controller",
          "k8s:app.kubernetes.io/instance=ingress-nginx",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=ingress-nginx",
          "k8s:app.kubernetes.io/part-of=ingress-nginx",
          "k8s:app.kubernetes.io/version=1.12.1",
          "k8s:helm.sh/chart=ingress-nginx-4.12.1",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=ingress-internal",
          "k8s:io.cilium.k8s.namespace.labels.name=ingress-internal",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=ingress-nginx",
          "k8s:io.kubernetes.pod.namespace=ingress-internal"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "namedPorts": [
        {
          "name": "http",
          "port": 80,
          "protocol": "TCP"
        },
        {
          "name": "https",
          "port": 443,
          "protocol": "TCP"
        },
        {
          "name": "webhook",
          "port": 8443,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.209",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "52:8f:58:05:3e:b6",
        "interface-index": 1534,
        "interface-name": "lxc40c4b2025f46",
        "mac": "96:c7:a9:fd:8e:6a"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 5643,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                    "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                    "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                  ]
                ],
                "rule": "{\"port\":443,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                      "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                      "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                      "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                      "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                      "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                      "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                    "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                    "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                  ]
                ],
                "rule": "{\"port\":80,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                      "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                      "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                      "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                      "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                      "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                      "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 5643,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                    "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                    "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                  ]
                ],
                "rule": "{\"port\":80,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                      "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                      "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                      "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                      "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                      "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                      "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                    "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                    "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                  ]
                ],
                "rule": "{\"port\":443,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                      "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                      "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                      "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                      "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-world-to-ingress-nginx",
                      "k8s:io.cilium.k8s.policy.namespace=ingress-internal",
                      "k8s:io.cilium.k8s.policy.uid=5e2f2bdd-f374-4698-ab40-0bd473bc18f6"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 3817

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 3817

```
Timestamp              Status   State                   Message
2026-01-19T22:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:37Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:37Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:37Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 5643

```
ID     LABELS
5643   k8s:app.kubernetes.io/component=controller
       k8s:app.kubernetes.io/instance=ingress-nginx
       k8s:app.kubernetes.io/managed-by=Helm
       k8s:app.kubernetes.io/name=ingress-nginx
       k8s:app.kubernetes.io/part-of=ingress-nginx
       k8s:app.kubernetes.io/version=1.12.1
       k8s:helm.sh/chart=ingress-nginx-4.12.1
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=ingress-internal
       k8s:io.cilium.k8s.namespace.labels.name=ingress-internal
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=ingress-nginx
       k8s:io.kubernetes.pod.namespace=ingress-internal

```


#### BPF Policy Get 3873

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES      PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -          -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -          -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -          -         0        0
Allow    Egress      0          ANY          NONE         disabled    11542746   63013     0        0

```


#### BPF CT List 3873

```
Invalid argument: unknown type 3873
```


#### Endpoint Get 3873

```
[
  {
    "id": 3873,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-3873-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "b09aa89c-f1d2-4eb7-a33f-b366f88bf356"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-system-upgrade/system-upgrade-controller-6fbbfc5bc8-wfblf",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:43.040Z",
            "success-count": 2
          },
          "uuid": "bfb956cc-690f-4262-b055-78dea997293d"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (3873)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "90e33491-a10f-49cb-b066-6e9f942b9b2c"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-3873",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:42.954Z",
            "success-count": 32
          },
          "uuid": "c736a6e6-be19-4484-bd8b-56a749b540d1"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (3873)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:28.846Z",
            "success-count": 2814
          },
          "uuid": "d8f1d59d-2ae3-4295-8f2d-b699f73ad635"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (3873)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:37.584Z",
            "success-count": 1
          },
          "uuid": "3c8729cb-0113-42d6-94e7-0ff2466748fe"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "38ee1754c5dec00d5d325ac89475c38984d8341a5b77ef2068751e6cd4d3f676:eth0",
        "container-id": "38ee1754c5dec00d5d325ac89475c38984d8341a5b77ef2068751e6cd4d3f676",
        "k8s-namespace": "system-upgrade",
        "k8s-pod-name": "system-upgrade-controller-6fbbfc5bc8-wfblf",
        "pod-name": "system-upgrade/system-upgrade-controller-6fbbfc5bc8-wfblf"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 57633,
        "labels": [
          "k8s:app.kubernetes.io/component=controller",
          "k8s:app.kubernetes.io/name=system-upgrade-controller",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=system-upgrade",
          "k8s:io.cilium.k8s.namespace.labels.pod-security.kubernetes.io/enforce=privileged",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=system-upgrade",
          "k8s:io.kubernetes.pod.namespace=system-upgrade",
          "k8s:upgrade.cattle.io/controller=system-upgrade-controller"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=6fbbfc5bc8"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/component=controller",
          "k8s:app.kubernetes.io/name=system-upgrade-controller",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=system-upgrade",
          "k8s:io.cilium.k8s.namespace.labels.pod-security.kubernetes.io/enforce=privileged",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=system-upgrade",
          "k8s:io.kubernetes.pod.namespace=system-upgrade",
          "k8s:upgrade.cattle.io/controller=system-upgrade-controller"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:37Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.13.20",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "de:33:73:93:52:65",
        "interface-index": 24,
        "interface-name": "lxc60f19d9b89d6",
        "mac": "c6:89:9c:70:cd:04"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 57633,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string