# Cilium debug information

#### Cilium status

```
KVStore:                Disabled   
Kubernetes:             Ok         1.35 (v1.35.0+k3s1) [linux/amd64]
Kubernetes APIs:        ["cilium/v2::CiliumCIDRGroup", "cilium/v2::CiliumClusterwideNetworkPolicy", "cilium/v2::CiliumEndpoint", "cilium/v2::CiliumNetworkPolicy", "cilium/v2::CiliumNode", "core/v1::Pods", "networking.k8s.io/v1::NetworkPolicy"]
KubeProxyReplacement:   True   [eno1   136.243.38.116 fe80::ab94:714a:5dfa:27c4, vlan4000   192.168.100.24 fe80::52c1:4df:8bac:2ba9 (Direct Routing), tailscale0    100.64.1.32 fd7a:115c:a1e0::121 fe80::8553:87f4:985c:e878]
Host firewall:          Disabled
SRv6:                   Disabled
CNI Chaining:           none
CNI Config file:        successfully wrote CNI configuration file to /host/etc/cni/net.d/05-cilium.conflist
Cilium:                 Ok   1.19.0-rc.0 (v1.19.0-rc.0-b6f44c92)
NodeMonitor:            Listening for events on 12 CPUs with 64x4096 of shared memory
Cilium health daemon:   Ok   
IPAM:                   IPv4: 18/254 allocated from 10.0.8.0/24, 
Allocated addresses:
  10.0.8.116 (kube-system/hubble-relay-76bcfd59cc-l79q4 [restored])
  10.0.8.123 (router)
  10.0.8.124 (kafka/kafka-cluster-dual-role-0 [restored])
  10.0.8.129 (redacted-dev/redacted-era5-ws-dev-85b446cdd7-7nxtw [restored])
  10.0.8.138 (redacted-dev/redacted-redis-job-met-nordic-6407064-chbhp)
  10.0.8.150 (longhorn-system/longhorn-manager-4vb5q [restored])
  10.0.8.153 (longhorn-system/engine-image-ei-e09d8caa-jmtmb [restored])
  10.0.8.178 (longhorn-system/longhorn-csi-plugin-tbhk4 [restored])
  10.0.8.196 (cert-manager/cert-manager-webhook-7b55b785f-2dgjt [restored])
  10.0.8.198 (cert-manager/cert-manager-75c86cbf4-phzdr [restored])
  10.0.8.200 (monitoring/victorialogs-vector-gccvj [restored])
  10.0.8.214 (longhorn-system/instance-manager-4c52d382650a0c25992d763e1f6d6085 [restored])
  10.0.8.229 (monitoring/kured-z95vm [restored])
  10.0.8.230 (health)
  10.0.8.28 (langfuse/langfuse-zookeeper-2 [restored])
  10.0.8.69 (kafka/strimzi-cluster-operator-56677ffff6-tm4d9 [restored])
  10.0.8.81 (kafka/kafka-cluster-entity-operator-55bf655b8d-csx8j [restored])
  10.0.8.84 (longhorn-system/longhorn-driver-deployer-54599c447c-pllq2 [restored])
IPv4 BIG TCP:           Disabled
IPv6 BIG TCP:           Disabled
BandwidthManager:       Disabled
Routing:                Network: Tunnel [vxlan]   Host: BPF
Attach Mode:            TCX
Device Mode:            veth
Masquerading:           BPF   [eno1, vlan4000, tailscale0]   10.0.8.0/24  [IPv4: Enabled, IPv6: Disabled]
Clock Source for BPF:   ktime
Controller Status:      110/110 healthy
  Name                                                                               Last success   Last error   Count   Message
  cilium-health-ep                                                                   53s ago        never        0       no error   
  ct-map-pressure                                                                    20s ago        never        0       no error   
  endpoint-1014-regeneration-recovery                                                never          never        0       no error   
  endpoint-102-regeneration-recovery                                                 never          never        0       no error   
  endpoint-1098-regeneration-recovery                                                never          never        0       no error   
  endpoint-1261-regeneration-recovery                                                never          never        0       no error   
  endpoint-1437-regeneration-recovery                                                never          never        0       no error   
  endpoint-1517-regeneration-recovery                                                never          never        0       no error   
  endpoint-152-regeneration-recovery                                                 never          never        0       no error   
  endpoint-1561-regeneration-recovery                                                never          never        0       no error   
  endpoint-1744-regeneration-recovery                                                never          never        0       no error   
  endpoint-2072-regeneration-recovery                                                never          never        0       no error   
  endpoint-2489-regeneration-recovery                                                never          never        0       no error   
  endpoint-2592-regeneration-recovery                                                never          never        0       no error   
  endpoint-3456-regeneration-recovery                                                never          never        0       no error   
  endpoint-383-regeneration-recovery                                                 never          never        0       no error   
  endpoint-399-regeneration-recovery                                                 never          never        0       no error   
  endpoint-883-regeneration-recovery                                                 never          never        0       no error   
  endpoint-901-regeneration-recovery                                                 never          never        0       no error   
  endpoint-997-regeneration-recovery                                                 never          never        0       no error   
  endpoint-gc                                                                        3m55s ago      never        0       no error   
  endpoint-periodic-regeneration                                                     54s ago        never        0       no error   
  ipcache-inject-labels                                                              55s ago        never        0       no error   
  k8s-heartbeat                                                                      19s ago        never        0       no error   
  local-identity-checkpoint                                                          7h1m50s ago    never        0       no error   
  resolve-identity-1261                                                              3m53s ago      never        0       no error   
  resolve-identity-383                                                               3m3s ago       never        0       no error   
  resolve-labels-/                                                                   7h48m54s ago   never        0       no error   
  resolve-labels-cert-manager/cert-manager-75c86cbf4-phzdr                           7h48m48s ago   never        0       no error   
  resolve-labels-cert-manager/cert-manager-webhook-7b55b785f-2dgjt                   7h48m48s ago   never        0       no error   
  resolve-labels-kafka/kafka-cluster-dual-role-0                                     7h48m48s ago   never        0       no error   
  resolve-labels-kafka/kafka-cluster-entity-operator-55bf655b8d-csx8j                7h48m47s ago   never        0       no error   
  resolve-labels-kafka/strimzi-cluster-operator-56677ffff6-tm4d9                     7h48m47s ago   never        0       no error   
  resolve-labels-kube-system/hubble-relay-76bcfd59cc-l79q4                           7h48m48s ago   never        0       no error   
  resolve-labels-langfuse/langfuse-zookeeper-2                                       7h48m47s ago   never        0       no error   
  resolve-labels-longhorn-system/engine-image-ei-e09d8caa-jmtmb                      7h48m47s ago   never        0       no error   
  resolve-labels-longhorn-system/instance-manager-4c52d382650a0c25992d763e1f6d6085   7h48m48s ago   never        0       no error   
  resolve-labels-longhorn-system/longhorn-csi-plugin-tbhk4                           7h48m48s ago   never        0       no error   
  resolve-labels-longhorn-system/longhorn-driver-deployer-54599c447c-pllq2           7h48m48s ago   never        0       no error   
  resolve-labels-longhorn-system/longhorn-manager-4vb5q                              7h48m48s ago   never        0       no error   
  resolve-labels-monitoring/kured-z95vm                                              7h48m47s ago   never        0       no error   
  resolve-labels-monitoring/victorialogs-vector-gccvj                                7h48m47s ago   never        0       no error   
  resolve-labels-redacted-dev/redacted-era5-ws-dev-85b446cdd7-7nxtw                    7h48m47s ago   never        0       no error   
  resolve-labels-redacted-dev/redacted-redis-job-met-nordic-6407064-chbhp              3m3s ago       never        0       no error   
  restoring-ep-identity (1014)                                                       7h48m55s ago   never        0       no error   
  restoring-ep-identity (102)                                                        7h48m55s ago   never        0       no error   
  restoring-ep-identity (1098)                                                       7h48m55s ago   never        0       no error   
  restoring-ep-identity (1437)                                                       7h48m55s ago   never        0       no error   
  restoring-ep-identity (1517)                                                       7h48m55s ago   never        0       no error   
  restoring-ep-identity (152)                                                        7h48m55s ago   never        0       no error   
  restoring-ep-identity (1561)                                                       7h48m55s ago   never        0       no error   
  restoring-ep-identity (1744)                                                       7h48m55s ago   never        0       no error   
  restoring-ep-identity (2072)                                                       7h48m55s ago   never        0       no error   
  restoring-ep-identity (2489)                                                       7h48m55s ago   never        0       no error   
  restoring-ep-identity (2592)                                                       7h48m55s ago   never        0       no error   
  restoring-ep-identity (3456)                                                       7h48m55s ago   never        0       no error   
  restoring-ep-identity (399)                                                        7h48m55s ago   never        0       no error   
  restoring-ep-identity (883)                                                        7h48m55s ago   never        0       no error   
  restoring-ep-identity (901)                                                        7h48m55s ago   never        0       no error   
  restoring-ep-identity (997)                                                        7h48m55s ago   never        0       no error   
  sync-policymap-1014                                                                3m47s ago      never        0       no error   
  sync-policymap-102                                                                 3m48s ago      never        0       no error   
  sync-policymap-1098                                                                3m48s ago      never        0       no error   
  sync-policymap-1261                                                                3m47s ago      never        0       no error   
  sync-policymap-1437                                                                3m47s ago      never        0       no error   
  sync-policymap-1517                                                                3m48s ago      never        0       no error   
  sync-policymap-152                                                                 3m48s ago      never        0       no error   
  sync-policymap-1561                                                                3m48s ago      never        0       no error   
  sync-policymap-1744                                                                3m48s ago      never        0       no error   
  sync-policymap-2072                                                                3m47s ago      never        0       no error   
  sync-policymap-2489                                                                3m48s ago      never        0       no error   
  sync-policymap-2592                                                                3m48s ago      never        0       no error   
  sync-policymap-3456                                                                3m48s ago      never        0       no error   
  sync-policymap-383                                                                 3m3s ago       never        0       no error   
  sync-policymap-399                                                                 3m45s ago      never        0       no error   
  sync-policymap-883                                                                 3m48s ago      never        0       no error   
  sync-policymap-901                                                                 3m48s ago      never        0       no error   
  sync-policymap-997                                                                 3m47s ago      never        0       no error   
  sync-to-k8s-ciliumendpoint (1014)                                                  2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (102)                                                   2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (1098)                                                  2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (1437)                                                  2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (1517)                                                  1s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (152)                                                   2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (1561)                                                  2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (1744)                                                  2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (2072)                                                  1s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (2489)                                                  1s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (2592)                                                  2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (3456)                                                  1s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (383)                                                   3s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (883)                                                   1s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (901)                                                   2s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (997)                                                   1s ago         never        0       no error   
  waiting-initial-global-identities-ep (1014)                                        7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (102)                                         7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (1098)                                        7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (1437)                                        7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (1517)                                        7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (152)                                         7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (1561)                                        7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (1744)                                        7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (2072)                                        7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (2489)                                        7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (2592)                                        7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (3456)                                        7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (883)                                         7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (901)                                         7h48m55s ago   never        0       no error   
  waiting-initial-global-identities-ep (997)                                         7h48m55s ago   never        0       no error   
  write-cni-file                                                                     7h48m55s ago   never        0       no error   
Proxy Status:            OK, ip 10.0.8.123, 0 redirects active on ports 10000-20000, Envoy: external
Global Identity Range:   min 256, max 65535
Hubble:                  Ok   Current/Max Flows: 4095/4095 (100.00%), Flows/s: 190.73   Metrics: Disabled
KubeProxyReplacement Details:
  Status:               True
  Socket LB:            Enabled
  Socket LB Tracing:    Enabled
  Socket LB Coverage:   Full
  Devices:              eno1   136.243.38.116 fe80::ab94:714a:5dfa:27c4, vlan4000   192.168.100.24 fe80::52c1:4df:8bac:2ba9 (Direct Routing), tailscale0    100.64.1.32 fd7a:115c:a1e0::121 fe80::8553:87f4:985c:e878
  Mode:                 SNAT
  Backend Selection:    Random
  Session Affinity:     Enabled
  NAT46/64 Support:     Disabled
  XDP Acceleration:     Disabled
  Services:
  - ClusterIP:      Enabled
  - NodePort:       Enabled (Range: 30000-32767) 
  - LoadBalancer:   Enabled 
  - externalIPs:    Enabled 
  - HostPort:       Enabled
  Annotations:
  - service.cilium.io/node
  - service.cilium.io/node-selector
  - service.cilium.io/proxy-delegation
  - service.cilium.io/src-ranges-policy
  - service.cilium.io/type
BPF Maps:   dynamic sizing: on (ratio: 0.002500)
  Name                          Size
  Auth                          524288
  Non-TCP connection tracking   591919
  TCP connection tracking       1183839
  Endpoints                     65535
  IP cache                      512000
  IPv4 masquerading agent       16384
  IPv6 masquerading agent       16384
  IPv4 fragmentation            8192
  IPv4 service                  65536
  IPv6 service                  65536
  IPv4 service backend          65536
  IPv6 service backend          65536
  IPv4 service reverse NAT      65536
  IPv6 service reverse NAT      65536
  Metrics                       1024
  Ratelimit metrics             64
  NAT                           1183839
  Neighbor table                1183839
  Endpoint policy               16384
  Policy stats                  65532
  Session affinity              65536
  Sock reverse NAT              591919
Encryption:   Wireguard   [NodeEncryption: Disabled, cilium_wg0 (Pubkey: Wmr/Qdun2kLnoUc49DNCZnzR3suR2BPO19thOefdoyI=, Port: 51871, Peers: 11)]
```

#### Cilium environment keys

```
certificates-directory:/var/run/cilium/certs
bpf-lb-ipip-sock-mark:false
monitor-aggregation-flags:all
bpf-ct-timeout-regular-any:1m0s
cluster-pool-ipv4-cidr:10.0.0.0/8
k8s-api-server-urls:
bpf-ct-timeout-regular-tcp:2h13m20s
enable-packetization-layer-pmtud:true
mesh-auth-signal-backoff-duration:1s
bpf-lb-dsr-dispatch:opt
enable-bgp-legacy-origin-attribute:false
envoy-default-log-level:
k8s-service-proxy-name:
lb-retry-backoff-min:1s
eni-subnet-ids:
bpf-lb-affinity-map-max:0
enable-dynamic-config:true
nat-map-stats-interval:30s
alibabacloud-security-groups:
trace-sock:true
set-cilium-node-taints:true
config-dir:/tmp/cilium/config-map
bpf-lb-service-map-max:0
unmanaged-pod-watcher-interval:15s
k8s-client-connection-timeout:30s
install-no-conntrack-iptables-rules:false
ipv4-service-range:auto
install-iptables-rules:true
vtep-cidr:
restore:true
hubble-redact-http-urlquery:false
cni-external-routing:false
ip-tracing-option-type:0
agent-liveness-update-interval:1s
bpf-events-default-rate-limit:0
hubble-prefer-ipv6:false
nat-map-stats-entries:32
lb-pressure-metrics-interval:5m0s
use-full-tls-context:false
hubble-redact-http-headers-deny:
enable-health-checking:true
kvstore-opt:
hubble-lost-event-send-interval:1s
l2-announcements-lease-duration:15s
l2-announcements-renew-deadline:5s
enable-cilium-api-server-access:
hubble-dynamic-metrics-config-path:
bpf-lb-map-max:65536
enable-bbr:false
ingress-secrets-namespace:
enable-endpoint-lockdown-on-policy-overflow:false
enable-local-redirect-policy:false
socket-path:/var/run/cilium/cilium.sock
pprof-mutex-profile-fraction:0
egress-masquerade-interfaces:
operator-api-serve-addr:127.0.0.1:9234
policy-secrets-namespace:cilium-secrets
lb-init-wait-timeout:1m0s
kvstore-lease-ttl:15m0s
bpf-ct-timeout-service-any:1m0s
hubble-drop-events-rate-limit:1
k8s-api-server:
enable-policy:default
bpf-lb-rss-ipv6-src-cidr:
identity-change-grace-period:5s
keep-config:false
vtep-endpoint:
enable-node-ipam:false
hubble-monitor-events:
agent-health-port:9879
pprof:false
config-sources-overrides:{"allowConfigKeys":[],"denyConfigKeys":[]}
bypass-ip-availability-upon-restore:false
node-encryption-opt-out-labels:node-role.kubernetes.io/control-plane
encrypt-interface:
bpf-lb-nat46x64:false
bpf-lb-mode:snat
default-lb-service-ipam:lbipam
dns-max-ips-per-restored-rule:1000
identity-max-jitter:30s
cni-chaining-target:
prepend-iptables-chains:true
enable-non-default-deny-policies:true
proxy-xff-num-trusted-hops-egress:0
bpf-neigh-global-max:524288
enable-ipv4:true
mesh-auth-gc-interval:5m0s
ipam-min-allocate:0
metrics-sampling-interval:5m
enable-tcx:true
identity-allocation-mode:crd
shell-sock-path:/var/run/cilium/shell.sock
alibabacloud-vswitch-tags:
ipam-multi-pool-pre-allocation:
cni-exclusive:true
hubble-export-file-max-size-mb:10
service-no-backend-response:reject
proxy-max-active-downstream-connections:50000
hubble-redact-http-headers-allow:
enable-active-connection-tracking:false
hubble-export-fieldaggregate:
bpf-policy-map-pressure-metrics-threshold:0.1
local-max-addr-scope:254
k8s-heartbeat-timeout:30s
lb-sock-terminate-all-protos:false
node-port-algorithm:
eni-delete-on-termination:true
preallocate-bpf-maps:false
pprof-block-profile-rate:0
enable-ingress-controller:false
debug-verbose:
underlay-protocol:ipv4
use-cilium-internal-ip-for-ipsec:false
enable-metrics:true
enable-host-legacy-routing:false
read-cni-conf:
proxy-max-connection-duration-seconds:0
enable-ciliumnode-crd:true
enable-ipip-termination:false
clustermesh-mcs-api-install-crds:true
version:false
enable-host-firewall:false
gops-port:9890
allocator-list-timeout:3m0s
ipv6-native-routing-cidr:
hubble-tls-cert-file:/var/lib/cilium/tls/hubble/server.crt
eni-subnet-tags:
tofqdns-max-deferred-connection-deletes:10000
api-rate-limit:
enable-bgp-control-plane:false
identity-management-mode:agent
bpf-lb-sock-terminate-pod-connections:true
mesh-auth-spire-admin-socket:
node-port-range:
bpf-lb-maglev-hash-seed:JLfvgnHc2kaSUFaI
enable-well-known-identities:false
hubble-network-policy-correlation-enabled:true
status-collector-warning-threshold:15s
k8s-namespace:kube-system
encryption-strict-egress-cidr:
tofqdns-preallocate-identities:true
dnsproxy-concurrency-processing-grace-period:0s
crd-wait-timeout:5m0s
enable-cilium-network-policy:true
eni-exclude-interface-tags:
enable-l2-pod-announcements:false
proxy-idle-timeout-seconds:60
install-uplink-routes-for-delegated-ipam:false
trace-payloadlen:128
enable-node-selector-labels:false
enable-bpf-clock-probe:false
proxy-prometheus-port:0
enable-mke:false
ip-masq-agent-config-path:/etc/config/ip-masq-agent
http-retry-count:3
hubble-metrics:
ipv6-mcast-device:
enable-route-mtu-for-cni-chaining:false
http-max-grpc-timeout:0
enable-ip-masq-agent:false
cmdref:
enable-ipsec:false
alibabacloud-vswitches:
ipv6-cluster-alloc-cidr:f00d::/64
lb-state-file-interval:1s
hubble-metrics-server-tls-client-ca-files:
kube-proxy-replacement-healthz-bind-address:
bpf-ct-global-any-max:262144
enable-service-topology:false
proxy-cluster-max-requests:1024
enable-drift-checker:true
health-check-icmp-failure-threshold:3
envoy-http-upstream-linger-timeout:-1
hubble-export-denylist:
hubble-export-fieldmask:
devices:
enable-xdp-prefilter:false
enable-endpoint-routes:false
hive-log-threshold:100ms
ipam-cilium-node-update-rate:15s
bpf-ct-timeout-service-tcp-grace:1m0s
bpf-lb-mode-annotation:false
proxy-gid:1337
enable-l2-announcements:false
tofqdns-endpoint-max-ip-per-hostname:1000
monitor-aggregation:medium
disable-iptables-feeder-rules:
enable-policy-secrets-sync:true
metrics:
fqdn-regex-compile-lru-size:1024
enable-endpoint-health-checking:true
enable-icmp-rules:true
hubble-tls-client-ca-files:/var/lib/cilium/tls/hubble/client-ca.crt
bpf-ct-timeout-regular-tcp-syn:1m0s
connectivity-probe-frequency-ratio:0.5
enable-ztunnel:false
ipv4-native-routing-cidr:
wireguard-track-all-ips-fallback:false
disable-external-ip-mitigation:false
enable-health-check-nodeport:true
identity-allocation-sync-interval:5m0s
enable-health-check-loadbalancer-ip:false
annotate-k8s-node:false
local-router-ipv4:
allow-icmp-frag-needed:true
enable-monitor:true
direct-routing-device:
hubble-redact-enabled:false
bpf-policy-map-max:16384
cluster-pool-ipv4-mask-size:24
agent-not-ready-taint-key:node.cilium.io/agent-not-ready
enable-gops:true
enable-source-ip-verification:true
enable-lb-ipam:true
enable-identity-mark:true
k8s-client-qps:10
alibabacloud-security-group-tags:
enable-k8s-networkpolicy:true
tofqdns-proxy-response-max-delay:100ms
bpf-lb-algorithm-annotation:false
vtep-mac:
vtep-sync-interval:1m0s
bpf-lb-rev-nat-map-max:0
enable-k8s-host-firewall-bypass:true
force-device-detection:false
restored-proxy-ports-age-limit:15
bpf-lb-sock:false
only-masquerade-default-pool:false
node-port-acceleration:disabled
hubble-listen-address::4244
set-cilium-is-up-condition:true
ipam-max-allocate:0
clustermesh-enable-mcs-api:false
direct-routing-skip-unreachable:false
nodeport-addresses:
kube-proxy-replacement:true
lb-retry-backoff-max:1s
hubble-event-buffer-capacity:4095
bpf-nat-global-max:524288
ipam:cluster-pool
pprof-address:localhost
cluster-health-port:4240
route-metric:0
identity-restore-grace-period:30s
enable-k8s:true
k8s-sync-timeout:3m0s
bpf-lb-sock-hostns-only:false
endpoint-bpf-prog-watchdog-interval:30s
policy-audit-mode:true
mtu:0
bpf-lb-service-backend-map-max:0
srv6-encap-mode:reduced
enable-auto-protect-node-port-range:true
encrypt-node:false
mesh-auth-enabled:true
tunnel-source-port-range:0-0
lrp-address-matcher-cidrs:
hive-stop-timeout:1m0s
envoy-config-timeout:2m0s
enable-hubble:true
proxy-max-requests-per-connection:0
node-port-bind-protection:true
write-cni-conf-when-ready:/host/etc/cni/net.d/05-cilium.conflist
cluster-id:0
envoy-base-id:0
clustermesh-cache-ttl:0s
enable-xt-socket-fallback:true
ipv6-service-range:auto
vtep-mask:
http-retry-timeout:0
enable-ipsec-xfrm-state-caching:true
bpf-lb-acceleration:disabled
ipv4-range:auto
k8s-require-ipv6-pod-cidr:false
operator-prometheus-serve-addr::9963
dnsproxy-lock-timeout:500ms
k8s-client-burst:20
bpf-events-policy-verdict-enabled:true
hive-start-timeout:5m0s
enable-ipv4-big-tcp:false
enable-ipv6-fragment-tracking:true
node-port-mode:
enable-ipv6-masquerade:true
tofqdns-dns-reject-response-code:refused
encryption-strict-mode-cidr:
enable-bandwidth-manager:false
policy-deny-response:none
azure-interface-name:
enable-remote-node-masquerade:false
enable-gateway-api:false
mesh-auth-rotated-identities-queue-size:1024
hubble-redact-kafka-apikey:false
allow-unsafe-policy-skb-usage:false
bpf-policy-map-full-reconciliation-interval:15m0s
status-collector-interval:5s
ztunnel-zds-unix-addr:/var/run/cilium/ztunnel.sock
enable-vtep:false
trace-payloadlen-overlay:192
monitor-aggregation-interval:5s
identity-heartbeat-timeout:30m0s
hubble-disable-tls:false
bpf-lb-rss-ipv4-src-cidr:
bpf-root:/sys/fs/bpf
ipv6-node:auto
bpf-events-trace-enabled:true
tunnel-protocol:vxlan
clustermesh-sync-timeout:1m0s
eni-disable-prefix-delegation:false
external-envoy-proxy:true
ipsec-key-rotation-duration:5m0s
bgp-router-id-allocation-mode:default
policy-default-local-cluster:true
bpf-events-drop-enabled:true
custom-cni-conf:false
identity-gc-interval:15m0s
dnsproxy-insecure-skip-transparent-mode-check:false
enable-stale-cilium-endpoint-cleanup:true
enable-l2-neigh-discovery:false
lb-state-file:
http-stream-idle-timeout:300
enable-l7-proxy:true
enable-dynamic-lifecycle-manager:false
cgroup-root:/run/cilium/cgroupv2
enable-bbr-hostns-only:false
static-cnp-path:
enable-extended-ip-protocols:false
ipv4-pod-subnets:
proxy-max-concurrent-retries:128
enable-srv6:false
bpf-lb-maglev-map-max:0
bpf-lb-maglev-table-size:16381
cni-chaining-mode:none
policy-secrets-only-from-secrets-namespace:true
bpf-ct-timeout-service-tcp:2h13m20s
ipsec-key-file:
exclude-node-label-patterns:
hubble-event-queue-size:0
hubble-metrics-server-enable-tls:false
log-driver:
bpf-ct-timeout-regular-tcp-fin:10s
status-collector-failure-threshold:1m0s
envoy-config-retry-interval:15s
hubble-metrics-server-tls-key-file:
hubble-flowlogs-config-path:
dnsproxy-socket-linger-timeout:10
hubble-drop-events:false
enable-unreachable-routes:false
enable-bgp-control-plane-status-report:true
dnsproxy-enable-transparent-mode:true
enable-wireguard:true
egress-gateway-reconciliation-trigger-interval:1s
pprof-port:6060
derive-masq-ip-addr-from-device:
bpf-conntrack-accounting:false
mke-cgroup-mount:
disable-envoy-version-check:false
tofqdns-min-ttl:0
cluster-name:default
ipam-static-ip-tags:
datapath-mode:veth
bpf-auth-map-max:524288
gateway-api-secrets-namespace:
policy-queue-size:100
enable-pmtu-discovery:false
enable-encryption-strict-mode:false
ipam-pre-allocate:0
proxy-initial-fetch-timeout:30
hubble-export-allowlist:
max-controller-interval:0
k8s-client-connection-keep-alive:30s
bgp-router-id-allocation-ip-pool:
enable-bpf-tproxy:false
bpf-filter-priority:1
hubble-export-file-max-backups:5
enable-ipv6:false
enable-k8s-api-discovery:false
nodes-gc-interval:5m0s
eni-security-groups:
conntrack-gc-max-interval:0s
proxy-cluster-max-connections:1024
hubble-skip-unknown-cgroup-ids:true
egress-gateway-policy-map-max:16384
ipv6-service-loopback-address:fe80::1
prometheus-serve-addr:
proxy-portrange-max:20000
enable-local-node-route:true
identity-allocation-timeout:2m0s
bpf-lb-external-clusterip:false
eni-first-interface-index:0
labels:
ipam-default-ip-pool:default
bpf-map-event-buffers:
routing-mode:tunnel
bpf-fragments-map-max:8192
exclude-local-address:
ipv4-node:auto
bpf-distributed-lru:false
enable-tunnel-big-tcp:false
envoy-policy-restore-timeout:3m0s
clustermesh-enable-endpoint-sync:false
hubble-metrics-server-tls-cert-file:
fixed-identity-mapping:
monitor-queue-size:0
clustermesh-config:/var/lib/cilium/clustermesh/
max-connected-clusters:255
enable-tracing:false
enable-standalone-dns-proxy:false
tofqdns-idle-connection-grace-period:0s
k8s-kubeconfig-path:
policy-accounting:true
synchronize-k8s-nodes:true
label-prefix-file:
ipv6-range:auto
status-collector-probe-check-timeout:5m0s
vlan-bpf-bypass:
tunnel-port:0
bpf-map-dynamic-size-ratio:0.0025
enable-ipv6-ndp:false
dnsproxy-lock-count:131
mesh-auth-spiffe-trust-domain:spiffe.cilium
kvstore-max-consecutive-quorum-errors:2
endpoint-gc-interval:5m0s
hubble-socket-path:/var/run/cilium/hubble.sock
bpf-node-map-max:16384
iptables-lock-timeout:5s
envoy-keep-cap-netbindservice:false
endpoint-queue-size:25
dynamic-lifecycle-config:[]
multicast-enabled:false
endpoint-regen-interval:2m0s
bpf-events-default-burst-limit:0
enable-bpf-masquerade:true
bpf-ct-global-tcp-max:524288
proxy-connect-timeout:2
proxy-portrange-min:10000
container-ip-local-reserved-ports:auto
lib-dir:/var/lib/cilium
enable-ipv4-masquerade:true
enable-nat46x64-gateway:false
status-collector-stackdump-path:/run/cilium/state/agent.stack.gz
hubble-drop-events-reasons:
proxy-xff-num-trusted-hops-ingress:0
proxy-use-original-source-address:true
hubble-redact-http-userinfo:true
conntrack-gc-interval:0s
enable-ipv4-fragment-tracking:true
tofqdns-proxy-port:0
eni-security-group-tags:
cni-log-file:/var/run/cilium/cilium-cni.log
wireguard-persistent-keepalive:0s
auto-create-cilium-node-resource:true
enable-no-service-endpoints-routable:true
agent-labels:
tofqdns-pre-cache:
enable-encryption-strict-mode-ingress:false
dns-policy-unload-on-shutdown:false
mesh-auth-queue-size:1024
policy-trigger-interval:1s
procfs:/host/proc
kvstore:
enable-ipsec-key-watcher:true
node-labels:
enable-encryption-strict-mode-egress:false
remove-cilium-node-taints:true
hubble-drop-events-interval:2m0s
bpf-lb-source-range-all-types:false
ignore-flags-drift-checker:
iptables-random-fully:false
hubble-export-file-path:
enable-cilium-health-api-server-access:
bpf-lb-algorithm:random
ipv6-pod-subnets:
bpf-lb-source-range-map-max:0
agent-health-require-k8s-connectivity:true
k8s-require-ipv4-pod-cidr:false
envoy-secrets-namespace:
enable-egress-gateway:true
config-sources:[{"kind":"config-map","namespace":"kube-system","name":"cilium-config"}]
http-request-timeout:3600
encryption-strict-egress-allow-remote-node-identities:false
hubble-drop-events-extended:false
enable-masquerade-to-route-source:false
encryption-strict-mode-allow-remote-node-identities:false
http-idle-timeout:0
debug:false
policy-cidr-match-mode:
enable-ipv6-big-tcp:false
mesh-auth-mutual-listener-port:0
eni-use-primary-address:false
hubble-tls-key-file:/var/lib/cilium/tls/hubble/server.key
bpf-policy-stats-map-max:65536
hubble-export-aggregation-interval:0s
controller-group-metrics:
ipv4-service-loopback-address:169.254.42.1
envoy-log:
max-internal-timer-delay:0s
enable-cilium-clusterwide-network-policy:true
disable-endpoint-crd:false
mesh-auth-mutual-connect-timeout:5s
auto-direct-node-routes:false
enable-hubble-open-metrics:false
state-dir:/var/run/cilium
boot-id-file:/proc/sys/kernel/random/boot_id
l2-pod-announcements-interface-pattern:
enable-envoy-config:false
http-normalize-path:true
proxy-admin-port:0
local-router-ipv6:
envoy-access-log-buffer-size:4096
l2-announcements-retry-period:2s
log-system-load:false
standalone-dns-proxy-server-port:10095
tofqdns-enable-dns-compression:true
log-opt:
enable-sctp:false
allow-localhost:auto
hubble-export-file-compress:false
bpf-sock-rev-map-max:0
config:
enable-cilium-endpoint-slice:false
dnsproxy-concurrency-limit:0
hubble-metrics-server:
cilium-endpoint-gc-interval:5m0s
```


#### Policy get

```
:
 [
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {}
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-same-namespace",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "4f936664-abef-481c-a701-081659408cae",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": false,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/cluster": "kafka-cluster",
          "k8s.strimzi.io/kind": "Kafka",
          "k8s.strimzi.io/name": "kafka-cluster-kafka"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/admission-webhook": "longhorn-admission-webhook"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9502",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-admission-webhook",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "dafd5ae7-fec1-4361-9b68-15a84634f20e",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "any.app.kubernetes.io/name": "ingress-nginx",
        "k8s.io.kubernetes.pod.namespace": "ingress-internal"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "reserved.world": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv4": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv6": ""
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "80",
            "protocol": "TCP"
          },
          {
            "port": "443",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-world-to-ingress-nginx",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "ingress-internal",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "5e2f2bdd-f374-4698-ab40-0bd473bc18f6",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka"
        }
      },
      "cidr:0.0.0.0/0"
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9092",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-internet",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "3435d905-c9c4-480e-b86e-a2c964f77c42",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "instance-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "5220481c-b461-4d94-adaf-7955db01ad5f",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/recovery-backend": "longhorn-recovery-backend"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9503",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-recovery-backend",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "a48ed662-92ca-48cf-8eb5-84f664e63c39",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/kind": "cluster-operator"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9090",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-csi-plugin",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/managed-by": "longhorn-manager"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      },
      "cidr:10.0.0.0/12"
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {},
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default"
        },
        "matchExpressions": [
          {
            "key": "k8s.io.kubernetes.pod.namespace",
            "operator": "Exists"
          }
        ]
      }
    ],
    "L4": [],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumClusterwideNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "test-allow-cluster-ingress-all",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "43ed3334-a7fd-4b02-a5ec-b7234ea021b4",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "5220481c-b461-4d94-adaf-7955db01ad5f",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-csi-plugin",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9808",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-csi-plugin",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "dcfe5679-1b87-415a-be9a-b0f75aff8771",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-ui",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app.kubernetes.io/component": "controller",
          "k8s.app.kubernetes.io/instance": "ingress-nginx",
          "k8s.app.kubernetes.io/name": "ingress-nginx",
          "k8s.io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name": "ingress-nginx",
          "k8s.io.cilium.k8s.policy.cluster": "default"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-ui",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b75292d2-11c7-467c-8558-50508860334c",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/name": "kafka-cluster-kafka-exporter"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9092",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-driver-deployer",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {},
    "L3": [
      {
        "matchLabels": {
          "reserved.world": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv4": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv6": ""
        }
      }
    ],
    "L4": [],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumClusterwideNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "test-allow-cluster-ingress-all",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "43ed3334-a7fd-4b02-a5ec-b7234ea021b4",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-data-source"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-data-source",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "6b710528-3078-446b-bf8d-e2dda11cfc84",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-data-source"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "backing-image-data-source"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-data-source",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "6b710528-3078-446b-bf8d-e2dda11cfc84",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "instance-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "instance-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "instance-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "2ff1f074-01bb-452c-85e6-a10cc548b287",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-csi-plugin",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      },
      "cidr:10.0.0.0/12"
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9808",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-csi-plugin",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "dcfe5679-1b87-415a-be9a-b0f75aff8771",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {}
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-same-namespace",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "4f936664-abef-481c-a701-081659408cae",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": false,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/kind": "cluster-operator"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "8443",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "instance-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "instance-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "2ff1f074-01bb-452c-85e6-a10cc548b287",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "instance-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "backing-image-data-source"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "instance-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "2ff1f074-01bb-452c-85e6-a10cc548b287",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/name": "kafka-cluster-cruise-control"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9093",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      "cidr:0.0.0.0/0"
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-internet",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "3435d905-c9c4-480e-b86e-a2c964f77c42",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": false,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-data-source"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "instance-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-data-source",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "6b710528-3078-446b-bf8d-e2dda11cfc84",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-data-source"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "backing-image-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-data-source",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "6b710528-3078-446b-bf8d-e2dda11cfc84",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/cluster": "kafka-cluster",
          "k8s.strimzi.io/kind": "Kafka",
          "k8s.strimzi.io/name": "kafka-cluster-kafka"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9090",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka"
        }
      },
      "cidr:10.0.0.0/12"
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "8080",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-node-ingress",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "a9a888a5-cbf8-4324-bab7-fa93a3a6b77b",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/kind": "cluster-operator"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/name": "kafka-cluster-entity-operator"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-ui",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        },
        "matchExpressions": [
          {
            "key": "k8s.longhorn.io/job-task",
            "operator": "Exists"
          }
        ]
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "any.app": "longhorn-csi-plugin",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "reserved.remote-node": ""
        }
      },
      {
        "matchLabels": {
          "reserved.host": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv4": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv6": ""
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9808",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-csi-plugin-node-access",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "4c790d77-1673-4c32-a951-9dccc4b34c5f",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "any.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "reserved.remote-node": ""
        }
      },
      {
        "matchLabels": {
          "reserved.host": ""
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager-node-access",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "3692c6de-9cb3-4390-bb4b-3e56867f9f61",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app.kubernetes.io/component": "controller",
        "k8s.app.kubernetes.io/name": "ingress-nginx",
        "k8s.io.kubernetes.pod.namespace": "ingress-nginx"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "80",
            "protocol": "TCP"
          },
          {
            "port": "443",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumClusterwideNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-all-to-ingress-nginx",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "9b0662a3-d945-4917-9cd7-524feb6d4f54",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "backing-image-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "5220481c-b461-4d94-adaf-7955db01ad5f",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-same-namespace",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "4f936664-abef-481c-a701-081659408cae",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  }
]
Revision: 25

```


#### Cilium memory map


```
00400000-03a47000 r-xp 00000000 00:5a 5375943                            /usr/bin/cilium-agent
03a47000-07dfe000 r--p 03647000 00:5a 5375943                            /usr/bin/cilium-agent
07dfe000-080c9000 rw-p 079fe000 00:5a 5375943                            /usr/bin/cilium-agent
080c9000-08657000 rw-p 00000000 00:00 0 
c000000000-c009400000 rw-p 00000000 00:00 0                              [anon: Go: heap]
c009400000-c00c000000 ---p 00000000 00:00 0                              [anon: Go: heap reservation]
7fb9c9a61000-7fb9c9a71000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7fb9c9a71000-7fb9c9ab1000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9c9ab1000-7fb9c9ad1000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7fb9c9ad1000-7fb9c9be3000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9c9be3000-7fb9c9c07000 rw-p 00000000 00:00 0                          [anon: Go: allspans array]
7fb9c9c07000-7fb9c9c47000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9c9c47000-7fb9c9c67000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7fb9c9c67000-7fb9c9ca7000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9c9ca9000-7fb9c9cf9000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7fb9c9cf9000-7fb9c9d39000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9c9d39000-7fb9c9d3a000 rw-p 00000000 00:00 0                          [anon: Go: getrandom states]
7fb9c9d3a000-7fb9c9d4c000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9c9d4c000-7fb9c9d8d000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9c9d8d000-7fb9c9dce000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9c9dce000-7fb9c9e0f000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9c9e0f000-7fb9c9e50000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9c9e50000-7fb9c9e91000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9c9e91000-7fb9c9ed2000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9c9ed2000-7fb9c9f13000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9c9f13000-7fb9c9f54000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9c9f54000-7fb9c9f95000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9c9f95000-7fb9c9fd6000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9c9fd6000-7fb9ca017000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9ca017000-7fb9ca058000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9ca058000-7fb9ca098000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9ca098000-7fb9ca09a000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9ca09a000-7fb9ca09c000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9ca09c000-7fb9ca09e000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9ca09e000-7fb9ca0a0000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9ca0a0000-7fb9ca0a2000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9ca0a2000-7fb9ca0a4000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9ca0a4000-7fb9ca0a6000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9ca0a6000-7fb9ca0a8000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9ca0a8000-7fb9ca0aa000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fb9ca0aa000-7fb9ca12a000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9ca12a000-7fb9ca14a000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7fb9ca14a000-7fb9ca1ca000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9ca1ca000-7fb9ca1da000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7fb9ca1da000-7fb9ca2da000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9ca2da000-7fb9ca2ea000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7fb9ca2ea000-7fb9ca4ea000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9ca4ea000-7fb9ca4fa000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7fb9ca4fa000-7fb9ca67a000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9ca67a000-7fb9ca7da000 rw-p 00000000 00:00 0                          [anon: Go: profiler hash buckets]
7fb9ca7da000-7fb9ca7f0000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fb9ca7f0000-7fb9ca800000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7fb9ca800000-7fb9cc800000 rw-p 00000000 00:00 0                          [anon: Go: heap index]
7fb9cc800000-7fb9dc980000 ---p 00000000 00:00 0                          [anon: Go: scavenge index]
7fb9dc980000-7fb9dc981000 rw-p 00000000 00:00 0                          [anon: Go: scavenge index]
7fb9dc981000-7fb9ec800000 ---p 00000000 00:00 0                          [anon: Go: scavenge index]
7fb9ec800000-7fb9fc980000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7fb9fc980000-7fb9fc981000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7fb9fc981000-7fba0e830000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7fba0e830000-7fba0e831000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7fba0e831000-7fba10c06000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7fba10c06000-7fba10c07000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7fba10c07000-7fba11000000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7fba11000000-7fba11001000 rw-s 00000000 00:10 1083                       anon_inode:bpf-map
7fba11001000-7fba11003000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fba11003000-7fba11005000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fba11005000-7fba11007000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7fba11007000-7fba11008000 rw-p 00000000 00:00 0                          [anon: Go: getrandom states]
7fba11008000-7fba11018000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7fba11018000-7fba11118000 rw-p 00000000 00:00 0                          [anon: Go: page alloc index]
7fba11118000-7fba1112a000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fba1112a000-7fba111aa000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7fba111aa000-7fba111ab000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7fba111ab000-7fba1122a000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7fba1122a000-7fba1124a000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7fba1124a000-7fba1128a000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7fba1128a000-7fba1128e000 r--p 00000000 00:00 0                          [vvar]
7fba1128e000-7fba11290000 r-xp 00000000 00:00 0                          [vdso]
7fff6af2e000-7fff6af4f000 rw-p 00000000 00:00 0                          [stack]
ffffffffff600000-ffffffffff601000 --xp 00000000 00:00 0                  [vsyscall]

```


#### Endpoint list

```
ENDPOINT   POLICY (ingress)   POLICY (egress)    IDENTITY   LABELS (source:key[=value])                                                                     IPv6   IPv4         STATUS   
           ENFORCEMENT        ENFORCEMENT                                                                                                                                       
102        Disabled (Audit)   Disabled           18592      k8s:app=redacted-era5-ws-dev                                                                            10.0.8.129   ready   
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev                                                  
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=default                                                                             
                                                            k8s:io.kubernetes.pod.namespace=redacted-dev                                                                                 
152        Disabled (Audit)   Disabled           29163      k8s:app.kubernetes.io/instance=longhorn                                                                10.0.8.84    ready   
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                       
                                                            k8s:app.kubernetes.io/name=longhorn                                                                                         
                                                            k8s:app.kubernetes.io/version=v1.9.0                                                                                        
                                                            k8s:app=longhorn-driver-deployer                                                                                            
                                                            k8s:helm.sh/chart=longhorn-1.9.0                                                                                            
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                              
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                            
                                                            k8s:io.kubernetes.pod.namespace=longhorn-system                                                                             
383        Disabled (Audit)   Disabled           9585       k8s:app=redacted-processor-dev-job                                                                      10.0.8.138   ready   
                                                            k8s:batch.kubernetes.io/job-name=redacted-redis-job-met-nordic-6407064                                                       
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev                                                  
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account                                                   
                                                            k8s:io.kubernetes.pod.namespace=redacted-dev                                                                                 
                                                            k8s:job-name=redacted-redis-job-met-nordic-6407064                                                                           
                                                            k8s:job=redis-job-met-nordic                                                                                                
399        Disabled           Disabled           1          k8s:k3s-upgrade=true                                                                                                ready   
                                                            k8s:node.kubernetes.io/instance-type=k3s                                                                                    
                                                            k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812                               
                                                            reserved:host                                                                                                               
883        Disabled (Audit)   Disabled           43550      k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                         10.0.8.153   ready   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                            
                                                            k8s:io.kubernetes.pod.namespace=longhorn-system                                                                             
                                                            k8s:longhorn.io/component=engine-image                                                                                      
                                                            k8s:longhorn.io/engine-image=ei-e09d8caa                                                                                    
901        Disabled (Audit)   Disabled           3446       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                         10.0.8.214   ready   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                            
                                                            k8s:io.kubernetes.pod.namespace=longhorn-system                                                                             
                                                            k8s:longhorn.io/component=instance-manager                                                                                  
                                                            k8s:longhorn.io/data-engine=v1                                                                                              
                                                            k8s:longhorn.io/instance-manager-image=imi-29909444                                                                         
                                                            k8s:longhorn.io/instance-manager-type=aio                                                                                   
                                                            k8s:longhorn.io/managed-by=longhorn-manager                                                                                 
                                                            k8s:longhorn.io/node=dev-agent-06                                                                                           
997        Disabled (Audit)   Disabled (Audit)   11332      k8s:app.kubernetes.io/instance=kafka-cluster                                                           10.0.8.124   ready   
                                                            k8s:app.kubernetes.io/managed-by=strimzi-cluster-operator                                                                   
                                                            k8s:app.kubernetes.io/name=kafka                                                                                            
                                                            k8s:app.kubernetes.io/part-of=strimzi-kafka-cluster                                                                         
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka                                                        
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=kafka-cluster-kafka                                                                 
                                                            k8s:io.kubernetes.pod.namespace=kafka                                                                                       
                                                            k8s:strimzi.io/broker-role=true                                                                                             
                                                            k8s:strimzi.io/cluster=kafka-cluster                                                                                        
                                                            k8s:strimzi.io/component-type=kafka                                                                                         
                                                            k8s:strimzi.io/controller-name=kafka-cluster-dual-role                                                                      
                                                            k8s:strimzi.io/controller-role=true                                                                                         
                                                            k8s:strimzi.io/controller=strimzipodset                                                                                     
                                                            k8s:strimzi.io/kind=Kafka                                                                                                   
                                                            k8s:strimzi.io/name=kafka-cluster-kafka                                                                                     
                                                            k8s:strimzi.io/pod-name=kafka-cluster-dual-role-0                                                                           
                                                            k8s:strimzi.io/pool-name=dual-role                                                                                          
1014       Disabled (Audit)   Disabled           28201      k8s:app=longhorn-csi-plugin                                                                            10.0.8.178   ready   
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                              
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                            
                                                            k8s:io.kubernetes.pod.namespace=longhorn-system                                                                             
1098       Disabled (Audit)   Disabled           4394       k8s:app.kubernetes.io/instance=longhorn                                                                10.0.8.150   ready   
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                       
                                                            k8s:app.kubernetes.io/name=longhorn                                                                                         
                                                            k8s:app.kubernetes.io/version=v1.9.0                                                                                        
                                                            k8s:app=longhorn-manager                                                                                                    
                                                            k8s:helm.sh/chart=longhorn-1.9.0                                                                                            
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                              
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                            
                                                            k8s:io.kubernetes.pod.namespace=longhorn-system                                                                             
                                                            k8s:longhorn.io/admission-webhook=longhorn-admission-webhook                                                                
                                                            k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook                                                              
                                                            k8s:longhorn.io/recovery-backend=longhorn-recovery-backend                                                                  
1261       Disabled (Audit)   Disabled           4          reserved:health                                                                                        10.0.8.230   ready   
1437       Disabled (Audit)   Disabled           43616      k8s:app.kubernetes.io/component=controller                                                             10.0.8.198   ready   
                                                            k8s:app.kubernetes.io/instance=cert-manager                                                                                 
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                       
                                                            k8s:app.kubernetes.io/name=cert-manager                                                                                     
                                                            k8s:app.kubernetes.io/version=v1.13.3                                                                                       
                                                            k8s:app=cert-manager                                                                                                        
                                                            k8s:helm.sh/chart=cert-manager-v1.13.3                                                                                      
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cert-manager                                                 
                                                            k8s:io.cilium.k8s.namespace.labels.name=cert-manager                                                                        
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=cert-manager                                                                        
                                                            k8s:io.kubernetes.pod.namespace=cert-manager                                                                                
1517       Disabled (Audit)   Disabled (Audit)   10807      k8s:app.kubernetes.io/instance=kafka-cluster                                                           10.0.8.81    ready   
                                                            k8s:app.kubernetes.io/managed-by=strimzi-cluster-operator                                                                   
                                                            k8s:app.kubernetes.io/name=entity-operator                                                                                  
                                                            k8s:app.kubernetes.io/part-of=strimzi-kafka-cluster                                                                         
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka                                                        
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=kafka-cluster-entity-operator                                                       
                                                            k8s:io.kubernetes.pod.namespace=kafka                                                                                       
                                                            k8s:strimzi.io/cluster=kafka-cluster                                                                                        
                                                            k8s:strimzi.io/component-type=entity-operator                                                                               
                                                            k8s:strimzi.io/kind=Kafka                                                                                                   
                                                            k8s:strimzi.io/name=kafka-cluster-entity-operator                                                                           
1561       Disabled (Audit)   Disabled           34352      k8s:app.kubernetes.io/component=Agent                                                                  10.0.8.200   ready   
                                                            k8s:app.kubernetes.io/instance=victorialogs                                                                                 
                                                            k8s:app.kubernetes.io/name=vector                                                                                           
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring                                                   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector                                                                 
                                                            k8s:io.kubernetes.pod.namespace=monitoring                                                                                  
                                                            k8s:vector.dev/exclude=true                                                                                                 
1744       Disabled (Audit)   Disabled           4988       k8s:app.kubernetes.io/instance=kured                                                                   10.0.8.229   ready   
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                       
                                                            k8s:app.kubernetes.io/name=kured                                                                                            
                                                            k8s:helm.sh/chart=kured-5.6.2                                                                                               
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring                                                   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=kured                                                                               
                                                            k8s:io.kubernetes.pod.namespace=monitoring                                                                                  
2072       Disabled (Audit)   Disabled           19324      k8s:app.kubernetes.io/component=webhook                                                                10.0.8.196   ready   
                                                            k8s:app.kubernetes.io/instance=cert-manager                                                                                 
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                       
                                                            k8s:app.kubernetes.io/name=webhook                                                                                          
                                                            k8s:app.kubernetes.io/version=v1.13.3                                                                                       
                                                            k8s:app=webhook                                                                                                             
                                                            k8s:helm.sh/chart=cert-manager-v1.13.3                                                                                      
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cert-manager                                                 
                                                            k8s:io.cilium.k8s.namespace.labels.name=cert-manager                                                                        
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=cert-manager-webhook                                                                
                                                            k8s:io.kubernetes.pod.namespace=cert-manager                                                                                
2489       Disabled (Audit)   Disabled           2843       k8s:app.kubernetes.io/component=zookeeper                                                              10.0.8.28    ready   
                                                            k8s:app.kubernetes.io/instance=langfuse                                                                                     
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                       
                                                            k8s:app.kubernetes.io/name=zookeeper                                                                                        
                                                            k8s:app.kubernetes.io/version=3.9.3                                                                                         
                                                            k8s:helm.sh/chart=zookeeper-13.7.4                                                                                          
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=langfuse                                                     
                                                            k8s:io.cilium.k8s.namespace.labels.name=langfuse                                                                            
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=langfuse-zookeeper                                                                  
                                                            k8s:io.kubernetes.pod.namespace=langfuse                                                                                    
2592       Disabled (Audit)   Disabled (Audit)   33688      k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka                                   10.0.8.69    ready   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=strimzi-cluster-operator                                                            
                                                            k8s:io.kubernetes.pod.namespace=kafka                                                                                       
                                                            k8s:name=strimzi-cluster-operator                                                                                           
                                                            k8s:strimzi.io/kind=cluster-operator                                                                                        
3456       Disabled (Audit)   Disabled           25226      k8s:app.kubernetes.io/name=hubble-relay                                                                10.0.8.116   ready   
                                                            k8s:app.kubernetes.io/part-of=cilium                                                                                        
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kube-system                                                  
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                            k8s:io.cilium.k8s.policy.serviceaccount=hubble-relay                                                                        
                                                            k8s:io.kubernetes.pod.namespace=kube-system                                                                                 
                                                            k8s:k8s-app=hubble-relay                                                                                                    
```

#### BPF Policy Get 102

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    43010     525       0        0
Allow    Ingress     2          ANY          NONE         disabled    2848444   34772     0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    2662207   16578     0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    5926476   85693     0        0

```


#### BPF CT List 102

```
Invalid argument: unknown type 102
```


#### Endpoint Get 102

```
[
  {
    "id": 102,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-102-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "96631447-6f57-424e-92c1-a335185def94"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-redacted-dev/redacted-era5-ws-dev-85b446cdd7-7nxtw",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:39.488Z",
            "success-count": 2
          },
          "uuid": "2a78ab37-3a09-41ad-8ec3-32a48725cae2"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (102)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "f8ec6702-c344-4e8b-82bd-f6f99cdaef6b"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-102",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:39.395Z",
            "success-count": 32
          },
          "uuid": "e56486df-d087-4cb3-bdc1-598c4fe090fb"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (102)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.141Z",
            "success-count": 2814
          },
          "uuid": "9db6420d-d674-4a5f-84d3-bb1c383a6af3"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (102)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "b064b8ba-92f3-487a-a23f-abdf51c8b571"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "57b6942e97c88649bbe8a71696f24fbb805a514a2133f68433cf4e6ed6c737cd:eth0",
        "container-id": "57b6942e97c88649bbe8a71696f24fbb805a514a2133f68433cf4e6ed6c737cd",
        "k8s-namespace": "redacted-dev",
        "k8s-pod-name": "redacted-era5-ws-dev-85b446cdd7-7nxtw",
        "pod-name": "redacted-dev/redacted-era5-ws-dev-85b446cdd7-7nxtw"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 18592,
        "labels": [
          "k8s:app=redacted-era5-ws-dev",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=redacted-dev"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=85b446cdd7"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=redacted-era5-ws-dev",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=redacted-dev"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:32Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.8.129",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "ca:01:fb:fa:57:f1",
        "interface-index": 2520,
        "interface-name": "lxc3ed7f7705f42",
        "mac": "9e:ba:90:40:85:1f"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 18592,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 18592,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 102

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 102

```
Timestamp              Status   State                   Message
2026-01-19T22:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 18592

```
ID      LABELS
18592   k8s:app=redacted-era5-ws-dev
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=default
        k8s:io.kubernetes.pod.namespace=redacted-dev

```


#### BPF Policy Get 152

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES   PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -       -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -       -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -       -         0        0
Allow    Egress      0          ANY          NONE         disabled    -       -         0        0

```


#### BPF CT List 152

```
Invalid argument: unknown type 152
```


#### Endpoint Get 152

```
[
  {
    "id": 152,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-152-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "68f96148-9fb2-437e-8171-b1a64ee693eb"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/longhorn-driver-deployer-54599c447c-pllq2",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:39.412Z",
            "success-count": 2
          },
          "uuid": "888075af-afec-4bb8-bbb9-c549b1d94d60"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (152)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "838ad97a-6ee4-4b92-a964-6e11ccb938b6"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-152",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:39.466Z",
            "success-count": 32
          },
          "uuid": "b0757f7d-e3ab-4f9f-9017-3d3b38922d92"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (152)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:24.885Z",
            "success-count": 2814
          },
          "uuid": "80bd447a-2894-42af-a2ec-cc2e64c1ec8e"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (152)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "556e8836-7b98-4a17-98f5-2e361728253e"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "3850bbe6f45786c922d964faf108cdb25d9c07a67c6a9a910c419395511f9614:eth0",
        "container-id": "3850bbe6f45786c922d964faf108cdb25d9c07a67c6a9a910c419395511f9614",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "longhorn-driver-deployer-54599c447c-pllq2",
        "pod-name": "longhorn-system/longhorn-driver-deployer-54599c447c-pllq2"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 29163,
        "labels": [
          "k8s:app=longhorn-driver-deployer",
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=54599c447c"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:app=longhorn-driver-deployer",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:32Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.8.84",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "82:a5:00:7c:d9:48",
        "interface-index": 2516,
        "interface-name": "lxc33e18b560d61",
        "mac": "52:a0:7b:62:bc:b2"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 29163,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 29163,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 152

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 152

```
Timestamp              Status   State                   Message
2026-01-19T22:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 29163

```
ID      LABELS
29163   k8s:app.kubernetes.io/instance=longhorn
        k8s:app.kubernetes.io/managed-by=Helm
        k8s:app.kubernetes.io/name=longhorn
        k8s:app.kubernetes.io/version=v1.9.0
        k8s:app=longhorn-driver-deployer
        k8s:helm.sh/chart=longhorn-1.9.0
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system

```


#### BPF Policy Get 383

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES       PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -           -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    888         12        0        0
Allow    Ingress     33454      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -           -         0        0
Allow    Egress      0          ANY          NONE         disabled    159024622   789872    0        0

```


#### BPF CT List 383

```
Invalid argument: unknown type 383
```


#### Endpoint Get 383

```
[
  {
    "id": 383,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-383-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "deecd6c4-4d7f-4f7d-82ba-924751a81b21"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "5m0s"
          },
          "name": "resolve-identity-383",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:06:23.797Z",
            "success-count": 1
          },
          "uuid": "a09bf5b2-abbf-4d5b-be7b-7be4c087e33b"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-redacted-dev/redacted-redis-job-met-nordic-6407064-chbhp",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:06:23.797Z",
            "success-count": 1
          },
          "uuid": "6aad3f0e-1185-48fa-9863-896edcfad4d8"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-383",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:06:23.874Z",
            "success-count": 1
          },
          "uuid": "bcf60ef1-ed0c-45a1-be1f-eba891dccb23"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (383)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:23.870Z",
            "success-count": 20
          },
          "uuid": "d7b7ed77-4cc3-46c4-894a-22c819ce47a3"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "2f2d96a6c8f5d85dc792124e4b2f67095dc16c97588418c0136410d9b716c4bd:eth0",
        "container-id": "2f2d96a6c8f5d85dc792124e4b2f67095dc16c97588418c0136410d9b716c4bd",
        "k8s-namespace": "redacted-dev",
        "k8s-pod-name": "redacted-redis-job-met-nordic-6407064-chbhp",
        "pod-name": "redacted-dev/redacted-redis-job-met-nordic-6407064-chbhp"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 9585,
        "labels": [
          "k8s:app=redacted-processor-dev-job",
          "k8s:batch.kubernetes.io/job-name=redacted-redis-job-met-nordic-6407064",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account",
          "k8s:io.kubernetes.pod.namespace=redacted-dev",
          "k8s:job=redis-job-met-nordic",
          "k8s:job-name=redacted-redis-job-met-nordic-6407064"
        ]
      },
      "labels": {
        "derived": [
          "k8s:batch.kubernetes.io/controller-uid=97a1bd82-1c62-485c-9610-0fe62a251bfe",
          "k8s:controller-uid=97a1bd82-1c62-485c-9610-0fe62a251bfe"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=redacted-processor-dev-job",
          "k8s:batch.kubernetes.io/job-name=redacted-redis-job-met-nordic-6407064",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account",
          "k8s:io.kubernetes.pod.namespace=redacted-dev",
          "k8s:job-name=redacted-redis-job-met-nordic-6407064",
          "k8s:job=redis-job-met-nordic"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:32Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.8.138",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "42:a5:aa:4a:fa:07",
        "interface-index": 2946,
        "interface-name": "lxcd384429f49ef",
        "mac": "de:b1:54:5c:32:a8"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 9585,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 9585,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 383

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 383

```
Timestamp              Status   State                   Message
2026-01-19T22:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:23Z   OK       ready                   Successfully regenerated endpoint program (Reason: updated security labels)
2026-01-19T22:06:23Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:23Z   OK       regenerating            Regenerating endpoint: updated security labels
2026-01-19T22:06:23Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to updated security labels
2026-01-19T22:06:23Z   OK       ready                   Set identity for this endpoint
2026-01-19T22:06:23Z   OK       waiting-for-identity    Endpoint creation

```


#### Identity get 9585

```
ID     LABELS
9585   k8s:app=redacted-processor-dev-job
       k8s:batch.kubernetes.io/job-name=redacted-redis-job-met-nordic-6407064
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account
       k8s:io.kubernetes.pod.namespace=redacted-dev
       k8s:job-name=redacted-redis-job-met-nordic-6407064
       k8s:job=redis-job-met-nordic

```


#### BPF Policy Get 399

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES   PACKETS   PREFIX   COOKIE
Allow    Ingress     0          ANY          NONE         disabled    -       -         0        0
Allow    Egress      0          ANY          NONE         disabled    -       -         0        0

```


#### BPF CT List 399

```
Invalid argument: unknown type 399
```


#### Endpoint Get 399

```
[
  {
    "id": 399,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-399-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "dfdbefa0-da61-4133-ad01-08ab0b92192f"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-/",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.803Z",
            "success-count": 1
          },
          "uuid": "f37ea40c-f2c6-442b-8b60-c916ae81529d"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (399)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "66b34c87-282d-466c-a261-775d507d86c8"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-399",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:41.959Z",
            "success-count": 32
          },
          "uuid": "335c1e12-b6fd-4b84-a6b4-879e2a1caf20"
        }
      ],
      "external-identifiers": {
        "pod-name": "/"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 1,
        "labels": [
          "reserved:host",
          "k8s:k3s-upgrade=true",
          "k8s:node.kubernetes.io/instance-type=k3s",
          "k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812"
        ]
      },
      "labels": {
        "derived": [
          "k8s:k3s-upgrade=true",
          "k8s:node.kubernetes.io/instance-type=k3s",
          "k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812",
          "reserved:host"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:k3s-upgrade=true",
          "k8s:node.kubernetes.io/instance-type=k3s",
          "k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812",
          "reserved:host"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:32Z"
        }
      ],
      "networking": {
        "addressing": [
          {}
        ],
        "host-mac": "ba:f8:b7:43:92:fc",
        "interface-index": 6,
        "interface-name": "cilium_host",
        "mac": "ba:f8:b7:43:92:fc"
      },
      "policy": {
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            0
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 1,
          "l4": {
            "egress": [],
            "ingress": []
          },
          "policy-enabled": "none",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            0
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 1,
          "l4": {
            "egress": [],
            "ingress": []
          },
          "policy-enabled": "none",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 399

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 399

```
Timestamp              Status   State                   Message
2026-01-19T22:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 1

```
ID   LABELS
1    reserved:host

```


#### BPF Policy Get 883

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES   PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -       -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -       -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -       -         0        0
Allow    Egress      0          ANY          NONE         disabled    -       -         0        0

```


#### BPF CT List 883

```
Invalid argument: unknown type 883
```


#### Endpoint Get 883

```
[
  {
    "id": 883,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-883-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "e4937349-f684-4b8a-b350-81ebb946d179"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/engine-image-ei-e09d8caa-jmtmb",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:39.502Z",
            "success-count": 2
          },
          "uuid": "284cd77e-f95e-4545-a020-e141cc1630a8"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (883)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "e98b6fb1-d170-451a-8a62-f43ec8acd79f"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-883",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:39.413Z",
            "success-count": 32
          },
          "uuid": "3a78ef9c-ad0d-469a-b3e2-0070d04083ff"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (883)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.619Z",
            "success-count": 2814
          },
          "uuid": "48d0f981-666d-42de-a16c-8cfa3ad0feff"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (883)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "aacd0d1b-f253-4c2e-9ba8-0e947a9b930e"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "0f0d1c96e07b0afe4ad1589045ce6f48750f0396e1038c2f3388032b160f8c0a:eth0",
        "container-id": "0f0d1c96e07b0afe4ad1589045ce6f48750f0396e1038c2f3388032b160f8c0a",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "engine-image-ei-e09d8caa-jmtmb",
        "pod-name": "longhorn-system/engine-image-ei-e09d8caa-jmtmb"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 43550,
        "labels": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=engine-image",
          "k8s:longhorn.io/engine-image=ei-e09d8caa"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=76b647f6f7",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=engine-image",
          "k8s:longhorn.io/engine-image=ei-e09d8caa"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:32Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.8.153",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "f6:b2:ce:60:de:94",
        "interface-index": 14,
        "interface-name": "lxcc154606542c2",
        "mac": "3a:55:57:89:d0:22"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43550,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43550,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 883

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 883

```
Timestamp              Status   State                   Message
2026-01-19T22:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 43550

```
ID      LABELS
43550   k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system
        k8s:longhorn.io/component=engine-image
        k8s:longhorn.io/engine-image=ei-e09d8caa

```


#### BPF Policy Get 901

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES        PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    657552       368       0        0
Allow    Ingress     2          ANY          NONE         disabled    11196646     5763      0        0
Allow    Ingress     9          ANY          NONE         disabled    -            -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -            -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -            -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -            -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    49346101     434332    0        0
Allow    Ingress     4988       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    6322445852   3182202   0        0
Allow    Ingress     17926      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    56804344     657548    0        0
Allow    Ingress     23582      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    69566249     666790    0        0
Allow    Ingress     27486      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    57722534     659617    0        0
Allow    Ingress     29994      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    28851022     330002    0        0
Allow    Ingress     54396      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -            -         0        0
Allow    Egress      0          ANY          NONE         disabled    80360608     664647    0        0

```


#### BPF CT List 901

```
Invalid argument: unknown type 901
```


#### Endpoint Get 901

```
[
  {
    "id": 901,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-901-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "b0b5221e-d889-49a3-b42e-58b05eab8092"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/instance-manager-4c52d382650a0c25992d763e1f6d6085",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:39.461Z",
            "success-count": 2
          },
          "uuid": "be9c8d1e-d5b0-4225-bf92-fd583604083c"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (901)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "cbeb5fa6-43aa-4021-879a-abbe4e3df927"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-901",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:39.373Z",
            "success-count": 32
          },
          "uuid": "e27f7fd6-9cbf-4a47-8c04-fe9b992c6ab8"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (901)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:24.635Z",
            "success-count": 2814
          },
          "uuid": "93da9107-61f6-422d-aad4-ea2dd3cc76a9"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (901)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "095a5352-4a07-42c7-a3cd-60dba8158d19"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "a6367e3fd5b0cad0b2eb7b3f70e486cb37cae00e81e089e451fdc756520d0f79:eth0",
        "container-id": "a6367e3fd5b0cad0b2eb7b3f70e486cb37cae00e81e089e451fdc756520d0f79",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "instance-manager-4c52d382650a0c25992d763e1f6d6085",
        "pod-name": "longhorn-system/instance-manager-4c52d382650a0c25992d763e1f6d6085"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 3446,
        "labels": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=instance-manager",
          "k8s:longhorn.io/data-engine=v1",
          "k8s:longhorn.io/instance-manager-image=imi-29909444",
          "k8s:longhorn.io/instance-manager-type=aio",
          "k8s:longhorn.io/managed-by=longhorn-manager",
          "k8s:longhorn.io/node=dev-agent-06"
        ]
      },
      "labels": {
        "realized": {},
        "security-relevant": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=instance-manager",
          "k8s:longhorn.io/data-engine=v1",
          "k8s:longhorn.io/instance-manager-image=imi-29909444",
          "k8s:longhorn.io/instance-manager-type=aio",
          "k8s:longhorn.io/managed-by=longhorn-manager",
          "k8s:longhorn.io/node=dev-agent-06"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:32Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.8.214",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "82:09:8d:b8:2e:2c",
        "interface-index": 80,
        "interface-name": "lxc9e9298dd4d25",
        "mac": "1e:b6:c4:6c:bc:d8"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 3446,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=instance-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 3446,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=instance-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 901

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 901

```
Timestamp              Status   State                   Message
2026-01-19T22:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 3446

```
ID     LABELS
3446   k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
       k8s:io.kubernetes.pod.namespace=longhorn-system
       k8s:longhorn.io/component=instance-manager
       k8s:longhorn.io/data-engine=v1
       k8s:longhorn.io/instance-manager-image=imi-29909444
       k8s:longhorn.io/instance-manager-type=aio
       k8s:longhorn.io/managed-by=longhorn-manager
       k8s:longhorn.io/node=dev-agent-06

```


#### BPF Policy Get 997

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES    PACKETS   PREFIX   COOKIE
Allow    Ingress     0          9093/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     0          9092/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     1          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -        -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10807      8080/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     10807      9091/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     10807      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     11332      9090/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     11332      8080/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     11332      9091/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     11332      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25152      8080/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     25152      9090/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     25152      9091/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     25226      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33688      9091/TCP     NONE         disabled    14430    195       24       0
Allow    Ingress     33688      9090/TCP     NONE         disabled    12284    166       24       0
Allow    Ingress     33688      8080/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     33688      8443/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     33755      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60492      9090/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     60492      8080/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     60492      9091/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     60523      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16777217   8080/TCP     NONE         disabled    -        -         24       0
Allow    Egress      0          ANY          NONE         disabled    431680   2260      0        0
Allow    Egress      2          ANY          NONE         disabled    -        -         0        0
Allow    Egress      16777217   ANY          NONE         disabled    -        -         0        0

```


#### BPF CT List 997

```
Invalid argument: unknown type 997
```


#### Endpoint Get 997

```
[
  {
    "id": 997,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-997-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "3d8fd9a7-cac4-4116-8ec5-770fcd911b58"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-kafka/kafka-cluster-dual-role-0",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:39.430Z",
            "success-count": 2
          },
          "uuid": "b914c31c-d3e4-4754-bfba-3af0787badb1"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (997)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "673fac16-af04-4193-9e60-aee39ca47efe"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-997",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:39.495Z",
            "success-count": 32
          },
          "uuid": "3eff0e3a-b914-4f83-afee-e112cf659394"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (997)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.529Z",
            "success-count": 2814
          },
          "uuid": "ecfb39ad-b4ca-4d3f-baae-f7410aff9073"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (997)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "829eaa17-ce21-4c9b-8a68-3fa25548f16f"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "a02284f4131e9d9cfa8e43ae8435bb5708e42ef2fb9f1243522f1811c28a60af:eth0",
        "container-id": "a02284f4131e9d9cfa8e43ae8435bb5708e42ef2fb9f1243522f1811c28a60af",
        "k8s-namespace": "kafka",
        "k8s-pod-name": "kafka-cluster-dual-role-0",
        "pod-name": "kafka/kafka-cluster-dual-role-0"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 11332,
        "labels": [
          "k8s:app.kubernetes.io/instance=kafka-cluster",
          "k8s:app.kubernetes.io/managed-by=strimzi-cluster-operator",
          "k8s:app.kubernetes.io/name=kafka",
          "k8s:app.kubernetes.io/part-of=strimzi-kafka-cluster",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kafka-cluster-kafka",
          "k8s:io.kubernetes.pod.namespace=kafka",
          "k8s:strimzi.io/broker-role=true",
          "k8s:strimzi.io/cluster=kafka-cluster",
          "k8s:strimzi.io/component-type=kafka",
          "k8s:strimzi.io/controller=strimzipodset",
          "k8s:strimzi.io/controller-name=kafka-cluster-dual-role",
          "k8s:strimzi.io/controller-role=true",
          "k8s:strimzi.io/kind=Kafka",
          "k8s:strimzi.io/name=kafka-cluster-kafka",
          "k8s:strimzi.io/pod-name=kafka-cluster-dual-role-0",
          "k8s:strimzi.io/pool-name=dual-role"
        ]
      },
      "labels": {
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=kafka-cluster",
          "k8s:app.kubernetes.io/managed-by=strimzi-cluster-operator",
          "k8s:app.kubernetes.io/name=kafka",
          "k8s:app.kubernetes.io/part-of=strimzi-kafka-cluster",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kafka-cluster-kafka",
          "k8s:io.kubernetes.pod.namespace=kafka",
          "k8s:strimzi.io/broker-role=true",
          "k8s:strimzi.io/cluster=kafka-cluster",
          "k8s:strimzi.io/component-type=kafka",
          "k8s:strimzi.io/controller-name=kafka-cluster-dual-role",
          "k8s:strimzi.io/controller-role=true",
          "k8s:strimzi.io/controller=strimzipodset",
          "k8s:strimzi.io/kind=Kafka",
          "k8s:strimzi.io/name=kafka-cluster-kafka",
          "k8s:strimzi.io/pod-name=kafka-cluster-dual-role-0",
          "k8s:strimzi.io/pool-name=dual-role"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:32Z"
        }
      ],
      "namedPorts": [
        {
          "name": "tcp-clients",
          "port": 9092,
          "protocol": "TCP"
        },
        {
          "name": "tcp-clientstls",
          "port": 9093,
          "protocol": "TCP"
        },
        {
          "name": "tcp-ctrlplane",
          "port": 9090,
          "protocol": "TCP"
        },
        {
          "name": "tcp-kafkaagent",
          "port": 8443,
          "protocol": "TCP"
        },
        {
          "name": "tcp-replication",
          "port": 9091,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.8.124",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "06:8e:86:92:3c:40",
        "interface-index": 2534,
        "interface-name": "lxcb3fbb06a4a66",
        "mac": "da:d7:17:5e:1e:4c"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0,
            2,
            16777217
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 11332,
          "l4": {
            "egress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-internet",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:0.0.0.0/0\":null}]}"
              }
            ],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-internet",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9092,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:0.0.0.0/0\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-internet",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "cidr:0.0.0.0/0": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-internet",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                  ]
                ],
                "rule": "{\"port\":8080,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9090,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9091,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-cruise-control,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-entity-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-kafka-exporter,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-cruise-control,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-entity-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-kafka-exporter,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":8443,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9093,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-both",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0,
            2,
            16777217
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 11332,
          "l4": {
            "egress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-internet",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:0.0.0.0/0\":null}]}"
              }
            ],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9091,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-cruise-control,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-entity-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-kafka-exporter,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-cruise-control,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-entity-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-kafka-exporter,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":8443,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9093,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-internet",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9092,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:0.0.0.0/0\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-internet",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "cidr:0.0.0.0/0": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-internet",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                  ]
                ],
                "rule": "{\"port\":8080,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9090,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-both",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 997

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 997

```
Timestamp              Status   State                   Message
2026-01-19T22:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 11332

```
ID      LABELS
11332   k8s:app.kubernetes.io/instance=kafka-cluster
        k8s:app.kubernetes.io/managed-by=strimzi-cluster-operator
        k8s:app.kubernetes.io/name=kafka
        k8s:app.kubernetes.io/part-of=strimzi-kafka-cluster
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=kafka-cluster-kafka
        k8s:io.kubernetes.pod.namespace=kafka
        k8s:strimzi.io/broker-role=true
        k8s:strimzi.io/cluster=kafka-cluster
        k8s:strimzi.io/component-type=kafka
        k8s:strimzi.io/controller-name=kafka-cluster-dual-role
        k8s:strimzi.io/controller-role=true
        k8s:strimzi.io/controller=strimzipodset
        k8s:strimzi.io/kind=Kafka
        k8s:strimzi.io/name=kafka-cluster-kafka
        k8s:strimzi.io/pod-name=kafka-cluster-dual-role-0
        k8s:strimzi.io/pool-name=dual-role

```


#### BPF Policy Get 1014

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          9808/TCP     NONE         disabled    34662     394       24       0
Allow    Ingress     1          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2          9808/TCP     NONE         disabled    2583120   29296     24       0
Allow    Ingress     2          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     7          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29395      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    546644    6538      0        0

```


#### BPF CT List 1014

```
Invalid argument: unknown type 1014
```


#### Endpoint Get 1014

```
[
  {
    "id": 1014,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1014-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "4e85f0c0-4a90-4d3d-bcff-ff9ea0ee5336"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/longhorn-csi-plugin-tbhk4",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:39.423Z",
            "success-count": 2
          },
          "uuid": "8f8f8394-b7b7-4df2-8869-55285bacbaa8"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1014)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "66d37040-2051-4ff1-95b0-7b00d46630ea"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1014",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:39.480Z",
            "success-count": 32
          },
          "uuid": "bae1448b-1a3c-4174-b5b2-48a0d6a91a0f"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1014)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:24.635Z",
            "success-count": 2814
          },
          "uuid": "f85da684-c991-4783-8439-662bc9239ab0"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1014)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "e9381541-dc5d-40e3-82e1-d79eb8ec566a"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "71c56b9c00c8b8cb2d8969b6d3d017f69db0adc24fdb3be39cc1ee73f3b91964:eth0",
        "container-id": "71c56b9c00c8b8cb2d8969b6d3d017f69db0adc24fdb3be39cc1ee73f3b91964",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "longhorn-csi-plugin-tbhk4",
        "pod-name": "longhorn-system/longhorn-csi-plugin-tbhk4"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 28201,
        "labels": [
          "k8s:app=longhorn-csi-plugin",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=5769d89c9f",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=longhorn-csi-plugin",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:32Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.8.178",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "5a:df:c4:09:64:e3",
        "interface-index": 18,
        "interface-name": "lxc36c50df835a8",
        "mac": "5e:eb:60:50:9d:0e"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 28201,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                  ]
                ],
                "rule": "{\"port\":9808,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 28201,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                  ]
                ],
                "rule": "{\"port\":9808,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1014

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1014

```
Timestamp              Status   State                   Message
2026-01-19T22:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 28201

```
ID      LABELS
28201   k8s:app=longhorn-csi-plugin
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system

```


#### BPF Policy Get 1098

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES       PACKETS   PREFIX   COOKIE
Allow    Ingress     0          9503/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     0          9502/TCP     NONE         disabled    418794      696       24       0
Allow    Ingress     1          9501/TCP     NONE         disabled    97450       453       24       0
Allow    Ingress     1          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2          ANY          NONE         disabled    6450888     30036     0        0
Allow    Ingress     6          9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     7          9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     9          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -           -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1252       9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     1252       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3446       9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     3446       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4394       9501/TCP     NONE         disabled    131274      1989      24       0
Allow    Ingress     4394       ANY          NONE         disabled    1590        13        0        0
Allow    Ingress     4988       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6043       9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     6043       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8453       9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     8779       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15473      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     15505      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17163      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     17163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19572      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     19572      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23106      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     23106      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27422      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     27422      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    390544      4774      0        0
Allow    Ingress     28201      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     28530      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29163      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     29163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29395      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     29994      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29994      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     31674      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34995      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     35682      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39166      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     39166      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43339      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     43339      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43550      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     43616      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    606694      8822      0        0
Allow    Ingress     47918      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     48334      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49075      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     49276      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53439      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     54396      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16777217   9501/TCP     NONE         disabled    -           -         24       0
Allow    Egress      0          ANY          NONE         disabled    153143195   1065432   0        0

```


#### BPF CT List 1098

```
Invalid argument: unknown type 1098
```


#### Endpoint Get 1098

```
[
  {
    "id": 1098,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1098-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "bf14d07e-43c3-4de5-9e5e-62ce3ef72754"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/longhorn-manager-4vb5q",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:39.462Z",
            "success-count": 2
          },
          "uuid": "e70a57a5-03e6-4523-b4ba-c1b33920e64d"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1098)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "b45a77b4-cfdd-4da7-9e69-39b06d33fb04"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1098",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:39.373Z",
            "success-count": 32
          },
          "uuid": "fdec8201-1ae4-44d9-8aff-f04543319ed7"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1098)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.325Z",
            "success-count": 2814
          },
          "uuid": "c906a97d-3a45-4598-8e35-efe47418015d"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1098)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "9f6761dd-f6e8-4e7c-a526-9732fc49747d"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "60b5788dfc0964d6e9ebf68fa36fb4243d0ccad9fbfead6d8ec55443f9977b5f:eth0",
        "container-id": "60b5788dfc0964d6e9ebf68fa36fb4243d0ccad9fbfead6d8ec55443f9977b5f",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "longhorn-manager-4vb5q",
        "pod-name": "longhorn-system/longhorn-manager-4vb5q"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4394,
        "labels": [
          "k8s:app=longhorn-manager",
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/admission-webhook=longhorn-admission-webhook",
          "k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook",
          "k8s:longhorn.io/recovery-backend=longhorn-recovery-backend"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=55566b9bd7",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:app=longhorn-manager",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/admission-webhook=longhorn-admission-webhook",
          "k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook",
          "k8s:longhorn.io/recovery-backend=longhorn-recovery-backend"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:32Z"
        }
      ],
      "namedPorts": [
        {
          "name": "admission-wh",
          "port": 9502,
          "protocol": "TCP"
        },
        {
          "name": "conversion-wh",
          "port": 9501,
          "protocol": "TCP"
        },
        {
          "name": "manager",
          "port": 9500,
          "protocol": "TCP"
        },
        {
          "name": "recov-backend",
          "port": 9503,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.8.150",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "72:d4:f2:f5:55:95",
        "interface-index": 16,
        "interface-name": "lxce78e32f53ee4",
        "mac": "b6:8d:55:2f:04:52"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4394,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                  ]
                ],
                "rule": "{\"port\":9501,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                  ]
                ],
                "rule": "{\"port\":9502,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                  ]
                ],
                "rule": "{\"port\":9503,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4394,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                  ]
                ],
                "rule": "{\"port\":9501,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                  ]
                ],
                "rule": "{\"port\":9502,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                  ]
                ],
                "rule": "{\"port\":9503,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1098

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1098

```
Timestamp              Status   State                   Message
2026-01-19T22:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4394

```
ID     LABELS
4394   k8s:app.kubernetes.io/instance=longhorn
       k8s:app.kubernetes.io/managed-by=Helm
       k8s:app.kubernetes.io/name=longhorn
       k8s:app.kubernetes.io/version=v1.9.0
       k8s:app=longhorn-manager
       k8s:helm.sh/chart=longhorn-1.9.0
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
       k8s:io.kubernetes.pod.namespace=longhorn-system
       k8s:longhorn.io/admission-webhook=longhorn-admission-webhook
       k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook
       k8s:longhorn.io/recovery-backend=longhorn-recovery-backend

```


#### BPF Policy Get 1261

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES    PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    275299   3233      0        0
Allow    Ingress     2          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -        -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -        -         0        0
Allow    Egress      0          ANY          NONE         disabled    -        -         0        0

```


#### BPF CT List 1261

```
Invalid argument: unknown type 1261
```


#### Endpoint Get 1261

```
[
  {
    "id": 1261,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1261-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "ce74f845-652b-47b0-83cc-68dab612d6ed"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "5m0s"
          },
          "name": "resolve-identity-1261",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:33.515Z",
            "success-count": 94
          },
          "uuid": "b7165e43-c652-4042-8f59-fa23e750e23e"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1261",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:39.546Z",
            "success-count": 32
          },
          "uuid": "14f6067c-e221-4b8a-9f83-33ad739b63c6"
        }
      ],
      "external-identifiers": {
        "container-name": "cilium-health",
        "pod-name": "/"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4,
        "labels": [
          "reserved:health"
        ]
      },
      "labels": {
        "realized": {},
        "security-relevant": [
          "reserved:health"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:32Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.8.230",
            "ipv4-pool-name": "default"
          }
        ],
        "host-mac": "da:82:72:c2:11:e2",
        "interface-index": 2622,
        "interface-name": "lxc_health",
        "mac": "e6:a9:12:ba:87:95"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1261

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1261

```
Timestamp              Status   State                   Message
2026-01-19T22:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4

```
ID   LABELS
4    reserved:health

```


#### BPF Policy Get 1437

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    1255228   13362     0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    3168973   19580     0        0

```


#### BPF CT List 1437

```
Invalid argument: unknown type 1437
```


#### Endpoint Get 1437

```
[
  {
    "id": 1437,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1437-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "71e03031-fb7d-474e-b10f-9ca8d78e0b72"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-cert-manager/cert-manager-75c86cbf4-phzdr",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:39.416Z",
            "success-count": 2
          },
          "uuid": "399c56a1-736b-4f49-8876-90caf7319842"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1437)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "246911a5-db3d-4a0f-840c-dfbb63759ed5"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1437",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:39.478Z",
            "success-count": 32
          },
          "uuid": "1835d08f-38c6-4fcf-9a88-3773cab41720"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1437)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:24.635Z",
            "success-count": 2814
          },
          "uuid": "04c2e0b3-5e85-4e11-95c2-c569479eed56"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1437)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "9e8c857c-8332-40fa-a33f-dff3495479b5"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "41d6cc46b35e93867f8137b03b0b68b379f48dcfe11b8002227eeda574923526:eth0",
        "container-id": "41d6cc46b35e93867f8137b03b0b68b379f48dcfe11b8002227eeda574923526",
        "k8s-namespace": "cert-manager",
        "k8s-pod-name": "cert-manager-75c86cbf4-phzdr",
        "pod-name": "cert-manager/cert-manager-75c86cbf4-phzdr"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 43616,
        "labels": [
          "k8s:app=cert-manager",
          "k8s:app.kubernetes.io/component=controller",
          "k8s:app.kubernetes.io/instance=cert-manager",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=cert-manager",
          "k8s:app.kubernetes.io/version=v1.13.3",
          "k8s:helm.sh/chart=cert-manager-v1.13.3",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cert-manager",
          "k8s:io.cilium.k8s.namespace.labels.name=cert-manager",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=cert-manager",
          "k8s:io.kubernetes.pod.namespace=cert-manager"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=75c86cbf4"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/component=controller",
          "k8s:app.kubernetes.io/instance=cert-manager",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=cert-manager",
          "k8s:app.kubernetes.io/version=v1.13.3",
          "k8s:app=cert-manager",
          "k8s:helm.sh/chart=cert-manager-v1.13.3",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cert-manager",
          "k8s:io.cilium.k8s.namespace.labels.name=cert-manager",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=cert-manager",
          "k8s:io.kubernetes.pod.namespace=cert-manager"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:32Z"
        }
      ],
      "namedPorts": [
        {
          "name": "http-healthz",
          "port": 9403,
          "protocol": "TCP"
        },
        {
          "name": "http-metrics",
          "port": 9402,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.8.198",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "3a:0d:60:35:0c:7b",
        "interface-index": 2512,
        "interface-name": "lxc3f18b45ca647",
        "mac": "d2:56:62:b7:34:ad"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43616,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43616,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1437

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1437

```
Timestamp              Status   State                   Message
2026-01-19T22:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 43616

```
ID      LABELS
43616   k8s:app.kubernetes.io/component=controller
        k8s:app.kubernetes.io/instance=cert-manager
        k8s:app.kubernetes.io/managed-by=Helm
        k8s:app.kubernetes.io/name=cert-manager
        k8s:app.kubernetes.io/version=v1.13.3
        k8s:app=cert-manager
        k8s:helm.sh/chart=cert-manager-v1.13.3
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cert-manager
        k8s:io.cilium.k8s.namespace.labels.name=cert-manager
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=cert-manager
        k8s:io.kubernetes.pod.namespace=cert-manager

```


#### BPF Policy Get 1517

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    64024     721       0        0
Allow    Ingress     2          9092/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     2          ANY          NONE         disabled    4513872   50860     0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      8080/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     10807      9092/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      9092/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     11332      8080/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      9092/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     25152      8080/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      8080/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     33688      9092/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      8080/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     60492      9092/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   9092/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     16777217   8080/TCP     NONE         disabled    -         -         24       0
Allow    Egress      0          ANY          NONE         disabled    1103479   7212      0        0
Allow    Egress      2          ANY          NONE         disabled    -         -         0        0
Allow    Egress      16777217   ANY          NONE         disabled    -         -         0        0

```


#### BPF CT List 1517

```
Invalid argument: unknown type 1517
```


#### Endpoint Get 1517

```
[
  {
    "id": 1517,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1517-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "0e9f6e9e-c8c6-4fad-9887-f00e856d405b"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-kafka/kafka-cluster-entity-operator-55bf655b8d-csx8j",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:39.500Z",
            "success-count": 2
          },
          "uuid": "96cfa5f8-cba7-4c03-9484-b29fc187309d"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1517)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "d61a123e-8f81-4383-8e3d-aa96fe05227a"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1517",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:39.407Z",
            "success-count": 32
          },
          "uuid": "3dda55ba-a2d2-4dcd-aebd-6309498f7d08"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1517)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:25.804Z",
            "success-count": 2814
          },
          "uuid": "91e7a8a7-8596-47ab-b18f-318c551231f0"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1517)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "9a00f016-bab5-4906-892c-ce2a9d9456a2"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "7416de5f4708febe858b85b3e9610a92f201cb4fd9cbeb234cbb57c244339b96:eth0",
        "container-id": "7416de5f4708febe858b85b3e9610a92f201cb4fd9cbeb234cbb57c244339b96",
        "k8s-namespace": "kafka",
        "k8s-pod-name": "kafka-cluster-entity-operator-55bf655b8d-csx8j",
        "pod-name": "kafka/kafka-cluster-entity-operator-55bf655b8d-csx8j"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 10807,
        "labels": [
          "k8s:app.kubernetes.io/instance=kafka-cluster",
          "k8s:app.kubernetes.io/managed-by=strimzi-cluster-operator",
          "k8s:app.kubernetes.io/name=entity-operator",
          "k8s:app.kubernetes.io/part-of=strimzi-kafka-cluster",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kafka-cluster-entity-operator",
          "k8s:io.kubernetes.pod.namespace=kafka",
          "k8s:strimzi.io/cluster=kafka-cluster",
          "k8s:strimzi.io/component-type=entity-operator",
          "k8s:strimzi.io/kind=Kafka",
          "k8s:strimzi.io/name=kafka-cluster-entity-operator"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=55bf655b8d"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=kafka-cluster",
          "k8s:app.kubernetes.io/managed-by=strimzi-cluster-operator",
          "k8s:app.kubernetes.io/name=entity-operator",
          "k8s:app.kubernetes.io/part-of=strimzi-kafka-cluster",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kafka-cluster-entity-operator",
          "k8s:io.kubernetes.pod.namespace=kafka",
          "k8s:strimzi.io/cluster=kafka-cluster",
          "k8s:strimzi.io/component-type=entity-operator",
          "k8s:strimzi.io/kind=Kafka",
          "k8s:strimzi.io/name=kafka-cluster-entity-operator"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:32Z"
        }
      ],
      "namedPorts": [
        {
          "name": "healthcheck",
          "port": 8081,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.8.81",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "06:b7:8d:63:63:78",
        "interface-index": 2464,
        "interface-name": "lxcdef1acdc8913",
        "mac": "6a:14:c2:35:32:35"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0,
            2,
            16777217
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 10807,
          "l4": {
            "egress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-internet",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:0.0.0.0/0\":null}]}"
              }
            ],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-internet",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                  ]
                ],
                "rule": "{\"port\":9092,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:0.0.0.0/0\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-internet",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                    ]
                  ],
                  "cidr:0.0.0.0/0": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-internet",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                  ]
                ],
                "rule": "{\"port\":8080,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-both",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0,
            2,
            16777217
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 10807,
          "l4": {
            "egress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-internet",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:0.0.0.0/0\":null}]}"
              }
            ],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-internet",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                  ]
                ],
                "rule": "{\"port\":9092,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:0.0.0.0/0\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-internet",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                    ]
                  ],
                  "cidr:0.0.0.0/0": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-internet",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                  ]
                ],
                "rule": "{\"port\":8080,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-both",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1517

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1517

```
Timestamp              Status   State                   Message
2026-01-19T22:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:32Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:32Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:32Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 10807

```
ID      LABELS
10807   k8s:app.kubernetes.io/instance=kafka-cluster
        k8s:app.kubernetes.io/managed-by=strimzi-cluster-operator
        k8s:app.kubernetes.io/name=entity-operator
        k8s:app.kubernetes.io/part-of=strimzi-kafka-cluster
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=kafka-cluster-entity-operator
        k8s:io.kubernetes.pod.namespace=kafka
        k8s:strimzi.io/cluster=kafka-cluster
        k8s:strimzi.io/component-type=entity-operator
        k8s:strimzi.io/kind=Kafka
        k8s:strimzi.io/name=kafka-cluster-entity-operator

```


#### BPF Policy Get 1561

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES       PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -           -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    3975        15        0        0
Allow    Ingress     35696      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -           -         0        0
Allow    Egress      0          ANY          NONE         disabled    179197787   1048864   0        0

```


#### BPF CT List 1561

```
Invalid argument: unknown type 1561
```


#### Endpoint Get 1561

```
[
  {
    "id": 1561,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1561-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "db4020d4-94e6-427b-ac50-a64d8dbeb7ed"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-monitoring/victorialogs-vector-gccvj",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:39.513Z",
            "success-count": 2
          },
          "uuid": "92aff5a2-b0da-457b-8795-17c1afbf3b4b"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1561)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "bfe960a3-b4f3-49ca-916b-5e32b0159c3b"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1561",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:05:39.415Z",
            "success-count": 32
          },
          "uuid": "0843f4a1-bc39-4371-b766-66ffc3278064"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1561)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:24.963Z",
            "success-count": 2814
          },
          "uuid": "010f56c5-d569-40fc-8b82-5963b049f047"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1561)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:20:32.437Z",
            "success-count": 1
          },
          "uuid": "f2b2a477-aed9-4636-83cf-e134971276fb"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "4b40c85713486bdfd0e1cb52880a9dcec3381fa4bdb27986f4ea68eaf2bf8c84:eth0",
        "container-id": "4b40c85713486bdfd0e1cb52880a9dcec3381fa4bdb27986f4ea68eaf2bf8c84",
        "k8s-namespace": "monitoring",
        "k8s-pod-name": "victorialogs-vector-gccvj",
        "pod-name": "monitoring/victorialogs-vector-gccvj"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 34352,
        "labels": [
          "k8s:app.kubernetes.io/component=Agent",
          "k8s:app.kubernetes.io/instance=victorialogs",
          "k8s:app.kubernetes.io/name=vector",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.n