#include "lib/utils.h"

/*
 cilium.v4.external.str 192.168.100.12
 cilium.v4.internal.str 10.0.0.37
 cilium.v4.nodeport.str [65.109.99.45 100.64.0.157 192.168.100.12]

 cilium.v4.internal.raw 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xa, 0x0, 0x0, 0x25
 */

#define CT_MAP_SIZE_TCP 1184130
#define CT_MAP_SIZE_ANY 592065
DECLARE_CONFIG(__u32, identity_length, "Identity length in bits");
ASSIGN_CONFIG(__u32, identity_length, 16);
DECLARE_CONFIG(__u32, interface_ifindex, "ifindex of the interface the bpf program is attached to");
#define AUTH_MAP_SIZE 524288
#define CIDR_IDENTITY_RANGE_END 33554431
#define CIDR_IDENTITY_RANGE_START 16777217
#define CILIUM_HOST_IFINDEX 6
#define CILIUM_HOST_MAC {.addr={0x62,0x8c,0xc0,0x87,0xfc,0x9b}}
#define CILIUM_IPV4_FRAG_MAP_MAX_ENTRIES 8192
#define CILIUM_IPV6_FRAG_MAP_MAX_ENTRIES 8192
#define CILIUM_LB_ACT_MAP_MAX_ENTRIES 1
#define CILIUM_LB_AFFINITY_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_BACKENDS_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_MAGLEV_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_REV_NAT_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_SERVICE_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_SKIP_MAP_MAX_ENTRIES 100
#define CILIUM_LB_SOURCE_RANGE_MAP_MAX_ENTRIES 65536
#define CILIUM_NET_IFINDEX 5
#define CILIUM_NET_MAC {.addr={0x52,0x16,0x21,0x1b,0x48,0x17}}
#define CONFIG_MAP_SIZE 256
#define CT_CLOSE_TIMEOUT 10
#define CT_CONNECTION_LIFETIME_NONTCP 60
#define CT_CONNECTION_LIFETIME_TCP 8000
#define CT_REPORT_FLAGS 0x00ff
#define CT_REPORT_INTERVAL 5
#define CT_SERVICE_CLOSE_REBALANCE 60
#define CT_SERVICE_LIFETIME_NONTCP 60
#define CT_SERVICE_LIFETIME_TCP 8000
#define CT_SYN_TIMEOUT 60
#define DSR_ENCAP_GENEVE 3
#define DSR_ENCAP_IPIP 2
#define DSR_ENCAP_MODE 0
#define DSR_ENCAP_NONE 1
#define EGRESS_POLICY_MAP_SIZE 16384
#define ENABLE_EGRESS_GATEWAY 1
#define ENABLE_HOST_ROUTING 1
#define ENABLE_IDENTITY_MARK 1
#define ENABLE_IPV4 1
#define ENABLE_IPV4_FRAGMENTS 1
#define ENABLE_MASQUERADE_IPV4 1
#define ENABLE_NODEPORT 1
#define ENABLE_SOCKET_LB_FULL 1
#define ENABLE_SOCKET_LB_PEER 1
#define ENABLE_WIREGUARD 1
#define ENCAP4_IFINDEX 0
#define ENCAP6_IFINDEX 0
#define ENCAP_IFINDEX 8
#define ENDPOINTS_MAP_SIZE 65535
#define EVENTS_MAP_BURST_LIMIT 0
#define EVENTS_MAP_RATE_LIMIT 0
#define HASH_INIT4_SEED 1910299206
#define HASH_INIT6_SEED 2454738568
#define HEALTH_ID 4
#define HOST_ID 1
#define HOST_NETNS_COOKIE 1
#define INIT_ID 5
#define IPCACHE_MAP_SIZE 512000
#define IPV4_DIRECT_ROUTING 207923392
#define IPV4_GATEWAY 0x2500000a
#define IPV4_RSS_PREFIX IPV4_DIRECT_ROUTING
#define IPV4_RSS_PREFIX_BITS 32
#define IPV4_SNAT_EXCLUSION_DST_CIDR 0xa
#define IPV4_SNAT_EXCLUSION_DST_CIDR_LEN 24
#define IS_L3_DEV(ifindex) ({ \
bool is_l3 = false; \
switch (ifindex) { \
 case 4: is_l3 = true; break; \
} \
is_l3; })
#define KUBE_APISERVER_NODE_ID 7
#define L2_RESPONDER_MAP4_SIZE 4096
#define L2_RESPONDER_MAP6_SIZE 4096
#define LB4_REVERSE_NAT_SK_MAP_SIZE 592065
#define LB4_SRC_RANGE_MAP_SIZE 65536
#define LB6_REVERSE_NAT_SK_MAP_SIZE 592065
#define LB6_SRC_RANGE_MAP_SIZE 65536
#define LB_MAGLEV_LUT_SIZE 16381
#define LB_SELECTION 1
#define LB_SELECTION_MAGLEV 2
#define LB_SELECTION_RANDOM 1
#define LOCAL_NODE_ID 6
#define METRICS_MAP_SIZE 1024
#define MTU 1280
#define NATIVE_DEV_MAC_BY_IFINDEX(IFINDEX) ({ \
union macaddr __mac = {.addr = {0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}; \
switch (IFINDEX) { \
 case 2: {union macaddr __tmp = {.addr = {0xa8,0xa1,0x59,0xeb,0xe4,0x67}}; __mac=__tmp;} break; \
 case 3: {union macaddr __tmp = {.addr = {0xa8,0xa1,0x59,0xeb,0xe4,0x67}}; __mac=__tmp;} break; \
 case 4: {union macaddr __tmp = {.addr = {0x0,0x0,0x0,0x0,0x0,0x0}}; __mac=__tmp;} break; \
} \
__mac; })
#define NAT_46X64_PREFIX_0 0
#define NAT_46X64_PREFIX_1 0
#define NAT_46X64_PREFIX_2 0
#define NAT_46X64_PREFIX_3 0
#define NODEPORT_NEIGH4_SIZE 1184130
#define NODEPORT_NEIGH6_SIZE 1184130
#define NODEPORT_PORT_MAX 32767
#define NODEPORT_PORT_MAX_NAT 65535
#define NODEPORT_PORT_MIN 30000
#define NODEPORT_PORT_MIN_NAT 32768
#define NODE_MAP_SIZE 16384
#define POLICY_MAP_SIZE 16384
#define POLICY_PROG_MAP_SIZE 65535
#define POLICY_STATS_MAP_SIZE 65532
#define REMOTE_NODE_ID 6
#define SERVICE_NO_BACKEND_RESPONSE 1
#define SNAT_COLLISION_RETRIES 32
#define SNAT_MAPPING_IPV4_SIZE 1184130
#define SNAT_MAPPING_IPV6_SIZE 1184130
#define SRV6_POLICY_MAP_SIZE 16384
#define SRV6_SID_MAP_SIZE 16384
#define SRV6_VRF_MAP_SIZE 16384
#define THROTTLE_MAP_SIZE 65535
#define TRACE_SOCK_NOTIFY 1
#define TUNNEL_MODE 1
#define TUNNEL_PORT 8472
#define TUNNEL_PROTOCOL 1
#define TUNNEL_PROTOCOL_GENEVE 2
#define TUNNEL_PROTOCOL_VXLAN 1
#define TUNNEL_SRC_PORT_HIGH 0
#define TUNNEL_SRC_PORT_LOW 0
#define UNKNOWN_ID 0
#define UNMANAGED_ID 3
#define VLAN_FILTER(ifindex, vlan_id) switch (ifindex) { \
case 2: \
switch (vlan_id) { \
case 4000: \
return true; \
} \
break; \
} \
return false;
#define VTEP_MAP_SIZE 8
#define WORLD_ID 2
#define WORLD_IPV4_ID 2
#define WORLD_IPV6_ID 2

// JSON_OUTPUT: eyJBVVRIX01BUF9TSVpFIjoiNTI0Mjg4IiwiQ0lEUl9JREVOVElUWV9SQU5HRV9FTkQiOiIzMzU1NDQzMSIsIkNJRFJfSURFTlRJVFlfUkFOR0VfU1RBUlQiOiIxNjc3NzIxNyIsIkNJTElVTV9IT1NUX0lGSU5ERVgiOiI2IiwiQ0lMSVVNX0hPU1RfTUFDIjoiey5hZGRyPXsweDYyLDB4OGMsMHhjMCwweDg3LDB4ZmMsMHg5Yn19IiwiQ0lMSVVNX0lQVjRfRlJBR19NQVBfTUFYX0VOVFJJRVMiOiI4MTkyIiwiQ0lMSVVNX0lQVjZfRlJBR19NQVBfTUFYX0VOVFJJRVMiOiI4MTkyIiwiQ0lMSVVNX0xCX0FDVF9NQVBfTUFYX0VOVFJJRVMiOiIxIiwiQ0lMSVVNX0xCX0FGRklOSVRZX01BUF9NQVhfRU5UUklFUyI6IjY1NTM2IiwiQ0lMSVVNX0xCX0JBQ0tFTkRTX01BUF9NQVhfRU5UUklFUyI6IjY1NTM2IiwiQ0lMSVVNX0xCX01BR0xFVl9NQVBfTUFYX0VOVFJJRVMiOiI2NTUzNiIsIkNJTElVTV9MQl9SRVZfTkFUX01BUF9NQVhfRU5UUklFUyI6IjY1NTM2IiwiQ0lMSVVNX0xCX1NFUlZJQ0VfTUFQX01BWF9FTlRSSUVTIjoiNjU1MzYiLCJDSUxJVU1fTEJfU0tJUF9NQVBfTUFYX0VOVFJJRVMiOiIxMDAiLCJDSUxJVU1fTEJfU09VUkNFX1JBTkdFX01BUF9NQVhfRU5UUklFUyI6IjY1NTM2IiwiQ0lMSVVNX05FVF9JRklOREVYIjoiNSIsIkNJTElVTV9ORVRfTUFDIjoiey5hZGRyPXsweDUyLDB4MTYsMHgyMSwweDFiLDB4NDgsMHgxN319IiwiQ09ORklHX01BUF9TSVpFIjoiMjU2IiwiQ1RfQ0xPU0VfVElNRU9VVCI6IjEwIiwiQ1RfQ09OTkVDVElPTl9MSUZFVElNRV9OT05UQ1AiOiI2MCIsIkNUX0NPTk5FQ1RJT05fTElGRVRJTUVfVENQIjoiODAwMCIsIkNUX1JFUE9SVF9GTEFHUyI6IjB4MDBmZiIsIkNUX1JFUE9SVF9JTlRFUlZBTCI6IjUiLCJDVF9TRVJWSUNFX0NMT1NFX1JFQkFMQU5DRSI6IjYwIiwiQ1RfU0VSVklDRV9MSUZFVElNRV9OT05UQ1AiOiI2MCIsIkNUX1NFUlZJQ0VfTElGRVRJTUVfVENQIjoiODAwMCIsIkNUX1NZTl9USU1FT1VUIjoiNjAiLCJEU1JfRU5DQVBfR0VORVZFIjoiMyIsIkRTUl9FTkNBUF9JUElQIjoiMiIsIkRTUl9FTkNBUF9NT0RFIjoiMCIsIkRTUl9FTkNBUF9OT05FIjoiMSIsIkVHUkVTU19QT0xJQ1lfTUFQX1NJWkUiOiIxNjM4NCIsIkVOQUJMRV9FR1JFU1NfR0FURVdBWSI6IjEiLCJFTkFCTEVfSE9TVF9ST1VUSU5HIjoiMSIsIkVOQUJMRV9JREVOVElUWV9NQVJLIjoiMSIsIkVOQUJMRV9JUFY0IjoiMSIsIkVOQUJMRV9JUFY0X0ZSQUdNRU5UUyI6IjEiLCJFTkFCTEVfTUFTUVVFUkFERV9JUFY0IjoiMSIsIkVOQUJMRV9OT0RFUE9SVCI6IjEiLCJFTkFCTEVfU09DS0VUX0xCX0ZVTEwiOiIxIiwiRU5BQkxFX1NPQ0tFVF9MQl9QRUVSIjoiMSIsIkVOQUJMRV9XSVJFR1VBUkQiOiIxIiwiRU5DQVA0X0lGSU5ERVgiOiIwIiwiRU5DQVA2X0lGSU5ERVgiOiIwIiwiRU5DQVBfSUZJTkRFWCI6IjgiLCJFTkRQT0lOVFNfTUFQX1NJWkUiOiI2NTUzNSIsIkVWRU5UU19NQVBfQlVSU1RfTElNSVQiOiIwIiwiRVZFTlRTX01BUF9SQVRFX0xJTUlUIjoiMCIsIkhBU0hfSU5JVDRfU0VFRCI6IjE5MTAyOTkyMDYiLCJIQVNIX0lOSVQ2X1NFRUQiOiIyNDU0NzM4NTY4IiwiSEVBTFRIX0lEIjoiNCIsIkhPU1RfSUQiOiIxIiwiSE9TVF9ORVROU19DT09LSUUiOiIxIiwiSU5JVF9JRCI6IjUiLCJJUENBQ0hFX01BUF9TSVpFIjoiNTEyMDAwIiwiSVBWNF9ESVJFQ1RfUk9VVElORyI6IjIwNzkyMzM5MiIsIklQVjRfR0FURVdBWSI6IjB4MjUwMDAwMGEiLCJJUFY0X1JTU19QUkVGSVgiOiJJUFY0X0RJUkVDVF9ST1VUSU5HIiwiSVBWNF9SU1NfUFJFRklYX0JJVFMiOiIzMiIsIklQVjRfU05BVF9FWENMVVNJT05fRFNUX0NJRFIiOiIweGEiLCJJUFY0X1NOQVRfRVhDTFVTSU9OX0RTVF9DSURSX0xFTiI6IjI0IiwiSVNfTDNfREVWKGlmaW5kZXgpIjoiKHsgXFxcbmJvb2wgaXNfbDMgPSBmYWxzZTsgXFxcbnN3aXRjaCAoaWZpbmRleCkgeyBcXFxuIGNhc2UgNDogaXNfbDMgPSB0cnVlOyBicmVhazsgXFxcbn0gXFxcbmlzX2wzOyB9KSIsIktVQkVfQVBJU0VSVkVSX05PREVfSUQiOiI3IiwiTDJfUkVTUE9OREVSX01BUDRfU0laRSI6IjQwOTYiLCJMMl9SRVNQT05ERVJfTUFQNl9TSVpFIjoiNDA5NiIsIkxCNF9SRVZFUlNFX05BVF9TS19NQVBfU0laRSI6IjU5MjA2NSIsIkxCNF9TUkNfUkFOR0VfTUFQX1NJWkUiOiI2NTUzNiIsIkxCNl9SRVZFUlNFX05BVF9TS19NQVBfU0laRSI6IjU5MjA2NSIsIkxCNl9TUkNfUkFOR0VfTUFQX1NJWkUiOiI2NTUzNiIsIkxCX01BR0xFVl9MVVRfU0laRSI6IjE2MzgxIiwiTEJfU0VMRUNUSU9OIjoiMSIsIkxCX1NFTEVDVElPTl9NQUdMRVYiOiIyIiwiTEJfU0VMRUNUSU9OX1JBTkRPTSI6IjEiLCJMT0NBTF9OT0RFX0lEIjoiNiIsIk1FVFJJQ1NfTUFQX1NJWkUiOiIxMDI0IiwiTVRVIjoiMTI4MCIsIk5BVElWRV9ERVZfTUFDX0JZX0lGSU5ERVgoSUZJTkRFWCkiOiIoeyBcXFxudW5pb24gbWFjYWRkciBfX21hYyA9IHsuYWRkciA9IHsweDAsIDB4MCwgMHgwLCAweDAsIDB4MCwgMHgwfX07IFxcXG5zd2l0Y2ggKElGSU5ERVgpIHsgXFxcbiBjYXNlIDI6IHt1bmlvbiBtYWNhZGRyIF9fdG1wID0gey5hZGRyID0gezB4YTgsMHhhMSwweDU5LDB4ZWIsMHhlNCwweDY3fX07IF9fbWFjPV9fdG1wO30gYnJlYWs7IFxcXG4gY2FzZSAzOiB7dW5pb24gbWFjYWRkciBfX3RtcCA9IHsuYWRkciA9IHsweGE4LDB4YTEsMHg1OSwweGViLDB4ZTQsMHg2N319OyBfX21hYz1fX3RtcDt9IGJyZWFrOyBcXFxuIGNhc2UgNDoge3VuaW9uIG1hY2FkZHIgX190bXAgPSB7LmFkZHIgPSB7MHgwLDB4MCwweDAsMHgwLDB4MCwweDB9fTsgX19tYWM9X190bXA7fSBicmVhazsgXFxcbn0gXFxcbl9fbWFjOyB9KSIsIk5BVF80Nlg2NF9QUkVGSVhfMCI6IjAiLCJOQVRfNDZYNjRfUFJFRklYXzEiOiIwIiwiTkFUXzQ2WDY0X1BSRUZJWF8yIjoiMCIsIk5BVF80Nlg2NF9QUkVGSVhfMyI6IjAiLCJOT0RFUE9SVF9ORUlHSDRfU0laRSI6IjExODQxMzAiLCJOT0RFUE9SVF9ORUlHSDZfU0laRSI6IjExODQxMzAiLCJOT0RFUE9SVF9QT1JUX01BWCI6IjMyNzY3IiwiTk9ERVBPUlRfUE9SVF9NQVhfTkFUIjoiNjU1MzUiLCJOT0RFUE9SVF9QT1JUX01JTiI6IjMwMDAwIiwiTk9ERVBPUlRfUE9SVF9NSU5fTkFUIjoiMzI3NjgiLCJOT0RFX01BUF9TSVpFIjoiMTYzODQiLCJQT0xJQ1lfTUFQX1NJWkUiOiIxNjM4NCIsIlBPTElDWV9QUk9HX01BUF9TSVpFIjoiNjU1MzUiLCJQT0xJQ1lfU1RBVFNfTUFQX1NJWkUiOiI2NTUzMiIsIlJFTU9URV9OT0RFX0lEIjoiNiIsIlNFUlZJQ0VfTk9fQkFDS0VORF9SRVNQT05TRSI6IjEiLCJTTkFUX0NPTExJU0lPTl9SRVRSSUVTIjoiMzIiLCJTTkFUX01BUFBJTkdfSVBWNF9TSVpFIjoiMTE4NDEzMCIsIlNOQVRfTUFQUElOR19JUFY2X1NJWkUiOiIxMTg0MTMwIiwiU1JWNl9QT0xJQ1lfTUFQX1NJWkUiOiIxNjM4NCIsIlNSVjZfU0lEX01BUF9TSVpFIjoiMTYzODQiLCJTUlY2X1ZSRl9NQVBfU0laRSI6IjE2Mzg0IiwiVEhST1RUTEVfTUFQX1NJWkUiOiI2NTUzNSIsIlRSQUNFX1NPQ0tfTk9USUZZIjoiMSIsIlRVTk5FTF9NT0RFIjoiMSIsIlRVTk5FTF9QT1JUIjoiODQ3MiIsIlRVTk5FTF9QUk9UT0NPTCI6IjEiLCJUVU5ORUxfUFJPVE9DT0xfR0VORVZFIjoiMiIsIlRVTk5FTF9QUk9UT0NPTF9WWExBTiI6IjEiLCJUVU5ORUxfU1JDX1BPUlRfSElHSCI6IjAiLCJUVU5ORUxfU1JDX1BPUlRfTE9XIjoiMCIsIlVOS05PV05fSUQiOiIwIiwiVU5NQU5BR0VEX0lEIjoiMyIsIlZMQU5fRklMVEVSKGlmaW5kZXgsIHZsYW5faWQpIjoic3dpdGNoIChpZmluZGV4KSB7IFxcXG5jYXNlIDI6IFxcXG5zd2l0Y2ggKHZsYW5faWQpIHsgXFxcbmNhc2UgNDAwMDogXFxcbnJldHVybiB0cnVlOyBcXFxufSBcXFxuYnJlYWs7IFxcXG59IFxcXG5yZXR1cm4gZmFsc2U7IiwiVlRFUF9NQVBfU0laRSI6IjgiLCJXT1JMRF9JRCI6IjIiLCJXT1JMRF9JUFY0X0lEIjoiMiIsIldPUkxEX0lQVjZfSUQiOiIyIn0=
