# Cilium debug information

#### Cilium encryption


##### WireGuard

```
interface: cilium_wg0
  public key: sOen1KxasKuG8RrUT7Zh9uLpLgWOsERp8XEG1jYaHWo=
  listening port: 51871

peer: Lno1XLmWU4wrd8lSXK/n2nNhoyoSJqGGicQNqCdy8Dc=
  endpoint: 192.168.100.21:51871
  allowed ips: 192.168.100.21/32
  latest handshake: 2026-01-19T22:08:33.572Z
  transfer: 2034888 B received, 6772328 B sent

peer: BSw5bTigw43neZycBX8XP+2TTJ/COr9KdR1BXbha0gs=
  endpoint: 192.168.100.22:51871
  allowed ips: 192.168.100.22/32
  latest handshake: 2026-01-19T22:08:05.412Z
  transfer: 1345428 B received, 1184236 B sent

peer: AKKOPPTW1gAcQFQPWwxeWGA5vvdFZsDTQqBUjTMJbDw=
  endpoint: 192.168.100.27:51871
  allowed ips: 192.168.100.27/32
  latest handshake: 2026-01-19T22:09:20.676Z
  transfer: 1316820 B received, 893996 B sent

peer: JPB7xEw64V/evoUIxU5a0VYh1abk57JVNGmBZqNNDSg=
  endpoint: 192.168.100.25:51871
  allowed ips: 192.168.100.25/32
  latest handshake: 2026-01-19T22:07:31.108Z
  transfer: 704919088 B received, 135330992 B sent

peer: l+i8onyueIOAdNh7mFBwDB2joUhSKNDdKtKiPtHMcUw=
  endpoint: 192.168.100.26:51871
  allowed ips: 192.168.100.26/32
  latest handshake: 2026-01-19T22:08:44.576Z
  transfer: 54534358336 B received, 2052745760 B sent

peer: ZibhTJXvvcX3rRQNp0heMp5faRQIp1OaNLl0FVJyujw=
  endpoint: 192.168.100.28:51871
  allowed ips: 192.168.100.28/32
  latest handshake: 2026-01-19T22:07:28.513Z
  transfer: 515739320 B received, 289116552 B sent

peer: iSGK51wuTocNHbZeOrZw8okBr6Lvdp8V628SZnMItmY=
  endpoint: 192.168.100.12:51871
  allowed ips: 192.168.100.12/32
  latest handshake: 2026-01-19T22:07:44.165Z
  transfer: 1054924500 B received, 8450754236 B sent

peer: hsIXVzzEK9DUP6e74Zy1i4ilh2sYWNR7/UWv3FUgSU8=
  endpoint: 192.168.100.23:51871
  allowed ips: 192.168.100.23/32
  latest handshake: 2026-01-19T22:09:26.935Z
  transfer: 632643808 B received, 159614528 B sent

peer: Wmr/Qdun2kLnoUc49DNCZnzR3suR2BPO19thOefdoyI=
  endpoint: 192.168.100.24:51871
  allowed ips: 192.168.100.24/32
  latest handshake: 2026-01-19T22:09:13.993Z
  transfer: 573145168 B received, 8359857120 B sent

peer: MBDqQ+cwr5VwHHKvYMkpcKZItLnJ6qb9HN7R4ZqMqnQ=
  endpoint: 192.168.100.10:51871
  allowed ips: 192.168.100.10/32
  latest handshake: 2026-01-19T22:08:13.093Z
  transfer: 28943096 B received, 4998792 B sent

peer: tgNBkpBaiPz2dqDHKyuq32GtsLCNV52iV3WG5G08AGQ=
  endpoint: 192.168.100.11:51871
  allowed ips: 192.168.100.11/32
  latest handshake: 2026-01-19T22:07:50.897Z
  transfer: 6921313648 B received, 5076694048 B sent

```

#### Policy get

```
:
 [
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/name": "kafka-cluster-entity-operator"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/name": "kafka-cluster-cruise-control"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/kind": "cluster-operator"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "8443",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka"
        }
      },
      "cidr:0.0.0.0/0"
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9092",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-internet",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "3435d905-c9c4-480e-b86e-a2c964f77c42",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      "cidr:0.0.0.0/0"
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-internet",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "3435d905-c9c4-480e-b86e-a2c964f77c42",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": false,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "instance-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "instance-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "2ff1f074-01bb-452c-85e6-a10cc548b287",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "any.app.kubernetes.io/name": "ingress-nginx",
        "k8s.io.kubernetes.pod.namespace": "ingress-internal"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "reserved.world": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv4": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv6": ""
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "80",
            "protocol": "TCP"
          },
          {
            "port": "443",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-world-to-ingress-nginx",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "ingress-internal",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "5e2f2bdd-f374-4698-ab40-0bd473bc18f6",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/cluster": "kafka-cluster",
          "k8s.strimzi.io/kind": "Kafka",
          "k8s.strimzi.io/name": "kafka-cluster-kafka"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/name": "kafka-cluster-kafka-exporter"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "any.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "reserved.remote-node": ""
        }
      },
      {
        "matchLabels": {
          "reserved.host": ""
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager-node-access",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "3692c6de-9cb3-4390-bb4b-3e56867f9f61",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-csi-plugin",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9808",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-csi-plugin",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "dcfe5679-1b87-415a-be9a-b0f75aff8771",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-data-source"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-data-source",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "6b710528-3078-446b-bf8d-e2dda11cfc84",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-data-source"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "backing-image-data-source"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-data-source",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "6b710528-3078-446b-bf8d-e2dda11cfc84",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {},
    "L3": [
      {
        "matchLabels": {
          "reserved.world": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv4": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv6": ""
        }
      }
    ],
    "L4": [],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumClusterwideNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "test-allow-cluster-ingress-all",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "43ed3334-a7fd-4b02-a5ec-b7234ea021b4",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka"
        }
      },
      "cidr:10.0.0.0/12"
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "8080",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-node-ingress",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "a9a888a5-cbf8-4324-bab7-fa93a3a6b77b",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-same-namespace",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "4f936664-abef-481c-a701-081659408cae",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "any.app": "longhorn-csi-plugin",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "reserved.remote-node": ""
        }
      },
      {
        "matchLabels": {
          "reserved.host": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv4": ""
        }
      },
      {
        "matchLabels": {
          "reserved.world-ipv6": ""
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9808",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-csi-plugin-node-access",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "4c790d77-1673-4c32-a951-9dccc4b34c5f",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9092",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-csi-plugin",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        },
        "matchExpressions": [
          {
            "key": "k8s.longhorn.io/job-task",
            "operator": "Exists"
          }
        ]
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/recovery-backend": "longhorn-recovery-backend"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9503",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-recovery-backend",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "a48ed662-92ca-48cf-8eb5-84f664e63c39",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "instance-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "instance-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "instance-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "2ff1f074-01bb-452c-85e6-a10cc548b287",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {}
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-same-namespace",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "4f936664-abef-481c-a701-081659408cae",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": false,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/cluster": "kafka-cluster",
          "k8s.strimzi.io/kind": "Kafka",
          "k8s.strimzi.io/name": "kafka-cluster-kafka"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9090",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "5220481c-b461-4d94-adaf-7955db01ad5f",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-csi-plugin",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      },
      "cidr:10.0.0.0/12"
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9808",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-csi-plugin",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "dcfe5679-1b87-415a-be9a-b0f75aff8771",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/managed-by": "longhorn-manager"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "instance-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "backing-image-data-source"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "instance-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "2ff1f074-01bb-452c-85e6-a10cc548b287",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-ui",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app.kubernetes.io/component": "controller",
          "k8s.app.kubernetes.io/instance": "ingress-nginx",
          "k8s.app.kubernetes.io/name": "ingress-nginx",
          "k8s.io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name": "ingress-nginx",
          "k8s.io.cilium.k8s.policy.cluster": "default"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-ui",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b75292d2-11c7-467c-8558-50508860334c",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "instance-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "5220481c-b461-4d94-adaf-7955db01ad5f",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/admission-webhook": "longhorn-admission-webhook"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9502",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-admission-webhook",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "dafd5ae7-fec1-4361-9b68-15a84634f20e",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-driver-deployer",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      },
      "cidr:10.0.0.0/12"
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app.kubernetes.io/component": "controller",
        "k8s.app.kubernetes.io/name": "ingress-nginx",
        "k8s.io.kubernetes.pod.namespace": "ingress-nginx"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "80",
            "protocol": "TCP"
          },
          {
            "port": "443",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumClusterwideNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-all-to-ingress-nginx",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "9b0662a3-d945-4917-9cd7-524feb6d4f54",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/kind": "cluster-operator"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9090",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-manager",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "kafka",
          "k8s.strimzi.io/kind": "cluster-operator"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9091",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka",
        "k8s.strimzi.io/cluster": "kafka-cluster",
        "k8s.strimzi.io/kind": "Kafka",
        "k8s.strimzi.io/name": "kafka-cluster-kafka"
      }
    },
    "L3": [
      {}
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9093",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "kafka-cluster-network-policy-kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "fe94c07b-4435-4613-a859-3cc3c265e445",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-manager"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "backing-image-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "5220481c-b461-4d94-adaf-7955db01ad5f",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.app": "longhorn-manager",
        "k8s.io.kubernetes.pod.namespace": "longhorn-system"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.app": "longhorn-ui",
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system"
        }
      }
    ],
    "L4": [
      {
        "ports": [
          {
            "port": "9501",
            "protocol": "TCP"
          }
        ]
      }
    ],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "longhorn-manager",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "b67ca757-20b6-4cf0-87ee-db5250a899a8",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-data-source"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "instance-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-data-source",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "6b710528-3078-446b-bf8d-e2dda11cfc84",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "longhorn-system",
        "k8s.longhorn.io/component": "backing-image-data-source"
      }
    },
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default",
          "k8s.io.kubernetes.pod.namespace": "longhorn-system",
          "k8s.longhorn.io/component": "backing-image-manager"
        }
      }
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "backing-image-data-source",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "longhorn-system",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "6b710528-3078-446b-bf8d-e2dda11cfc84",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {
      "matchLabels": {
        "k8s.io.kubernetes.pod.namespace": "kafka"
      }
    },
    "L3": [
      {}
    ],
    "L4": null,
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "NetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "allow-same-namespace",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.namespace",
        "value": "kafka",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "4f936664-abef-481c-a701-081659408cae",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": false,
    "Node": false
  },
  {
    "Tier": 0,
    "Priority": 0,
    "Authentication": null,
    "Log": {},
    "Subject": {},
    "L3": [
      {
        "matchLabels": {
          "k8s.io.cilium.k8s.policy.cluster": "default"
        },
        "matchExpressions": [
          {
            "key": "k8s.io.kubernetes.pod.namespace",
            "operator": "Exists"
          }
        ]
      }
    ],
    "L4": [],
    "Labels": [
      {
        "key": "io.cilium.k8s.policy.derived-from",
        "value": "CiliumClusterwideNetworkPolicy",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.name",
        "value": "test-allow-cluster-ingress-all",
        "source": "k8s"
      },
      {
        "key": "io.cilium.k8s.policy.uid",
        "value": "43ed3334-a7fd-4b02-a5ec-b7234ea021b4",
        "source": "k8s"
      }
    ],
    "DefaultDeny": true,
    "Verdict": 0,
    "Ingress": true,
    "Node": false
  }
]
Revision: 25

```


#### Cilium memory map


```
00400000-03a47000 r-xp 00000000 00:5f 30743909                           /usr/bin/cilium-agent
03a47000-07dfe000 r--p 03647000 00:5f 30743909                           /usr/bin/cilium-agent
07dfe000-080c9000 rw-p 079fe000 00:5f 30743909                           /usr/bin/cilium-agent
080c9000-08657000 rw-p 00000000 00:00 0 
c000000000-c008400000 rw-p 00000000 00:00 0                              [anon: Go: heap]
c008400000-c00c000000 ---p 00000000 00:00 0                              [anon: Go: heap reservation]
7ff2d1a6f000-7ff2d1a7f000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7ff2d1a7f000-7ff2d1b51000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7ff2d1b51000-7ff2d1b61000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7ff2d1b61000-7ff2d1b85000 rw-p 00000000 00:00 0                          [anon: Go: allspans array]
7ff2d1b85000-7ff2d1c05000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7ff2d1c05000-7ff2d1c35000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7ff2d1c35000-7ff2d1c75000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7ff2d1c83000-7ff2d1c93000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7ff2d1c93000-7ff2d1cd3000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7ff2d1cd3000-7ff2d1d03000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7ff2d1d06000-7ff2d1d18000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7ff2d1d18000-7ff2d1d59000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d1d59000-7ff2d1d9a000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d1d9a000-7ff2d1ddb000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d1ddb000-7ff2d1e1c000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d1e1c000-7ff2d1e5d000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d1e5d000-7ff2d1e9e000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d1e9e000-7ff2d1edf000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d1edf000-7ff2d1f20000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d1f20000-7ff2d1f61000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d1f61000-7ff2d1fa2000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d1fa2000-7ff2d1fe3000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d1fe3000-7ff2d2024000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d2024000-7ff2d2026000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d2026000-7ff2d2028000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d2028000-7ff2d202a000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d202a000-7ff2d202c000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d202c000-7ff2d202e000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d202e000-7ff2d2030000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff2d2030000-7ff2d20b0000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7ff2d20b0000-7ff2d20c0000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7ff2d20c0000-7ff2d2100000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7ff2d2100000-7ff2d2110000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7ff2d2110000-7ff2d2190000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7ff2d2190000-7ff2d21a0000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7ff2d21a0000-7ff2d25a0000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7ff2d25a0000-7ff2d2700000 rw-p 00000000 00:00 0                          [anon: Go: profiler hash buckets]
7ff2d2700000-7ff2d2800000 rw-p 00000000 00:00 0                          [anon: Go: page alloc index]
7ff2d2800000-7ff2d4800000 rw-p 00000000 00:00 0                          [anon: Go: heap index]
7ff2d4800000-7ff2e4980000 ---p 00000000 00:00 0                          [anon: Go: scavenge index]
7ff2e4980000-7ff2e4981000 rw-p 00000000 00:00 0                          [anon: Go: scavenge index]
7ff2e4981000-7ff2f4800000 ---p 00000000 00:00 0                          [anon: Go: scavenge index]
7ff2f4800000-7ff304980000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7ff304980000-7ff304981000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7ff304981000-7ff316830000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7ff316830000-7ff316831000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7ff316831000-7ff318c06000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7ff318c06000-7ff318c07000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7ff318c07000-7ff319000000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7ff319000000-7ff319001000 rw-s 00000000 00:10 1083                       anon_inode:bpf-map
7ff319001000-7ff319003000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff319003000-7ff319005000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff319005000-7ff319007000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff319007000-7ff319009000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff319009000-7ff31900b000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff31900b000-7ff31900d000 rw-s 00000000 00:10 1083                       anon_inode:[perf_event]
7ff31900d000-7ff31902d000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7ff31902d000-7ff31902e000 rw-p 00000000 00:00 0                          [anon: Go: getrandom states]
7ff31902e000-7ff3190c4000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7ff3190c4000-7ff3190e4000 rw-p 00000000 00:00 0                          [anon: Go: gc bits]
7ff3190e4000-7ff3190f6000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7ff3190f6000-7ff319176000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7ff319176000-7ff319177000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7ff319177000-7ff3191f6000 ---p 00000000 00:00 0                          [anon: Go: page summary]
7ff3191f6000-7ff319216000 rw-p 00000000 00:00 0                          [anon: Go: page alloc]
7ff319216000-7ff319256000 rw-p 00000000 00:00 0                          [anon: Go: immortal metadata]
7ff319256000-7ff31925a000 r--p 00000000 00:00 0                          [vvar]
7ff31925a000-7ff31925c000 r-xp 00000000 00:00 0                          [vdso]
7ffd321cf000-7ffd321f0000 rw-p 00000000 00:00 0                          [stack]
ffffffffff600000-ffffffffff601000 --xp 00000000 00:00 0                  [vsyscall]

```


#### ipam

```
(string) (len=6) "owners"
(map[ipam.Pool]map[string]string) (len=1) {
 (ipam.Pool) (len=7) default: (map[string]string) (len=10) {
  (string) (len=10) "10.0.6.214": (string) (len=52) "longhorn-system/longhorn-csi-plugin-hgs45 [restored]",
  (string) (len=9) "10.0.6.35": (string) (len=49) "longhorn-system/longhorn-manager-lv2c5 [restored]",
  (string) (len=10) "10.0.6.166": (string) (len=57) "longhorn-system/engine-image-ei-e09d8caa-6csmp [restored]",
  (string) (len=10) "10.0.6.135": (string) (len=6) "router",
  (string) (len=10) "10.0.6.104": (string) (len=6) "health",
  (string) (len=10) "10.0.6.169": (string) (len=83) "monitoring/vmsingle-vmetrics-victoria-metrics-k8s-stack-7995bbfdc8-jgphq [restored]",
  (string) (len=10) "10.0.6.181": (string) (len=33) "monitoring/kured-ltrpm [restored]",
  (string) (len=10) "10.0.6.110": (string) (len=76) "longhorn-system/instance-manager-ac9872fca799281e77c29b3929ae84fd [restored]",
  (string) (len=10) "10.0.6.212": (string) (len=65) "redacted-dev/redacted-wetteralarm-job-dev-68c58fb997-xbhdk [restored]",
  (string) (len=9) "10.0.6.33": (string) (len=47) "monitoring/victorialogs-vector-xw5lq [restored]"
 }
}
(string) (len=17) "expiration timers"
(map[ipam.timerKey]ipam.expirationTimer) {
}
(string) (len=12) "excluded ips"
(map[string]string) (len=1) {
 (string) (len=22) "default:192.168.100.20": (string) (len=7) "node-ip"
}

```


#### kvstore-locks

```
(map[string]kvstore.lockOwner) {
}

```


#### ongoing-endpoint-creations


#### Cilium version

```
1.19.0-rc.0 b6f44c92 2026-01-14T23:04:46+00:00 go version go1.25.5 linux/amd64
```


#### Kernel version

```
6.12.0
```


#### Cilium status

```
KVStore:                Disabled   
Kubernetes:             Ok         1.35 (v1.35.0+k3s1) [linux/amd64]
Kubernetes APIs:        ["cilium/v2::CiliumCIDRGroup", "cilium/v2::CiliumClusterwideNetworkPolicy", "cilium/v2::CiliumEndpoint", "cilium/v2::CiliumNetworkPolicy", "cilium/v2::CiliumNode", "core/v1::Pods", "networking.k8s.io/v1::NetworkPolicy"]
KubeProxyReplacement:   True   [enp35s0   135.181.20.52 fe80::6a68:5d99:89ad:75ea, vlan4000   192.168.100.20 fe80::2553:8d69:9290:8e6 (Direct Routing), tailscale0    100.64.0.155 fd7a:115c:a1e0::9c fe80::a493:3e2f:1f65:3da1]
Host firewall:          Disabled
SRv6:                   Disabled
CNI Chaining:           none
CNI Config file:        successfully wrote CNI configuration file to /host/etc/cni/net.d/05-cilium.conflist
Cilium:                 Ok   1.19.0-rc.0 (v1.19.0-rc.0-b6f44c92)
NodeMonitor:            Listening for events on 12 CPUs with 64x4096 of shared memory
Cilium health daemon:   Ok   
IPAM:                   IPv4: 10/254 allocated from 10.0.6.0/24, 
Allocated addresses:
  10.0.6.104 (health)
  10.0.6.110 (longhorn-system/instance-manager-ac9872fca799281e77c29b3929ae84fd [restored])
  10.0.6.135 (router)
  10.0.6.166 (longhorn-system/engine-image-ei-e09d8caa-6csmp [restored])
  10.0.6.169 (monitoring/vmsingle-vmetrics-victoria-metrics-k8s-stack-7995bbfdc8-jgphq [restored])
  10.0.6.181 (monitoring/kured-ltrpm [restored])
  10.0.6.212 (redacted-dev/redacted-wetteralarm-job-dev-68c58fb997-xbhdk [restored])
  10.0.6.214 (longhorn-system/longhorn-csi-plugin-hgs45 [restored])
  10.0.6.33 (monitoring/victorialogs-vector-xw5lq [restored])
  10.0.6.35 (longhorn-system/longhorn-manager-lv2c5 [restored])
IPv4 BIG TCP:           Disabled
IPv6 BIG TCP:           Disabled
BandwidthManager:       Disabled
Routing:                Network: Tunnel [vxlan]   Host: BPF
Attach Mode:            TCX
Device Mode:            veth
Masquerading:           BPF   [enp35s0, vlan4000, tailscale0]   10.0.6.0/24  [IPv4: Enabled, IPv6: Disabled]
Clock Source for BPF:   ktime
Controller Status:      63/63 healthy
  Name                                                                                      Last success   Last error   Count   Message
  cilium-health-ep                                                                          34s ago        never        0       no error   
  ct-map-pressure                                                                           16s ago        never        0       no error   
  endpoint-1575-regeneration-recovery                                                       never          never        0       no error   
  endpoint-158-regeneration-recovery                                                        never          never        0       no error   
  endpoint-1979-regeneration-recovery                                                       never          never        0       no error   
  endpoint-2136-regeneration-recovery                                                       never          never        0       no error   
  endpoint-2890-regeneration-recovery                                                       never          never        0       no error   
  endpoint-2904-regeneration-recovery                                                       never          never        0       no error   
  endpoint-3368-regeneration-recovery                                                       never          never        0       no error   
  endpoint-376-regeneration-recovery                                                        never          never        0       no error   
  endpoint-435-regeneration-recovery                                                        never          never        0       no error   
  endpoint-745-regeneration-recovery                                                        never          never        0       no error   
  endpoint-gc                                                                               4m36s ago      never        0       no error   
  endpoint-periodic-regeneration                                                            1m36s ago      never        0       no error   
  ipcache-inject-labels                                                                     36s ago        never        0       no error   
  k8s-heartbeat                                                                             5s ago         never        0       no error   
  local-identity-checkpoint                                                                 7h1m50s ago    never        0       no error   
  resolve-identity-1979                                                                     4m34s ago      never        0       no error   
  resolve-labels-/                                                                          7h49m35s ago   never        0       no error   
  resolve-labels-longhorn-system/engine-image-ei-e09d8caa-6csmp                             7h49m30s ago   never        0       no error   
  resolve-labels-longhorn-system/instance-manager-ac9872fca799281e77c29b3929ae84fd          7h49m30s ago   never        0       no error   
  resolve-labels-longhorn-system/longhorn-csi-plugin-hgs45                                  7h49m30s ago   never        0       no error   
  resolve-labels-longhorn-system/longhorn-manager-lv2c5                                     7h49m30s ago   never        0       no error   
  resolve-labels-monitoring/kured-ltrpm                                                     7h49m30s ago   never        0       no error   
  resolve-labels-monitoring/victorialogs-vector-xw5lq                                       7h49m30s ago   never        0       no error   
  resolve-labels-monitoring/vmsingle-vmetrics-victoria-metrics-k8s-stack-7995bbfdc8-jgphq   7h49m30s ago   never        0       no error   
  resolve-labels-redacted-dev/redacted-wetteralarm-job-dev-68c58fb997-xbhdk                     7h49m30s ago   never        0       no error   
  restoring-ep-identity (1575)                                                              7h49m35s ago   never        0       no error   
  restoring-ep-identity (158)                                                               7h49m35s ago   never        0       no error   
  restoring-ep-identity (2136)                                                              7h49m35s ago   never        0       no error   
  restoring-ep-identity (2890)                                                              7h49m35s ago   never        0       no error   
  restoring-ep-identity (2904)                                                              7h49m35s ago   never        0       no error   
  restoring-ep-identity (3368)                                                              7h49m35s ago   never        0       no error   
  restoring-ep-identity (376)                                                               7h49m35s ago   never        0       no error   
  restoring-ep-identity (435)                                                               7h49m35s ago   never        0       no error   
  restoring-ep-identity (745)                                                               7h49m35s ago   never        0       no error   
  sync-policymap-1575                                                                       4m30s ago      never        0       no error   
  sync-policymap-158                                                                        4m30s ago      never        0       no error   
  sync-policymap-1979                                                                       4m30s ago      never        0       no error   
  sync-policymap-2136                                                                       4m31s ago      never        0       no error   
  sync-policymap-2890                                                                       4m31s ago      never        0       no error   
  sync-policymap-2904                                                                       4m31s ago      never        0       no error   
  sync-policymap-3368                                                                       4m30s ago      never        0       no error   
  sync-policymap-376                                                                        4m30s ago      never        0       no error   
  sync-policymap-435                                                                        4m31s ago      never        0       no error   
  sync-policymap-745                                                                        4m30s ago      never        0       no error   
  sync-to-k8s-ciliumendpoint (1575)                                                         4s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (158)                                                          4s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (2136)                                                         4s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (2890)                                                         4s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (2904)                                                         4s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (3368)                                                         4s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (435)                                                          4s ago         never        0       no error   
  sync-to-k8s-ciliumendpoint (745)                                                          4s ago         never        0       no error   
  waiting-initial-global-identities-ep (1575)                                               7h49m35s ago   never        0       no error   
  waiting-initial-global-identities-ep (158)                                                7h49m35s ago   never        0       no error   
  waiting-initial-global-identities-ep (2136)                                               7h49m35s ago   never        0       no error   
  waiting-initial-global-identities-ep (2890)                                               7h49m35s ago   never        0       no error   
  waiting-initial-global-identities-ep (2904)                                               7h49m35s ago   never        0       no error   
  waiting-initial-global-identities-ep (3368)                                               7h49m35s ago   never        0       no error   
  waiting-initial-global-identities-ep (435)                                                7h49m35s ago   never        0       no error   
  waiting-initial-global-identities-ep (745)                                                7h49m35s ago   never        0       no error   
  write-cni-file                                                                            7h49m36s ago   never        0       no error   
Proxy Status:            OK, ip 10.0.6.135, 0 redirects active on ports 10000-20000, Envoy: external
Global Identity Range:   min 256, max 65535
Hubble:                  Ok   Current/Max Flows: 4095/4095 (100.00%), Flows/s: 1191.70   Metrics: Disabled
KubeProxyReplacement Details:
  Status:               True
  Socket LB:            Enabled
  Socket LB Tracing:    Enabled
  Socket LB Coverage:   Full
  Devices:              enp35s0   135.181.20.52 fe80::6a68:5d99:89ad:75ea, vlan4000   192.168.100.20 fe80::2553:8d69:9290:8e6 (Direct Routing), tailscale0    100.64.0.155 fd7a:115c:a1e0::9c fe80::a493:3e2f:1f65:3da1
  Mode:                 SNAT
  Backend Selection:    Random
  Session Affinity:     Enabled
  NAT46/64 Support:     Disabled
  XDP Acceleration:     Disabled
  Services:
  - ClusterIP:      Enabled
  - NodePort:       Enabled (Range: 30000-32767) 
  - LoadBalancer:   Enabled 
  - externalIPs:    Enabled 
  - HostPort:       Enabled
  Annotations:
  - service.cilium.io/node
  - service.cilium.io/node-selector
  - service.cilium.io/proxy-delegation
  - service.cilium.io/src-ranges-policy
  - service.cilium.io/type
BPF Maps:   dynamic sizing: on (ratio: 0.002500)
  Name                          Size
  Auth                          524288
  Non-TCP connection tracking   592044
  TCP connection tracking       1184089
  Endpoints                     65535
  IP cache                      512000
  IPv4 masquerading agent       16384
  IPv6 masquerading agent       16384
  IPv4 fragmentation            8192
  IPv4 service                  65536
  IPv6 service                  65536
  IPv4 service backend          65536
  IPv6 service backend          65536
  IPv4 service reverse NAT      65536
  IPv6 service reverse NAT      65536
  Metrics                       1024
  Ratelimit metrics             64
  NAT                           1184089
  Neighbor table                1184089
  Endpoint policy               16384
  Policy stats                  65532
  Session affinity              65536
  Sock reverse NAT              592044
Encryption:   Wireguard   [NodeEncryption: Disabled, cilium_wg0 (Pubkey: sOen1KxasKuG8RrUT7Zh9uLpLgWOsERp8XEG1jYaHWo=, Port: 51871, Peers: 11)]
```

#### Cilium environment keys

```
enable-route-mtu-for-cni-chaining:false
dns-max-ips-per-restored-rule:1000
alibabacloud-security-groups:
node-port-acceleration:disabled
enable-active-connection-tracking:false
controller-group-metrics:
socket-path:/var/run/cilium/cilium.sock
enable-no-service-endpoints-routable:true
disable-endpoint-crd:false
policy-deny-response:none
fixed-identity-mapping:
enable-bpf-clock-probe:false
enable-pmtu-discovery:false
proxy-cluster-max-connections:1024
enable-encryption-strict-mode-egress:false
tofqdns-proxy-response-max-delay:100ms
ipam-static-ip-tags:
use-cilium-internal-ip-for-ipsec:false
local-router-ipv6:
nodes-gc-interval:5m0s
shell-sock-path:/var/run/cilium/shell.sock
operator-prometheus-serve-addr::9963
enable-stale-cilium-endpoint-cleanup:true
enable-ipv6-fragment-tracking:true
node-port-mode:
mke-cgroup-mount:
ipv6-service-loopback-address:fe80::1
k8s-client-qps:10
azure-interface-name:
k8s-require-ipv6-pod-cidr:false
wireguard-track-all-ips-fallback:false
hubble-metrics-server-tls-client-ca-files:
log-driver:
enable-wireguard:true
bpf-sock-rev-map-max:0
enable-hubble-open-metrics:false
enable-ipsec-key-watcher:true
keep-config:false
operator-api-serve-addr:127.0.0.1:9234
nodeport-addresses:
kube-proxy-replacement:true
alibabacloud-vswitches:
hubble-redact-http-headers-allow:
lb-state-file:
bgp-router-id-allocation-mode:default
dnsproxy-lock-timeout:500ms
bpf-conntrack-accounting:false
dnsproxy-concurrency-limit:0
bpf-events-trace-enabled:true
proxy-admin-port:0
bpf-lb-acceleration:disabled
local-router-ipv4:
hubble-monitor-events:
bpf-map-event-buffers:
enable-bpf-tproxy:false
enable-bgp-control-plane:false
hive-log-threshold:100ms
hubble-tls-key-file:/var/lib/cilium/tls/hubble/server.key
policy-queue-size:100
allow-icmp-frag-needed:true
status-collector-probe-check-timeout:5m0s
ipv6-node:auto
debug:false
agent-health-port:9879
enable-packetization-layer-pmtud:true
enable-node-selector-labels:false
status-collector-interval:5s
bpf-events-drop-enabled:true
cluster-pool-ipv4-cidr:10.0.0.0/8
hubble-dynamic-metrics-config-path:
enable-policy:default
alibabacloud-vswitch-tags:
proxy-connect-timeout:2
disable-envoy-version-check:false
default-lb-service-ipam:lbipam
enable-source-ip-verification:true
tofqdns-idle-connection-grace-period:0s
proxy-xff-num-trusted-hops-ingress:0
restored-proxy-ports-age-limit:15
bpf-fragments-map-max:8192
encryption-strict-mode-allow-remote-node-identities:false
certificates-directory:/var/run/cilium/certs
envoy-log:
bypass-ip-availability-upon-restore:false
derive-masq-ip-addr-from-device:
enable-standalone-dns-proxy:false
hubble-export-file-max-backups:5
health-check-icmp-failure-threshold:3
enable-dynamic-lifecycle-manager:false
agent-liveness-update-interval:1s
bpf-events-policy-verdict-enabled:true
enable-ipv4-fragment-tracking:true
hubble-metrics-server-enable-tls:false
identity-restore-grace-period:30s
enable-ipv4:true
enable-policy-secrets-sync:true
enable-l2-announcements:false
encryption-strict-egress-cidr:
enable-drift-checker:true
endpoint-gc-interval:5m0s
tofqdns-dns-reject-response-code:refused
ipam-pre-allocate:0
enable-ipv6-ndp:false
ipv6-native-routing-cidr:
bpf-lb-dsr-dispatch:opt
proxy-initial-fetch-timeout:30
metrics-sampling-interval:5m
lrp-address-matcher-cidrs:
pprof-address:localhost
ipv4-service-range:auto
ipv4-range:auto
enable-srv6:false
enable-ciliumnode-crd:true
proxy-max-concurrent-retries:128
bpf-lb-sock-terminate-pod-connections:true
enable-well-known-identities:false
enable-tracing:false
hubble-metrics-server:
identity-heartbeat-timeout:30m0s
bpf-lb-rss-ipv6-src-cidr:
enable-ipv4-masquerade:true
hubble-disable-tls:false
ipv4-node:auto
bpf-node-map-max:16384
enable-ipv6-masquerade:true
bpf-filter-priority:1
enable-dynamic-config:true
envoy-base-id:0
node-labels:
bpf-ct-global-tcp-max:524288
trace-payloadlen:128
clustermesh-enable-endpoint-sync:false
enable-k8s-host-firewall-bypass:true
max-internal-timer-delay:0s
enable-ip-masq-agent:false
k8s-client-connection-keep-alive:30s
endpoint-regen-interval:2m0s
http-retry-timeout:0
enable-endpoint-health-checking:true
bpf-distributed-lru:false
enable-bandwidth-manager:false
bpf-ct-timeout-regular-tcp-fin:10s
boot-id-file:/proc/sys/kernel/random/boot_id
nat-map-stats-entries:32
enable-local-node-route:true
bpf-ct-timeout-regular-tcp:2h13m20s
pprof-mutex-profile-fraction:0
use-full-tls-context:false
remove-cilium-node-taints:true
annotate-k8s-node:false
exclude-local-address:
enable-gateway-api:false
install-uplink-routes-for-delegated-ipam:false
egress-gateway-reconciliation-trigger-interval:1s
bpf-policy-map-max:16384
mesh-auth-mutual-connect-timeout:5s
enable-envoy-config:false
state-dir:/var/run/cilium
dns-policy-unload-on-shutdown:false
bpf-policy-map-pressure-metrics-threshold:0.1
proxy-portrange-min:10000
hubble-event-buffer-capacity:4095
identity-allocation-sync-interval:5m0s
enable-health-check-loadbalancer-ip:false
eni-disable-prefix-delegation:false
hubble-export-allowlist:
endpoint-queue-size:25
http-max-grpc-timeout:0
k8s-kubeconfig-path:
bpf-lb-map-max:65536
bpf-ct-global-any-max:262144
clustermesh-enable-mcs-api:false
enable-ipsec:false
config-sources:[{"kind":"config-map","namespace":"kube-system","name":"cilium-config"}]
bpf-lb-nat46x64:false
routing-mode:tunnel
enable-ipip-termination:false
mesh-auth-spire-admin-socket:
bpf-ct-timeout-regular-any:1m0s
k8s-namespace:kube-system
gops-port:9890
dnsproxy-insecure-skip-transparent-mode-check:false
hubble-flowlogs-config-path:
enable-l7-proxy:true
container-ip-local-reserved-ports:auto
policy-audit-mode:true
unmanaged-pod-watcher-interval:15s
endpoint-bpf-prog-watchdog-interval:30s
vtep-sync-interval:1m0s
conntrack-gc-max-interval:0s
custom-cni-conf:false
envoy-keep-cap-netbindservice:false
hubble-drop-events-rate-limit:1
exclude-node-label-patterns:
hubble-redact-http-userinfo:true
dnsproxy-lock-count:131
iptables-random-fully:false
egress-masquerade-interfaces:
k8s-service-proxy-name:
hive-stop-timeout:1m0s
lb-retry-backoff-min:1s
cni-chaining-target:
static-cnp-path:
bpf-events-default-rate-limit:0
datapath-mode:veth
ipv6-mcast-device:
hubble-export-fieldmask:
vtep-endpoint:
hubble-redact-http-headers-deny:
enable-service-topology:false
pprof-block-profile-rate:0
tofqdns-endpoint-max-ip-per-hostname:1000
bpf-lb-affinity-map-max:0
bpf-policy-stats-map-max:65536
mesh-auth-queue-size:1024
hubble-drop-events:false
enable-lb-ipam:true
node-port-bind-protection:true
enable-host-firewall:false
vlan-bpf-bypass:
synchronize-k8s-nodes:true
envoy-http-upstream-linger-timeout:-1
iptables-lock-timeout:5s
identity-max-jitter:30s
install-no-conntrack-iptables-rules:false
agent-labels:
node-port-algorithm:
mesh-auth-mutual-listener-port:0
envoy-config-retry-interval:15s
bpf-lb-source-range-map-max:0
enable-gops:true
ipsec-key-rotation-duration:5m0s
auto-create-cilium-node-resource:true
k8s-require-ipv4-pod-cidr:false
enable-nat46x64-gateway:false
status-collector-failure-threshold:1m0s
enable-cilium-network-policy:true
cni-chaining-mode:none
enable-l2-pod-announcements:false
cmdref:
enable-tunnel-big-tcp:false
tunnel-source-port-range:0-0
mtu:0
status-collector-warning-threshold:15s
prepend-iptables-chains:true
max-controller-interval:0
k8s-sync-timeout:3m0s
hubble-event-queue-size:0
devices:
install-iptables-rules:true
proxy-max-requests-per-connection:0
bpf-ct-timeout-service-any:1m0s
bpf-lb-ipip-sock-mark:false
crd-wait-timeout:5m0s
k8s-api-server-urls:
trace-payloadlen-overlay:192
ipv4-pod-subnets:
set-cilium-node-taints:true
proxy-idle-timeout-seconds:60
bpf-lb-rev-nat-map-max:0
dnsproxy-socket-linger-timeout:10
ip-masq-agent-config-path:/etc/config/ip-masq-agent
hubble-redact-enabled:false
monitor-aggregation-interval:5s
cluster-name:default
srv6-encap-mode:reduced
kvstore-lease-ttl:15m0s
debug-verbose:
ingress-secrets-namespace:
allocator-list-timeout:3m0s
identity-change-grace-period:5s
allow-localhost:auto
direct-routing-device:
connectivity-probe-frequency-ratio:0.5
http-stream-idle-timeout:300
conntrack-gc-interval:0s
kvstore:
clustermesh-mcs-api-install-crds:true
ipv6-range:auto
ipv4-service-loopback-address:169.254.42.1
enable-health-check-nodeport:true
enable-non-default-deny-policies:true
disable-iptables-feeder-rules:
bpf-lb-sock-hostns-only:false
auto-direct-node-routes:false
clustermesh-sync-timeout:1m0s
write-cni-conf-when-ready:/host/etc/cni/net.d/05-cilium.conflist
hubble-metrics:
monitor-aggregation-flags:all
policy-cidr-match-mode:
eni-security-groups:
hubble-metrics-server-tls-key-file:
lb-state-file-interval:1s
log-system-load:false
hubble-listen-address::4244
pprof-port:6060
policy-accounting:true
local-max-addr-scope:254
enable-monitor:true
bpf-lb-external-clusterip:false
k8s-client-connection-timeout:30s
bpf-ct-timeout-service-tcp:2h13m20s
lb-init-wait-timeout:1m0s
http-request-timeout:3600
enable-sctp:false
eni-subnet-ids:
hubble-redact-http-urlquery:false
ztunnel-zds-unix-addr:/var/run/cilium/ztunnel.sock
bpf-lb-mode-annotation:false
ipv6-service-range:auto
enable-mke:false
log-opt:
eni-delete-on-termination:true
bpf-events-default-burst-limit:0
mesh-auth-rotated-identities-queue-size:1024
label-prefix-file:
nat-map-stats-interval:30s
dynamic-lifecycle-config:[]
cilium-endpoint-gc-interval:5m0s
enable-bbr-hostns-only:false
eni-subnet-tags:
mesh-auth-enabled:true
http-retry-count:3
hubble-drop-events-reasons:
identity-gc-interval:15m0s
clustermesh-cache-ttl:0s
only-masquerade-default-pool:false
enable-local-redirect-policy:false
enable-cilium-endpoint-slice:false
lb-retry-backoff-max:1s
tunnel-protocol:vxlan
ipam-default-ip-pool:default
vtep-mask:
bpf-nat-global-max:524288
enable-bpf-masquerade:true
lib-dir:/var/lib/cilium
bpf-neigh-global-max:524288
proxy-portrange-max:20000
encrypt-interface:
enable-bbr:false
enable-xt-socket-fallback:true
enable-cilium-clusterwide-network-policy:true
lb-sock-terminate-all-protos:false
ipam-min-allocate:0
enable-k8s-api-discovery:false
identity-allocation-timeout:2m0s
force-device-detection:false
enable-extended-ip-protocols:false
enable-tcx:true
kvstore-max-consecutive-quorum-errors:2
lb-pressure-metrics-interval:5m0s
api-rate-limit:
allow-unsafe-policy-skb-usage:false
preallocate-bpf-maps:false
dnsproxy-enable-transparent-mode:true
encrypt-node:false
hubble-lost-event-send-interval:1s
ipsec-key-file:
hubble-export-file-path:
proxy-xff-num-trusted-hops-egress:0
route-metric:0
proxy-max-connection-duration-seconds:0
metrics:
bpf-lb-maglev-table-size:16381
enable-endpoint-lockdown-on-policy-overflow:false
enable-xdp-prefilter:false
enable-ingress-controller:false
hubble-socket-path:/var/run/cilium/hubble.sock
enable-unreachable-routes:false
hubble-network-policy-correlation-enabled:true
enable-encryption-strict-mode:false
direct-routing-skip-unreachable:false
proxy-max-active-downstream-connections:50000
status-collector-stackdump-path:/run/cilium/state/agent.stack.gz
disable-external-ip-mitigation:false
eni-first-interface-index:0
hubble-tls-cert-file:/var/lib/cilium/tls/hubble/server.crt
hubble-skip-unknown-cgroup-ids:true
enable-remote-node-masquerade:false
bpf-lb-algorithm:random
hubble-export-denylist:
http-idle-timeout:0
hive-start-timeout:5m0s
hubble-prefer-ipv6:false
enable-vtep:false
bpf-lb-service-map-max:0
underlay-protocol:ipv4
ipv4-native-routing-cidr:
kvstore-opt:
encryption-strict-mode-cidr:
mesh-auth-gc-interval:5m0s
enable-ipv4-big-tcp:false
l2-announcements-lease-duration:15s
standalone-dns-proxy-server-port:10095
vtep-mac:
eni-use-primary-address:false
restore:true
mesh-auth-signal-backoff-duration:1s
agent-health-require-k8s-connectivity:true
enable-health-checking:true
multicast-enabled:false
ipam-cilium-node-update-rate:15s
l2-pod-announcements-interface-pattern:
node-encryption-opt-out-labels:node-role.kubernetes.io/control-plane
cgroup-root:/run/cilium/cgroupv2
identity-allocation-mode:crd
monitor-aggregation:medium
cluster-pool-ipv4-mask-size:24
envoy-config-timeout:2m0s
tofqdns-pre-cache:
bgp-router-id-allocation-ip-pool:
k8s-client-burst:20
hubble-export-aggregation-interval:0s
procfs:/host/proc
hubble-tls-client-ca-files:/var/lib/cilium/tls/hubble/client-ca.crt
eni-security-group-tags:
bpf-lb-sock:false
ipv6-cluster-alloc-cidr:f00d::/64
cni-exclusive:true
bpf-ct-timeout-regular-tcp-syn:1m0s
enable-node-ipam:false
bpf-lb-mode:snat
enable-ipv6-big-tcp:false
enable-metrics:true
k8s-heartbeat-timeout:30s
cni-log-file:/var/run/cilium/cilium-cni.log
hubble-export-file-compress:false
ip-tracing-option-type:0
proxy-cluster-max-requests:1024
gateway-api-secrets-namespace:
max-connected-clusters:255
enable-cilium-health-api-server-access:
encryption-strict-egress-allow-remote-node-identities:false
cni-external-routing:false
enable-host-legacy-routing:false
k8s-api-server:
l2-announcements-retry-period:2s
enable-bgp-legacy-origin-attribute:false
config:
enable-k8s-networkpolicy:true
hubble-export-fieldaggregate:
external-envoy-proxy:true
dnsproxy-concurrency-processing-grace-period:0s
identity-management-mode:agent
bpf-lb-source-range-all-types:false
tofqdns-preallocate-identities:true
envoy-default-log-level:
enable-ztunnel:false
labels:
ipam:cluster-pool
bpf-lb-service-backend-map-max:0
enable-endpoint-routes:false
read-cni-conf:
monitor-queue-size:0
ignore-flags-drift-checker:
enable-encryption-strict-mode-ingress:false
enable-icmp-rules:true
wireguard-persistent-keepalive:0s
http-normalize-path:true
enable-masquerade-to-route-source:false
hubble-drop-events-interval:2m0s
vtep-cidr:
enable-cilium-api-server-access:
enable-hubble:true
bpf-lb-rss-ipv4-src-cidr:
envoy-policy-restore-timeout:3m0s
alibabacloud-security-group-tags:
eni-exclude-interface-tags:
service-no-backend-response:reject
bpf-ct-timeout-service-tcp-grace:1m0s
policy-secrets-namespace:cilium-secrets
policy-trigger-interval:1s
egress-gateway-policy-map-max:16384
config-sources-overrides:{"allowConfigKeys":[],"denyConfigKeys":[]}
bpf-auth-map-max:524288
tofqdns-max-deferred-connection-deletes:10000
bpf-lb-algorithm-annotation:false
policy-secrets-only-from-secrets-namespace:true
enable-identity-mark:true
enable-l2-neigh-discovery:false
tofqdns-min-ttl:0
version:false
cluster-id:0
envoy-access-log-buffer-size:4096
enable-bgp-control-plane-status-report:true
enable-k8s:true
tofqdns-proxy-port:0
enable-egress-gateway:true
hubble-drop-events-extended:false
enable-auto-protect-node-port-range:true
prometheus-serve-addr:
bpf-lb-maglev-hash-seed:JLfvgnHc2kaSUFaI
ipam-multi-pool-pre-allocation:
clustermesh-config:/var/lib/cilium/clustermesh/
proxy-gid:1337
mesh-auth-spiffe-trust-domain:spiffe.cilium
tofqdns-enable-dns-compression:true
proxy-prometheus-port:0
bpf-root:/sys/fs/bpf
trace-sock:true
set-cilium-is-up-condition:true
bpf-policy-map-full-reconciliation-interval:15m0s
bpf-lb-maglev-map-max:0
l2-announcements-renew-deadline:5s
policy-default-local-cluster:true
enable-ipsec-xfrm-state-caching:true
config-dir:/tmp/cilium/config-map
hubble-metrics-server-tls-cert-file:
ipam-max-allocate:0
envoy-secrets-namespace:
cluster-health-port:4240
enable-ipv6:false
bpf-map-dynamic-size-ratio:0.0025
fqdn-regex-compile-lru-size:1024
pprof:false
kube-proxy-replacement-healthz-bind-address:
hubble-redact-kafka-apikey:false
node-port-range:
agent-not-ready-taint-key:node.cilium.io/agent-not-ready
hubble-export-file-max-size-mb:10
tunnel-port:0
proxy-use-original-source-address:true
ipv6-pod-subnets:
```


#### Endpoint list

```
ENDPOINT   POLICY (ingress)   POLICY (egress)   IDENTITY   LABELS (source:key[=value])                                                                     IPv6   IPv4         STATUS   
           ENFORCEMENT        ENFORCEMENT                                                                                                                                      
158        Disabled (Audit)   Disabled          28201      k8s:app=longhorn-csi-plugin                                                                            10.0.6.214   ready   
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                              
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                            
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                             
376        Disabled           Disabled          1          k8s:k3s-upgrade=true                                                                                                ready   
                                                           k8s:node.kubernetes.io/instance-type=k3s                                                                                    
                                                           k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812                               
                                                           reserved:host                                                                                                               
435        Disabled (Audit)   Disabled          53293      k8s:app.kubernetes.io/component=monitoring                                                             10.0.6.169   ready   
                                                           k8s:app.kubernetes.io/instance=vmetrics-victoria-metrics-k8s-stack                                                          
                                                           k8s:app.kubernetes.io/name=vmsingle                                                                                         
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring                                                   
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                           k8s:io.cilium.k8s.policy.serviceaccount=vmsingle-vmetrics-victoria-metrics-k8s-stack                                        
                                                           k8s:io.kubernetes.pod.namespace=monitoring                                                                                  
                                                           k8s:managed-by=vm-operator                                                                                                  
745        Disabled (Audit)   Disabled          39699      k8s:app=redacted-wetteralarm-job-dev                                                                      10.0.6.212   ready   
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev                                                  
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                           k8s:io.cilium.k8s.policy.serviceaccount=default                                                                             
                                                           k8s:io.kubernetes.pod.namespace=redacted-dev                                                                                 
1575       Disabled (Audit)   Disabled          17163      k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                         10.0.6.110   ready   
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                            
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                             
                                                           k8s:longhorn.io/component=instance-manager                                                                                  
                                                           k8s:longhorn.io/data-engine=v1                                                                                              
                                                           k8s:longhorn.io/instance-manager-image=imi-29909444                                                                         
                                                           k8s:longhorn.io/instance-manager-type=aio                                                                                   
                                                           k8s:longhorn.io/managed-by=longhorn-manager                                                                                 
                                                           k8s:longhorn.io/node=dev-agent-01                                                                                           
1979       Disabled (Audit)   Disabled          4          reserved:health                                                                                        10.0.6.104   ready   
2136       Disabled (Audit)   Disabled          4988       k8s:app.kubernetes.io/instance=kured                                                                   10.0.6.181   ready   
                                                           k8s:app.kubernetes.io/managed-by=Helm                                                                                       
                                                           k8s:app.kubernetes.io/name=kured                                                                                            
                                                           k8s:helm.sh/chart=kured-5.6.2                                                                                               
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring                                                   
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                           k8s:io.cilium.k8s.policy.serviceaccount=kured                                                                               
                                                           k8s:io.kubernetes.pod.namespace=monitoring                                                                                  
2890       Disabled (Audit)   Disabled          4394       k8s:app.kubernetes.io/instance=longhorn                                                                10.0.6.35    ready   
                                                           k8s:app.kubernetes.io/managed-by=Helm                                                                                       
                                                           k8s:app.kubernetes.io/name=longhorn                                                                                         
                                                           k8s:app.kubernetes.io/version=v1.9.0                                                                                        
                                                           k8s:app=longhorn-manager                                                                                                    
                                                           k8s:helm.sh/chart=longhorn-1.9.0                                                                                            
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                              
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                            
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                             
                                                           k8s:longhorn.io/admission-webhook=longhorn-admission-webhook                                                                
                                                           k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook                                                              
                                                           k8s:longhorn.io/recovery-backend=longhorn-recovery-backend                                                                  
2904       Disabled (Audit)   Disabled          34352      k8s:app.kubernetes.io/component=Agent                                                                  10.0.6.33    ready   
                                                           k8s:app.kubernetes.io/instance=victorialogs                                                                                 
                                                           k8s:app.kubernetes.io/name=vector                                                                                           
                                                           k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring                                                   
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                           k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector                                                                 
                                                           k8s:io.kubernetes.pod.namespace=monitoring                                                                                  
                                                           k8s:vector.dev/exclude=true                                                                                                 
3368       Disabled (Audit)   Disabled          43550      k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                         10.0.6.166   ready   
                                                           k8s:io.cilium.k8s.policy.cluster=default                                                                                    
                                                           k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                            
                                                           k8s:io.kubernetes.pod.namespace=longhorn-system                                                                             
                                                           k8s:longhorn.io/component=engine-image                                                                                      
                                                           k8s:longhorn.io/engine-image=ei-e09d8caa                                                                                    
```

#### BPF Policy Get 158

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          9808/TCP     NONE         disabled    27795     313       24       0
Allow    Ingress     1          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2          9808/TCP     NONE         disabled    2531721   28480     24       0
Allow    Ingress     2          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     7          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29395      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    430314    5392      0        0

```


#### BPF CT List 158

```
Invalid argument: unknown type 158
```


#### Endpoint Get 158

```
[
  {
    "id": 158,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-158-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "e90222bf-1e8e-4f9d-a3da-9bbdaaef2386"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/longhorn-csi-plugin-hgs45",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:56.306Z",
            "success-count": 2
          },
          "uuid": "60350d4e-eba8-415d-8796-6a9e52a66f9f"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (158)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "69d3c3f2-e4b6-4aa9-bbbc-abb98286fa9c"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-158",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:56.267Z",
            "success-count": 32
          },
          "uuid": "850b51de-8b9a-4557-b0b1-b4167459839d"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (158)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:22.702Z",
            "success-count": 2818
          },
          "uuid": "93c77edf-ba2f-4582-95f2-461066e6732f"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (158)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "9b950e27-f27d-4b63-b3e6-3cf732e93f06"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "4634d5938c6e7b13d24b490c1e9d5c8ab0cf855ada17da089ea07a34a090e530:eth0",
        "container-id": "4634d5938c6e7b13d24b490c1e9d5c8ab0cf855ada17da089ea07a34a090e530",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "longhorn-csi-plugin-hgs45",
        "pod-name": "longhorn-system/longhorn-csi-plugin-hgs45"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 28201,
        "labels": [
          "k8s:app=longhorn-csi-plugin",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=5769d89c9f",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=longhorn-csi-plugin",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:07:51Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.6.214",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "a6:9c:b3:15:12:fb",
        "interface-index": 18,
        "interface-name": "lxcf64cf074e5ab",
        "mac": "26:8c:e6:9a:84:e5"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 28201,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                  ]
                ],
                "rule": "{\"port\":9808,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 28201,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                  ]
                ],
                "rule": "{\"port\":9808,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 158

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 158

```
Timestamp              Status   State                   Message
2026-01-19T22:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 28201

```
ID      LABELS
28201   k8s:app=longhorn-csi-plugin
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system

```


#### BPF Policy Get 376

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES   PACKETS   PREFIX   COOKIE
Allow    Ingress     0          ANY          NONE         disabled    -       -         0        0
Allow    Egress      0          ANY          NONE         disabled    -       -         0        0

```


#### BPF CT List 376

```
Invalid argument: unknown type 376
```


#### Endpoint Get 376

```
[
  {
    "id": 376,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-376-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "37b2b934-ab73-4fb6-a28d-f4a83e1e7d80"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-/",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.590Z",
            "success-count": 1
          },
          "uuid": "625c2ee4-1382-4ac7-9280-230f0d313f15"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (376)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "b9e90625-75ca-4f9d-91db-ec4a25544478"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-376",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:56.359Z",
            "success-count": 32
          },
          "uuid": "2981202f-74f3-437d-84a2-94c210694911"
        }
      ],
      "external-identifiers": {
        "pod-name": "/"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 1,
        "labels": [
          "reserved:host",
          "k8s:k3s-upgrade=true",
          "k8s:node.kubernetes.io/instance-type=k3s",
          "k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812"
        ]
      },
      "labels": {
        "derived": [
          "k8s:k3s-upgrade=true",
          "k8s:node.kubernetes.io/instance-type=k3s",
          "k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812",
          "reserved:host"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:k3s-upgrade=true",
          "k8s:node.kubernetes.io/instance-type=k3s",
          "k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812",
          "reserved:host"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:07:51Z"
        }
      ],
      "networking": {
        "addressing": [
          {}
        ],
        "host-mac": "a6:bc:89:41:52:dc",
        "interface-index": 6,
        "interface-name": "cilium_host",
        "mac": "a6:bc:89:41:52:dc"
      },
      "policy": {
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            0
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 1,
          "l4": {
            "egress": [],
            "ingress": []
          },
          "policy-enabled": "none",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            0
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 1,
          "l4": {
            "egress": [],
            "ingress": []
          },
          "policy-enabled": "none",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 376

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 376

```
Timestamp              Status   State                   Message
2026-01-19T22:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 1

```
ID   LABELS
1    reserved:host

```


#### BPF Policy Get 435

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES        PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    32372        378       0        0
Allow    Ingress     2          ANY          NONE         disabled    2534892      29544     0        0
Allow    Ingress     9          ANY          NONE         disabled    -            -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -            -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -            -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -            -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    155288       846       0        0
Allow    Ingress     5993       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -            -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    2935718054   846509    0        0
Allow    Ingress     33454      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    5047961      29040     0        0
Allow    Ingress     41969      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -            -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -            -         0        0
Allow    Egress      0          ANY          NONE         disabled    -            -         0        0

```


#### BPF CT List 435

```
Invalid argument: unknown type 435
```


#### Endpoint Get 435

```
[
  {
    "id": 435,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-435-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "6fc79032-4a74-45aa-940c-ee0fcb53aa41"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-monitoring/vmsingle-vmetrics-victoria-metrics-k8s-stack-7995bbfdc8-jgphq",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:56.276Z",
            "success-count": 2
          },
          "uuid": "d8e8ab95-9f45-4bd6-bfc9-8c10fa6694a5"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (435)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "e03cb4e4-9c5c-4092-81da-8944611bab5e"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-435",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:56.246Z",
            "success-count": 32
          },
          "uuid": "25ae9672-5306-410b-b112-611bd5841e7f"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (435)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:22.701Z",
            "success-count": 2818
          },
          "uuid": "46d0c9e8-4660-44df-a700-d1894300a716"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (435)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "caa3b218-5b7d-4d56-b304-ead786a00ab6"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "c86ec7cb4d928534689e297a2dacefc6df19d22527c886c4ee74f72f0fab4d9b:eth0",
        "container-id": "c86ec7cb4d928534689e297a2dacefc6df19d22527c886c4ee74f72f0fab4d9b",
        "k8s-namespace": "monitoring",
        "k8s-pod-name": "vmsingle-vmetrics-victoria-metrics-k8s-stack-7995bbfdc8-jgphq",
        "pod-name": "monitoring/vmsingle-vmetrics-victoria-metrics-k8s-stack-7995bbfdc8-jgphq"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 53293,
        "labels": [
          "k8s:app.kubernetes.io/component=monitoring",
          "k8s:app.kubernetes.io/instance=vmetrics-victoria-metrics-k8s-stack",
          "k8s:app.kubernetes.io/name=vmsingle",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=vmsingle-vmetrics-victoria-metrics-k8s-stack",
          "k8s:io.kubernetes.pod.namespace=monitoring",
          "k8s:managed-by=vm-operator"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=7995bbfdc8"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/component=monitoring",
          "k8s:app.kubernetes.io/instance=vmetrics-victoria-metrics-k8s-stack",
          "k8s:app.kubernetes.io/name=vmsingle",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=vmsingle-vmetrics-victoria-metrics-k8s-stack",
          "k8s:io.kubernetes.pod.namespace=monitoring",
          "k8s:managed-by=vm-operator"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:07:51Z"
        }
      ],
      "namedPorts": [
        {
          "name": "http",
          "port": 8428,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.6.169",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "e2:1c:02:e2:e6:12",
        "interface-index": 34,
        "interface-name": "lxc46a98f8f4902",
        "mac": "76:a3:29:f7:6d:41"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 53293,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 53293,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 435

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 435

```
Timestamp              Status   State                   Message
2026-01-19T22:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 53293

```
ID      LABELS
53293   k8s:app.kubernetes.io/component=monitoring
        k8s:app.kubernetes.io/instance=vmetrics-victoria-metrics-k8s-stack
        k8s:app.kubernetes.io/name=vmsingle
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=vmsingle-vmetrics-victoria-metrics-k8s-stack
        k8s:io.kubernetes.pod.namespace=monitoring
        k8s:managed-by=vm-operator

```


#### BPF Policy Get 745

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES       PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    35924       420       0        0
Allow    Ingress     2          ANY          NONE         disabled    2961300     34583     0        0
Allow    Ingress     9          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -           -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    3272879     19301     0        0
Allow    Ingress     5993       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    3379249     45398     0        0
Allow    Ingress     33454      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -           -         0        0
Allow    Egress      0          ANY          NONE         disabled    694058562   2513684   0        0

```


#### BPF CT List 745

```
Invalid argument: unknown type 745
```


#### Endpoint Get 745

```
[
  {
    "id": 745,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-745-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "6e736ceb-82a4-478e-ac84-7bc948a3da3e"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-redacted-dev/redacted-wetteralarm-job-dev-68c58fb997-xbhdk",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:56.318Z",
            "success-count": 2
          },
          "uuid": "628a66a2-2edd-4bcc-b5e7-7a95af5e4504"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (745)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "00e386b9-7ccd-43fe-816a-0baec1140da9"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-745",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:56.267Z",
            "success-count": 32
          },
          "uuid": "69cd4431-a45f-4a14-b426-d9477bb555de"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (745)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:22.701Z",
            "success-count": 2818
          },
          "uuid": "a2e9bd9b-4b6a-4b55-b4b2-4969f354dd4b"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (745)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "2abbdf39-0009-4139-aa04-b58d3ea6162d"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "2ac618ef334965a4b097c136d8ccaac778c947e7d8774b34418b14d944d71e0f:eth0",
        "container-id": "2ac618ef334965a4b097c136d8ccaac778c947e7d8774b34418b14d944d71e0f",
        "k8s-namespace": "redacted-dev",
        "k8s-pod-name": "redacted-wetteralarm-job-dev-68c58fb997-xbhdk",
        "pod-name": "redacted-dev/redacted-wetteralarm-job-dev-68c58fb997-xbhdk"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 39699,
        "labels": [
          "k8s:app=redacted-wetteralarm-job-dev",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=redacted-dev"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=68c58fb997"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=redacted-wetteralarm-job-dev",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=redacted-dev"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:07:51Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.6.212",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "fa:45:5c:10:e5:99",
        "interface-index": 24,
        "interface-name": "lxc679c5656f262",
        "mac": "f2:01:9a:af:49:f7"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 39699,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 39699,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 745

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 745

```
Timestamp              Status   State                   Message
2026-01-19T22:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 39699

```
ID      LABELS
39699   k8s:app=redacted-wetteralarm-job-dev
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=default
        k8s:io.kubernetes.pod.namespace=redacted-dev

```


#### BPF Policy Get 1575

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES         PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    63331516      26054     0        0
Allow    Ingress     2          ANY          NONE         disabled    5505791720    2277182   0        0
Allow    Ingress     9          ANY          NONE         disabled    -             -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -             -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -             -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -             -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    26540118      238280    0        0
Allow    Ingress     4988       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -             -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    28311060      328310    0        0
Allow    Ingress     23582      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -             -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -             -         0        0
Allow    Egress      0          ANY          NONE         disabled    12437720311   2798420   0        0

```


#### BPF CT List 1575

```
Invalid argument: unknown type 1575
```


#### Endpoint Get 1575

```
[
  {
    "id": 1575,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1575-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "6f3560cb-5f58-4696-b67d-60dc337bbf3d"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/instance-manager-ac9872fca799281e77c29b3929ae84fd",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:56.309Z",
            "success-count": 2
          },
          "uuid": "eadaaf0d-c22f-438a-b4a6-abaf7374a5a4"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (1575)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "717eb1bc-8c48-4a00-85d3-5237b6d8ec74"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1575",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:56.267Z",
            "success-count": 32
          },
          "uuid": "e1175e5a-4599-4062-96f8-b6a423f38029"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (1575)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:22.701Z",
            "success-count": 2818
          },
          "uuid": "fdba5aeb-a497-49ff-b15a-9696b014fec9"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (1575)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "16e5d43d-14c9-41dd-8531-b345e9f1fd10"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "78febe2b321e5fc8a7454798d4d154bd963525aa1d4901aec8b15157e3c197af:eth0",
        "container-id": "78febe2b321e5fc8a7454798d4d154bd963525aa1d4901aec8b15157e3c197af",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "instance-manager-ac9872fca799281e77c29b3929ae84fd",
        "pod-name": "longhorn-system/instance-manager-ac9872fca799281e77c29b3929ae84fd"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 17163,
        "labels": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=instance-manager",
          "k8s:longhorn.io/data-engine=v1",
          "k8s:longhorn.io/instance-manager-image=imi-29909444",
          "k8s:longhorn.io/instance-manager-type=aio",
          "k8s:longhorn.io/managed-by=longhorn-manager",
          "k8s:longhorn.io/node=dev-agent-01"
        ]
      },
      "labels": {
        "realized": {},
        "security-relevant": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=instance-manager",
          "k8s:longhorn.io/data-engine=v1",
          "k8s:longhorn.io/instance-manager-image=imi-29909444",
          "k8s:longhorn.io/instance-manager-type=aio",
          "k8s:longhorn.io/managed-by=longhorn-manager",
          "k8s:longhorn.io/node=dev-agent-01"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:07:51Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.6.110",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "ba:71:fd:24:d5:46",
        "interface-index": 22,
        "interface-name": "lxce14383dc9a05",
        "mac": "ee:b3:9a:a2:c1:f1"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 17163,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=instance-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 17163,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=instance-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: backing-image-data-source,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/component: instance-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=instance-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=2ff1f074-01bb-452c-85e6-a10cc548b287"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1575

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1575

```
Timestamp              Status   State                   Message
2026-01-19T22:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 17163

```
ID      LABELS
17163   k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system
        k8s:longhorn.io/component=instance-manager
        k8s:longhorn.io/data-engine=v1
        k8s:longhorn.io/instance-manager-image=imi-29909444
        k8s:longhorn.io/instance-manager-type=aio
        k8s:longhorn.io/managed-by=longhorn-manager
        k8s:longhorn.io/node=dev-agent-01

```


#### BPF Policy Get 1979

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES    PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    275303   3230      0        0
Allow    Ingress     2          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -        -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -        -         0        0
Allow    Egress      0          ANY          NONE         disabled    -        -         0        0

```


#### BPF CT List 1979

```
Invalid argument: unknown type 1979
```


#### Endpoint Get 1979

```
[
  {
    "id": 1979,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-1979-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "bd21dea3-35de-4cf8-b32e-a91be9cef5e9"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "5m0s"
          },
          "name": "resolve-identity-1979",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:52.345Z",
            "success-count": 94
          },
          "uuid": "d397240d-bff4-4093-952c-0430e9608ba3"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-1979",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:56.267Z",
            "success-count": 32
          },
          "uuid": "63a7180a-515f-488a-9e1d-10c47e6a64f1"
        }
      ],
      "external-identifiers": {
        "container-name": "cilium-health",
        "pod-name": "/"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4,
        "labels": [
          "reserved:health"
        ]
      },
      "labels": {
        "realized": {},
        "security-relevant": [
          "reserved:health"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:07:51Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.6.104",
            "ipv4-pool-name": "default"
          }
        ],
        "host-mac": "7a:8e:46:4d:db:c9",
        "interface-index": 36,
        "interface-name": "lxc_health",
        "mac": "46:0f:ce:f4:f6:be"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 1979

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 1979

```
Timestamp              Status   State                   Message
2026-01-19T22:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4

```
ID   LABELS
4    reserved:health

```


#### BPF Policy Get 2136

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    15282     189       0        0
Allow    Ingress     2          ANY          NONE         disabled    1074192   13301     0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    -         -         0        0

```


#### BPF CT List 2136

```
Invalid argument: unknown type 2136
```


#### Endpoint Get 2136

```
[
  {
    "id": 2136,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-2136-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "ae4c060d-59b2-41bd-aaf9-ae5d4aa483e6"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-monitoring/kured-ltrpm",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:56.280Z",
            "success-count": 2
          },
          "uuid": "61a64268-743f-4a90-9559-b9899f0c1147"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (2136)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "ff45fd76-cd5e-4930-8f38-cbcad21880ac"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-2136",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:56.240Z",
            "success-count": 32
          },
          "uuid": "714cf5be-1da7-4cd5-ba0a-f82ea5a8a0c4"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (2136)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:22.701Z",
            "success-count": 2818
          },
          "uuid": "c5f6ed53-7f9e-4010-bb8c-d73680894bf4"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (2136)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "40e05753-8b9a-452f-b944-ff7328845d1e"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "2c23e8be96a3f54de5335f4d48de785a483d8695784e9b8dd8f0f1a4f4216216:eth0",
        "container-id": "2c23e8be96a3f54de5335f4d48de785a483d8695784e9b8dd8f0f1a4f4216216",
        "k8s-namespace": "monitoring",
        "k8s-pod-name": "kured-ltrpm",
        "pod-name": "monitoring/kured-ltrpm"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4988,
        "labels": [
          "k8s:app.kubernetes.io/instance=kured",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=kured",
          "k8s:helm.sh/chart=kured-5.6.2",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kured",
          "k8s:io.kubernetes.pod.namespace=monitoring"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=796657747b",
          "k8s:pod-template-generation=4"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=kured",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=kured",
          "k8s:helm.sh/chart=kured-5.6.2",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kured",
          "k8s:io.kubernetes.pod.namespace=monitoring"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:07:51Z"
        }
      ],
      "namedPorts": [
        {
          "name": "metrics",
          "port": 8080,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.6.181",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "c6:71:dd:01:64:ce",
        "interface-index": 12,
        "interface-name": "lxc9ee35a282fb3",
        "mac": "fa:29:c2:8f:68:d0"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4988,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4988,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 2136

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 2136

```
Timestamp              Status   State                   Message
2026-01-19T22:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4988

```
ID     LABELS
4988   k8s:app.kubernetes.io/instance=kured
       k8s:app.kubernetes.io/managed-by=Helm
       k8s:app.kubernetes.io/name=kured
       k8s:helm.sh/chart=kured-5.6.2
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=kured
       k8s:io.kubernetes.pod.namespace=monitoring

```


#### BPF Policy Get 2890

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES      PACKETS   PREFIX   COOKIE
Allow    Ingress     0          9503/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     0          9502/TCP     NONE         disabled    406206     616       24       0
Allow    Ingress     1          9501/TCP     NONE         disabled    86177      404       24       0
Allow    Ingress     1          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2          ANY          NONE         disabled    6372066    29698     0        0
Allow    Ingress     6          9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     7          9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     9          ANY          NONE         disabled    -          -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -          -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -          -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1252       9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     1252       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3446       9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     3446       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     4394       9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     4394       ANY          NONE         disabled    240893     1832      0        0
Allow    Ingress     4988       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6043       9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     6043       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     8453       9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     8779       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -          -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15473      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     15505      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     17163      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     17163      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19572      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     19572      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     23106      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     23106      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     27422      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     27422      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    646806     7723      0        0
Allow    Ingress     28201      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     28530      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29163      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     29163      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29395      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     29994      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     29994      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     31674      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     34995      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     35682      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39166      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     39166      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43339      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     43339      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     43550      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     43616      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    1321175    19482     0        0
Allow    Ingress     47918      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     48334      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     49075      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     49276      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     53439      9501/TCP     NONE         disabled    -          -         24       0
Allow    Ingress     54396      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -          -         0        0
Allow    Ingress     16777217   9501/TCP     NONE         disabled    -          -         24       0
Allow    Egress      0          ANY          NONE         disabled    97340775   826376    0        0

```


#### BPF CT List 2890

```
Invalid argument: unknown type 2890
```


#### Endpoint Get 2890

```
[
  {
    "id": 2890,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-2890-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "f979cab5-cd8e-44ad-9fc2-251ee964d3db"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/longhorn-manager-lv2c5",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:56.280Z",
            "success-count": 2
          },
          "uuid": "5c5800dc-9514-4517-9456-185bbdacdad7"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (2890)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "a07512fe-c2e4-4bb2-8079-648bc8b7144b"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-2890",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:56.246Z",
            "success-count": 32
          },
          "uuid": "996c498f-7134-46fb-ac27-d63e1799c956"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (2890)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:22.701Z",
            "success-count": 2818
          },
          "uuid": "7d8def2b-e3b5-48e8-8c8c-128aaef25629"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (2890)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "47321d25-148e-4602-b44f-5e659ff1ff52"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "61c5efd378162134f08227408d231826296e0b577b3b05b4a6e1d539e99f63f0:eth0",
        "container-id": "61c5efd378162134f08227408d231826296e0b577b3b05b4a6e1d539e99f63f0",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "longhorn-manager-lv2c5",
        "pod-name": "longhorn-system/longhorn-manager-lv2c5"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4394,
        "labels": [
          "k8s:app=longhorn-manager",
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/admission-webhook=longhorn-admission-webhook",
          "k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook",
          "k8s:longhorn.io/recovery-backend=longhorn-recovery-backend"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=55566b9bd7",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:app=longhorn-manager",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/admission-webhook=longhorn-admission-webhook",
          "k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook",
          "k8s:longhorn.io/recovery-backend=longhorn-recovery-backend"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:07:51Z"
        }
      ],
      "namedPorts": [
        {
          "name": "admission-wh",
          "port": 9502,
          "protocol": "TCP"
        },
        {
          "name": "conversion-wh",
          "port": 9501,
          "protocol": "TCP"
        },
        {
          "name": "manager",
          "port": 9500,
          "protocol": "TCP"
        },
        {
          "name": "recov-backend",
          "port": 9503,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.6.35",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "ba:fc:9e:1d:e3:49",
        "interface-index": 16,
        "interface-name": "lxcdaae7de08c30",
        "mac": "ee:64:97:80:5e:fe"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4394,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                  ]
                ],
                "rule": "{\"port\":9501,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                  ]
                ],
                "rule": "{\"port\":9502,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                  ]
                ],
                "rule": "{\"port\":9503,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4394,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                  ]
                ],
                "rule": "{\"port\":9501,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                  ]
                ],
                "rule": "{\"port\":9502,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                  ]
                ],
                "rule": "{\"port\":9503,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 2890

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 2890

```
Timestamp              Status   State                   Message
2026-01-19T22:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4394

```
ID     LABELS
4394   k8s:app.kubernetes.io/instance=longhorn
       k8s:app.kubernetes.io/managed-by=Helm
       k8s:app.kubernetes.io/name=longhorn
       k8s:app.kubernetes.io/version=v1.9.0
       k8s:app=longhorn-manager
       k8s:helm.sh/chart=longhorn-1.9.0
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
       k8s:io.kubernetes.pod.namespace=longhorn-system
       k8s:longhorn.io/admission-webhook=longhorn-admission-webhook
       k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook
       k8s:longhorn.io/recovery-backend=longhorn-recovery-backend

```


#### BPF Policy Get 2904

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES        PACKETS    PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     10         ANY          NONE         disabled    -            -          0        0
Allow    Ingress     465        ANY          NONE         disabled    -            -          0        0
Allow    Ingress     566        ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1252       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1596       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1624       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1637       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2269       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2645       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2833       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2843       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2978       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3128       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3446       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3592       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3761       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3836       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3866       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     4394       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     4988       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5015       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5080       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5117       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5438       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5493       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5643       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5993       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6043       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6344       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6933       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     7513       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     7936       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8105       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8231       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8241       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8367       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8453       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8779       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9194       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9585       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     10807      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     11332      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12176      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12201      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12307      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12337      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13556      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13626      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13786      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14280      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14657      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14667      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14966      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14973      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15202      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15473      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15505      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15927      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16376      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16908      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16992      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     17163      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     17926      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     18592      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     18622      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19324      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19460      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19572      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19792      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19881      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19945      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     20806      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     22863      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     22922      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     23106      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     23582      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     24706      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     24736      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25152      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25226      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25555      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25589      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26001      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26267      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26869      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26892      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     27422      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     27486      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28201      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28530      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28621      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29089      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29163      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29395      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29994      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     31674      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     31840      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     32467      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33088      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33311      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33454      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33688      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33755      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34216      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34266      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34352      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34736      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34995      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     35682      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     35696      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     36596      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     37415      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     37517      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     38491      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39166      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39278      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39699      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     40088      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     41969      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42199      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42605      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42869      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43339      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43550      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43616      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     47483      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     47918      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     48334      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     48593      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     49075      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     49276      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52241      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52642      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52772      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53263      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53293      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53439      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     54396      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     54583      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     55202      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     55741      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     57633      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     58710      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60465      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60492      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60523      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     61421      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     61927      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     62026      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     63330      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     64556      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     65239      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -            -          0        0
Allow    Egress      0          ANY          NONE         disabled    3428635334   19933576   0        0

```


#### BPF CT List 2904

```
Invalid argument: unknown type 2904
```


#### Endpoint Get 2904

```
[
  {
    "id": 2904,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-2904-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "ed1bbed3-2c13-4cc7-8a35-c6dc90aef2a3"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-monitoring/victorialogs-vector-xw5lq",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:56.277Z",
            "success-count": 2
          },
          "uuid": "0e7d8f30-c3b7-48fb-a44c-839b49021bde"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (2904)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "926859b2-609c-46f3-a353-4e3fb378f02a"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-2904",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:56.240Z",
            "success-count": 32
          },
          "uuid": "f2ed9d98-9178-4bac-8df3-655fe1ff7af3"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (2904)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:22.701Z",
            "success-count": 2818
          },
          "uuid": "2aede9cd-6251-4513-b985-f8d26435ecbb"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (2904)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "53229dee-188e-41d1-ac11-eeac24bfe4c5"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "7cf5cd0192d5a75637147f2e6311dc6879fd9d1572815162a9ccb3a667be607e:eth0",
        "container-id": "7cf5cd0192d5a75637147f2e6311dc6879fd9d1572815162a9ccb3a667be607e",
        "k8s-namespace": "monitoring",
        "k8s-pod-name": "victorialogs-vector-xw5lq",
        "pod-name": "monitoring/victorialogs-vector-xw5lq"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 34352,
        "labels": [
          "k8s:app.kubernetes.io/component=Agent",
          "k8s:app.kubernetes.io/instance=victorialogs",
          "k8s:app.kubernetes.io/name=vector",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector",
          "k8s:io.kubernetes.pod.namespace=monitoring",
          "k8s:vector.dev/exclude=true"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=547c594464",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/component=Agent",
          "k8s:app.kubernetes.io/instance=victorialogs",
          "k8s:app.kubernetes.io/name=vector",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector",
          "k8s:io.kubernetes.pod.namespace=monitoring",
          "k8s:vector.dev/exclude=true"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:07:51Z"
        }
      ],
      "namedPorts": [
        {
          "name": "prom-exporter",
          "port": 9090,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.6.33",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "2a:bf:cb:1b:28:b6",
        "interface-index": 14,
        "interface-name": "lxcf35ea8d4b04e",
        "mac": "4e:87:57:58:e6:b4"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 34352,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 34352,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 2904

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 2904

```
Timestamp              Status   State                   Message
2026-01-19T22:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 34352

```
ID      LABELS
34352   k8s:app.kubernetes.io/component=Agent
        k8s:app.kubernetes.io/instance=victorialogs
        k8s:app.kubernetes.io/name=vector
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector
        k8s:io.kubernetes.pod.namespace=monitoring
        k8s:vector.dev/exclude=true

```


#### BPF Policy Get 3368

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES   PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -       -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -       -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -       -         0        0
Allow    Egress      0          ANY          NONE         disabled    -       -         0        0

```


#### BPF CT List 3368

```
Invalid argument: unknown type 3368
```


#### Endpoint Get 3368

```
[
  {
    "id": 3368,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-3368-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "2705b987-bdcb-49e0-9c99-23554059e423"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/engine-image-ei-e09d8caa-6csmp",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:56.283Z",
            "success-count": 2
          },
          "uuid": "7071763c-812f-4a13-91e6-89d2ab1bee92"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (3368)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "a2676611-83a8-4278-b229-1b3bf7bc179b"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-3368",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:56.251Z",
            "success-count": 32
          },
          "uuid": "9633721f-0fa3-4812-95e8-c00324044642"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (3368)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:22.701Z",
            "success-count": 2818
          },
          "uuid": "16379e7b-7a60-418e-a401-81dbd541fd5e"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (3368)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:51.283Z",
            "success-count": 1
          },
          "uuid": "47e1f4ea-1bba-4858-80c9-38e527ef81d9"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "72d48563019c0e1a3c4cee9138412391d923aa1bb062834ecca9189e9403018c:eth0",
        "container-id": "72d48563019c0e1a3c4cee9138412391d923aa1bb062834ecca9189e9403018c",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "engine-image-ei-e09d8caa-6csmp",
        "pod-name": "longhorn-system/engine-image-ei-e09d8caa-6csmp"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 43550,
        "labels": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=engine-image",
          "k8s:longhorn.io/engine-image=ei-e09d8caa"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=76b647f6f7",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=engine-image",
          "k8s:longhorn.io/engine-image=ei-e09d8caa"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:07:51Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.6.166",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "86:a3:fc:dd:38:f3",
        "interface-index": 20,
        "interface-name": "lxc32a763784f75",
        "mac": "c6:68:9b:22:8f:f1"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43550,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43550,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 3368

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 3368

```
Timestamp              Status   State                   Message
2026-01-19T22:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:59:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:59:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:59:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:57:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:57:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:57:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:55:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:55:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:55:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:53:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:53:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:53:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:51:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:51:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:51:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:49:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:49:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:49:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:47:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:47:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:47:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:45:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:45:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:45:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:43:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:43:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:43:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:41:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:41:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:41:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:39:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:39:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:39:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:37:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:37:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:37:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:35:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:35:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:35:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:33:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:33:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:33:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:31:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:31:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:31:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:29:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:29:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:29:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:27:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:27:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:27:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:25:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:25:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:25:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:23:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:23:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:23:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:21:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:21:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:21:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:19:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:19:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:19:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:17:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:17:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:17:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:15:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:15:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:15:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:13:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:13:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:13:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:11:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:11:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:11:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:09:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:09:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:09:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:07:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:07:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:07:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:05:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:05:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:05:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:03:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:03:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:03:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:01:51Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:01:51Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:01:51Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 43550

```
ID      LABELS
43550   k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system
        k8s:longhorn.io/component=engine-image
        k8s:longhorn.io/engine-image=ei-e09d8caa

```


#### Service list

```
ID   Frontend                  Service Type   Backend                                   
1    10.43.140.7:9402/TCP      ClusterIP      1 => 10.0.8.198:9402/TCP (active)         
2    10.43.143.190:443/TCP     ClusterIP      1 => 10.0.8.196:10250/TCP (active)        
3    10.43.235.23:443/TCP      ClusterIP      1 => 10.0.11.242:9443/TCP (active)        
4    10.43.0.1:443/TCP         ClusterIP      1 => 192.168.100.10:6443/TCP (active)     
                                              2 => 192.168.100.11:6443/TCP (active)     
                                              3 => 192.168.100.12:6443/TCP (active)     
5    10.43.137.234:80/TCP      ClusterIP      1 => 10.0.11.78:8080/TCP (active)         
6    10.43.182.35:5432/TCP     ClusterIP      1 => 10.0.2.69:5432/TCP (active)          
7    10.43.185.45:80/TCP       ClusterIP      1 => 10.0.12.243:8080/TCP (maintenance)   
8    10.43.120.177:80/TCP      ClusterIP      1 => 10.0.2.144:8080/TCP (active)         
9    10.43.173.175:6379/TCP    ClusterIP      1 => 10.0.2.94:6379/TCP (active)          
10   10.43.155.42:5000/TCP     ClusterIP      1 => 10.0.2.111:5000/TCP (active)         
11   10.43.155.42:8080/TCP     ClusterIP      1 => 10.0.2.111:8080/TCP (active)         
12   10.43.56.177:8080/TCP     ClusterIP      1 => 10.0.11.214:8080/TCP (active)        
13   10.43.135.54:80/TCP       ClusterIP      1 => 10.0.0.220:80/TCP (active)           
                                              2 => 10.0.2.88:80/TCP (active)            
                                              3 => 10.0.13.209:80/TCP (active)          
14   10.43.135.54:443/TCP      ClusterIP      1 => 10.0.0.220:443/TCP (active)          
                                              2 => 10.0.2.88:443/TCP (active)           
                                              3 => 10.0.13.209:443/TCP (active)         
18   0.0.0.0:30908/TCP         NodePort       1 => 10.0.0.220:443/TCP (active)          
                                              2 => 10.0.2.88:443/TCP (active)           
                                              3 => 10.0.13.209:443/TCP (active)         
19   0.0.0.0:31337/TCP         NodePort       1 => 10.0.0.220:80/TCP (active)           
                                              2 => 10.0.2.88:80/TCP (active)            
                                              3 => 10.0.13.209:80/TCP (active)          
23   10.43.241.115:443/TCP     ClusterIP      1 => 10.0.0.220:8443/TCP (active)         
                                              2 => 10.0.2.88:8443/TCP (active)          
                                              3 => 10.0.13.209:8443/TCP (active)        
24   10.43.4.93:9091/TCP       ClusterIP      1 => 10.0.5.46:9091/TCP (maintenance)     
                                              2 => 10.0.8.124:9091/TCP (maintenance)    
                                              3 => 10.0.11.189:9091/TCP (maintenance)   
25   10.43.4.93:9092/TCP       ClusterIP      1 => 10.0.5.46:9092/TCP (maintenance)     
                                              2 => 10.0.8.124:9092/TCP (maintenance)    
                                              3 => 10.0.11.189:9092/TCP (maintenance)   
26   10.43.4.93:9093/TCP       ClusterIP      1 => 10.0.5.46:9093/TCP (maintenance)     
                                              2 => 10.0.8.124:9093/TCP (maintenance)    
                                              3 => 10.0.11.189:9093/TCP (maintenance)   
27   10.43.254.4:443/TCP       ClusterIP      1 => 192.168.100.20:4244/TCP (active)     
28   10.43.135.114:80/TCP      ClusterIP      1 => 10.0.8.116:4245/TCP (active)         
29   10.43.52.21:80/TCP        ClusterIP      1 => 10.0.0.107:8081/TCP (active)         
30   10.43.0.10:9153/TCP       ClusterIP      1 => 10.0.2.158:9153/TCP (active)         
31   10.43.0.10:53/UDP         ClusterIP      1 => 10.0.2.158:53/UDP (active)           
32   10.43.0.10:53/TCP         ClusterIP      1 => 10.0.2.158:53/TCP (active)           
33   10.43.159.1:443/TCP       ClusterIP      1 => 10.0.2.237:10250/TCP (active)        
34   10.43.82.123:8123/TCP     ClusterIP      1 => 10.0.10.192:8123/TCP (active)        
                                              2 => 10.0.13.1:8123/TCP (active)          
                                              3 => 10.0.14.236:8123/TCP (active)        
35   10.43.82.123:9000/TCP     ClusterIP      1 => 10.0.10.192:9000/TCP (active)        
                                              2 => 10.0.13.1:9000/TCP (active)          
                                              3 => 10.0.14.236:9000/TCP (active)        
36   10.43.82.123:9004/TCP     ClusterIP      1 => 10.0.10.192:9004/TCP (active)        
                                              2 => 10.0.13.1:9004/TCP (active)          
                                              3 => 10.0.14.236:9004/TCP (active)        
37   10.43.82.123:9005/TCP     ClusterIP      1 => 10.0.10.192:9005/TCP (active)        
                                              2 => 10.0.13.1:9005/TCP (active)          
                                              3 => 10.0.14.236:9005/TCP (active)        
38   10.43.82.123:9009/TCP     ClusterIP      1 => 10.0.10.192:9009/TCP (active)        
                                              2 => 10.0.13.1:9009/TCP (active)          
                                              3 => 10.0.14.236:9009/TCP (active)        
39   10.43.208.117:5432/TCP    ClusterIP      1 => 10.0.9.80:5432/TCP (active)          
40   10.43.104.20:6379/TCP     ClusterIP      1 => 10.0.9.89:6379/TCP (maintenance)     
41   10.43.13.77:9000/TCP      ClusterIP      1 => 10.0.11.36:9000/TCP (active)         
42   10.43.13.77:9001/TCP      ClusterIP      1 => 10.0.11.36:9001/TCP (active)         
43   10.43.2.220:3000/TCP      ClusterIP      1 => 10.0.9.5:3000/TCP (maintenance)      
44   10.43.57.80:2181/TCP      ClusterIP      1 => 10.0.8.28:2181/TCP (active)          
                                              2 => 10.0.9.46:2181/TCP (active)          
                                              3 => 10.0.11.66:2181/TCP (maintenance)    
45   10.43.57.80:2888/TCP      ClusterIP      1 => 10.0.8.28:2888/TCP (active)          
                                              2 => 10.0.9.46:2888/TCP (active)          
                                              3 => 10.0.11.66:2888/TCP (maintenance)    
46   10.43.57.80:3888/TCP      ClusterIP      1 => 10.0.8.28:3888/TCP (active)          
                                              2 => 10.0.9.46:3888/TCP (active)          
                                              3 => 10.0.11.66:3888/TCP (maintenance)    
47   10.43.177.85:5558/TCP     ClusterIP      1 => 10.0.2.90:5558/TCP (active)          
48   10.43.177.85:8089/TCP     ClusterIP      1 => 10.0.2.90:8089/TCP (active)          
49   10.43.177.85:5557/TCP     ClusterIP      1 => 10.0.2.90:5557/TCP (active)          
50   10.43.134.50:9502/TCP     ClusterIP      1 => 10.0.0.68:9502/TCP (active)          
                                              2 => 10.0.2.190:9502/TCP (active)         
                                              3 => 10.0.5.87:9502/TCP (active)          
                                              4 => 10.0.6.35:9502/TCP (active)          
                                              5 => 10.0.7.203:9502/TCP (active)         
                                              6 => 10.0.8.150:9502/TCP (active)         
                                              7 => 10.0.9.211:9502/TCP (active)         
                                              8 => 10.0.10.111:9502/TCP (active)        
                                              9 => 10.0.11.30:9502/TCP (active)         
                                              10 => 10.0.12.24:9502/TCP (active)        
                                              11 => 10.0.13.16:9502/TCP (active)        
                                              12 => 10.0.14.170:9502/TCP (active)       
51   10.43.4.198:9500/TCP      ClusterIP      1 => 10.0.0.68:9500/TCP (active)          
                                              2 => 10.0.2.190:9500/TCP (active)         
                                              3 => 10.0.5.87:9500/TCP (active)          
                                              4 => 10.0.6.35:9500/TCP (active)          
                                              5 => 10.0.7.203:9500/TCP (active)         
                                              6 => 10.0.8.150:9500/TCP (active)         
                                              7 => 10.0.9.211:9500/TCP (active)         
                                              8 => 10.0.10.111:9500/TCP (active)        
                                              9 => 10.0.11.30:9500/TCP (active)         
                                              10 => 10.0.12.24:9500/TCP (active)        
                                              11 => 10.0.13.16:9500/TCP (active)        
                                              12 => 10.0.14.170:9500/TCP (active)       
52   10.43.105.144:9501/TCP    ClusterIP      1 => 10.0.0.68:9501/TCP (active)          
                                              2 => 10.0.2.190:9501/TCP (active)         
                                              3 => 10.0.5.87:9501/TCP (active)          
                                              4 => 10.0.6.35:9501/TCP (active)          
                                              5 => 10.0.7.203:9501/TCP (active)         
                                              6 => 10.0.8.150:9501/TCP (active)         
                                              7 => 10.0.9.211:9501/TCP (active)         
                                              8 => 10.0.10.111:9501/TCP (active)        
                                              9 => 10.0.11.30:9501/TCP (active)         
                                              10 => 10.0.12.24:9501/TCP (active)        
                                              11 => 10.0.13.16:9501/TCP (active)        
                                              12 => 10.0.14.170:9501/TCP (active)       
53   10.43.246.180:80/TCP      ClusterIP      1 => 10.0.2.38:8000/TCP (active)          
                                              2 => 10.0.13.26:8000/TCP (active)         
54   10.43.210.20:9503/TCP     ClusterIP      1 => 10.0.0.68:9503/TCP (active)          
                                              2 => 10.0.2.190:9503/TCP (active)         
                                              3 => 10.0.5.87:9503/TCP (active)          
                                              4 => 10.0.6.35:9503/TCP (active)          
                                              5 => 10.0.7.203:9503/TCP (active)         
                                              6 => 10.0.8.150:9503/TCP (active)         
                                              7 => 10.0.9.211:9503/TCP (active)         
                                              8 => 10.0.10.111:9503/TCP (active)        
                                              9 => 10.0.11.30:9503/TCP (active)         
                                              10 => 10.0.12.24:9503/TCP (active)        
                                              11 => 10.0.13.16:9503/TCP (active)        
                                              12 => 10.0.14.170:9503/TCP (active)       
55   10.43.210.167:5432/TCP    ClusterIP                                                
56   10.43.56.234:5432/TCP     ClusterIP                                                
57   10.43.148.227:5432/TCP    ClusterIP                                                
58   10.43.185.251:8080/TCP    ClusterIP      1 => 10.0.9.197:8080/TCP (maintenance)    
59   10.43.7.198:9003/TCP      ClusterIP      1 => 10.0.5.133:9003/TCP (active)         
60   10.43.7.198:9090/TCP      ClusterIP      1 => 10.0.5.133:9090/TCP (active)         
61   10.43.153.111:8429/TCP    ClusterIP      1 => 10.0.5.60:8429/TCP (active)          
62   10.43.134.2:8080/TCP      ClusterIP      1 => 10.0.11.20:8080/TCP (active)         
63   10.43.96.250:9100/TCP     ClusterIP                                                
64   10.43.102.143:9443/TCP    ClusterIP      1 => 10.0.9.186:9443/TCP (active)         
65   10.43.102.143:8080/TCP    ClusterIP      1 => 10.0.9.186:8080/TCP (active)         
66   10.43.158.92:8428/TCP     ClusterIP      1 => 10.0.6.169:8428/TCP (active)         
67   10.43.124.188:80/TCP      ClusterIP      1 => 10.0.2.146:4180/TCP (active)         
68   10.43.124.188:44180/TCP   ClusterIP      1 => 10.0.2.146:44180/TCP (active)        
69   10.43.222.236:8080/TCP    ClusterIP      1 => 10.0.13.165:8080/TCP (maintenance)   
70   10.43.136.244:6379/TCP    ClusterIP                                                
71   10.43.123.199:9121/TCP    ClusterIP                                                
72   10.43.103.159:5432/TCP    ClusterIP      1 => 10.0.9.191:5432/TCP (maintenance)    
73   10.43.144.150:5432/TCP    ClusterIP                                                
74   10.43.174.66:5432/TCP     ClusterIP      1 => 10.0.9.191:5432/TCP (maintenance)    
75   10.43.228.139:8080/TCP    ClusterIP      1 => 10.0.11.111:8080/TCP (maintenance)   
76   10.43.43.90:8080/TCP      ClusterIP      1 => 10.0.7.55:8080/TCP (maintenance)     
77   10.43.13.222:5432/TCP     ClusterIP      1 => 10.0.12.229:5432/TCP (maintenance)   
                                              2 => 10.0.14.51:5432/TCP (active)         
78   10.43.233.54:5432/TCP     ClusterIP      1 => 10.0.12.229:5432/TCP (maintenance)   
79   10.43.231.192:5432/TCP    ClusterIP      1 => 10.0.14.51:5432/TCP (active)         
80   10.43.152.86:3000/TCP     ClusterIP      1 => 10.0.0.30:3000/TCP (active)          
81   10.43.250.59:8080/TCP     ClusterIP      1 => 10.0.6.212:8080/TCP (active)         
82   10.43.69.189:8080/TCP     ClusterIP      1 => 10.0.12.19:8080/TCP (active)         
83   10.43.17.147:8000/TCP     ClusterIP      1 => 10.0.8.129:8000/TCP (active)         
84   10.43.9.105:8080/TCP      ClusterIP      1 => 10.0.9.170:8080/TCP (active)         
85   10.43.228.145:8080/TCP    ClusterIP      1 => 10.0.0.84:8080/TCP (active)          
86   10.43.243.11:8080/TCP     ClusterIP      1 => 10.0.5.142:8080/TCP (active)         
87   10.43.130.49:8000/TCP     ClusterIP      1 => 10.0.0.245:8000/TCP (active)         
                                              2 => 10.0.5.77:8000/TCP (active)          
                                              3 => 10.0.9.178:8000/TCP (active)         
                                              4 => 10.0.11.4:8000/TCP (active)          
88   10.43.184.39:8080/TCP     ClusterIP      1 => 10.0.11.42:8080/TCP (active)         
89   10.43.170.239:8080/TCP    ClusterIP      1 => 10.0.2.123:8080/TCP (active)         
90   10.43.215.61:6379/TCP     ClusterIP      1 => 10.0.10.205:6379/TCP (active)        
91   10.43.173.222:9121/TCP    ClusterIP      1 => 10.0.10.205:9121/TCP (active)        
92   10.43.154.43:8080/TCP     ClusterIP      1 => 10.0.2.214:8080/TCP (active)         
```
