# Cilium debug information

#### Cilium encryption


##### WireGuard

```
interface: cilium_wg0
  public key: hsIXVzzEK9DUP6e74Zy1i4ilh2sYWNR7/UWv3FUgSU8=
  listening port: 51871

peer: BSw5bTigw43neZycBX8XP+2TTJ/COr9KdR1BXbha0gs=
  endpoint: 192.168.100.22:51871
  allowed ips: 192.168.100.22/32
  latest handshake: 2026-01-19T22:09:13.354Z
  transfer: 457787901892 B received, 78187948876 B sent

peer: JPB7xEw64V/evoUIxU5a0VYh1abk57JVNGmBZqNNDSg=
  endpoint: 192.168.100.25:51871
  allowed ips: 192.168.100.25/32
  latest handshake: 2026-01-19T22:08:45.625Z
  transfer: 41969299552 B received, 261540093984 B sent

peer: Lno1XLmWU4wrd8lSXK/n2nNhoyoSJqGGicQNqCdy8Dc=
  endpoint: 192.168.100.21:51871
  allowed ips: 192.168.100.21/32
  latest handshake: 2026-01-19T22:08:55.939Z
  transfer: 51942452784 B received, 2112254260288 B sent

peer: MBDqQ+cwr5VwHHKvYMkpcKZItLnJ6qb9HN7R4ZqMqnQ=
  endpoint: 192.168.100.10:51871
  allowed ips: 192.168.100.10/32
  latest handshake: 2026-01-19T22:09:07.902Z
  transfer: 18680991536 B received, 180549672528 B sent

peer: iSGK51wuTocNHbZeOrZw8okBr6Lvdp8V628SZnMItmY=
  endpoint: 192.168.100.12:51871
  allowed ips: 192.168.100.12/32
  latest handshake: 2026-01-19T22:07:30.321Z
  transfer: 987229508 B received, 523459924 B sent

peer: AKKOPPTW1gAcQFQPWwxeWGA5vvdFZsDTQqBUjTMJbDw=
  endpoint: 192.168.100.27:51871
  allowed ips: 192.168.100.27/32
  latest handshake: 2026-01-19T22:07:59.699Z
  transfer: 664896448 B received, 355440116 B sent

peer: ZibhTJXvvcX3rRQNp0heMp5faRQIp1OaNLl0FVJyujw=
  endpoint: 192.168.100.28:51871
  allowed ips: 192.168.100.28/32
  latest handshake: 2026-01-19T22:08:51.888Z
  transfer: 2481477496 B received, 9550856412 B sent

peer: Wmr/Qdun2kLnoUc49DNCZnzR3suR2BPO19thOefdoyI=
  endpoint: 192.168.100.24:51871
  allowed ips: 192.168.100.24/32
  latest handshake: 2026-01-19T22:07:49.312Z
  transfer: 8831220232 B received, 182381231424 B sent

peer: tgNBkpBaiPz2dqDHKyuq32GtsLCNV52iV3WG5G08AGQ=
  endpoint: 192.168.100.11:51871
  allowed ips: 192.168.100.11/32
  latest handshake: 2026-01-19T22:07:46.379Z
  transfer: 156310866720 B received, 124285799284 B sent

peer: l+i8onyueIOAdNh7mFBwDB2joUhSKNDdKtKiPtHMcUw=
  endpoint: 192.168.100.26:51871
  allowed ips: 192.168.100.26/32
  latest handshake: 2026-01-19T22:08:50.450Z
  transfer: 162248296 B received, 6292765608 B sent

peer: sOen1KxasKuG8RrUT7Zh9uLpLgWOsERp8XEG1jYaHWo=
  endpoint: 192.168.100.20:51871
  allowed ips: 192.168.100.20/32
  latest handshake: 2026-01-19T22:09:26.936Z
  transfer: 159582816 B received, 634954784 B sent

```

#### Kernel version

```
6.12.0
```


#### Cilium environment keys

```
enable-well-known-identities:false
dnsproxy-enable-transparent-mode:true
bpf-lb-source-range-map-max:0
enable-icmp-rules:true
restore:true
allocator-list-timeout:3m0s
identity-gc-interval:15m0s
wireguard-track-all-ips-fallback:false
hubble-metrics-server-tls-client-ca-files:
enable-xt-socket-fallback:true
enable-egress-gateway:true
debug:false
alibabacloud-vswitch-tags:
bpf-sock-rev-map-max:0
enable-identity-mark:true
endpoint-queue-size:25
dnsproxy-lock-count:131
enable-hubble-open-metrics:false
bpf-ct-timeout-regular-tcp-syn:1m0s
clustermesh-enable-endpoint-sync:false
tofqdns-pre-cache:
enable-health-check-loadbalancer-ip:false
node-encryption-opt-out-labels:node-role.kubernetes.io/control-plane
enable-ipv6-masquerade:true
enable-no-service-endpoints-routable:true
bpf-ct-timeout-service-any:1m0s
bpf-lb-rev-nat-map-max:0
dynamic-lifecycle-config:[]
bpf-ct-global-any-max:262144
multicast-enabled:false
eni-subnet-ids:
bpf-lb-ipip-sock-mark:false
auto-create-cilium-node-resource:true
k8s-client-burst:20
http-normalize-path:true
allow-icmp-frag-needed:true
dnsproxy-insecure-skip-transparent-mode-check:false
hubble-socket-path:/var/run/cilium/hubble.sock
tofqdns-enable-dns-compression:true
enable-l2-neigh-discovery:false
metrics:
envoy-secrets-namespace:
policy-secrets-only-from-secrets-namespace:true
hubble-metrics-server-tls-cert-file:
cni-external-routing:false
enable-ztunnel:false
hubble-metrics-server-tls-key-file:
use-full-tls-context:false
standalone-dns-proxy-server-port:10095
hubble-metrics:
node-port-acceleration:disabled
tunnel-source-port-range:0-0
bpf-lb-service-backend-map-max:0
log-opt:
hubble-export-file-max-size-mb:10
direct-routing-skip-unreachable:false
max-connected-clusters:255
proxy-max-concurrent-retries:128
bpf-filter-priority:1
install-iptables-rules:true
status-collector-warning-threshold:15s
conntrack-gc-interval:0s
mesh-auth-spire-admin-socket:
bypass-ip-availability-upon-restore:false
policy-cidr-match-mode:
enable-endpoint-routes:false
proxy-cluster-max-requests:1024
bpf-node-map-max:16384
bpf-fragments-map-max:8192
k8s-api-server:
mesh-auth-spiffe-trust-domain:spiffe.cilium
lb-pressure-metrics-interval:5m0s
metrics-sampling-interval:5m
ipam-cilium-node-update-rate:15s
enable-bbr-hostns-only:false
identity-management-mode:agent
policy-default-local-cluster:true
state-dir:/var/run/cilium
mesh-auth-mutual-connect-timeout:5s
operator-prometheus-serve-addr::9963
cni-log-file:/var/run/cilium/cilium-cni.log
operator-api-serve-addr:127.0.0.1:9234
prepend-iptables-chains:true
encrypt-node:false
hubble-dynamic-metrics-config-path:
identity-allocation-sync-interval:5m0s
monitor-aggregation-interval:5s
envoy-default-log-level:
ipv4-node:auto
service-no-backend-response:reject
direct-routing-device:
log-driver:
set-cilium-is-up-condition:true
hubble-drop-events-reasons:
cluster-id:0
kube-proxy-replacement:true
enable-ingress-controller:false
node-labels:
k8s-require-ipv6-pod-cidr:false
bpf-events-drop-enabled:true
vtep-endpoint:
enable-service-topology:false
hive-stop-timeout:1m0s
hubble-export-fieldaggregate:
api-rate-limit:
debug-verbose:
nat-map-stats-interval:30s
iptables-random-fully:false
proxy-xff-num-trusted-hops-ingress:0
identity-change-grace-period:5s
proxy-connect-timeout:2
bpf-events-default-rate-limit:0
egress-gateway-reconciliation-trigger-interval:1s
hubble-skip-unknown-cgroup-ids:true
enable-l7-proxy:true
hubble-redact-kafka-apikey:false
enable-vtep:false
bpf-auth-map-max:524288
lib-dir:/var/lib/cilium
enable-masquerade-to-route-source:false
trace-payloadlen-overlay:192
enable-ciliumnode-crd:true
node-port-bind-protection:true
lb-retry-backoff-min:1s
srv6-encap-mode:reduced
dns-policy-unload-on-shutdown:false
node-port-range:
enable-ipv4:true
mesh-auth-rotated-identities-queue-size:1024
synchronize-k8s-nodes:true
envoy-base-id:0
enable-node-selector-labels:false
write-cni-conf-when-ready:/host/etc/cni/net.d/05-cilium.conflist
k8s-service-proxy-name:
enable-ipv4-big-tcp:false
l2-pod-announcements-interface-pattern:
enable-endpoint-health-checking:true
bpf-ct-timeout-service-tcp:2h13m20s
trace-sock:true
encryption-strict-egress-allow-remote-node-identities:false
mesh-auth-signal-backoff-duration:1s
ingress-secrets-namespace:
bpf-policy-map-max:16384
bpf-lb-source-range-all-types:false
clustermesh-cache-ttl:0s
policy-deny-response:none
agent-not-ready-taint-key:node.cilium.io/agent-not-ready
dns-max-ips-per-restored-rule:1000
disable-external-ip-mitigation:false
lrp-address-matcher-cidrs:
hubble-metrics-server-enable-tls:false
tofqdns-proxy-port:0
ipam-pre-allocate:0
devices:
l2-announcements-renew-deadline:5s
bpf-lb-sock-hostns-only:false
hubble-prefer-ipv6:false
ipam-multi-pool-pre-allocation:
enable-ipv4-fragment-tracking:true
lb-sock-terminate-all-protos:false
tofqdns-min-ttl:0
nat-map-stats-entries:32
eni-subnet-tags:
hubble-tls-client-ca-files:/var/lib/cilium/tls/hubble/client-ca.crt
envoy-keep-cap-netbindservice:false
mesh-auth-queue-size:1024
bpf-lb-sock-terminate-pod-connections:true
bpf-neigh-global-max:524288
only-masquerade-default-pool:false
policy-queue-size:100
enable-local-redirect-policy:false
keep-config:false
proxy-max-connection-duration-seconds:0
dnsproxy-concurrency-limit:0
enable-bpf-tproxy:false
ipam:cluster-pool
hubble-flowlogs-config-path:
enable-l2-pod-announcements:false
vtep-mac:
bpf-map-event-buffers:
ipv6-service-loopback-address:fe80::1
route-metric:0
bpf-lb-external-clusterip:false
config:
proxy-portrange-min:10000
ipv4-native-routing-cidr:
enable-auto-protect-node-port-range:true
http-max-grpc-timeout:0
mtu:0
ipv6-mcast-device:
enable-cilium-network-policy:true
certificates-directory:/var/run/cilium/certs
cluster-health-port:4240
enable-envoy-config:false
enable-xdp-prefilter:false
lb-state-file:
enable-gateway-api:false
envoy-http-upstream-linger-timeout:-1
alibabacloud-security-group-tags:
enable-k8s-networkpolicy:true
use-cilium-internal-ip-for-ipsec:false
eni-security-group-tags:
procfs:/host/proc
set-cilium-node-taints:true
ipv6-service-range:auto
enable-policy-secrets-sync:true
cgroup-root:/run/cilium/cgroupv2
policy-secrets-namespace:cilium-secrets
tofqdns-proxy-response-max-delay:100ms
ipv4-service-range:auto
controller-group-metrics:
ip-tracing-option-type:0
k8s-api-server-urls:
ipv4-service-loopback-address:169.254.42.1
k8s-kubeconfig-path:
dnsproxy-lock-timeout:500ms
remove-cilium-node-taints:true
hubble-redact-http-headers-allow:
enable-metrics:true
datapath-mode:veth
vtep-cidr:
envoy-config-retry-interval:15s
enable-encryption-strict-mode:false
enable-host-firewall:false
ipam-max-allocate:0
mesh-auth-mutual-listener-port:0
hubble-export-file-path:
annotate-k8s-node:false
alibabacloud-vswitches:
hubble-drop-events-interval:2m0s
hive-start-timeout:5m0s
clustermesh-enable-mcs-api:false
hubble-tls-cert-file:/var/lib/cilium/tls/hubble/server.crt
node-port-mode:
enable-ipsec-xfrm-state-caching:true
enable-tracing:false
enable-stale-cilium-endpoint-cleanup:true
status-collector-interval:5s
status-collector-probe-check-timeout:5m0s
enable-active-connection-tracking:false
prometheus-serve-addr:
enable-srv6:false
azure-interface-name:
alibabacloud-security-groups:
eni-exclude-interface-tags:
ipsec-key-rotation-duration:5m0s
enable-k8s-api-discovery:false
proxy-max-requests-per-connection:0
enable-bbr:false
hubble-lost-event-send-interval:1s
cni-chaining-mode:none
bpf-nat-global-max:524288
bpf-events-trace-enabled:true
preallocate-bpf-maps:false
install-uplink-routes-for-delegated-ipam:false
disable-endpoint-crd:false
node-port-algorithm:
l2-announcements-retry-period:2s
agent-health-port:9879
bgp-router-id-allocation-mode:default
bpf-lb-sock:false
bpf-lb-maglev-map-max:0
cluster-pool-ipv4-cidr:10.0.0.0/8
proxy-initial-fetch-timeout:30
identity-restore-grace-period:30s
cluster-name:default
enable-cilium-api-server-access:
http-idle-timeout:0
mesh-auth-enabled:true
enable-ip-masq-agent:false
tofqdns-max-deferred-connection-deletes:10000
hubble-network-policy-correlation-enabled:true
nodes-gc-interval:5m0s
cni-chaining-target:
eni-delete-on-termination:true
enable-tcx:true
proxy-portrange-max:20000
enable-endpoint-lockdown-on-policy-overflow:false
fqdn-regex-compile-lru-size:1024
local-router-ipv6:
hubble-drop-events-rate-limit:1
bpf-ct-timeout-regular-tcp-fin:10s
bpf-policy-stats-map-max:65536
exclude-local-address:
hubble-event-buffer-capacity:4095
vtep-sync-interval:1m0s
enable-l2-announcements:false
kvstore-lease-ttl:15m0s
eni-security-groups:
enable-pmtu-discovery:false
enable-gops:true
tunnel-protocol:vxlan
crd-wait-timeout:5m0s
hubble-disable-tls:false
pprof-mutex-profile-fraction:0
eni-disable-prefix-delegation:false
hubble-redact-http-urlquery:false
restored-proxy-ports-age-limit:15
enable-ipv6:false
enable-lb-ipam:true
enable-k8s-host-firewall-bypass:true
bpf-ct-timeout-regular-tcp:2h13m20s
enable-policy:default
enable-health-check-nodeport:true
bpf-events-default-burst-limit:0
hubble-export-fieldmask:
log-system-load:false
enable-nat46x64-gateway:false
encrypt-interface:
proxy-gid:1337
default-lb-service-ipam:lbipam
ipam-static-ip-tags:
hubble-redact-enabled:false
hubble-drop-events-extended:false
gateway-api-secrets-namespace:
disable-iptables-feeder-rules:
enable-sctp:false
encryption-strict-egress-cidr:
enable-ipv6-fragment-tracking:true
connectivity-probe-frequency-ratio:0.5
enable-bpf-clock-probe:false
conntrack-gc-max-interval:0s
ipv6-pod-subnets:
proxy-xff-num-trusted-hops-egress:0
agent-health-require-k8s-connectivity:true
hubble-metrics-server:
bpf-distributed-lru:false
monitor-aggregation:medium
cluster-pool-ipv4-mask-size:24
http-request-timeout:3600
envoy-log:
cmdref:
clustermesh-sync-timeout:1m0s
bpf-policy-map-pressure-metrics-threshold:0.1
proxy-prometheus-port:0
enable-source-ip-verification:true
exclude-node-label-patterns:
bpf-policy-map-full-reconciliation-interval:15m0s
bpf-lb-maglev-hash-seed:JLfvgnHc2kaSUFaI
envoy-policy-restore-timeout:3m0s
hubble-export-denylist:
boot-id-file:/proc/sys/kernel/random/boot_id
enable-drift-checker:true
force-device-detection:false
derive-masq-ip-addr-from-device:
bpf-lb-mode-annotation:false
bpf-ct-timeout-regular-any:1m0s
eni-use-primary-address:false
http-retry-timeout:0
enable-bgp-control-plane-status-report:true
fixed-identity-mapping:
bpf-ct-global-tcp-max:524288
policy-trigger-interval:1s
pprof-address:localhost
policy-accounting:true
bpf-lb-algorithm:random
enable-tunnel-big-tcp:false
tunnel-port:0
tofqdns-preallocate-identities:true
encryption-strict-mode-cidr:
enable-packetization-layer-pmtud:true
bpf-lb-rss-ipv4-src-cidr:
bpf-lb-mode:snat
bpf-lb-acceleration:disabled
config-sources-overrides:{"allowConfigKeys":[],"denyConfigKeys":[]}
trace-payloadlen:128
max-controller-interval:0
bpf-lb-dsr-dispatch:opt
read-cni-conf:
monitor-aggregation-flags:all
enable-host-legacy-routing:false
vlan-bpf-bypass:
enable-bgp-legacy-origin-attribute:false
kube-proxy-replacement-healthz-bind-address:
http-retry-count:3
shell-sock-path:/var/run/cilium/shell.sock
enable-k8s:true
enable-health-checking:true
clustermesh-config:/var/lib/cilium/clustermesh/
bpf-lb-algorithm-annotation:false
unmanaged-pod-watcher-interval:15s
allow-localhost:auto
hubble-export-file-compress:false
mke-cgroup-mount:
k8s-heartbeat-timeout:30s
dnsproxy-socket-linger-timeout:10
mesh-auth-gc-interval:5m0s
ipv4-pod-subnets:
hubble-event-queue-size:0
ipsec-key-file:
label-prefix-file:
bpf-events-policy-verdict-enabled:true
enable-mke:false
eni-first-interface-index:0
underlay-protocol:ipv4
labels:
enable-ipv6-big-tcp:false
enable-wireguard:true
bpf-root:/sys/fs/bpf
identity-heartbeat-timeout:30m0s
local-router-ipv4:
ignore-flags-drift-checker:
enable-cilium-health-api-server-access:
status-collector-failure-threshold:1m0s
nodeport-addresses:
kvstore-opt:
external-envoy-proxy:true
ipv6-node:auto
ip-masq-agent-config-path:/etc/config/ip-masq-agent
cilium-endpoint-gc-interval:5m0s
routing-mode:tunnel
hubble-export-file-max-backups:5
bpf-lb-service-map-max:0
proxy-max-active-downstream-connections:50000
tofqdns-endpoint-max-ip-per-hostname:1000
enable-encryption-strict-mode-egress:false
enable-bpf-masquerade:true
version:false
enable-route-mtu-for-cni-chaining:false
ipam-min-allocate:0
ztunnel-zds-unix-addr:/var/run/cilium/ztunnel.sock
enable-ipip-termination:false
static-cnp-path:
enable-cilium-endpoint-slice:false
identity-allocation-mode:crd
kvstore-max-consecutive-quorum-errors:2
hubble-export-aggregation-interval:0s
egress-masquerade-interfaces:
bpf-map-dynamic-size-ratio:0.0025
tofqdns-dns-reject-response-code:refused
bgp-router-id-allocation-ip-pool:
wireguard-persistent-keepalive:0s
pprof-port:6060
status-collector-stackdump-path:/run/cilium/state/agent.stack.gz
health-check-icmp-failure-threshold:3
enable-bandwidth-manager:false
enable-hubble:true
enable-dynamic-lifecycle-manager:false
identity-allocation-timeout:2m0s
agent-liveness-update-interval:1s
k8s-client-qps:10
endpoint-regen-interval:2m0s
container-ip-local-reserved-ports:auto
bpf-lb-maglev-table-size:16381
socket-path:/var/run/cilium/cilium.sock
envoy-access-log-buffer-size:4096
endpoint-gc-interval:5m0s
disable-envoy-version-check:false
encryption-strict-mode-allow-remote-node-identities:false
custom-cni-conf:false
ipv6-range:auto
envoy-config-timeout:2m0s
enable-encryption-strict-mode-ingress:false
dnsproxy-concurrency-processing-grace-period:0s
config-sources:[{"kind":"config-map","namespace":"kube-system","name":"cilium-config"}]
lb-retry-backoff-max:1s
enable-standalone-dns-proxy:false
bpf-lb-affinity-map-max:0
pprof-block-profile-rate:0
pprof:false
iptables-lock-timeout:5s
bpf-lb-map-max:65536
vtep-mask:
enable-local-node-route:true
proxy-cluster-max-connections:1024
cni-exclusive:true
k8s-client-connection-keep-alive:30s
proxy-use-original-source-address:true
endpoint-bpf-prog-watchdog-interval:30s
enable-remote-node-masquerade:false
hive-log-threshold:100ms
enable-ipsec:false
agent-labels:
clustermesh-mcs-api-install-crds:true
http-stream-idle-timeout:300
gops-port:9890
hubble-redact-http-headers-deny:
ipv6-native-routing-cidr:
enable-dynamic-config:true
lb-state-file-interval:1s
enable-cilium-clusterwide-network-policy:true
max-internal-timer-delay:0s
install-no-conntrack-iptables-rules:false
kvstore:
hubble-monitor-events:
monitor-queue-size:0
hubble-tls-key-file:/var/lib/cilium/tls/hubble/server.key
ipv6-cluster-alloc-cidr:f00d::/64
bpf-lb-nat46x64:false
egress-gateway-policy-map-max:16384
hubble-drop-events:false
bpf-conntrack-accounting:false
enable-ipsec-key-watcher:true
k8s-client-connection-timeout:30s
policy-audit-mode:true
bpf-lb-rss-ipv6-src-cidr:
config-dir:/tmp/cilium/config-map
local-max-addr-scope:254
ipv4-range:auto
enable-extended-ip-protocols:false
bpf-ct-timeout-service-tcp-grace:1m0s
hubble-redact-http-userinfo:true
enable-node-ipam:false
k8s-require-ipv4-pod-cidr:false
enable-ipv4-masquerade:true
hubble-listen-address::4244
auto-direct-node-routes:false
enable-bgp-control-plane:false
identity-max-jitter:30s
proxy-idle-timeout-seconds:60
k8s-sync-timeout:3m0s
enable-monitor:true
enable-unreachable-routes:false
allow-unsafe-policy-skb-usage:false
lb-init-wait-timeout:1m0s
l2-announcements-lease-duration:15s
k8s-namespace:kube-system
hubble-export-allowlist:
tofqdns-idle-connection-grace-period:0s
enable-non-default-deny-policies:true
enable-ipv6-ndp:false
ipam-default-ip-pool:default
proxy-admin-port:0
```


#### Endpoint list

```
ENDPOINT   POLICY (ingress)   POLICY (egress)    IDENTITY   LABELS (source:key[=value])                                                                     IPv6   IPv4          STATUS   
           ENFORCEMENT        ENFORCEMENT                                                                                                                                        
34         Disabled (Audit)   Disabled           4988       k8s:app.kubernetes.io/instance=kured                                                                   10.0.11.96    ready   
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                        
                                                            k8s:app.kubernetes.io/name=kured                                                                                             
                                                            k8s:helm.sh/chart=kured-5.6.2                                                                                                
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring                                                    
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=kured                                                                                
                                                            k8s:io.kubernetes.pod.namespace=monitoring                                                                                   
62         Disabled (Audit)   Disabled           54583      k8s:app.kubernetes.io/instance=cloudnative-pg                                                          10.0.11.242   ready   
                                                            k8s:app.kubernetes.io/name=cloudnative-pg                                                                                    
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cloudnative-pg                                                
                                                            k8s:io.cilium.k8s.namespace.labels.name=cloudnative-pg                                                                       
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=cloudnative-pg                                                                       
                                                            k8s:io.kubernetes.pod.namespace=cloudnative-pg                                                                               
89         Disabled (Audit)   Disabled           28201      k8s:app=longhorn-csi-plugin                                                                            10.0.11.33    ready   
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                               
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                             
                                                            k8s:io.kubernetes.pod.namespace=longhorn-system                                                                              
98         Disabled (Audit)   Disabled           4          reserved:health                                                                                        10.0.11.187   ready   
130        Disabled (Audit)   Disabled           29089      k8s:app.kubernetes.io/component=cainjector                                                             10.0.11.2     ready   
                                                            k8s:app.kubernetes.io/instance=cert-manager                                                                                  
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                        
                                                            k8s:app.kubernetes.io/name=cainjector                                                                                        
                                                            k8s:app.kubernetes.io/version=v1.13.3                                                                                        
                                                            k8s:app=cainjector                                                                                                           
                                                            k8s:helm.sh/chart=cert-manager-v1.13.3                                                                                       
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cert-manager                                                  
                                                            k8s:io.cilium.k8s.namespace.labels.name=cert-manager                                                                         
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=cert-manager-cainjector                                                              
                                                            k8s:io.kubernetes.pod.namespace=cert-manager                                                                                 
186        Disabled (Audit)   Disabled           2843       k8s:app.kubernetes.io/component=zookeeper                                                              10.0.11.66    ready   
                                                            k8s:app.kubernetes.io/instance=langfuse                                                                                      
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                        
                                                            k8s:app.kubernetes.io/name=zookeeper                                                                                         
                                                            k8s:app.kubernetes.io/version=3.9.3                                                                                          
                                                            k8s:helm.sh/chart=zookeeper-13.7.4                                                                                           
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=langfuse                                                      
                                                            k8s:io.cilium.k8s.namespace.labels.name=langfuse                                                                             
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=langfuse-zookeeper                                                                   
                                                            k8s:io.kubernetes.pod.namespace=langfuse                                                                                     
466        Disabled (Audit)   Disabled           16908      k8s:app.kubernetes.io/component=trivy                                                                  10.0.11.214   ready   
                                                            k8s:app.kubernetes.io/instance=harbor                                                                                        
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                        
                                                            k8s:app.kubernetes.io/name=harbor                                                                                            
                                                            k8s:app.kubernetes.io/part-of=harbor                                                                                         
                                                            k8s:app.kubernetes.io/version=2.12.0                                                                                         
                                                            k8s:app=harbor                                                                                                               
                                                            k8s:chart=harbor                                                                                                             
                                                            k8s:component=trivy                                                                                                          
                                                            k8s:heritage=Helm                                                                                                            
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=harbor                                                        
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=default                                                                              
                                                            k8s:io.kubernetes.pod.namespace=harbor                                                                                       
                                                            k8s:release=harbor                                                                                                           
627        Disabled (Audit)   Disabled (Audit)   60492      k8s:app.kubernetes.io/instance=kafka-cluster                                                           10.0.11.189   ready   
                                                            k8s:app.kubernetes.io/managed-by=strimzi-cluster-operator                                                                    
                                                            k8s:app.kubernetes.io/name=kafka                                                                                             
                                                            k8s:app.kubernetes.io/part-of=strimzi-kafka-cluster                                                                          
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka                                                         
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=kafka-cluster-kafka                                                                  
                                                            k8s:io.kubernetes.pod.namespace=kafka                                                                                        
                                                            k8s:strimzi.io/broker-role=true                                                                                              
                                                            k8s:strimzi.io/cluster=kafka-cluster                                                                                         
                                                            k8s:strimzi.io/component-type=kafka                                                                                          
                                                            k8s:strimzi.io/controller-name=kafka-cluster-dual-role                                                                       
                                                            k8s:strimzi.io/controller-role=true                                                                                          
                                                            k8s:strimzi.io/controller=strimzipodset                                                                                      
                                                            k8s:strimzi.io/kind=Kafka                                                                                                    
                                                            k8s:strimzi.io/name=kafka-cluster-kafka                                                                                      
                                                            k8s:strimzi.io/pod-name=kafka-cluster-dual-role-1                                                                            
                                                            k8s:strimzi.io/pool-name=dual-role                                                                                           
665        Disabled (Audit)   Disabled           4394       k8s:app.kubernetes.io/instance=longhorn                                                                10.0.11.30    ready   
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                        
                                                            k8s:app.kubernetes.io/name=longhorn                                                                                          
                                                            k8s:app.kubernetes.io/version=v1.9.0                                                                                         
                                                            k8s:app=longhorn-manager                                                                                                     
                                                            k8s:helm.sh/chart=longhorn-1.9.0                                                                                             
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                                               
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                             
                                                            k8s:io.kubernetes.pod.namespace=longhorn-system                                                                              
                                                            k8s:longhorn.io/admission-webhook=longhorn-admission-webhook                                                                 
                                                            k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook                                                               
                                                            k8s:longhorn.io/recovery-backend=longhorn-recovery-backend                                                                   
815        Disabled (Audit)   Disabled           43550      k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                         10.0.11.19    ready   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                             
                                                            k8s:io.kubernetes.pod.namespace=longhorn-system                                                                              
                                                            k8s:longhorn.io/component=engine-image                                                                                       
                                                            k8s:longhorn.io/engine-image=ei-e09d8caa                                                                                     
855        Disabled (Audit)   Disabled           32467      k8s:app.kubernetes.io/component=core                                                                   10.0.11.78    ready   
                                                            k8s:app.kubernetes.io/instance=harbor                                                                                        
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                        
                                                            k8s:app.kubernetes.io/name=harbor                                                                                            
                                                            k8s:app.kubernetes.io/part-of=harbor                                                                                         
                                                            k8s:app.kubernetes.io/version=2.12.0                                                                                         
                                                            k8s:app=harbor                                                                                                               
                                                            k8s:chart=harbor                                                                                                             
                                                            k8s:component=core                                                                                                           
                                                            k8s:heritage=Helm                                                                                                            
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=harbor                                                        
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=default                                                                              
                                                            k8s:io.kubernetes.pod.namespace=harbor                                                                                       
                                                            k8s:release=harbor                                                                                                           
940        Disabled (Audit)   Disabled           15202      k8s:app=redacted-weather-data-converter-dev                                                             10.0.11.4     ready   
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev                                                   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=default                                                                              
                                                            k8s:io.kubernetes.pod.namespace=redacted-dev                                                                                  
975        Disabled (Audit)   Disabled           28621      k8s:app.kubernetes.io/instance=langfuse                                                                10.0.11.36    ready   
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                        
                                                            k8s:app.kubernetes.io/name=s3                                                                                                
                                                            k8s:app.kubernetes.io/version=2024.12.18                                                                                     
                                                            k8s:helm.sh/chart=s3-14.10.5                                                                                                 
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=langfuse                                                      
                                                            k8s:io.cilium.k8s.namespace.labels.name=langfuse                                                                             
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=langfuse-s3                                                                          
                                                            k8s:io.kubernetes.pod.namespace=langfuse                                                                                     
1013       Disabled (Audit)   Disabled           8241       k8s:app=redacted-processor-dev-job                                                                      10.0.11.219   ready   
                                                            k8s:batch.kubernetes.io/job-name=redacted-redis-job-met-hu-arome-6407076                                                      
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev                                                   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account                                                    
                                                            k8s:io.kubernetes.pod.namespace=redacted-dev                                                                                  
                                                            k8s:job-name=redacted-redis-job-met-hu-arome-6407076                                                                          
                                                            k8s:job=redis-job-met-hu-arome                                                                                               
1136       Disabled (Audit)   Disabled           566        k8s:app.kubernetes.io/instance=locust                                                                  10.0.11.213   ready   
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                        
                                                            k8s:app.kubernetes.io/name=locust                                                                                            
                                                            k8s:app.kubernetes.io/version=2.32.2                                                                                         
                                                            k8s:component=worker                                                                                                         
                                                            k8s:helm.sh/chart=locust-0.32.6                                                                                              
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=locust                                                        
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=locust-worker                                                                        
                                                            k8s:io.kubernetes.pod.namespace=locust                                                                                       
                                                            k8s:load_test=example                                                                                                        
1345       Disabled (Audit)   Disabled           2645       k8s:app=redacted-processor-dev-job                                                                      10.0.11.120   ready   
                                                            k8s:batch.kubernetes.io/job-name=redacted-redis-job-meteo-swiss-icon-6407035                                                  
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev                                                   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account                                                    
                                                            k8s:io.kubernetes.pod.namespace=redacted-dev                                                                                  
                                                            k8s:job-name=redacted-redis-job-meteo-swiss-icon-6407035                                                                      
                                                            k8s:job=redis-job-meteo-swiss-icon                                                                                           
1425       Disabled (Audit)   Disabled           15927      k8s:app.kubernetes.io/component=metrics                                                                10.0.11.20    ready   
                                                            k8s:app.kubernetes.io/instance=vmetrics                                                                                      
                                                            k8s:app.kubernetes.io/managed-by=Helm                                                                                        
                                                            k8s:app.kubernetes.io/name=kube-state-metrics                                                                                
                                                            k8s:app.kubernetes.io/part-of=kube-state-metrics                                                                             
                                                            k8s:app.kubernetes.io/version=2.17.0                                                                                         
                                                            k8s:helm.sh/chart=kube-state-metrics-6.4.2                                                                                   
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring                                                    
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=vmetrics-kube-state-metrics                                                          
                                                            k8s:io.kubernetes.pod.namespace=monitoring                                                                                   
1874       Disabled (Audit)   Disabled           23106      k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system                         10.0.11.220   ready   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account                                                             
                                                            k8s:io.kubernetes.pod.namespace=longhorn-system                                                                              
                                                            k8s:longhorn.io/component=instance-manager                                                                                   
                                                            k8s:longhorn.io/data-engine=v1                                                                                               
                                                            k8s:longhorn.io/instance-manager-image=imi-29909444                                                                          
                                                            k8s:longhorn.io/instance-manager-type=aio                                                                                    
                                                            k8s:longhorn.io/managed-by=longhorn-manager                                                                                  
                                                            k8s:longhorn.io/node=dev-agent-04                                                                                            
2540       Disabled (Audit)   Disabled           8779       k8s:app=redacted-weather-ws-dev                                                                         10.0.11.42    ready   
                                                            k8s:egress=cilium                                                                                                            
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev                                                   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=default                                                                              
                                                            k8s:io.kubernetes.pod.namespace=redacted-dev                                                                                  
2749       Disabled (Audit)   Disabled           5993       k8s:app=redacted-processor-dev-job                                                                      10.0.11.5     ready   
                                                            k8s:batch.kubernetes.io/job-name=redacted-redis-job-geo-sphere-austria-6407082                                                
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev                                                   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=redacted-processor-service-account                                                    
                                                            k8s:io.kubernetes.pod.namespace=redacted-dev                                                                                  
                                                            k8s:job-name=redacted-redis-job-geo-sphere-austria-6407082                                                                    
                                                            k8s:job=redis-job-geo-sphere-austria                                                                                         
3554       Disabled (Audit)   Disabled           1624       k8s:app=route-generator-job-dev                                                                        10.0.11.111   ready   
                                                            k8s:egress=cilium                                                                                                            
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=route-generator-dev                                           
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=route-generator-job-service-account                                                  
                                                            k8s:io.kubernetes.pod.namespace=route-generator-dev                                                                          
3559       Disabled           Disabled           1          k8s:k3s-upgrade=true                                                                                                 ready   
                                                            k8s:node.kubernetes.io/instance-type=k3s                                                                                     
                                                            k8s:plan.upgrade.cattle.io/k3s-agent=e1ec324e7ae240b5b767a512e1706d1595c676680c1d3663ad6b5812                                
                                                            reserved:host                                                                                                                
3795       Disabled (Audit)   Disabled           34352      k8s:app.kubernetes.io/component=Agent                                                                  10.0.11.212   ready   
                                                            k8s:app.kubernetes.io/instance=victorialogs                                                                                  
                                                            k8s:app.kubernetes.io/name=vector                                                                                            
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring                                                    
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=victorialogs-vector                                                                  
                                                            k8s:io.kubernetes.pod.namespace=monitoring                                                                                   
                                                            k8s:vector.dev/exclude=true                                                                                                  
3980       Disabled (Audit)   Disabled           60465      k8s:app=local-path-provisioner                                                                         10.0.11.129   ready   
                                                            k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kube-system                                                   
                                                            k8s:io.cilium.k8s.policy.cluster=default                                                                                     
                                                            k8s:io.cilium.k8s.policy.serviceaccount=local-path-provisioner-service-account                                               
                                                            k8s:io.kubernetes.pod.namespace=kube-system                                                                                  
```

#### BPF Policy Get 34

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    38568     478       0        0
Allow    Ingress     2          ANY          NONE         disabled    1052421   13019     0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    -         -         0        0

```


#### BPF CT List 34

```
Invalid argument: unknown type 34
```


#### Endpoint Get 34

```
[
  {
    "id": 34,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-34-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "6088e186-2559-4c70-b5ef-b6fa3dacc975"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-monitoring/kured-n8lg7",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:03.215Z",
            "success-count": 2
          },
          "uuid": "197b30cc-e607-41d0-aa85-f15a90ccea8f"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (34)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "731aa426-56ee-4f6f-acda-40b7e9df9d57"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-34",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.074Z",
            "success-count": 32
          },
          "uuid": "af64ac3d-df6a-4981-8128-8297a005f077"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (34)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:20.338Z",
            "success-count": 2823
          },
          "uuid": "35630835-98d6-42c1-8c24-6e0d9cf20619"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (34)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "96ad68e1-4b27-47a5-abe2-2fd1f9ea5105"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "6fba4b4bba46218741510e1ea5c6b373858d24381ec047140497a1498f1d36b0:eth0",
        "container-id": "6fba4b4bba46218741510e1ea5c6b373858d24381ec047140497a1498f1d36b0",
        "k8s-namespace": "monitoring",
        "k8s-pod-name": "kured-n8lg7",
        "pod-name": "monitoring/kured-n8lg7"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4988,
        "labels": [
          "k8s:app.kubernetes.io/instance=kured",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=kured",
          "k8s:helm.sh/chart=kured-5.6.2",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kured",
          "k8s:io.kubernetes.pod.namespace=monitoring"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=796657747b",
          "k8s:pod-template-generation=4"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=kured",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=kured",
          "k8s:helm.sh/chart=kured-5.6.2",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kured",
          "k8s:io.kubernetes.pod.namespace=monitoring"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "namedPorts": [
        {
          "name": "metrics",
          "port": 8080,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.96",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "5a:c9:dc:de:53:ae",
        "interface-index": 80,
        "interface-name": "lxc0eb95db7122f",
        "mac": "3e:f2:1c:ac:99:9f"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4988,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4988,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 34

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 34

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4988

```
ID     LABELS
4988   k8s:app.kubernetes.io/instance=kured
       k8s:app.kubernetes.io/managed-by=Helm
       k8s:app.kubernetes.io/name=kured
       k8s:helm.sh/chart=kured-5.6.2
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=monitoring
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=kured
       k8s:io.kubernetes.pod.namespace=monitoring

```


#### BPF Policy Get 62

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES       PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    451503      2076      0        0
Allow    Ingress     2          ANY          NONE         disabled    12612508    57733     0        0
Allow    Ingress     9          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -           -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -           -         0        0
Allow    Egress      0          ANY          NONE         disabled    589351910   1233191   0        0

```


#### BPF CT List 62

```
Invalid argument: unknown type 62
```


#### Endpoint Get 62

```
[
  {
    "id": 62,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-62-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "e47ee0d0-4ffc-4e32-9ef7-f47c51fd8e49"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-cloudnative-pg/cloudnative-pg-574545f4cc-7mr94",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:03.089Z",
            "success-count": 2
          },
          "uuid": "26709b94-b1e6-4621-ac01-8ccf56dc63bb"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (62)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "d143bb47-a2e3-4aa0-b8a5-942c8625f9c1"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-62",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.112Z",
            "success-count": 32
          },
          "uuid": "6aff93b8-124a-4882-8000-e054b265f1b3"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (62)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:19.270Z",
            "success-count": 2823
          },
          "uuid": "9dcf566e-634a-4164-a7bf-e2c50157786a"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (62)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "61b71fcf-fc15-4609-929f-eb44748f7d37"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "289fdd90f122812e1349348544cc1086d177363712d7bc327f3325024cf86514:eth0",
        "container-id": "289fdd90f122812e1349348544cc1086d177363712d7bc327f3325024cf86514",
        "k8s-namespace": "cloudnative-pg",
        "k8s-pod-name": "cloudnative-pg-574545f4cc-7mr94",
        "pod-name": "cloudnative-pg/cloudnative-pg-574545f4cc-7mr94"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 54583,
        "labels": [
          "k8s:app.kubernetes.io/instance=cloudnative-pg",
          "k8s:app.kubernetes.io/name=cloudnative-pg",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cloudnative-pg",
          "k8s:io.cilium.k8s.namespace.labels.name=cloudnative-pg",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=cloudnative-pg",
          "k8s:io.kubernetes.pod.namespace=cloudnative-pg"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=574545f4cc"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=cloudnative-pg",
          "k8s:app.kubernetes.io/name=cloudnative-pg",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cloudnative-pg",
          "k8s:io.cilium.k8s.namespace.labels.name=cloudnative-pg",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=cloudnative-pg",
          "k8s:io.kubernetes.pod.namespace=cloudnative-pg"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "namedPorts": [
        {
          "name": "metrics",
          "port": 8080,
          "protocol": "TCP"
        },
        {
          "name": "webhook-server",
          "port": 9443,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.242",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "c6:8d:b1:c6:b9:65",
        "interface-index": 62,
        "interface-name": "lxce04abcf4313e",
        "mac": "d2:6b:92:5d:a9:32"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 54583,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 54583,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 62

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 62

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 54583

```
ID      LABELS
54583   k8s:app.kubernetes.io/instance=cloudnative-pg
        k8s:app.kubernetes.io/name=cloudnative-pg
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cloudnative-pg
        k8s:io.cilium.k8s.namespace.labels.name=cloudnative-pg
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=cloudnative-pg
        k8s:io.kubernetes.pod.namespace=cloudnative-pg

```


#### BPF Policy Get 89

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          9808/TCP     NONE         disabled    79149     889       24       0
Allow    Ingress     1          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2          9808/TCP     NONE         disabled    2475318   27808     24       0
Allow    Ingress     2          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     7          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9          9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29395      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   9808/TCP     NONE         disabled    -         -         24       0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    932154    10669     0        0

```


#### BPF CT List 89

```
Invalid argument: unknown type 89
```


#### Endpoint Get 89

```
[
  {
    "id": 89,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-89-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "541b7a43-6940-4930-8991-1a737f1dfe4b"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/longhorn-csi-plugin-ssbmv",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:03.201Z",
            "success-count": 2
          },
          "uuid": "b4ce825f-e32a-48dc-8c7e-3bd84e834cae"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (89)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "f71e177a-c3ce-453b-8238-84c9f2fd588a"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-89",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.062Z",
            "success-count": 32
          },
          "uuid": "a64daf33-855d-4668-8d56-b04b3f20a54d"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (89)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:19.761Z",
            "success-count": 2823
          },
          "uuid": "e069f955-1821-4698-8ca0-63dc25cfd036"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (89)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "e2b5395b-1eb8-4342-92d6-826db59c2259"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "19bcf8f92a4866539465c69c6400812a1ee43ee9786943356aaa468ffb26dfc6:eth0",
        "container-id": "19bcf8f92a4866539465c69c6400812a1ee43ee9786943356aaa468ffb26dfc6",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "longhorn-csi-plugin-ssbmv",
        "pod-name": "longhorn-system/longhorn-csi-plugin-ssbmv"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 28201,
        "labels": [
          "k8s:app=longhorn-csi-plugin",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=5769d89c9f",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=longhorn-csi-plugin",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.33",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "b2:0c:ea:15:c9:aa",
        "interface-index": 14,
        "interface-name": "lxcae074a40745f",
        "mac": "1e:d4:5e:dd:54:41"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 28201,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                  ]
                ],
                "rule": "{\"port\":9808,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 28201,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                  ]
                ],
                "rule": "{\"port\":9808,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=4c790d77-1673-4c32-a951-9dccc4b34c5f"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-csi-plugin",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dcfe5679-1b87-415a-be9a-b0f75aff8771"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 89

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 89

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 28201

```
ID      LABELS
28201   k8s:app=longhorn-csi-plugin
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system

```


#### BPF Policy Get 98

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES    PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    277208   3248      0        0
Allow    Ingress     2          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -        -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -        -         0        0
Allow    Egress      0          ANY          NONE         disabled    -        -         0        0

```


#### BPF CT List 98

```
Invalid argument: unknown type 98
```


#### Endpoint Get 98

```
[
  {
    "id": 98,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-98-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "942c1b5b-f0de-44c0-9fac-98160736530c"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "5m0s"
          },
          "name": "resolve-identity-98",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:08:58.878Z",
            "success-count": 95
          },
          "uuid": "cbc89fd8-68c9-4795-907d-cd0338432b10"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-98",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.204Z",
            "success-count": 32
          },
          "uuid": "4c71ba0e-1755-4df5-9891-b2a3607578ca"
        }
      ],
      "external-identifiers": {
        "container-name": "cilium-health",
        "pod-name": "/"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4,
        "labels": [
          "reserved:health"
        ]
      },
      "labels": {
        "realized": {},
        "security-relevant": [
          "reserved:health"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.187",
            "ipv4-pool-name": "default"
          }
        ],
        "host-mac": "aa:6b:ef:55:0d:9e",
        "interface-index": 174,
        "interface-name": "lxc_health",
        "mac": "36:6c:b5:2c:e8:85"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 98

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 98

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4

```
ID   LABELS
4    reserved:health

```


#### BPF Policy Get 130

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    2882694   16130     0        0

```


#### BPF CT List 130

```
Invalid argument: unknown type 130
```


#### Endpoint Get 130

```
[
  {
    "id": 130,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-130-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "cbbda29d-36a9-4074-bf25-7a3bf2769f16"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-cert-manager/cert-manager-cainjector-7f5bd9c869-tz9xj",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:03.149Z",
            "success-count": 2
          },
          "uuid": "64a83d38-76da-4a49-8025-4aa190d7d5ad"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (130)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.820Z",
            "success-count": 1
          },
          "uuid": "fd71789e-1742-404f-9902-b7a1761e1f3f"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-130",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.175Z",
            "success-count": 32
          },
          "uuid": "e8b08806-a723-4d16-a2da-a508cd26e736"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (130)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:19.174Z",
            "success-count": 2823
          },
          "uuid": "7e7ee525-f026-4e6c-b9c6-b68acacca612"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (130)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.820Z",
            "success-count": 1
          },
          "uuid": "6ff47ee0-2854-4225-a2e5-f8264c3ad363"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "e723ca2865b1da0705b80ea9ee050d620d94e925bfa8a6ae3e57fbab583a199f:eth0",
        "container-id": "e723ca2865b1da0705b80ea9ee050d620d94e925bfa8a6ae3e57fbab583a199f",
        "k8s-namespace": "cert-manager",
        "k8s-pod-name": "cert-manager-cainjector-7f5bd9c869-tz9xj",
        "pod-name": "cert-manager/cert-manager-cainjector-7f5bd9c869-tz9xj"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 29089,
        "labels": [
          "k8s:app=cainjector",
          "k8s:app.kubernetes.io/component=cainjector",
          "k8s:app.kubernetes.io/instance=cert-manager",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=cainjector",
          "k8s:app.kubernetes.io/version=v1.13.3",
          "k8s:helm.sh/chart=cert-manager-v1.13.3",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cert-manager",
          "k8s:io.cilium.k8s.namespace.labels.name=cert-manager",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=cert-manager-cainjector",
          "k8s:io.kubernetes.pod.namespace=cert-manager"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=7f5bd9c869"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/component=cainjector",
          "k8s:app.kubernetes.io/instance=cert-manager",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=cainjector",
          "k8s:app.kubernetes.io/version=v1.13.3",
          "k8s:app=cainjector",
          "k8s:helm.sh/chart=cert-manager-v1.13.3",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cert-manager",
          "k8s:io.cilium.k8s.namespace.labels.name=cert-manager",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=cert-manager-cainjector",
          "k8s:io.kubernetes.pod.namespace=cert-manager"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.2",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "02:29:56:68:ca:7f",
        "interface-index": 72,
        "interface-name": "lxc7c4c0f17cfe3",
        "mac": "d6:7e:8a:f0:8e:70"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 29089,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 29089,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 130

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 130

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 29089

```
ID      LABELS
29089   k8s:app.kubernetes.io/component=cainjector
        k8s:app.kubernetes.io/instance=cert-manager
        k8s:app.kubernetes.io/managed-by=Helm
        k8s:app.kubernetes.io/name=cainjector
        k8s:app.kubernetes.io/version=v1.13.3
        k8s:app=cainjector
        k8s:helm.sh/chart=cert-manager-v1.13.3
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=cert-manager
        k8s:io.cilium.k8s.namespace.labels.name=cert-manager
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=cert-manager-cainjector
        k8s:io.kubernetes.pod.namespace=cert-manager

```


#### BPF Policy Get 186

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES       PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -           -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    136573741   806955    0        0
Allow    Ingress     2978       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    561804      7020      0        0
Allow    Ingress     12201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -           -         0        0
Allow    Egress      0          ANY          NONE         disabled    45331974    609606    0        0

```


#### BPF CT List 186

```
Invalid argument: unknown type 186
```


#### Endpoint Get 186

```
[
  {
    "id": 186,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-186-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "721d6932-40a8-4ff6-8f13-73bab020f55b"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-langfuse/langfuse-zookeeper-0",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:03.213Z",
            "success-count": 2
          },
          "uuid": "dfb84650-129e-4e5a-99d1-dcab4bc49c28"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (186)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "e4e03754-4a0d-45f4-893f-d7a0bfa09216"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-186",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.077Z",
            "success-count": 32
          },
          "uuid": "821eadda-7021-439b-90a0-b987f350cd57"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (186)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:20.027Z",
            "success-count": 2823
          },
          "uuid": "5a2618be-466e-4b1d-aa16-8f2a27837af6"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (186)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "a26d7c7e-485a-404d-a067-75da1abb7933"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "071086183ebbae1bd3eb682447e5ad8a908d14af5e7fd8e67656970f502e2724:eth0",
        "container-id": "071086183ebbae1bd3eb682447e5ad8a908d14af5e7fd8e67656970f502e2724",
        "k8s-namespace": "langfuse",
        "k8s-pod-name": "langfuse-zookeeper-0",
        "pod-name": "langfuse/langfuse-zookeeper-0"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 2843,
        "labels": [
          "k8s:app.kubernetes.io/component=zookeeper",
          "k8s:app.kubernetes.io/instance=langfuse",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=zookeeper",
          "k8s:app.kubernetes.io/version=3.9.3",
          "k8s:helm.sh/chart=zookeeper-13.7.4",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=langfuse",
          "k8s:io.cilium.k8s.namespace.labels.name=langfuse",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=langfuse-zookeeper",
          "k8s:io.kubernetes.pod.namespace=langfuse"
        ]
      },
      "labels": {
        "derived": [
          "k8s:apps.kubernetes.io/pod-index=0",
          "k8s:controller-revision-hash=langfuse-zookeeper-6bbf79768",
          "k8s:statefulset.kubernetes.io/pod-name=langfuse-zookeeper-0"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/component=zookeeper",
          "k8s:app.kubernetes.io/instance=langfuse",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=zookeeper",
          "k8s:app.kubernetes.io/version=3.9.3",
          "k8s:helm.sh/chart=zookeeper-13.7.4",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=langfuse",
          "k8s:io.cilium.k8s.namespace.labels.name=langfuse",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=langfuse-zookeeper",
          "k8s:io.kubernetes.pod.namespace=langfuse"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "namedPorts": [
        {
          "name": "client",
          "port": 2181,
          "protocol": "TCP"
        },
        {
          "name": "election",
          "port": 3888,
          "protocol": "TCP"
        },
        {
          "name": "follower",
          "port": 2888,
          "protocol": "TCP"
        },
        {
          "name": "http-admin",
          "port": 8080,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.66",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "b6:0b:05:2e:35:e2",
        "interface-index": 100,
        "interface-name": "lxcf8741af5b68c",
        "mac": "36:aa:5b:52:a9:ab"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 2843,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 2843,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 186

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 186

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 2843

```
ID     LABELS
2843   k8s:app.kubernetes.io/component=zookeeper
       k8s:app.kubernetes.io/instance=langfuse
       k8s:app.kubernetes.io/managed-by=Helm
       k8s:app.kubernetes.io/name=zookeeper
       k8s:app.kubernetes.io/version=3.9.3
       k8s:helm.sh/chart=zookeeper-13.7.4
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=langfuse
       k8s:io.cilium.k8s.namespace.labels.name=langfuse
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=langfuse-zookeeper
       k8s:io.kubernetes.pod.namespace=langfuse

```


#### BPF Policy Get 466

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    89422     1025      0        0
Allow    Ingress     2          ANY          NONE         disabled    2492924   28541     0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    685989    5646      0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    1374002   18821     0        0

```


#### BPF CT List 466

```
Invalid argument: unknown type 466
```


#### Endpoint Get 466

```
[
  {
    "id": 466,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-466-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "3ab970e5-f86c-49a4-8d53-239ed05fde5d"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-harbor/harbor-trivy-0",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:03.122Z",
            "success-count": 2
          },
          "uuid": "1e3325bd-adc5-4235-b5e8-a2f7ab3847a6"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (466)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "030f319f-1026-40ea-88e0-e9b2e141b87d"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-466",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.148Z",
            "success-count": 32
          },
          "uuid": "0447426a-081c-460a-88dc-9cb4aa79cb6a"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (466)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:20.869Z",
            "success-count": 2823
          },
          "uuid": "d7db420a-1203-4897-a955-6f7748f8f96e"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (466)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "c4378762-5864-47a3-a743-a86d9de3362c"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "a7636b239eedf9f2ad19dd9ef177a75ecfe1188667f1a229a8d578a69dc025d3:eth0",
        "container-id": "a7636b239eedf9f2ad19dd9ef177a75ecfe1188667f1a229a8d578a69dc025d3",
        "k8s-namespace": "harbor",
        "k8s-pod-name": "harbor-trivy-0",
        "pod-name": "harbor/harbor-trivy-0"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 16908,
        "labels": [
          "k8s:app=harbor",
          "k8s:app.kubernetes.io/component=trivy",
          "k8s:app.kubernetes.io/instance=harbor",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=harbor",
          "k8s:app.kubernetes.io/part-of=harbor",
          "k8s:app.kubernetes.io/version=2.12.0",
          "k8s:chart=harbor",
          "k8s:component=trivy",
          "k8s:heritage=Helm",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=harbor",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=harbor",
          "k8s:release=harbor"
        ]
      },
      "labels": {
        "derived": [
          "k8s:apps.kubernetes.io/pod-index=0",
          "k8s:controller-revision-hash=harbor-trivy-69fc85796f",
          "k8s:statefulset.kubernetes.io/pod-name=harbor-trivy-0"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/component=trivy",
          "k8s:app.kubernetes.io/instance=harbor",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=harbor",
          "k8s:app.kubernetes.io/part-of=harbor",
          "k8s:app.kubernetes.io/version=2.12.0",
          "k8s:app=harbor",
          "k8s:chart=harbor",
          "k8s:component=trivy",
          "k8s:heritage=Helm",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=harbor",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=harbor",
          "k8s:release=harbor"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "namedPorts": [
        {
          "name": "api-server",
          "port": 8080,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.214",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "72:ce:40:d0:99:d3",
        "interface-index": 142,
        "interface-name": "lxc71cc3c69f482",
        "mac": "4e:61:d3:5e:37:b5"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 16908,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 16908,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 466

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 466

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 16908

```
ID      LABELS
16908   k8s:app.kubernetes.io/component=trivy
        k8s:app.kubernetes.io/instance=harbor
        k8s:app.kubernetes.io/managed-by=Helm
        k8s:app.kubernetes.io/name=harbor
        k8s:app.kubernetes.io/part-of=harbor
        k8s:app.kubernetes.io/version=2.12.0
        k8s:app=harbor
        k8s:chart=harbor
        k8s:component=trivy
        k8s:heritage=Helm
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=harbor
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=default
        k8s:io.kubernetes.pod.namespace=harbor
        k8s:release=harbor

```


#### BPF Policy Get 627

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES    PACKETS   PREFIX   COOKIE
Allow    Ingress     0          9093/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     0          9092/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     1          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -        -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -        -         0        0
Allow    Ingress     10807      8080/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     10807      9091/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     10807      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     11332      9090/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     11332      8080/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     11332      9091/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     11332      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25152      8080/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     25152      9090/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     25152      9091/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     25226      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     33688      9091/TCP     NONE         disabled    14208    192       24       0
Allow    Ingress     33688      9090/TCP     NONE         disabled    11840    160       24       0
Allow    Ingress     33688      8080/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     33688      8443/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     33755      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     60492      9090/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     60492      8080/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     60492      9091/TCP     NONE         disabled    -        -         24       0
Allow    Ingress     60523      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -        -         0        0
Allow    Ingress     16777217   8080/TCP     NONE         disabled    -        -         24       0
Allow    Egress      0          ANY          NONE         disabled    420354   2021      0        0
Allow    Egress      2          ANY          NONE         disabled    -        -         0        0
Allow    Egress      16777217   ANY          NONE         disabled    -        -         0        0

```


#### BPF CT List 627

```
Invalid argument: unknown type 627
```


#### Endpoint Get 627

```
[
  {
    "id": 627,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-627-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "7dc1554d-08ec-4dcf-9964-b41eebf786ca"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-kafka/kafka-cluster-dual-role-1",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:03.146Z",
            "success-count": 2
          },
          "uuid": "997c79d9-2724-4abb-b659-c8717b603e2b"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (627)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "bb72e84d-1d42-4784-8035-119ea8561653"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-627",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.175Z",
            "success-count": 32
          },
          "uuid": "bcdb6aa5-8384-486b-9b94-e58c5fe6d881"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (627)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:20.487Z",
            "success-count": 2823
          },
          "uuid": "1f15ceba-d481-411d-9da3-33bbd5876a8c"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (627)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.820Z",
            "success-count": 1
          },
          "uuid": "9f54e067-dd9f-4db2-8ae4-8d4a938376d3"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "d4acf01588c6877f1fb16f991f12cefeadb4e8ba8082f3050fde90842e443912:eth0",
        "container-id": "d4acf01588c6877f1fb16f991f12cefeadb4e8ba8082f3050fde90842e443912",
        "k8s-namespace": "kafka",
        "k8s-pod-name": "kafka-cluster-dual-role-1",
        "pod-name": "kafka/kafka-cluster-dual-role-1"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 60492,
        "labels": [
          "k8s:app.kubernetes.io/instance=kafka-cluster",
          "k8s:app.kubernetes.io/managed-by=strimzi-cluster-operator",
          "k8s:app.kubernetes.io/name=kafka",
          "k8s:app.kubernetes.io/part-of=strimzi-kafka-cluster",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kafka-cluster-kafka",
          "k8s:io.kubernetes.pod.namespace=kafka",
          "k8s:strimzi.io/broker-role=true",
          "k8s:strimzi.io/cluster=kafka-cluster",
          "k8s:strimzi.io/component-type=kafka",
          "k8s:strimzi.io/controller=strimzipodset",
          "k8s:strimzi.io/controller-name=kafka-cluster-dual-role",
          "k8s:strimzi.io/controller-role=true",
          "k8s:strimzi.io/kind=Kafka",
          "k8s:strimzi.io/name=kafka-cluster-kafka",
          "k8s:strimzi.io/pod-name=kafka-cluster-dual-role-1",
          "k8s:strimzi.io/pool-name=dual-role"
        ]
      },
      "labels": {
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=kafka-cluster",
          "k8s:app.kubernetes.io/managed-by=strimzi-cluster-operator",
          "k8s:app.kubernetes.io/name=kafka",
          "k8s:app.kubernetes.io/part-of=strimzi-kafka-cluster",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=kafka-cluster-kafka",
          "k8s:io.kubernetes.pod.namespace=kafka",
          "k8s:strimzi.io/broker-role=true",
          "k8s:strimzi.io/cluster=kafka-cluster",
          "k8s:strimzi.io/component-type=kafka",
          "k8s:strimzi.io/controller-name=kafka-cluster-dual-role",
          "k8s:strimzi.io/controller-role=true",
          "k8s:strimzi.io/controller=strimzipodset",
          "k8s:strimzi.io/kind=Kafka",
          "k8s:strimzi.io/name=kafka-cluster-kafka",
          "k8s:strimzi.io/pod-name=kafka-cluster-dual-role-1",
          "k8s:strimzi.io/pool-name=dual-role"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "namedPorts": [
        {
          "name": "tcp-clients",
          "port": 9092,
          "protocol": "TCP"
        },
        {
          "name": "tcp-clientstls",
          "port": 9093,
          "protocol": "TCP"
        },
        {
          "name": "tcp-ctrlplane",
          "port": 9090,
          "protocol": "TCP"
        },
        {
          "name": "tcp-kafkaagent",
          "port": 8443,
          "protocol": "TCP"
        },
        {
          "name": "tcp-replication",
          "port": 9091,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.189",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "66:8e:c7:c5:3c:b5",
        "interface-index": 106,
        "interface-name": "lxc4a5b4f6108c5",
        "mac": "6a:53:17:b8:ac:27"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0,
            2,
            16777217
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 60492,
          "l4": {
            "egress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-internet",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:0.0.0.0/0\":null}]}"
              }
            ],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                  ]
                ],
                "rule": "{\"port\":8080,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9090,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9091,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-cruise-control,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-entity-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-kafka-exporter,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-cruise-control,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-entity-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-kafka-exporter,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":8443,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9093,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-internet",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9092,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:0.0.0.0/0\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-internet",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "cidr:0.0.0.0/0": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-internet",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-both",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0,
            2,
            16777217
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 60492,
          "l4": {
            "egress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-internet",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:0.0.0.0/0\":null}]}"
              }
            ],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9091,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-cruise-control,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-entity-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-kafka-exporter,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-cruise-control,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-entity-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/name: kafka-cluster-kafka-exporter,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":8443,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9093,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-same-namespace",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=4f936664-abef-481c-a701-081659408cae"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-internet",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9092,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:0.0.0.0/0\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-internet",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "cidr:0.0.0.0/0": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-internet",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=3435d905-c9c4-480e-b86e-a2c964f77c42"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                  ]
                ],
                "rule": "{\"port\":8080,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=allow-node-ingress",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=a9a888a5-cbf8-4324-bab7-fa93a3a6b77b"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                    "k8s:io.cilium.k8s.policy.namespace=kafka",
                    "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                  ]
                ],
                "rule": "{\"port\":9090,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/cluster: kafka-cluster,k8s.strimzi.io/kind: Kafka,k8s.strimzi.io/name: kafka-cluster-kafka,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: kafka,k8s.strimzi.io/kind: cluster-operator,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=kafka-cluster-network-policy-kafka",
                      "k8s:io.cilium.k8s.policy.namespace=kafka",
                      "k8s:io.cilium.k8s.policy.uid=fe94c07b-4435-4613-a859-3cc3c265e445"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-both",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 627

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 627

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 60492

```
ID      LABELS
60492   k8s:app.kubernetes.io/instance=kafka-cluster
        k8s:app.kubernetes.io/managed-by=strimzi-cluster-operator
        k8s:app.kubernetes.io/name=kafka
        k8s:app.kubernetes.io/part-of=strimzi-kafka-cluster
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=kafka
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=kafka-cluster-kafka
        k8s:io.kubernetes.pod.namespace=kafka
        k8s:strimzi.io/broker-role=true
        k8s:strimzi.io/cluster=kafka-cluster
        k8s:strimzi.io/component-type=kafka
        k8s:strimzi.io/controller-name=kafka-cluster-dual-role
        k8s:strimzi.io/controller-role=true
        k8s:strimzi.io/controller=strimzipodset
        k8s:strimzi.io/kind=Kafka
        k8s:strimzi.io/name=kafka-cluster-kafka
        k8s:strimzi.io/pod-name=kafka-cluster-dual-role-1
        k8s:strimzi.io/pool-name=dual-role

```


#### BPF Policy Get 665

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES       PACKETS   PREFIX   COOKIE
Allow    Ingress     0          9503/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     0          9502/TCP     NONE         disabled    394614      4190      24       0
Allow    Ingress     1          9501/TCP     NONE         disabled    222420      1027      24       0
Allow    Ingress     1          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2          ANY          NONE         disabled    6330864     29219     0        0
Allow    Ingress     6          9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     7          9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     9          ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -           -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1252       9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     1252       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3446       9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     3446       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4394       9501/TCP     NONE         disabled    131670      1995      24       0
Allow    Ingress     4394       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6043       9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     6043       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     8453       9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     8779       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -           -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15473      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     15505      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17163      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     17163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19572      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     19572      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23106      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     23106      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27422      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     27422      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    1047980     12206     0        0
Allow    Ingress     28201      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     28530      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29163      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     29163      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29395      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     29994      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     29994      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     31674      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     34995      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     35682      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39166      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     39166      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43339      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     43339      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     43550      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     43616      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    38929       351       0        0
Allow    Ingress     47918      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     48334      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     49075      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     49276      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     53439      9501/TCP     NONE         disabled    -           -         24       0
Allow    Ingress     54396      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -           -         0        0
Allow    Ingress     16777217   9501/TCP     NONE         disabled    -           -         24       0
Allow    Egress      0          ANY          NONE         disabled    181313662   1412330   0        0

```


#### BPF CT List 665

```
Invalid argument: unknown type 665
```


#### Endpoint Get 665

```
[
  {
    "id": 665,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-665-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "a6413dae-769e-4958-bd9f-7fa0d65f8859"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/longhorn-manager-br5gn",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:03.220Z",
            "success-count": 2
          },
          "uuid": "53426034-d94f-4489-a0b2-1e7311158597"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (665)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.820Z",
            "success-count": 1
          },
          "uuid": "149fc8b8-7940-4d9e-bf1f-2f0d1bdf8fb1"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-665",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.092Z",
            "success-count": 32
          },
          "uuid": "4e5d4a2c-2e56-4fbe-a85b-690a3512329c"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (665)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:20.669Z",
            "success-count": 2823
          },
          "uuid": "fded3761-d855-464a-bf8c-2f0fc18e31f4"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (665)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.820Z",
            "success-count": 1
          },
          "uuid": "cb4a6481-023d-4050-9b79-452221da8067"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "4dc9d8507a49fc65a8b550f06742f0eb19e397c01ea5db2d618446688a62d65a:eth0",
        "container-id": "4dc9d8507a49fc65a8b550f06742f0eb19e397c01ea5db2d618446688a62d65a",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "longhorn-manager-br5gn",
        "pod-name": "longhorn-system/longhorn-manager-br5gn"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 4394,
        "labels": [
          "k8s:app=longhorn-manager",
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/admission-webhook=longhorn-admission-webhook",
          "k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook",
          "k8s:longhorn.io/recovery-backend=longhorn-recovery-backend"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=55566b9bd7",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=longhorn",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=longhorn",
          "k8s:app.kubernetes.io/version=v1.9.0",
          "k8s:app=longhorn-manager",
          "k8s:helm.sh/chart=longhorn-1.9.0",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/admission-webhook=longhorn-admission-webhook",
          "k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook",
          "k8s:longhorn.io/recovery-backend=longhorn-recovery-backend"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "namedPorts": [
        {
          "name": "admission-wh",
          "port": 9502,
          "protocol": "TCP"
        },
        {
          "name": "conversion-wh",
          "port": 9501,
          "protocol": "TCP"
        },
        {
          "name": "manager",
          "port": 9500,
          "protocol": "TCP"
        },
        {
          "name": "recov-backend",
          "port": 9503,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.30",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "9e:21:28:2e:84:04",
        "interface-index": 16,
        "interface-name": "lxc9a6e31757ed5",
        "mac": "e2:c8:38:03:98:40"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4394,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                  ]
                ],
                "rule": "{\"port\":9501,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                  ]
                ],
                "rule": "{\"port\":9502,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                  ]
                ],
                "rule": "{\"port\":9503,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 4394,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                  ],
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                  ]
                ],
                "rule": "{\"port\":9501,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"cidr:10.0.0.0/12\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-csi-plugin,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-driver-deployer,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-manager,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.app: longhorn-ui,k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,k8s.longhorn.io/managed-by: longhorn-manager,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.longhorn.io/job-task,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,k8s.io.kubernetes.pod.namespace: longhorn-system,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.host: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.remote-node: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager-node-access",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=3692c6de-9cb3-4390-bb4b-3e56867f9f61"
                    ]
                  ],
                  "cidr:10.0.0.0/12": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-manager",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=b67ca757-20b6-4cf0-87ee-db5250a899a8"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                  ]
                ],
                "rule": "{\"port\":9502,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-admission-webhook",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=dafd5ae7-fec1-4361-9b68-15a84634f20e"
                    ]
                  ]
                }
              },
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                    "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                    "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                  ]
                ],
                "rule": "{\"port\":9503,\"protocol\":\"TCP\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=NetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=longhorn-recovery-backend",
                      "k8s:io.cilium.k8s.policy.namespace=longhorn-system",
                      "k8s:io.cilium.k8s.policy.uid=a48ed662-92ca-48cf-8eb5-84f664e63c39"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 665

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 665

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 4394

```
ID     LABELS
4394   k8s:app.kubernetes.io/instance=longhorn
       k8s:app.kubernetes.io/managed-by=Helm
       k8s:app.kubernetes.io/name=longhorn
       k8s:app.kubernetes.io/version=v1.9.0
       k8s:app=longhorn-manager
       k8s:helm.sh/chart=longhorn-1.9.0
       k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
       k8s:io.cilium.k8s.policy.cluster=default
       k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
       k8s:io.kubernetes.pod.namespace=longhorn-system
       k8s:longhorn.io/admission-webhook=longhorn-admission-webhook
       k8s:longhorn.io/conversion-webhook=longhorn-conversion-webhook
       k8s:longhorn.io/recovery-backend=longhorn-recovery-backend

```


#### BPF Policy Get 815

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES   PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9          ANY          NONE         disabled    -       -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -       -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -       -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -       -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -       -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -       -         0        0
Allow    Egress      0          ANY          NONE         disabled    -       -         0        0

```


#### BPF CT List 815

```
Invalid argument: unknown type 815
```


#### Endpoint Get 815

```
[
  {
    "id": 815,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-815-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "893f1e47-2b79-4a57-ad5e-73535f70e56e"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-longhorn-system/engine-image-ei-e09d8caa-qpljv",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:03.188Z",
            "success-count": 2
          },
          "uuid": "80b61a76-7573-4344-9bd8-15c3b1085995"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (815)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "e794ff0d-e5b5-48a3-befd-c2f978405a9d"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-815",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.034Z",
            "success-count": 32
          },
          "uuid": "1438dcf0-e9a9-4861-850c-f85d58b0dfa5"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (815)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:20.739Z",
            "success-count": 2823
          },
          "uuid": "3a3615b6-dc7a-45a3-bb2b-7d2db64069ef"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (815)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "54861076-c3d6-4e41-9021-82610cf9ce73"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "6228e91364199aa291a801555852fc376eac01d05d92e5acbecf918cd1a7015f:eth0",
        "container-id": "6228e91364199aa291a801555852fc376eac01d05d92e5acbecf918cd1a7015f",
        "k8s-namespace": "longhorn-system",
        "k8s-pod-name": "engine-image-ei-e09d8caa-qpljv",
        "pod-name": "longhorn-system/engine-image-ei-e09d8caa-qpljv"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 43550,
        "labels": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=engine-image",
          "k8s:longhorn.io/engine-image=ei-e09d8caa"
        ]
      },
      "labels": {
        "derived": [
          "k8s:controller-revision-hash=76b647f6f7",
          "k8s:pod-template-generation=1"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account",
          "k8s:io.kubernetes.pod.namespace=longhorn-system",
          "k8s:longhorn.io/component=engine-image",
          "k8s:longhorn.io/engine-image=ei-e09d8caa"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.19",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "fe:a2:1e:53:46:32",
        "interface-index": 12,
        "interface-name": "lxc452717fc664e",
        "mac": "76:50:e9:48:3b:99"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43550,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 43550,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 815

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 815

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 43550

```
ID      LABELS
43550   k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=longhorn-system
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=longhorn-service-account
        k8s:io.kubernetes.pod.namespace=longhorn-system
        k8s:longhorn.io/component=engine-image
        k8s:longhorn.io/engine-image=ei-e09d8caa

```


#### BPF Policy Get 855

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    85074     961       0        0
Allow    Ingress     2          ANY          NONE         disabled    2381724   26855     0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    192586    2376      0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    9777965   98790     0        0

```


#### BPF CT List 855

```
Invalid argument: unknown type 855
```


#### Endpoint Get 855

```
[
  {
    "id": 855,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-855-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "52626779-1d42-4017-a70b-246b2e9e8caa"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-harbor/harbor-core-58f556d759-46sp4",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:03.149Z",
            "success-count": 2
          },
          "uuid": "e9513566-c1b4-4ef8-aca9-98db3f08b483"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (855)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.820Z",
            "success-count": 1
          },
          "uuid": "674d9123-318f-486d-8bce-885b8372a607"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-855",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.175Z",
            "success-count": 32
          },
          "uuid": "ec5a572d-3501-4c8b-b13b-458d0a5cf356"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (855)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:29.430Z",
            "success-count": 2824
          },
          "uuid": "795687c8-25b0-4eed-ba42-2331ac766758"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (855)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.820Z",
            "success-count": 1
          },
          "uuid": "d31dd4bc-1f9f-4eb2-9a6a-dfe38d81dae0"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "301fc6b7121359211d7b0b9c268e130f8211b00247fb84c0cf6d7a610b9c1687:eth0",
        "container-id": "301fc6b7121359211d7b0b9c268e130f8211b00247fb84c0cf6d7a610b9c1687",
        "k8s-namespace": "harbor",
        "k8s-pod-name": "harbor-core-58f556d759-46sp4",
        "pod-name": "harbor/harbor-core-58f556d759-46sp4"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 32467,
        "labels": [
          "k8s:app=harbor",
          "k8s:app.kubernetes.io/component=core",
          "k8s:app.kubernetes.io/instance=harbor",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=harbor",
          "k8s:app.kubernetes.io/part-of=harbor",
          "k8s:app.kubernetes.io/version=2.12.0",
          "k8s:chart=harbor",
          "k8s:component=core",
          "k8s:heritage=Helm",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=harbor",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=harbor",
          "k8s:release=harbor"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=58f556d759"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/component=core",
          "k8s:app.kubernetes.io/instance=harbor",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=harbor",
          "k8s:app.kubernetes.io/part-of=harbor",
          "k8s:app.kubernetes.io/version=2.12.0",
          "k8s:app=harbor",
          "k8s:chart=harbor",
          "k8s:component=core",
          "k8s:heritage=Helm",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=harbor",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=harbor",
          "k8s:release=harbor"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.78",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "0e:9a:30:7e:63:0b",
        "interface-index": 68,
        "interface-name": "lxc9ea9f38937e6",
        "mac": "9e:1d:dd:6c:ed:5e"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 32467,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 32467,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 855

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 855

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 32467

```
ID      LABELS
32467   k8s:app.kubernetes.io/component=core
        k8s:app.kubernetes.io/instance=harbor
        k8s:app.kubernetes.io/managed-by=Helm
        k8s:app.kubernetes.io/name=harbor
        k8s:app.kubernetes.io/part-of=harbor
        k8s:app.kubernetes.io/version=2.12.0
        k8s:app=harbor
        k8s:chart=harbor
        k8s:component=core
        k8s:heritage=Helm
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=harbor
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=default
        k8s:io.kubernetes.pod.namespace=harbor
        k8s:release=harbor

```


#### BPF Policy Get 940

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES        PACKETS    PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9          ANY          NONE         disabled    -            -          0        0
Allow    Ingress     10         ANY          NONE         disabled    -            -          0        0
Allow    Ingress     465        ANY          NONE         disabled    -            -          0        0
Allow    Ingress     566        ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1252       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1596       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1624       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     1637       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2269       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2645       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2833       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2843       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     2978       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3128       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3446       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3592       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3761       ANY          NONE         disabled    152596315    75003      0        0
Allow    Ingress     3836       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     3866       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     4394       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     4988       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5015       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5080       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5117       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5438       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5493       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5643       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     5993       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6043       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6344       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     6933       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     7513       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     7936       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8105       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8231       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8241       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8367       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8453       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     8779       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9194       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     9585       ANY          NONE         disabled    -            -          0        0
Allow    Ingress     10807      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     11332      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12176      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12201      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12307      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     12337      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13556      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13626      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     13786      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14280      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14657      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14667      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14966      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     14973      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15202      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15473      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15505      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     15927      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16376      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16908      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16992      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     17163      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     17926      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     18592      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     18622      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19324      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19460      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19572      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19792      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19881      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     19945      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     20806      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     22863      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     22922      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     23106      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     23582      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     24706      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     24736      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25152      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25226      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25555      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     25589      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26001      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26267      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26869      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     26892      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     27422      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     27486      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28201      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28530      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     28621      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29089      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29163      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29395      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     29994      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     31674      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     31840      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     32467      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33088      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33311      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33454      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33688      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     33755      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34216      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34266      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34352      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34736      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     34995      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     35682      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     35696      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     36596      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     37415      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     37517      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     38491      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39166      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39278      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     39699      ANY          NONE         disabled    38153606     54360      0        0
Allow    Ingress     40088      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     41969      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42199      ANY          NONE         disabled    5122575252   14127282   0        0
Allow    Ingress     42605      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     42869      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43339      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43550      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     43616      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     47483      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     47918      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     48334      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     48593      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     49075      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     49276      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52241      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52642      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     52772      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53263      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53293      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     53439      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     54396      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     54583      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     55202      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     55741      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     57633      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     58710      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60465      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60492      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     60523      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     61421      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     61927      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     62026      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     63330      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     64556      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     65239      ANY          NONE         disabled    -            -          0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -            -          0        0
Allow    Egress      0          ANY          NONE         disabled    -            -          0        0

```


#### BPF CT List 940

```
Invalid argument: unknown type 940
```


#### Endpoint Get 940

```
[
  {
    "id": 940,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-940-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "644df97e-3921-4690-8eb5-56f7c3597f29"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-redacted-dev/redacted-weather-data-converter-dev-b7d6b585-767xn",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:03.086Z",
            "success-count": 2
          },
          "uuid": "28c996c3-3e56-482f-9671-0d3d7d61ba2c"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (940)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.820Z",
            "success-count": 1
          },
          "uuid": "50bc9421-2cce-48ba-a8ed-83639b2c2264"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-940",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.112Z",
            "success-count": 32
          },
          "uuid": "f3de7ad9-e785-40ee-b804-a64cd6646b62"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (940)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:29.558Z",
            "success-count": 2824
          },
          "uuid": "c62fe251-3d25-401c-b487-cf8d58f1027e"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (940)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.820Z",
            "success-count": 1
          },
          "uuid": "eb2b00e2-597e-4d46-8f14-e3d592104ffa"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "512fd3ed4ebf928260af12e1c778dc38b7f96215c836b56edf872c349dfbe38c:eth0",
        "container-id": "512fd3ed4ebf928260af12e1c778dc38b7f96215c836b56edf872c349dfbe38c",
        "k8s-namespace": "redacted-dev",
        "k8s-pod-name": "redacted-weather-data-converter-dev-b7d6b585-767xn",
        "pod-name": "redacted-dev/redacted-weather-data-converter-dev-b7d6b585-767xn"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 15202,
        "labels": [
          "k8s:app=redacted-weather-data-converter-dev",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=redacted-dev"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=b7d6b585"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app=redacted-weather-data-converter-dev",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=default",
          "k8s:io.kubernetes.pod.namespace=redacted-dev"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.4",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "a2:58:bb:2c:cb:fd",
        "interface-index": 108,
        "interface-name": "lxc9ff123636f0b",
        "mac": "8e:6d:4d:df:55:f5"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 15202,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 15202,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 940

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 940

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:38:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:38:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:38:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:36:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:36:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:36:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:34:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:34:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:34:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:32:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:32:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:32:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:30:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:30:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:30:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:28:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:28:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:28:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:26:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:26:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:26:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:24:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:24:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:24:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:22:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:22:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:22:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:20:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:20:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:20:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:18:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:18:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:18:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:16:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:16:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:16:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:14:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:14:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:14:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:12:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:12:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:12:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:10:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:10:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:10:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T20:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T20:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T20:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration

```


#### Identity get 15202

```
ID      LABELS
15202   k8s:app=redacted-weather-data-converter-dev
        k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=redacted-dev
        k8s:io.cilium.k8s.policy.cluster=default
        k8s:io.cilium.k8s.policy.serviceaccount=default
        k8s:io.kubernetes.pod.namespace=redacted-dev

```


#### BPF Policy Get 975

```
POLICY   DIRECTION   IDENTITY   PORT/PROTO   PROXY PORT   AUTH TYPE   BYTES     PACKETS   PREFIX   COOKIE
Allow    Ingress     1          ANY          NONE         disabled    137621    1723      0        0
Allow    Ingress     2          ANY          NONE         disabled    3815989   47687     0        0
Allow    Ingress     9          ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10         ANY          NONE         disabled    -         -         0        0
Allow    Ingress     465        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     566        ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1252       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1596       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1624       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     1637       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2269       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2645       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2833       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2843       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     2978       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3128       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3446       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3592       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3761       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3836       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     3866       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4394       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     4988       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5015       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5080       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5117       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5438       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5493       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5643       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     5993       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6043       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6344       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     6933       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7513       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     7936       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8105       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8231       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8241       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8367       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8453       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     8779       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9194       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     9585       ANY          NONE         disabled    -         -         0        0
Allow    Ingress     10807      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     11332      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12176      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12307      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     12337      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13626      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     13786      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14280      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14657      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14667      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14966      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     14973      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15473      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15505      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     15927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16376      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16908      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16992      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     17926      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18592      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     18622      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19324      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19460      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19572      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19792      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19881      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     19945      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     20806      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22863      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     22922      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23106      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     23582      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24706      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     24736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25152      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25226      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25555      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     25589      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26001      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26267      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     26892      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27422      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     27486      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28201      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28530      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     28621      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29089      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29163      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29395      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     29994      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31674      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     31840      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     32467      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33311      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33454      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33688      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     33755      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34216      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34266      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34352      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34736      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     34995      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35682      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     35696      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     36596      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37415      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     37517      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     38491      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39166      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39278      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     39699      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     40088      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     41969      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42199      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42605      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     42869      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43339      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43550      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     43616      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47483      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     47918      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48334      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     48593      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49075      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     49276      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52241      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52642      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     52772      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53263      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53293      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     53439      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54396      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     54583      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55202      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     55741      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     57633      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     58710      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60465      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60492      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     60523      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61421      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     61927      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     62026      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     63330      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     64556      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     65239      ANY          NONE         disabled    -         -         0        0
Allow    Ingress     16777217   ANY          NONE         disabled    -         -         0        0
Allow    Egress      0          ANY          NONE         disabled    -         -         0        0

```


#### BPF CT List 975

```
Invalid argument: unknown type 975
```


#### Endpoint Get 975

```
[
  {
    "id": 975,
    "spec": {
      "label-configuration": {},
      "options": {
        "ConntrackAccounting": "Disabled",
        "Debug": "Disabled",
        "DebugLB": "Disabled",
        "DebugPolicy": "Disabled",
        "DropNotification": "Enabled",
        "MonitorAggregationLevel": "Medium",
        "PolicyAccounting": "Enabled",
        "PolicyAuditMode": "Enabled",
        "PolicyVerdictNotification": "Enabled",
        "SourceIPVerification": "Enabled",
        "TraceNotification": "Enabled"
      }
    },
    "status": {
      "controllers": [
        {
          "configuration": {
            "error-retry": true,
            "error-retry-base": "2s",
            "interval": "1s"
          },
          "name": "endpoint-975-regeneration-recovery",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "0001-01-01T00:00:00.000Z"
          },
          "uuid": "2f42d738-3a9a-4e39-a69f-19c1b85180e4"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "resolve-labels-langfuse/langfuse-s3-6797cbd7d-kc6k6",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:19:03.149Z",
            "success-count": 2
          },
          "uuid": "8fff0abc-35bf-4777-b398-c5fa2a34b42e"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "restoring-ep-identity (975)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "02ecac72-c353-4c88-becf-8aef90763c9a"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "15m0s"
          },
          "name": "sync-policymap-975",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:04:03.028Z",
            "success-count": 32
          },
          "uuid": "fb0791a2-a666-458b-bd6b-cc53b43f895e"
        },
        {
          "configuration": {
            "error-retry": true,
            "interval": "10s"
          },
          "name": "sync-to-k8s-ciliumendpoint (975)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T22:09:30.135Z",
            "success-count": 2824
          },
          "uuid": "a5538781-5399-4280-aa97-2e7c668ab6d8"
        },
        {
          "configuration": {
            "error-retry": true
          },
          "name": "waiting-initial-global-identities-ep (975)",
          "status": {
            "last-failure-timestamp": "0001-01-01T00:00:00.000Z",
            "last-success-timestamp": "2026-01-19T14:18:57.819Z",
            "success-count": 1
          },
          "uuid": "0b4236c5-4918-4179-b95e-be38dc244cf5"
        }
      ],
      "external-identifiers": {
        "cni-attachment-id": "bb6866da4747918986d75ba1e6defb4c6610725f654a1517d6b0c734ab82d1a4:eth0",
        "container-id": "bb6866da4747918986d75ba1e6defb4c6610725f654a1517d6b0c734ab82d1a4",
        "k8s-namespace": "langfuse",
        "k8s-pod-name": "langfuse-s3-6797cbd7d-kc6k6",
        "pod-name": "langfuse/langfuse-s3-6797cbd7d-kc6k6"
      },
      "health": {
        "bpf": "OK",
        "connected": true,
        "overallHealth": "OK",
        "policy": "OK"
      },
      "identity": {
        "id": 28621,
        "labels": [
          "k8s:app.kubernetes.io/instance=langfuse",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=s3",
          "k8s:app.kubernetes.io/version=2024.12.18",
          "k8s:helm.sh/chart=s3-14.10.5",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=langfuse",
          "k8s:io.cilium.k8s.namespace.labels.name=langfuse",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=langfuse-s3",
          "k8s:io.kubernetes.pod.namespace=langfuse"
        ]
      },
      "labels": {
        "derived": [
          "k8s:pod-template-hash=6797cbd7d"
        ],
        "realized": {},
        "security-relevant": [
          "k8s:app.kubernetes.io/instance=langfuse",
          "k8s:app.kubernetes.io/managed-by=Helm",
          "k8s:app.kubernetes.io/name=s3",
          "k8s:app.kubernetes.io/version=2024.12.18",
          "k8s:helm.sh/chart=s3-14.10.5",
          "k8s:io.cilium.k8s.namespace.labels.kubernetes.io/metadata.name=langfuse",
          "k8s:io.cilium.k8s.namespace.labels.name=langfuse",
          "k8s:io.cilium.k8s.policy.cluster=default",
          "k8s:io.cilium.k8s.policy.serviceaccount=langfuse-s3",
          "k8s:io.kubernetes.pod.namespace=langfuse"
        ]
      },
      "log": [
        {
          "code": "OK",
          "message": "Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)",
          "state": "ready",
          "timestamp": "2026-01-19T22:08:57Z"
        }
      ],
      "namedPorts": [
        {
          "name": "minio-api",
          "port": 9000,
          "protocol": "TCP"
        },
        {
          "name": "minio-console",
          "port": 9001,
          "protocol": "TCP"
        }
      ],
      "networking": {
        "addressing": [
          {
            "ipv4": "10.0.11.36",
            "ipv4-pool-name": "default"
          }
        ],
        "container-interface-name": "eth0",
        "host-mac": "22:98:7a:be:af:ef",
        "interface-index": 98,
        "interface-name": "lxc9eac7433fdb9",
        "mac": "0e:26:0e:d5:f4:b6"
      },
      "policy": {
        "proxy-policy-revision": 25,
        "proxy-statistics": [],
        "realized": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 28621,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        },
        "spec": {
          "allowed-egress-identities": [
            0
          ],
          "allowed-ingress-identities": [
            1,
            2,
            9,
            10,
            465,
            566,
            1252,
            1596,
            1624,
            1637,
            2269,
            2645,
            2833,
            2843,
            2978,
            3128,
            3446,
            3592,
            3761,
            3836,
            3866,
            4394,
            4988,
            5015,
            5080,
            5117,
            5438,
            5493,
            5643,
            5993,
            6043,
            6344,
            6933,
            7513,
            7936,
            8105,
            8231,
            8241,
            8367,
            8453,
            8779,
            9194,
            9585,
            10807,
            11332,
            12176,
            12201,
            12307,
            12337,
            13556,
            13626,
            13786,
            14280,
            14657,
            14667,
            14966,
            14973,
            15202,
            15473,
            15505,
            15927,
            16376,
            16908,
            16992,
            17163,
            17926,
            18592,
            18622,
            19324,
            19460,
            19572,
            19792,
            19881,
            19945,
            20806,
            22863,
            22922,
            23106,
            23582,
            24706,
            24736,
            25152,
            25226,
            25555,
            25589,
            26001,
            26267,
            26869,
            26892,
            27422,
            27486,
            28201,
            28530,
            28621,
            29089,
            29163,
            29395,
            29994,
            31674,
            31840,
            32467,
            33088,
            33311,
            33454,
            33688,
            33755,
            34216,
            34266,
            34352,
            34736,
            34995,
            35682,
            35696,
            36596,
            37415,
            37517,
            38491,
            39166,
            39278,
            39699,
            40088,
            41969,
            42199,
            42605,
            42869,
            43339,
            43550,
            43616,
            47483,
            47918,
            48334,
            48593,
            49075,
            49276,
            52241,
            52642,
            52772,
            53263,
            53293,
            53439,
            54396,
            54583,
            55202,
            55741,
            57633,
            58710,
            60465,
            60492,
            60523,
            61421,
            61927,
            62026,
            63330,
            64556,
            65239,
            16777217
          ],
          "build": 25,
          "denied-egress-identities": null,
          "denied-ingress-identities": null,
          "id": 28621,
          "l4": {
            "egress": [],
            "ingress": [
              {
                "derived-from-rules": [
                  [
                    "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                    "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                    "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                  ]
                ],
                "rule": "{\"port\":0,\"protocol\":\"ANY\",\"l7-rules\":[{\"\\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null},{\"\\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}\":null}]}",
                "rules-by-selector": {
                  "\u0026LabelSelector{MatchLabels:map[string]string{k8s.io.cilium.k8s.policy.cluster: default,},MatchExpressions:[]LabelSelectorRequirement{LabelSelectorRequirement{Key:k8s.io.kubernetes.pod.namespace,Operator:Exists,Values:[],},},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv4: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world-ipv6: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ],
                  "\u0026LabelSelector{MatchLabels:map[string]string{reserved.world: ,},MatchExpressions:[]LabelSelectorRequirement{},}": [
                    [
                      "k8s:io.cilium.k8s.policy.derived-from=CiliumClusterwideNetworkPolicy",
                      "k8s:io.cilium.k8s.policy.name=test-allow-cluster-ingress-all",
                      "k8s:io.cilium.k8s.policy.uid=43ed3334-a7fd-4b02-a5ec-b7234ea021b4"
                    ]
                  ]
                }
              }
            ]
          },
          "policy-enabled": "audit-ingress",
          "policy-revision": 25
        }
      },
      "realized": {
        "label-configuration": {},
        "options": {
          "ConntrackAccounting": "Disabled",
          "Debug": "Disabled",
          "DebugLB": "Disabled",
          "DebugPolicy": "Disabled",
          "DropNotification": "Enabled",
          "MonitorAggregationLevel": "Medium",
          "PolicyAccounting": "Enabled",
          "PolicyAuditMode": "Enabled",
          "PolicyVerdictNotification": "Enabled",
          "SourceIPVerification": "Enabled",
          "TraceNotification": "Enabled"
        }
      },
      "state": "ready"
    }
  }
]


```


#### Endpoint Health 975

```
Overall Health:   OK
BPF Health:       OK
Policy Health:    OK
Connected:        yes

```


#### Endpoint Log 975

```
Timestamp              Status   State                   Message
2026-01-19T22:08:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:08:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:08:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:08:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:06:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:06:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:06:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:04:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:04:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:04:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:02:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:02:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:02:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T22:00:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T22:00:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T22:00:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:58:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:58:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:58:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:56:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:56:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:56:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:54:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:54:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:54:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:52:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:52:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:52:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:50:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:50:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:50:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:48:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:48:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:48:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:46:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:46:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:46:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:44:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:44:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:44:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:42:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:42:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:42:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:40:57Z   OK       ready                   Completed endpoint regeneration with no pending regeneration requests
2026-01-19T21:40:57Z   OK       regenerating            Regenerating endpoint: periodic endpoint regeneration
2026-01-19T21:40:57Z   OK       waiting-to-regenerate   Triggering endpoint regeneration due to periodic endpoint regeneration
2026-01-19T21:38:57Z   OK       ready                   Successfully regenerated endpoint program (Reason: periodic endpoint regeneration)
2026-01-19T21:38:57Z   OK  