#include "lib/utils.h"

/*
 cilium.v4.external.str 192.168.100.10
 cilium.v4.internal.str 10.0.13.178
 cilium.v4.nodeport.str [65.109.103.254 100.64.0.154 192.168.100.10]

 cilium.v4.internal.raw 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xa, 0x0, 0xd, 0xb2
 */

#define CT_MAP_SIZE_TCP 1183953
#define CT_MAP_SIZE_ANY 591976
DECLARE_CONFIG(__u32, identity_length, "Identity length in bits");
ASSIGN_CONFIG(__u32, identity_length, 16);
DECLARE_CONFIG(__u32, interface_ifindex, "ifindex of the interface the bpf program is attached to");
#define AUTH_MAP_SIZE 524288
#define CIDR_IDENTITY_RANGE_END 33554431
#define CIDR_IDENTITY_RANGE_START 16777217
#define CILIUM_HOST_IFINDEX 6
#define CILIUM_HOST_MAC {.addr={0x4e,0x7c,0x3e,0x19,0x8b,0x3d}}
#define CILIUM_IPV4_FRAG_MAP_MAX_ENTRIES 8192
#define CILIUM_IPV6_FRAG_MAP_MAX_ENTRIES 8192
#define CILIUM_LB_ACT_MAP_MAX_ENTRIES 1
#define CILIUM_LB_AFFINITY_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_BACKENDS_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_MAGLEV_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_REV_NAT_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_SERVICE_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_SKIP_MAP_MAX_ENTRIES 100
#define CILIUM_LB_SOURCE_RANGE_MAP_MAX_ENTRIES 65536
#define CILIUM_NET_IFINDEX 5
#define CILIUM_NET_MAC {.addr={0xe,0x32,0x4b,0x75,0x3,0xcf}}
#define CONFIG_MAP_SIZE 256
#define CT_CLOSE_TIMEOUT 10
#define CT_CONNECTION_LIFETIME_NONTCP 60
#define CT_CONNECTION_LIFETIME_TCP 8000
#define CT_REPORT_FLAGS 0x00ff
#define CT_REPORT_INTERVAL 5
#define CT_SERVICE_CLOSE_REBALANCE 60
#define CT_SERVICE_LIFETIME_NONTCP 60
#define CT_SERVICE_LIFETIME_TCP 8000
#define CT_SYN_TIMEOUT 60
#define DSR_ENCAP_GENEVE 3
#define DSR_ENCAP_IPIP 2
#define DSR_ENCAP_MODE 0
#define DSR_ENCAP_NONE 1
#define EGRESS_POLICY_MAP_SIZE 16384
#define ENABLE_EGRESS_GATEWAY 1
#define ENABLE_HOST_ROUTING 1
#define ENABLE_IDENTITY_MARK 1
#define ENABLE_IPV4 1
#define ENABLE_IPV4_FRAGMENTS 1
#define ENABLE_MASQUERADE_IPV4 1
#define ENABLE_NODEPORT 1
#define ENABLE_SOCKET_LB_FULL 1
#define ENABLE_SOCKET_LB_PEER 1
#define ENABLE_WIREGUARD 1
#define ENCAP4_IFINDEX 0
#define ENCAP6_IFINDEX 0
#define ENCAP_IFINDEX 8
#define ENDPOINTS_MAP_SIZE 65535
#define EVENTS_MAP_BURST_LIMIT 0
#define EVENTS_MAP_RATE_LIMIT 0
#define HASH_INIT4_SEED 1910299206
#define HASH_INIT6_SEED 2454738568
#define HEALTH_ID 4
#define HOST_ID 1
#define HOST_NETNS_COOKIE 1
#define INIT_ID 5
#define IPCACHE_MAP_SIZE 512000
#define IPV4_DIRECT_ROUTING 174368960
#define IPV4_GATEWAY 0xb20d000a
#define IPV4_RSS_PREFIX IPV4_DIRECT_ROUTING
#define IPV4_RSS_PREFIX_BITS 32
#define IPV4_SNAT_EXCLUSION_DST_CIDR 0xd000a
#define IPV4_SNAT_EXCLUSION_DST_CIDR_LEN 24
#define IS_L3_DEV(ifindex) ({ \
bool is_l3 = false; \
switch (ifindex) { \
 case 4: is_l3 = true; break; \
} \
is_l3; })
#define KUBE_APISERVER_NODE_ID 7
#define L2_RESPONDER_MAP4_SIZE 4096
#define L2_RESPONDER_MAP6_SIZE 4096
#define LB4_REVERSE_NAT_SK_MAP_SIZE 591976
#define LB4_SRC_RANGE_MAP_SIZE 65536
#define LB6_REVERSE_NAT_SK_MAP_SIZE 591976
#define LB6_SRC_RANGE_MAP_SIZE 65536
#define LB_MAGLEV_LUT_SIZE 16381
#define LB_SELECTION 1
#define LB_SELECTION_MAGLEV 2
#define LB_SELECTION_RANDOM 1
#define LOCAL_NODE_ID 6
#define METRICS_MAP_SIZE 1024
#define MTU 1280
#define NATIVE_DEV_MAC_BY_IFINDEX(IFINDEX) ({ \
union macaddr __mac = {.addr = {0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}; \
switch (IFINDEX) { \
 case 2: {union macaddr __tmp = {.addr = {0x58,0x11,0x22,0xc4,0x53,0xc7}}; __mac=__tmp;} break; \
 case 3: {union macaddr __tmp = {.addr = {0x58,0x11,0x22,0xc4,0x53,0xc7}}; __mac=__tmp;} break; \
 case 4: {union macaddr __tmp = {.addr = {0x0,0x0,0x0,0x0,0x0,0x0}}; __mac=__tmp;} break; \
} \
__mac; })
#define NAT_46X64_PREFIX_0 0
#define NAT_46X64_PREFIX_1 0
#define NAT_46X64_PREFIX_2 0
#define NAT_46X64_PREFIX_3 0
#define NODEPORT_NEIGH4_SIZE 1183953
#define NODEPORT_NEIGH6_SIZE 1183953
#define NODEPORT_PORT_MAX 32767
#define NODEPORT_PORT_MAX_NAT 65535
#define NODEPORT_PORT_MIN 30000
#define NODEPORT_PORT_MIN_NAT 32768
#define NODE_MAP_SIZE 16384
#define POLICY_MAP_SIZE 16384
#define POLICY_PROG_MAP_SIZE 65535
#define POLICY_STATS_MAP_SIZE 65532
#define REMOTE_NODE_ID 6
#define SERVICE_NO_BACKEND_RESPONSE 1
#define SNAT_COLLISION_RETRIES 32
#define SNAT_MAPPING_IPV4_SIZE 1183953
#define SNAT_MAPPING_IPV6_SIZE 1183953
#define SRV6_POLICY_MAP_SIZE 16384
#define SRV6_SID_MAP_SIZE 16384
#define SRV6_VRF_MAP_SIZE 16384
#define THROTTLE_MAP_SIZE 65535
#define TRACE_SOCK_NOTIFY 1
#define TUNNEL_MODE 1
#define TUNNEL_PORT 8472
#define TUNNEL_PROTOCOL 1
#define TUNNEL_PROTOCOL_GENEVE 2
#define TUNNEL_PROTOCOL_VXLAN 1
#define TUNNEL_SRC_PORT_HIGH 0
#define TUNNEL_SRC_PORT_LOW 0
#define UNKNOWN_ID 0
#define UNMANAGED_ID 3
#define VLAN_FILTER(ifindex, vlan_id) switch (ifindex) { \
case 2: \
switch (vlan_id) { \
case 4000: \
return true; \
} \
break; \
} \
return false;
#define VTEP_MAP_SIZE 8
#define WORLD_ID 2
#define WORLD_IPV4_ID 2
#define WORLD_IPV6_ID 2

// JSON_OUTPUT: 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
