#include "lib/utils.h"

/*
 cilium.v4.external.str 192.168.100.26
 cilium.v4.internal.str 10.0.5.72
 cilium.v4.nodeport.str [100.64.1.33 135.181.179.206 192.168.100.26]

 cilium.v4.internal.raw 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xa, 0x0, 0x5, 0x48
 */

#define CT_MAP_SIZE_TCP 1183978
#define CT_MAP_SIZE_ANY 591989
DECLARE_CONFIG(__u32, identity_length, "Identity length in bits");
ASSIGN_CONFIG(__u32, identity_length, 16);
DECLARE_CONFIG(__u32, interface_ifindex, "ifindex of the interface the bpf program is attached to");
#define AUTH_MAP_SIZE 524288
#define CIDR_IDENTITY_RANGE_END 33554431
#define CIDR_IDENTITY_RANGE_START 16777217
#define CILIUM_HOST_IFINDEX 6
#define CILIUM_HOST_MAC {.addr={0xe2,0x1f,0xa5,0x1e,0xaf,0xea}}
#define CILIUM_IPV4_FRAG_MAP_MAX_ENTRIES 8192
#define CILIUM_IPV6_FRAG_MAP_MAX_ENTRIES 8192
#define CILIUM_LB_ACT_MAP_MAX_ENTRIES 1
#define CILIUM_LB_AFFINITY_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_BACKENDS_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_MAGLEV_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_REV_NAT_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_SERVICE_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_SKIP_MAP_MAX_ENTRIES 100
#define CILIUM_LB_SOURCE_RANGE_MAP_MAX_ENTRIES 65536
#define CILIUM_NET_IFINDEX 5
#define CILIUM_NET_MAC {.addr={0x2,0x24,0xa7,0x83,0xd0,0xf5}}
#define CONFIG_MAP_SIZE 256
#define CT_CLOSE_TIMEOUT 10
#define CT_CONNECTION_LIFETIME_NONTCP 60
#define CT_CONNECTION_LIFETIME_TCP 8000
#define CT_REPORT_FLAGS 0x00ff
#define CT_REPORT_INTERVAL 5
#define CT_SERVICE_CLOSE_REBALANCE 60
#define CT_SERVICE_LIFETIME_NONTCP 60
#define CT_SERVICE_LIFETIME_TCP 8000
#define CT_SYN_TIMEOUT 60
#define DSR_ENCAP_GENEVE 3
#define DSR_ENCAP_IPIP 2
#define DSR_ENCAP_MODE 0
#define DSR_ENCAP_NONE 1
#define EGRESS_POLICY_MAP_SIZE 16384
#define ENABLE_EGRESS_GATEWAY 1
#define ENABLE_HOST_ROUTING 1
#define ENABLE_IDENTITY_MARK 1
#define ENABLE_IPV4 1
#define ENABLE_IPV4_FRAGMENTS 1
#define ENABLE_MASQUERADE_IPV4 1
#define ENABLE_NODEPORT 1
#define ENABLE_SOCKET_LB_FULL 1
#define ENABLE_SOCKET_LB_PEER 1
#define ENABLE_WIREGUARD 1
#define ENCAP4_IFINDEX 0
#define ENCAP6_IFINDEX 0
#define ENCAP_IFINDEX 8
#define ENDPOINTS_MAP_SIZE 65535
#define EVENTS_MAP_BURST_LIMIT 0
#define EVENTS_MAP_RATE_LIMIT 0
#define HASH_INIT4_SEED 1910299206
#define HASH_INIT6_SEED 2454738568
#define HEALTH_ID 4
#define HOST_ID 1
#define HOST_NETNS_COOKIE 1
#define INIT_ID 5
#define IPCACHE_MAP_SIZE 512000
#define IPV4_DIRECT_ROUTING 442804416
#define IPV4_GATEWAY 0x4805000a
#define IPV4_RSS_PREFIX IPV4_DIRECT_ROUTING
#define IPV4_RSS_PREFIX_BITS 32
#define IPV4_SNAT_EXCLUSION_DST_CIDR 0x5000a
#define IPV4_SNAT_EXCLUSION_DST_CIDR_LEN 24
#define IS_L3_DEV(ifindex) ({ \
bool is_l3 = false; \
switch (ifindex) { \
 case 4: is_l3 = true; break; \
} \
is_l3; })
#define KUBE_APISERVER_NODE_ID 7
#define L2_RESPONDER_MAP4_SIZE 4096
#define L2_RESPONDER_MAP6_SIZE 4096
#define LB4_REVERSE_NAT_SK_MAP_SIZE 591989
#define LB4_SRC_RANGE_MAP_SIZE 65536
#define LB6_REVERSE_NAT_SK_MAP_SIZE 591989
#define LB6_SRC_RANGE_MAP_SIZE 65536
#define LB_MAGLEV_LUT_SIZE 16381
#define LB_SELECTION 1
#define LB_SELECTION_MAGLEV 2
#define LB_SELECTION_RANDOM 1
#define LOCAL_NODE_ID 6
#define METRICS_MAP_SIZE 1024
#define MTU 1280
#define NATIVE_DEV_MAC_BY_IFINDEX(IFINDEX) ({ \
union macaddr __mac = {.addr = {0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}; \
switch (IFINDEX) { \
 case 2: {union macaddr __tmp = {.addr = {0xb4,0x2e,0x99,0xcc,0xf4,0x68}}; __mac=__tmp;} break; \
 case 3: {union macaddr __tmp = {.addr = {0xb4,0x2e,0x99,0xcc,0xf4,0x68}}; __mac=__tmp;} break; \
 case 4: {union macaddr __tmp = {.addr = {0x0,0x0,0x0,0x0,0x0,0x0}}; __mac=__tmp;} break; \
} \
__mac; })
#define NAT_46X64_PREFIX_0 0
#define NAT_46X64_PREFIX_1 0
#define NAT_46X64_PREFIX_2 0
#define NAT_46X64_PREFIX_3 0
#define NODEPORT_NEIGH4_SIZE 1183978
#define NODEPORT_NEIGH6_SIZE 1183978
#define NODEPORT_PORT_MAX 32767
#define NODEPORT_PORT_MAX_NAT 65535
#define NODEPORT_PORT_MIN 30000
#define NODEPORT_PORT_MIN_NAT 32768
#define NODE_MAP_SIZE 16384
#define POLICY_MAP_SIZE 16384
#define POLICY_PROG_MAP_SIZE 65535
#define POLICY_STATS_MAP_SIZE 65532
#define REMOTE_NODE_ID 6
#define SERVICE_NO_BACKEND_RESPONSE 1
#define SNAT_COLLISION_RETRIES 32
#define SNAT_MAPPING_IPV4_SIZE 1183978
#define SNAT_MAPPING_IPV6_SIZE 1183978
#define SRV6_POLICY_MAP_SIZE 16384
#define SRV6_SID_MAP_SIZE 16384
#define SRV6_VRF_MAP_SIZE 16384
#define THROTTLE_MAP_SIZE 65535
#define TRACE_SOCK_NOTIFY 1
#define TUNNEL_MODE 1
#define TUNNEL_PORT 8472
#define TUNNEL_PROTOCOL 1
#define TUNNEL_PROTOCOL_GENEVE 2
#define TUNNEL_PROTOCOL_VXLAN 1
#define TUNNEL_SRC_PORT_HIGH 0
#define TUNNEL_SRC_PORT_LOW 0
#define UNKNOWN_ID 0
#define UNMANAGED_ID 3
#define VLAN_FILTER(ifindex, vlan_id) switch (ifindex) { \
case 2: \
switch (vlan_id) { \
case 4000: \
return true; \
} \
break; \
} \
return false;
#define VTEP_MAP_SIZE 8
#define WORLD_ID 2
#define WORLD_IPV4_ID 2
#define WORLD_IPV6_ID 2

// JSON_OUTPUT: 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
