#include "lib/utils.h"

/*
 cilium.v4.external.str 192.168.100.23
 cilium.v4.internal.str 10.0.11.87
 cilium.v4.nodeport.str [65.109.99.173 100.64.0.164 192.168.100.23]

 cilium.v4.internal.raw 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xa, 0x0, 0xb, 0x57
 */

#define CT_MAP_SIZE_TCP 1183953
#define CT_MAP_SIZE_ANY 591976
DECLARE_CONFIG(__u32, identity_length, "Identity length in bits");
ASSIGN_CONFIG(__u32, identity_length, 16);
DECLARE_CONFIG(__u32, interface_ifindex, "ifindex of the interface the bpf program is attached to");
#define AUTH_MAP_SIZE 524288
#define CIDR_IDENTITY_RANGE_END 33554431
#define CIDR_IDENTITY_RANGE_START 16777217
#define CILIUM_HOST_IFINDEX 6
#define CILIUM_HOST_MAC {.addr={0x5a,0xdc,0xe2,0x24,0x12,0x3f}}
#define CILIUM_IPV4_FRAG_MAP_MAX_ENTRIES 8192
#define CILIUM_IPV6_FRAG_MAP_MAX_ENTRIES 8192
#define CILIUM_LB_ACT_MAP_MAX_ENTRIES 1
#define CILIUM_LB_AFFINITY_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_BACKENDS_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_MAGLEV_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_REV_NAT_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_SERVICE_MAP_MAX_ENTRIES 65536
#define CILIUM_LB_SKIP_MAP_MAX_ENTRIES 100
#define CILIUM_LB_SOURCE_RANGE_MAP_MAX_ENTRIES 65536
#define CILIUM_NET_IFINDEX 5
#define CILIUM_NET_MAC {.addr={0x22,0x64,0x30,0x33,0xcb,0x77}}
#define CONFIG_MAP_SIZE 256
#define CT_CLOSE_TIMEOUT 10
#define CT_CONNECTION_LIFETIME_NONTCP 60
#define CT_CONNECTION_LIFETIME_TCP 8000
#define CT_REPORT_FLAGS 0x00ff
#define CT_REPORT_INTERVAL 5
#define CT_SERVICE_CLOSE_REBALANCE 60
#define CT_SERVICE_LIFETIME_NONTCP 60
#define CT_SERVICE_LIFETIME_TCP 8000
#define CT_SYN_TIMEOUT 60
#define DSR_ENCAP_GENEVE 3
#define DSR_ENCAP_IPIP 2
#define DSR_ENCAP_MODE 0
#define DSR_ENCAP_NONE 1
#define EGRESS_POLICY_MAP_SIZE 16384
#define ENABLE_EGRESS_GATEWAY 1
#define ENABLE_HOST_ROUTING 1
#define ENABLE_IDENTITY_MARK 1
#define ENABLE_IPV4 1
#define ENABLE_IPV4_FRAGMENTS 1
#define ENABLE_MASQUERADE_IPV4 1
#define ENABLE_NODEPORT 1
#define ENABLE_SOCKET_LB_FULL 1
#define ENABLE_SOCKET_LB_PEER 1
#define ENABLE_WIREGUARD 1
#define ENCAP4_IFINDEX 0
#define ENCAP6_IFINDEX 0
#define ENCAP_IFINDEX 8
#define ENDPOINTS_MAP_SIZE 65535
#define EVENTS_MAP_BURST_LIMIT 0
#define EVENTS_MAP_RATE_LIMIT 0
#define HASH_INIT4_SEED 1910299206
#define HASH_INIT6_SEED 2454738568
#define HEALTH_ID 4
#define HOST_ID 1
#define HOST_NETNS_COOKIE 1
#define INIT_ID 5
#define IPCACHE_MAP_SIZE 512000
#define IPV4_DIRECT_ROUTING 392472768
#define IPV4_GATEWAY 0x570b000a
#define IPV4_RSS_PREFIX IPV4_DIRECT_ROUTING
#define IPV4_RSS_PREFIX_BITS 32
#define IPV4_SNAT_EXCLUSION_DST_CIDR 0xb000a
#define IPV4_SNAT_EXCLUSION_DST_CIDR_LEN 24
#define IS_L3_DEV(ifindex) ({ \
bool is_l3 = false; \
switch (ifindex) { \
 case 4: is_l3 = true; break; \
} \
is_l3; })
#define KUBE_APISERVER_NODE_ID 7
#define L2_RESPONDER_MAP4_SIZE 4096
#define L2_RESPONDER_MAP6_SIZE 4096
#define LB4_REVERSE_NAT_SK_MAP_SIZE 591976
#define LB4_SRC_RANGE_MAP_SIZE 65536
#define LB6_REVERSE_NAT_SK_MAP_SIZE 591976
#define LB6_SRC_RANGE_MAP_SIZE 65536
#define LB_MAGLEV_LUT_SIZE 16381
#define LB_SELECTION 1
#define LB_SELECTION_MAGLEV 2
#define LB_SELECTION_RANDOM 1
#define LOCAL_NODE_ID 6
#define METRICS_MAP_SIZE 1024
#define MTU 1280
#define NATIVE_DEV_MAC_BY_IFINDEX(IFINDEX) ({ \
union macaddr __mac = {.addr = {0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}; \
switch (IFINDEX) { \
 case 2: {union macaddr __tmp = {.addr = {0x58,0x11,0x22,0xc4,0x4c,0xcc}}; __mac=__tmp;} break; \
 case 3: {union macaddr __tmp = {.addr = {0x58,0x11,0x22,0xc4,0x4c,0xcc}}; __mac=__tmp;} break; \
 case 4: {union macaddr __tmp = {.addr = {0x0,0x0,0x0,0x0,0x0,0x0}}; __mac=__tmp;} break; \
} \
__mac; })
#define NAT_46X64_PREFIX_0 0
#define NAT_46X64_PREFIX_1 0
#define NAT_46X64_PREFIX_2 0
#define NAT_46X64_PREFIX_3 0
#define NODEPORT_NEIGH4_SIZE 1183953
#define NODEPORT_NEIGH6_SIZE 1183953
#define NODEPORT_PORT_MAX 32767
#define NODEPORT_PORT_MAX_NAT 65535
#define NODEPORT_PORT_MIN 30000
#define NODEPORT_PORT_MIN_NAT 32768
#define NODE_MAP_SIZE 16384
#define POLICY_MAP_SIZE 16384
#define POLICY_PROG_MAP_SIZE 65535
#define POLICY_STATS_MAP_SIZE 65532
#define REMOTE_NODE_ID 6
#define SERVICE_NO_BACKEND_RESPONSE 1
#define SNAT_COLLISION_RETRIES 32
#define SNAT_MAPPING_IPV4_SIZE 1183953
#define SNAT_MAPPING_IPV6_SIZE 1183953
#define SRV6_POLICY_MAP_SIZE 16384
#define SRV6_SID_MAP_SIZE 16384
#define SRV6_VRF_MAP_SIZE 16384
#define THROTTLE_MAP_SIZE 65535
#define TRACE_SOCK_NOTIFY 1
#define TUNNEL_MODE 1
#define TUNNEL_PORT 8472
#define TUNNEL_PROTOCOL 1
#define TUNNEL_PROTOCOL_GENEVE 2
#define TUNNEL_PROTOCOL_VXLAN 1
#define TUNNEL_SRC_PORT_HIGH 0
#define TUNNEL_SRC_PORT_LOW 0
#define UNKNOWN_ID 0
#define UNMANAGED_ID 3
#define VLAN_FILTER(ifindex, vlan_id) switch (ifindex) { \
case 2: \
switch (vlan_id) { \
case 4000: \
return true; \
} \
break; \
} \
return false;
#define VTEP_MAP_SIZE 8
#define WORLD_ID 2
#define WORLD_IPV4_ID 2
#define WORLD_IPV6_ID 2

// JSON_OUTPUT: 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
